/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanType;
import com.sun.jdi.ByteType;
import com.sun.jdi.CharType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleType;
import com.sun.jdi.Field;
import com.sun.jdi.FloatType;
import com.sun.jdi.IntegerType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.LongType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VoidType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassLoaderInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIFieldInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIMethodInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIPlsqlTableElement;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.runner.xslt.XSLTRunnerAddin;

final class DebugJDIClassInfo
extends JDIInformationProvider
implements DebugClassInfo {
    DebugJDI dj;
    Type type;
    private boolean classLoaderReferenceKnown;
    private ClassLoaderReference classLoaderReference;
    boolean rtCollected;
    String name;
    List methods;
    boolean debuggable;
    String justPackage;
    String packagePath;
    String nameWithoutPackage;
    private int hashCode;

    DebugJDIClassInfo(DebugJDI debugJDI, Type type) {
        this.dj = debugJDI;
        this.type = type;
        this.name = type.name();
        this.checkDebuggable();
    }

    DebugJDIClassInfo(String string) {
        this.name = string;
    }

    void checkDebuggable() {
        this.debuggable = this.type instanceof PrimitiveType || this.type instanceof VoidType ? true : this.dj.isClassDebuggable(this.name);
    }

    ReferenceType getReferenceType() {
        if (this.type instanceof ReferenceType) {
            return (ReferenceType)this.type;
        }
        return null;
    }

    public boolean hasExpired() {
        return this.rtCollected;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Class has expired " + this.name);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPackage() {
        if (this.justPackage == null) {
            this.justPackage = DebugShared.getPackage(this.name);
        }
        return this.justPackage;
    }

    public String getPackagePath() {
        if (this.packagePath == null) {
            this.packagePath = DebugShared.getPackagePath(this.name);
        }
        return this.packagePath;
    }

    public String getNameWithoutPackage() {
        if (this.nameWithoutPackage == null) {
            this.nameWithoutPackage = DebugShared.getNameWithoutPackage(this.name);
        }
        return this.nameWithoutPackage;
    }

    public String getGenericSignature() {
        if (this.type instanceof ReferenceType) {
            return ((ReferenceType)this.type).genericSignature();
        }
        return null;
    }

    public int getAccess() {
        this.throwIfExpired();
        if (this.type instanceof ReferenceType) {
            ReferenceType referenceType = (ReferenceType)this.type;
            try {
                int n = referenceType.modifiers();
                return n;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public boolean isInterface() {
        this.throwIfExpired();
        return this.type instanceof InterfaceType;
    }

    public boolean isPrimitive() {
        this.throwIfExpired();
        return this.type instanceof PrimitiveType || this.type instanceof VoidType;
    }

    public boolean isObject() {
        this.throwIfExpired();
        return this.type instanceof ClassType;
    }

    public boolean isArray() {
        this.throwIfExpired();
        return this.type instanceof ArrayType;
    }

    public int getSizeOfObject() {
        this.throwIfExpired();
        if (this.type instanceof PrimitiveType || this.type instanceof VoidType) {
            if (this.type instanceof BooleanType) {
                return 1;
            }
            if (this.type instanceof ByteType) {
                return 1;
            }
            if (this.type instanceof CharType) {
                return 2;
            }
            if (this.type instanceof DoubleType) {
                return 8;
            }
            if (this.type instanceof FloatType) {
                return 4;
            }
            if (this.type instanceof IntegerType) {
                return 4;
            }
            if (this.type instanceof LongType) {
                return 8;
            }
            if (this.type instanceof ShortType) {
                return 2;
            }
            if (this.type instanceof VoidType) {
                return 0;
            }
        } else if (this.type instanceof ReferenceType) {
            ReferenceType referenceType = (ReferenceType)this.type;
            try {
                List<Field> list = referenceType.allFields();
                int n = 0;
                int n2 = 0;
                while (n2 < list.size()) {
                    Field field = list.get(n2);
                    if (!field.isStatic()) {
                        String string = field.signature();
                        char c = string.charAt(0);
                        switch (c) {
                            case 'B': {
                                ++n;
                                break;
                            }
                            case 'C': {
                                n += 2;
                                break;
                            }
                            case 'D': {
                                n += 8;
                                break;
                            }
                            case 'F': {
                                n += 4;
                                break;
                            }
                            case 'I': {
                                n += 4;
                                break;
                            }
                            case 'J': {
                                n += 8;
                                break;
                            }
                            case 'S': {
                                n += 2;
                                break;
                            }
                            case 'Z': {
                                ++n;
                                break;
                            }
                            case 'L': 
                            case '[': {
                                n += 4;
                            }
                        }
                    }
                    ++n2;
                }
                int n3 = n;
                return n3;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public int countObjectsOfClass() {
        return 0;
    }

    public int countMemoryOfClass() {
        return 0;
    }

    public DebugDataObjectInfo getClassObject() {
        this.throwIfExpired();
        if (this.type instanceof PrimitiveType || this.type instanceof VoidType) {
            try {
                Value value;
                Field field;
                ReferenceType referenceType;
                DebugJDIClassInfo debugJDIClassInfo = null;
                if (this.type instanceof BooleanType) {
                    debugJDIClassInfo = this.dj.findClassByName("java.lang.Boolean", false);
                } else if (this.type instanceof ByteType) {
                    debugJDIClassInfo = this.dj.findClassByName("java.lang.Byte", false);
                } else if (this.type instanceof CharType) {
                    debugJDIClassInfo = this.dj.findClassByName("java.lang.Char", false);
                } else if (this.type instanceof DoubleType) {
                    debugJDIClassInfo = this.dj.findClassByName("java.lang.Double", false);
                } else if (this.type instanceof FloatType) {
                    debugJDIClassInfo = this.dj.findClassByName("java.lang.Float", false);
                } else if (this.type instanceof IntegerType) {
                    debugJDIClassInfo = this.dj.findClassByName("java.lang.Integer", false);
                } else if (this.type instanceof LongType) {
                    debugJDIClassInfo = this.dj.findClassByName("java.lang.Long", false);
                } else if (this.type instanceof ShortType) {
                    debugJDIClassInfo = this.dj.findClassByName("java.lang.Short", false);
                } else if (this.type instanceof VoidType) {
                    debugJDIClassInfo = this.dj.findClassByName("java.lang.Void", false);
                }
                if (debugJDIClassInfo != null && (referenceType = debugJDIClassInfo.getReferenceType()) != null && (field = referenceType.fieldByName("TYPE")) != null && field.isStatic() && (value = referenceType.getValue(field)) != null) {
                    DebugDataObjectInfo debugDataObjectInfo = (DebugDataObjectInfo)((Object)this.dj.makeData(value, null));
                    return debugDataObjectInfo;
                }
            }
            catch (Exception exception) {}
        } else if (this.type instanceof ReferenceType) {
            ReferenceType referenceType = (ReferenceType)this.type;
            try {
                DebugDataObjectInfo debugDataObjectInfo = (DebugDataObjectInfo)((Object)this.dj.makeData(referenceType.classObject(), null));
                return debugDataObjectInfo;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    ClassLoaderReference getClassLoaderReference() {
        if (!this.classLoaderReferenceKnown) {
            try {
                if (this.type instanceof ReferenceType) {
                    ReferenceType referenceType = (ReferenceType)this.type;
                    this.classLoaderReference = this.dj.getClassLoader(referenceType);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.classLoaderReferenceKnown = true;
        }
        return this.classLoaderReference;
    }

    void setClassLoaderReference(ClassLoaderReference classLoaderReference) {
        if (!this.classLoaderReferenceKnown) {
            this.classLoaderReference = classLoaderReference;
            this.classLoaderReferenceKnown = true;
        }
    }

    public DebugDataObjectInfo getClassLoaderObject() {
        ClassLoaderReference classLoaderReference;
        this.throwIfExpired();
        if (this.type instanceof ReferenceType && (classLoaderReference = this.getClassLoaderReference()) != null) {
            return (DebugDataObjectInfo)((Object)this.dj.makeData(classLoaderReference, null));
        }
        return null;
    }

    public DebugClassLoaderInfo getClassLoader() {
        this.throwIfExpired();
        if (this.type instanceof ReferenceType) {
            return DebugJDIClassLoaderInfo.makeClassLoaderInfo(this.dj, this.getClassLoaderReference());
        }
        return null;
    }

    public String getPrimarySourceFilename() {
        this.throwIfExpired();
        if (this.type instanceof ReferenceType && !(this.type instanceof ArrayType)) {
            ReferenceType referenceType = (ReferenceType)this.type;
            try {
                List<String> list = referenceType.sourceNames(referenceType.defaultStratum());
                if (list != null && list.size() > 0) {
                    String string = list.get(0);
                    return string;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getSourceFilename();
    }

    public String getSourceFilename() {
        this.throwIfExpired();
        if (this.type instanceof ReferenceType && !(this.type instanceof ArrayType)) {
            ReferenceType referenceType = (ReferenceType)this.type;
            try {
                String string = referenceType.sourceName();
                return string;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public DebugClassInfo getSuperClass(int n) {
        this.throwIfExpired();
        if (this.type instanceof ClassType) {
            ClassType classType = (ClassType)this.type;
            int n2 = 0;
            while (classType != null && n2 < n) {
                classType = classType.superclass();
                ++n2;
            }
            if (classType != null) {
                return this.dj.findClass(classType);
            }
        }
        return null;
    }

    void redefiningClass() {
        this.methods = null;
    }

    private void getRTMethods() {
        if (this.methods == null) {
            ReferenceType referenceType = (ReferenceType)this.type;
            try {
                this.methods = referenceType.methods();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getMethodCount() {
        this.throwIfExpired();
        if (this.type instanceof ReferenceType) {
            this.getRTMethods();
            if (this.methods != null) {
                return this.methods.size();
            }
        }
        return 0;
    }

    public DebugMethodInfo[] getMethods() {
        this.throwIfExpired();
        if (this.type instanceof ReferenceType) {
            this.getRTMethods();
            if (this.methods != null) {
                DebugMethodInfo[] debugMethodInfoArray = new DebugMethodInfo[this.methods.size()];
                int n = 0;
                while (n < this.methods.size()) {
                    debugMethodInfoArray[n] = new DebugJDIMethodInfo(this.dj, this, (Method)this.methods.get(n));
                    ++n;
                }
                return debugMethodInfoArray;
            }
        }
        return new DebugMethodInfo[0];
    }

    public int getStaticFieldCount() {
        return this.getStaticFieldCount(0, false);
    }

    public DebugFieldInfo[] getStaticFields() {
        return this.getStaticFields(0, false);
    }

    public DebugFieldInfo getStaticField(int n) {
        return this.getStaticField(0, false, n);
    }

    public int getStaticFieldCount(int n) {
        return this.getStaticFieldCount(n, false);
    }

    public DebugFieldInfo[] getStaticFields(int n) {
        return this.getStaticFields(n, false);
    }

    public DebugFieldInfo getStaticField(int n, int n2) {
        return this.getStaticField(n, false, n2);
    }

    public int getStaticFieldCount(int n, boolean bl) {
        this.throwIfExpired();
        List list = this.collectFields(n, null, bl, Boolean.TRUE, false);
        return list.size();
    }

    public DebugFieldInfo[] getStaticFields(int n, boolean bl) {
        this.throwIfExpired();
        List list = this.collectFields(n, null, bl, Boolean.TRUE, false);
        int n2 = list.size();
        DebugFieldInfo[] debugFieldInfoArray = new DebugFieldInfo[n2];
        int n3 = 0;
        while (n3 < n2) {
            debugFieldInfoArray[n3] = new DebugJDIFieldInfo(this.dj, (Field)list.get(n3), this, null);
            ++n3;
        }
        return debugFieldInfoArray;
    }

    public DebugFieldInfo getStaticField(int n, boolean bl, int n2) {
        this.throwIfExpired();
        List list = this.collectFields(n, null, bl, Boolean.TRUE, false);
        int n3 = list.size();
        if (n2 < n3) {
            return new DebugJDIFieldInfo(this.dj, (Field)list.get(n2), this, null);
        }
        return null;
    }

    public DebugFieldInfo getStaticField(String string) {
        block3: {
            try {
                ArrayList arrayList;
                String string2;
                if (this.getLanguage() == 2 && (string2 = DebugJDIPlsqlTableElement.parseTableElement(string, arrayList = new ArrayList())) != null) {
                    DebugFieldInfo debugFieldInfo = DebugJDIPlsqlTableElement.getTableElementField(this.getStaticFields(), string2, arrayList, this.dj, string, this, true);
                    return debugFieldInfo;
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) break block3;
                throw (ThreadDeath)throwable;
            }
        }
        return null;
    }

    public int getFieldCount(int n) {
        return this.getFieldCount(n, false, false);
    }

    public DebugFieldInfo[] getFields(int n) {
        return this.getFields(n, false, false);
    }

    public DebugFieldInfo getField(int n, int n2) {
        return this.getField(n, false, false, n2);
    }

    public int getFieldCount(int n, boolean bl) {
        return this.getFieldCount(n, bl, false);
    }

    public DebugFieldInfo[] getFields(int n, boolean bl) {
        return this.getFields(n, bl, false);
    }

    public DebugFieldInfo getField(int n, boolean bl, int n2) {
        return this.getField(n, bl, false, n2);
    }

    public int getFieldCount(int n, boolean bl, boolean bl2) {
        this.throwIfExpired();
        Boolean bl3 = bl2 ? Boolean.FALSE : null;
        List list = this.collectFields(n, null, bl, bl3, false);
        return list.size();
    }

    public DebugFieldInfo[] getFields(int n, boolean bl, boolean bl2) {
        this.throwIfExpired();
        Boolean bl3 = bl2 ? Boolean.FALSE : null;
        List list = this.collectFields(n, null, bl, bl3, false);
        int n2 = list.size();
        DebugFieldInfo[] debugFieldInfoArray = new DebugFieldInfo[n2];
        int n3 = 0;
        while (n3 < n2) {
            debugFieldInfoArray[n3] = new DebugJDIFieldInfo(this.dj, (Field)list.get(n3), this, null);
            ++n3;
        }
        return debugFieldInfoArray;
    }

    public DebugFieldInfo getField(int n, boolean bl, boolean bl2, int n2) {
        this.throwIfExpired();
        Boolean bl3 = bl2 ? Boolean.FALSE : null;
        List list = this.collectFields(n, null, bl, bl3, false);
        int n3 = list.size();
        if (n2 < n3) {
            return new DebugJDIFieldInfo(this.dj, (Field)list.get(n2), this, null);
        }
        return null;
    }

    List collectFields(int n, ObjectReference objectReference, boolean bl, Boolean bl2, boolean bl3) {
        ArrayList arrayList = new ArrayList();
        try {
            if (this.type instanceof ClassType) {
                ClassType classType = (ClassType)this.type;
                int n2 = 0;
                while (classType != null) {
                    if (n < 0 || n2 == n) {
                        DebugJDIClassInfo.addFields(arrayList, classType.fields(), objectReference, bl, bl2, bl3);
                        if (n < 0) {
                            DebugJDIClassInfo.addInterfaceFields(arrayList, classType, objectReference, bl, bl2, bl3);
                        }
                    }
                    classType = classType.superclass();
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private static void addFields(List list, List list2, ObjectReference objectReference, boolean bl, Boolean bl2, boolean bl3) {
        int n = list2.size();
        int n2 = 0;
        while (n2 < n) {
            Field field = (Field)list2.get(n2);
            if (!DebugJDIClassInfo.skipField(field, objectReference, bl, bl2, bl3)) {
                list.add(field);
            }
            ++n2;
        }
    }

    private static boolean skipField(Field field, ObjectReference objectReference, boolean bl, Boolean bl2, boolean bl3) {
        if (bl && field.isFinal()) {
            return true;
        }
        if (bl2 != null && bl2.booleanValue() != field.isStatic()) {
            return true;
        }
        return bl3 && objectReference != null && objectReference.getValue(field) == null;
    }

    private static void addInterfaceFields(List list, ReferenceType referenceType, ObjectReference objectReference, boolean bl, Boolean bl2, boolean bl3) {
        List<InterfaceType> list2 = null;
        if (referenceType instanceof ClassType) {
            list2 = ((ClassType)referenceType).interfaces();
        } else if (referenceType instanceof InterfaceType) {
            list2 = ((InterfaceType)referenceType).superinterfaces();
        }
        if (list2 != null) {
            int n = list2.size();
            int n2 = 0;
            while (n2 < n) {
                InterfaceType interfaceType = list2.get(n2);
                DebugJDIClassInfo.addFields(list, interfaceType.fields(), objectReference, bl, bl2, bl3);
                DebugJDIClassInfo.addInterfaceFields(list, interfaceType, objectReference, bl, bl2, bl3);
                ++n2;
            }
        }
    }

    Field fieldByName(String string) {
        try {
            if (this.type instanceof ClassType) {
                ClassType classType = (ClassType)this.type;
                Field field = classType.fieldByName(string);
                return field;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public boolean isDebuggable() {
        return this.debuggable;
    }

    public void setDebuggable(boolean bl) {
        this.debuggable = bl;
    }

    public boolean isObfuscated() {
        this.throwIfExpired();
        if (this.type instanceof ClassType) {
            ClassType classType = (ClassType)this.type;
            try {
                if (this.getMethodCount() > 0) {
                    String string = classType.sourceName();
                    if (string == null || string.length() == 0) {
                        boolean bl = true;
                        return bl;
                    }
                    List<Location> list = classType.allLineLocations();
                    if (list == null || list.size() == 0) {
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            catch (Exception exception) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public boolean isCodeCoverage() {
        return false;
    }

    public void setCodeCoverage(boolean bl) {
    }

    public void discardCodeCoverage() {
    }

    public double getCodeCoverageRatio() {
        return 0.0;
    }

    private void addAllInterfaces(Set set, InterfaceType interfaceType) {
        DebugJDIClassInfo debugJDIClassInfo = this.dj.findClass(interfaceType);
        if (debugJDIClassInfo != null) {
            set.add(debugJDIClassInfo);
        }
        List<InterfaceType> list = interfaceType.superinterfaces();
        int n = 0;
        while (n < list.size()) {
            InterfaceType interfaceType2 = list.get(n);
            this.addAllInterfaces(set, interfaceType2);
            ++n;
        }
    }

    public DebugClassInfo[] getInterfaces() {
        return this.getInterfaces(0);
    }

    public DebugClassInfo[] getInterfaces(int n) {
        this.throwIfExpired();
        HashSet<DebugJDIClassInfo> hashSet = new HashSet<DebugJDIClassInfo>();
        try {
            if (this.type instanceof ClassType) {
                int n2 = 0;
                ClassType classType = (ClassType)this.type;
                while (classType != null) {
                    if (n == -1 || n == n2) {
                        List<InterfaceType> list = classType.interfaces();
                        int n3 = 0;
                        while (n3 < list.size()) {
                            InterfaceType interfaceType = list.get(n3);
                            this.addAllInterfaces(hashSet, interfaceType);
                            ++n3;
                        }
                    }
                    ++n2;
                    classType = classType.superclass();
                }
            } else if (this.type instanceof InterfaceType) {
                if (n == -1) {
                    this.addAllInterfaces(hashSet, (InterfaceType)this.type);
                } else if (n == 0) {
                    List<InterfaceType> list = ((InterfaceType)this.type).superinterfaces();
                    int n4 = 0;
                    while (n4 < list.size()) {
                        InterfaceType interfaceType = list.get(n4);
                        DebugJDIClassInfo debugJDIClassInfo = this.dj.findClass(interfaceType);
                        if (debugJDIClassInfo != null) {
                            hashSet.add(debugJDIClassInfo);
                        }
                        ++n4;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DebugClassInfo[] debugClassInfoArray = new DebugClassInfo[hashSet.size()];
        return hashSet.toArray(debugClassInfoArray);
    }

    public int getLanguage() {
        if (this.name.startsWith(XSLTRunnerAddin.getXSLTPackage())) {
            return 4;
        }
        if (this.name.startsWith("$Oracle.")) {
            return 2;
        }
        return 1;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.type != null ? this.type.hashCode() : this.name.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugJDIClassInfo) {
            DebugJDIClassInfo debugJDIClassInfo = (DebugJDIClassInfo)object;
            return (this.type == null ? debugJDIClassInfo.type == null : this.type.equals(debugJDIClassInfo.type)) && this.name.equals(this.name);
        }
        return false;
    }

    public Type getJDIType() {
        return this.type;
    }

    public Value getJDIValue() {
        try {
            if (this.type instanceof ReferenceType) {
                ClassObjectReference classObjectReference = ((ReferenceType)this.type).classObject();
                return classObjectReference;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

