/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataObjectInfo;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;

final class DebugJDIClassLoaderInfo
extends JDIInformationProvider
implements DebugClassLoaderInfo {
    private DebugJDI dj;
    private ClassLoaderReference clr;
    private boolean parentKnown;
    private DebugJDIClassLoaderInfo parent;
    private String className;
    private int id;
    private int hashCode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DebugJDIClassLoaderInfo makeClassLoaderInfo(DebugJDI debugJDI, ClassLoaderReference classLoaderReference) {
        Map map = debugJDI.classLoaderInfos;
        synchronized (map) {
            Object object = classLoaderReference != null ? (Object)classLoaderReference : (Object)"BootstrapClassLoader";
            DebugJDIClassLoaderInfo debugJDIClassLoaderInfo = (DebugJDIClassLoaderInfo)debugJDI.classLoaderInfos.get(object);
            if (debugJDIClassLoaderInfo == null) {
                debugJDIClassLoaderInfo = new DebugJDIClassLoaderInfo(debugJDI, classLoaderReference);
                debugJDI.classLoaderInfos.put(object, debugJDIClassLoaderInfo);
                debugJDIClassLoaderInfo.explore();
            }
            DebugJDIClassLoaderInfo debugJDIClassLoaderInfo2 = debugJDIClassLoaderInfo;
            return debugJDIClassLoaderInfo2;
        }
    }

    private DebugJDIClassLoaderInfo(DebugJDI debugJDI, ClassLoaderReference classLoaderReference) {
        this.dj = debugJDI;
        this.clr = classLoaderReference;
        if (classLoaderReference != null) {
            this.className = classLoaderReference.referenceType().name();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void explore() {
        if (this.clr != null && !this.className.equals("sun.reflect.DelegatingClassLoader")) {
            DebugShared.exploreClassLoaderParents(this);
        }
        Map map = this.dj.classLoaderIds;
        synchronized (map) {
            Integer n = (Integer)this.dj.classLoaderIds.get(this.className);
            this.id = n == null ? 1 : n + 1;
            n = new Integer(this.id);
            this.dj.classLoaderIds.put(this.className, n);
        }
    }

    public boolean hasExpired() {
        return this.clr != null && this.dj.isObjectCollected(this.clr);
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("ClassLoader has expired");
        }
    }

    public String getClassName() {
        this.throwIfExpired();
        return this.className;
    }

    public int getId() {
        this.throwIfExpired();
        return this.id;
    }

    public DebugClassInfo[] listDefinedClasses() {
        this.throwIfExpired();
        ArrayList<DebugJDIClassInfo> arrayList = new ArrayList<DebugJDIClassInfo>();
        if (this.clr != null) {
            List<ReferenceType> list = this.clr.definedClasses();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                ReferenceType referenceType = list.get(n2);
                DebugJDIClassInfo debugJDIClassInfo = this.dj.findClass(referenceType);
                if (debugJDIClassInfo != null) {
                    arrayList.add(debugJDIClassInfo);
                }
                ++n2;
            }
        } else {
            for (DebugJDIClassInfo debugJDIClassInfo : this.dj.classesByReferenceType.values()) {
                if (debugJDIClassInfo.getClassLoaderReference() != null) continue;
                arrayList.add(debugJDIClassInfo);
            }
        }
        DebugClassInfo[] debugClassInfoArray = new DebugClassInfo[arrayList.size()];
        return arrayList.toArray(debugClassInfoArray);
    }

    public DebugDataObjectInfo getClassLoaderObject() {
        this.throwIfExpired();
        try {
            if (this.clr != null) {
                DebugDataObjectInfo debugDataObjectInfo = (DebugDataObjectInfo)((Object)this.dj.makeData(this.clr, null));
                return debugDataObjectInfo;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public DebugClassLoaderInfo getParent() {
        this.throwIfExpired();
        if (this.clr != null) {
            if (!this.parentKnown) {
                ClassLoaderReference classLoaderReference;
                DebugJDIDataObjectInfo debugJDIDataObjectInfo;
                DebugDataObjectInfo debugDataObjectInfo = this.getClassLoaderObject();
                if (debugDataObjectInfo != null && (debugJDIDataObjectInfo = (DebugJDIDataObjectInfo)DebugShared.getParentClassLoaderObject(debugDataObjectInfo)) != null && (classLoaderReference = (ClassLoaderReference)debugJDIDataObjectInfo.value) != null) {
                    this.parent = DebugJDIClassLoaderInfo.makeClassLoaderInfo(this.dj, classLoaderReference);
                }
                this.parentKnown = true;
            }
            return this.parent;
        }
        return null;
    }

    public boolean isSystemClassLoader() {
        return this.clr != null && this.clr == this.dj.getSystemClassLoader();
    }

    public int hashCode() {
        if (this.hashCode == 0 && this.clr != null) {
            this.hashCode = this.clr.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugJDIClassLoaderInfo) {
            DebugJDIClassLoaderInfo debugJDIClassLoaderInfo = (DebugJDIClassLoaderInfo)object;
            return this.clr == null ? debugJDIClassLoaderInfo.clr == null : this.clr.equals(debugJDIClassLoaderInfo.clr);
        }
        return false;
    }

    public Value getJDIValue() {
        return this.clr;
    }
}

