/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.connect.Connector;
import java.util.Map;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugConnectArg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DebugJDIConnectArg
implements DebugConnectArg {
    int factory;
    Map<String, Connector.Argument> defArgs;
    private Connector.Argument arg;
    private String name;

    DebugJDIConnectArg(int n, Map<String, Connector.Argument> map, Connector.Argument argument) {
        this.factory = n;
        this.defArgs = map;
        this.arg = argument;
        this.name = argument.name();
        String string = DebugShared.getDefaultConnectArgValue(n, this.name);
        if (string != null) {
            this.setValue(string);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLabel() {
        return this.arg.label();
    }

    @Override
    public void setValue(String string) {
        if (this.name.equals("timeout")) {
            try {
                int n = Integer.parseInt(string);
                int n2 = n * 1000;
                string = Integer.toString(n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.arg.setValue(string);
    }

    @Override
    public String getValue() {
        String string = this.arg.value();
        if (this.name.equals("timeout")) {
            try {
                int n = Integer.parseInt(string);
                int n2 = n / 1000;
                string = Integer.toString(n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    @Override
    public boolean allowBlank() {
        return this.arg.mustSpecify() ^ true;
    }
}

