/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.Connector;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import oracle.jdevimpl.debugger.jdi.DebugJDIConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnector;

abstract class DebugJDIConnector
implements DebugConnector {
    protected int factory;
    protected Connector connector;

    public static String getVersion() {
        VirtualMachineManager virtualMachineManager = Bootstrap.virtualMachineManager();
        int n = virtualMachineManager.majorInterfaceVersion();
        int n2 = virtualMachineManager.minorInterfaceVersion();
        return Integer.toString(n) + "." + Integer.toString(n2);
    }

    protected DebugJDIConnector(int n) {
        this.factory = n;
        this.connector = this.findConnector();
    }

    protected abstract Connector findConnector();

    public synchronized DebugConnectArg[] getConnectArgs() {
        Map<String, Connector.Argument> map = this.connector.defaultArguments();
        DebugConnectArg[] debugConnectArgArray = new DebugConnectArg[map.size()];
        int n = 0;
        for (Connector.Argument argument : map.values()) {
            debugConnectArgArray[n++] = new DebugJDIConnectArg(this.factory, map, argument);
        }
        Arrays.sort(debugConnectArgArray, new 1());
        return debugConnectArgArray;
    }

    final class 1
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n = this.getSortValue((DebugConnectArg)object);
            int n2 = this.getSortValue((DebugConnectArg)object2);
            return n - n2;
        }

        private int getSortValue(DebugConnectArg debugConnectArg) {
            String string = debugConnectArg.getName();
            if (string.equals("hostname")) {
                return 0;
            }
            if (string.equals("port")) {
                return 1;
            }
            if (string.equals("timeout")) {
                return 2;
            }
            return 3;
        }
    }
}

