/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.ListeningConnector;
import java.util.Map;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIConnectArg;
import oracle.jdevimpl.debugger.jdi.DebugJDIConnector;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnectionListener;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

public final class DebugJDIConnectorListen
extends DebugJDIConnector
implements Runnable {
    private Object listeningSync = new Integer(1);
    private boolean listening;
    protected Map<String, Connector.Argument> defArgs;
    private DebugConnectionListener connectionListener;
    private Thread listeningThread;

    public DebugJDIConnectorListen() {
        super(2);
    }

    protected Connector findConnector() {
        VirtualMachineManager virtualMachineManager = Bootstrap.virtualMachineManager();
        for (ListeningConnector listeningConnector : virtualMachineManager.listeningConnectors()) {
            if (!listeningConnector.transport().name().equals("dt_socket")) continue;
            return listeningConnector;
        }
        throw new IllegalArgumentException("Can not find listening connector for transport dt_socket");
    }

    public synchronized DebugVirtualMachine connect(DebugConnectArg[] debugConnectArgArray) throws Exception {
        Map<String, Connector.Argument> map = ((DebugJDIConnectArg)debugConnectArgArray[0]).defArgs;
        ListeningConnector listeningConnector = (ListeningConnector)this.connector;
        listeningConnector.startListening(map);
        VirtualMachine virtualMachine = listeningConnector.accept(map);
        listeningConnector.stopListening(map);
        return new DebugJDI(virtualMachine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startListening(DebugConnectArg[] debugConnectArgArray, DebugConnectionListener debugConnectionListener) throws Exception {
        Object object = this.listeningSync;
        synchronized (object) {
            if (!this.listening) {
                this.defArgs = ((DebugJDIConnectArg)debugConnectArgArray[0]).defArgs;
                this.connectionListener = debugConnectionListener;
                ListeningConnector listeningConnector = (ListeningConnector)this.connector;
                listeningConnector.startListening(this.defArgs);
                this.listening = true;
                debugConnectionListener.listeningStarted();
                this.listeningThread = new Thread((Runnable)this, "JPDA Listener");
                this.listeningThread.start();
                this.listeningSync.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopListening() throws Exception {
        Object object = this.listeningSync;
        synchronized (object) {
            if (this.listening) {
                ListeningConnector listeningConnector = (ListeningConnector)this.connector;
                listeningConnector.stopListening(this.defArgs);
                this.listening = false;
                this.connectionListener.listeningStopped();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isListening() {
        Object object = this.listeningSync;
        synchronized (object) {
            boolean bl = this.listening;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block8: {
            ListeningConnector listeningConnector = (ListeningConnector)this.connector;
            try {
                while (this.isListening()) {
                    Object object = this.listeningSync;
                    synchronized (object) {
                        this.listeningSync.notify();
                    }
                    VirtualMachine virtualMachine = listeningConnector.accept(this.defArgs);
                    DebugJDI debugJDI = new DebugJDI(virtualMachine);
                    boolean bl = this.connectionListener.connectionEstablished(debugJDI);
                    if (bl && listeningConnector.supportsMultipleConnections()) continue;
                }
            }
            catch (Exception exception) {
                if (!this.isListening()) break block8;
                exception.printStackTrace();
            }
        }
        try {
            this.stopListening();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.listeningThread = null;
    }
}

