/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIArrayElementInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataCompositeInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataInfo;
import oracle.jdevimpl.debugger.support.DebugArrayElementInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;

final class DebugJDIDataArrayInfo
extends DebugJDIDataCompositeInfo
implements DebugDataArrayInfo {
    DebugJDIDataArrayInfo(DebugJDI debugJDI, DebugJDIClassInfo debugJDIClassInfo, Value value, Object object) {
        super(debugJDI, debugJDIClassInfo, value, object);
    }

    public DebugClassInfo getArrayElementClassInfo() {
        this.throwIfExpired();
        ReferenceType referenceType = this.clazz.getReferenceType();
        if (referenceType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)referenceType;
            try {
                DebugJDIClassInfo debugJDIClassInfo = this.dj.findClassByType(arrayType.componentType());
                if (debugJDIClassInfo != null) {
                    DebugJDIClassInfo debugJDIClassInfo2 = debugJDIClassInfo;
                    return debugJDIClassInfo2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.dj.findClassByName(arrayType.componentTypeName(), true);
        }
        return null;
    }

    public int getArrayStart() {
        return 0;
    }

    public int getArrayCount() {
        return this.getArrayCount(false);
    }

    public DebugArrayElementInfo[] getArrayElements() {
        return this.getArrayElements(0, -1, false);
    }

    public DebugArrayElementInfo[] getArrayElements(int n, int n2) {
        return this.getArrayElements(n, n2, false);
    }

    public int getArrayCount(boolean bl) {
        this.throwIfExpired();
        if (this.value == null) {
            return 0;
        }
        ArrayReference arrayReference = (ArrayReference)this.value;
        int n = 0;
        if (bl) {
            List<Value> list = arrayReference.getValues(0, -1);
            int n2 = 0;
            while (n2 < list.size()) {
                Value value = list.get(n2);
                if (value != null) {
                    ++n;
                }
                ++n2;
            }
        } else {
            n = arrayReference.length();
        }
        return n;
    }

    public DebugArrayElementInfo[] getArrayElements(boolean bl) {
        return this.getArrayElements(0, -1, bl);
    }

    public DebugArrayElementInfo[] getArrayElements(int n, int n2, boolean bl) {
        this.throwIfExpired();
        if (this.value == null) {
            return new DebugArrayElementInfo[0];
        }
        ArrayReference arrayReference = (ArrayReference)this.value;
        ArrayType arrayType = (ArrayType)arrayReference.referenceType();
        DebugJDIClassInfo debugJDIClassInfo = (DebugJDIClassInfo)this.getArrayElementClassInfo();
        ArrayList<DebugJDIArrayElementInfo> arrayList = new ArrayList<DebugJDIArrayElementInfo>();
        if (arrayReference.length() > 0) {
            List<Value> list = arrayReference.getValues(n, n2);
            int n3 = 0;
            while (n3 < list.size()) {
                Value value = list.get(n3);
                if (!bl || value != null) {
                    DebugJDIDataInfo debugJDIDataInfo = value != null ? this.dj.makeData(value, null) : this.dj.makeNullData(debugJDIClassInfo, null);
                    arrayList.add(new DebugJDIArrayElementInfo(this.dj, debugJDIClassInfo, n + n3, debugJDIDataInfo, this));
                }
                ++n3;
            }
            DebugArrayElementInfo[] debugArrayElementInfoArray = new DebugArrayElementInfo[arrayList.size()];
            return arrayList.toArray(debugArrayElementInfoArray);
        }
        return new DebugArrayElementInfo[0];
    }

    public boolean equals(Object object) {
        if (object instanceof DebugJDIDataArrayInfo) {
            return super.equals(object);
        }
        return false;
    }
}

