/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.List;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugPinListener;
import oracle.jdevimpl.debugger.support.DebugPinnedInfo;

class DebugJDIDataCompositeInfo
extends DebugJDIDataInfo
implements DebugDataCompositeInfo {
    DebugJDIDataCompositeInfo(DebugJDI debugJDI, DebugJDIClassInfo debugJDIClassInfo, Value value, Object object) {
        super(debugJDI, debugJDIClassInfo, value, object);
    }

    public boolean isNull() {
        this.throwIfExpired();
        return this.value == null;
    }

    public long getAddressOfObject() {
        this.throwIfExpired();
        return 0L;
    }

    public boolean canSetAddressOfObject() {
        return false;
    }

    public boolean canSetAddressOfObjectToNull() {
        return true;
    }

    public boolean setAddressOfObject(long l) {
        this.throwIfExpired();
        if (l == 0L) {
            return this.modifyData(null);
        }
        return false;
    }

    public DebugPinnedInfo pinObject(DebugPinListener debugPinListener) {
        this.throwIfExpired();
        if (this.value instanceof ObjectReference) {
            return this.dj.pinObject((ObjectReference)this.value, debugPinListener);
        }
        return null;
    }

    public long getUniqueID() {
        this.throwIfExpired();
        if (this.value instanceof ObjectReference) {
            return ((ObjectReference)this.value).uniqueID();
        }
        return 0L;
    }

    public String getCourtesyValue() {
        this.throwIfExpired();
        String string = DebugJDIDataCompositeInfo.getCourtesyValueForValue(this.value);
        if (string != null) {
            if (string.length() > 100) {
                string = string.substring(0, 100);
            }
            return string;
        }
        return null;
    }

    public boolean canGetWholeThing() {
        ClassType classType;
        String string;
        ObjectReference objectReference;
        ReferenceType referenceType;
        this.throwIfExpired();
        if (this.value instanceof StringReference) {
            return true;
        }
        if (this.value instanceof ArrayReference) {
            ArrayReference arrayReference = (ArrayReference)this.value;
            ReferenceType referenceType2 = arrayReference.referenceType();
            String string2 = referenceType2.name();
            if (string2.equals("char[]")) {
                return true;
            }
            if (string2.equals("byte[]")) {
                return true;
            }
            if (string2.equals("short[]")) {
                return true;
            }
            if (string2.equals("int[]")) {
                return true;
            }
            if (string2.equals("long[]")) {
                return true;
            }
        } else if (this.value instanceof ObjectReference && (referenceType = (objectReference = (ObjectReference)this.value).referenceType()) instanceof ClassType && (string = (classType = (ClassType)referenceType).name()).equals("java.lang.StringBuffer")) {
            return true;
        }
        return false;
    }

    public Object getWholeThing() {
        ClassType classType;
        String string;
        ObjectReference objectReference;
        ReferenceType referenceType;
        this.throwIfExpired();
        if (this.value instanceof StringReference) {
            return ((StringReference)this.value).value();
        }
        if (this.value instanceof ArrayReference) {
            ArrayReference arrayReference = (ArrayReference)this.value;
            ReferenceType referenceType2 = arrayReference.referenceType();
            String string2 = referenceType2.name();
            if (string2.equals("char[]")) {
                StringBuffer stringBuffer = new StringBuffer();
                int n = arrayReference.length();
                int n2 = 0;
                while (n2 < n) {
                    char c = ((CharValue)arrayReference.getValue(n2)).value();
                    if (c == '\u0000') break;
                    stringBuffer.append(c);
                    ++n2;
                }
                return stringBuffer.toString();
            }
            if (string2.equals("byte[]")) {
                int n = arrayReference.length();
                byte[] byArray = new byte[n];
                int n3 = 0;
                while (n3 < n) {
                    byArray[n3] = ((ByteValue)arrayReference.getValue(n3)).value();
                    ++n3;
                }
                return byArray;
            }
            if (string2.equals("short[]")) {
                int n = arrayReference.length();
                short[] sArray = new short[n];
                int n4 = 0;
                while (n4 < n) {
                    sArray[n4] = ((ShortValue)arrayReference.getValue(n4)).value();
                    ++n4;
                }
                return sArray;
            }
            if (string2.equals("int[]")) {
                int n = arrayReference.length();
                int[] nArray = new int[n];
                int n5 = 0;
                while (n5 < n) {
                    nArray[n5] = ((IntegerValue)arrayReference.getValue(n5)).value();
                    ++n5;
                }
                return nArray;
            }
            if (string2.equals("long[]")) {
                int n = arrayReference.length();
                long[] lArray = new long[n];
                int n6 = 0;
                while (n6 < n) {
                    lArray[n6] = ((LongValue)arrayReference.getValue(n6)).value();
                    ++n6;
                }
                return lArray;
            }
        } else if (this.value instanceof ObjectReference && (referenceType = (objectReference = (ObjectReference)this.value).referenceType()) instanceof ClassType && (string = (classType = (ClassType)referenceType).name()).equals("java.lang.StringBuffer")) {
            ArrayReference arrayReference = (ArrayReference)objectReference.getValue(referenceType.fieldByName("value"));
            List<Value> list = arrayReference.getValues();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < list.size()) {
                char c = ((CharValue)list.get(n)).value();
                if (c == '\u0000') break;
                stringBuffer.append(c);
                ++n;
            }
            return stringBuffer.toString();
        }
        return null;
    }

    private static String getCourtesyValueForValue(Value value) {
        try {
            ObjectReference objectReference;
            ReferenceType referenceType;
            if (value instanceof ClassObjectReference) {
                String string = ((ClassObjectReference)value).reflectedType().name();
                return string;
            }
            if (value instanceof StringReference) {
                String string = ((StringReference)value).value();
                return string;
            }
            if (value instanceof ArrayReference) {
                ArrayReference arrayReference = (ArrayReference)value;
                ReferenceType referenceType2 = arrayReference.referenceType();
                String string = referenceType2.name();
                if (string.equals("char[]")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = arrayReference.length();
                    int n2 = 0;
                    while (n2 < n) {
                        char c = ((CharValue)arrayReference.getValue(n2)).value();
                        if (c == '\u0000') break;
                        stringBuffer.append(c);
                        ++n2;
                    }
                    String string2 = stringBuffer.toString();
                    return string2;
                }
            } else if (value instanceof ObjectReference && (referenceType = (objectReference = (ObjectReference)value).referenceType()) instanceof ClassType) {
                ClassType classType = (ClassType)referenceType;
                while (classType != null) {
                    String string = classType.name();
                    if (string.equals("java.lang.StringBuffer")) {
                        ArrayReference arrayReference = (ArrayReference)objectReference.getValue(referenceType.fieldByName("value"));
                        List<Value> list = arrayReference.getValues();
                        StringBuffer stringBuffer = new StringBuffer();
                        int n = 0;
                        while (n < list.size()) {
                            char c = ((CharValue)list.get(n)).value();
                            if (c == '\u0000') break;
                            stringBuffer.append(c);
                            ++n;
                        }
                        String string3 = stringBuffer.toString();
                        return string3;
                    }
                    classType = classType.superclass();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public DebugMonitorInfo getMonitor() {
        this.throwIfExpired();
        if (this.dj.canGetMonitors() && this.value != null) {
            ObjectReference objectReference = (ObjectReference)this.value;
            return new DebugJDIMonitorInfo(this.dj, objectReference);
        }
        return null;
    }

    public String getValue() {
        this.throwIfExpired();
        if (this.value == null) {
            return "null";
        }
        return "";
    }

    public boolean equals(Object object) {
        if (object instanceof DebugJDIDataCompositeInfo) {
            return super.equals(object);
        }
        return false;
    }
}

