/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.List;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIArrayElementInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataObjectInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIFieldInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIMethodInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIVariableInfo;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;

class DebugJDIDataInfo
extends JDIInformationProvider
implements DebugDataInfo {
    DebugJDI dj;
    DebugJDIClassInfo clazz;
    Value value;
    Object owner;
    int stoppedCount;
    DebugJDIFieldInfo staticField;
    private int hashCode;

    DebugJDIDataInfo(DebugJDI debugJDI, DebugJDIClassInfo debugJDIClassInfo, Value value, Object object) {
        this.dj = debugJDI;
        this.clazz = debugJDIClassInfo;
        this.value = value;
        this.owner = object;
        this.stoppedCount = debugJDI.stoppedCount;
    }

    void setStaticField(DebugJDIFieldInfo debugJDIFieldInfo) {
        this.staticField = debugJDIFieldInfo;
    }

    public DebugVirtualMachine getVM() {
        return this.dj;
    }

    public boolean hasExpired() {
        if (this.dj.stoppedCount != this.stoppedCount && this.staticField != null && !this.staticField.hasExpired()) {
            this.value = this.staticField.updateStaticFieldValue();
            this.clazz = this.value != null ? this.dj.findClassByType(this.value.type()) : (DebugJDIClassInfo)this.staticField.getClassInfo();
            this.stoppedCount = this.dj.stoppedCount;
        }
        return this.dj.stoppedCount != this.stoppedCount;
    }

    protected void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Data has expired");
        }
    }

    public DebugClassInfo getClassInfo() {
        return this.clazz;
    }

    public String getValue() {
        return "";
    }

    public String getHexValue() {
        return "";
    }

    public boolean canModifyDataWithString() {
        DebugDataInfo debugDataInfo;
        if (this.owner != null) {
            if (this.value instanceof BooleanValue || this.value instanceof ByteValue || this.value instanceof CharValue || this.value instanceof DoubleValue || this.value instanceof FloatValue || this.value instanceof IntegerValue || this.value instanceof LongValue || this.value instanceof ShortValue || this.value instanceof StringReference) {
                return true;
            }
            if (this.value == null && this.clazz != null && this.clazz.name.equals("java.lang.String")) {
                return true;
            }
        }
        if (this instanceof DebugJDIDataObjectInfo && this.clazz != null && this.clazz.name.startsWith("$Oracle.Builtin.") && (debugDataInfo = DebugShared.findFieldData((DebugDataObjectInfo)((Object)this), "_value", "java.lang.String")) != null) {
            return debugDataInfo.canModifyDataWithString();
        }
        return false;
    }

    public boolean modifyDataWithString(String string) {
        DebugDataInfo debugDataInfo;
        Value value = null;
        if (this.value instanceof BooleanValue) {
            value = this.dj.makeBooleanValue(string);
        } else if (this.value instanceof ByteValue) {
            value = this.dj.makeByteValue(string);
        } else if (this.value instanceof CharValue) {
            value = this.dj.makeCharValue(string);
        } else if (this.value instanceof DoubleValue) {
            value = this.dj.makeDoubleValue(string);
        } else if (this.value instanceof FloatValue) {
            value = this.dj.makeFloatValue(string);
        } else if (this.value instanceof IntegerValue) {
            value = this.dj.makeIntegerValue(string);
        } else if (this.value instanceof LongValue) {
            value = this.dj.makeLongValue(string);
        } else if (this.value instanceof ShortValue) {
            value = this.dj.makeShortValue(string);
        } else if (this.value instanceof StringReference) {
            value = this.dj.makeStringValue(string);
        } else if (this.value == null && this.clazz != null && this.clazz.name.equals("java.lang.String")) {
            value = this.dj.makeStringValue(string);
        }
        if (value != null) {
            return this.modifyData(value);
        }
        if (this instanceof DebugJDIDataObjectInfo && this.clazz != null && this.clazz.name.startsWith("$Oracle.Builtin.") && (debugDataInfo = DebugShared.findFieldData((DebugDataObjectInfo)((Object)this), "_value", "java.lang.String")) != null) {
            return debugDataInfo.modifyDataWithString(string);
        }
        return false;
    }

    public boolean canModifyDataWithData() {
        return this.owner != null;
    }

    public boolean modifyDataWithData(DebugDataInfo debugDataInfo) {
        Value value = ((DebugJDIDataInfo)debugDataInfo).value;
        return this.modifyData(value);
    }

    public boolean canModifyDataWithNewObject() {
        return this.owner != null && this.value instanceof ObjectReference && this.dj.eventThread != null;
    }

    public boolean modifyDataWithNewObject(DebugMethodInfo debugMethodInfo, String[] stringArray) {
        boolean bl = false;
        if (this.value instanceof ObjectReference && this.dj.eventThread != null) {
            ObjectReference objectReference = null;
            List list = this.dj.tempDisableRequests();
            try {
                try {
                    DebugJDIMethodInfo debugJDIMethodInfo = (DebugJDIMethodInfo)debugMethodInfo;
                    ClassType classType = (ClassType)debugJDIMethodInfo.ci.getReferenceType();
                    Method method = debugJDIMethodInfo.m;
                    List<Value> list2 = this.dj.makeArgumentsFromStrings(method, stringArray);
                    if (list2 != null) {
                        objectReference = classType.newInstance(this.dj.eventThread, method, list2, 1);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            finally {
                DebugJDIStackFrameInfo.rebuildCache(this.dj);
                this.dj.tempReenableRequests(list);
                this.dj.incrementStoppedCount(false);
            }
            if (objectReference != null) {
                try {
                    bl = this.modifyData(objectReference);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return bl;
    }

    protected boolean modifyData(Value value) {
        try {
            if (this.owner instanceof DebugJDIVariableInfo) {
                DebugJDIVariableInfo debugJDIVariableInfo = (DebugJDIVariableInfo)this.owner;
                debugJDIVariableInfo.djsf.sf.setValue(debugJDIVariableInfo.lv, value);
                boolean bl = true;
                return bl;
            }
            if (this.owner instanceof DebugJDIFieldInfo) {
                DebugJDIFieldInfo debugJDIFieldInfo = (DebugJDIFieldInfo)this.owner;
                if (debugJDIFieldInfo.or != null) {
                    debugJDIFieldInfo.or.setValue(debugJDIFieldInfo.field, value);
                    boolean bl = true;
                    return bl;
                }
                if (debugJDIFieldInfo.isStatic) {
                    ((ClassType)debugJDIFieldInfo.declaringClass.getReferenceType()).setValue(debugJDIFieldInfo.field, value);
                    boolean bl = true;
                    return bl;
                }
            } else if (this.owner instanceof DebugJDIArrayElementInfo) {
                DebugJDIArrayElementInfo debugJDIArrayElementInfo = (DebugJDIArrayElementInfo)this.owner;
                ((ArrayReference)debugJDIArrayElementInfo.array.value).setValue(debugJDIArrayElementInfo.index, value);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.dj.hashCode();
            if (this.clazz != null) {
                this.hashCode += this.clazz.hashCode();
            }
            if (this.value != null) {
                this.hashCode += this.value.hashCode();
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugJDIDataInfo) {
            DebugJDIDataInfo debugJDIDataInfo = (DebugJDIDataInfo)object;
            return this.dj.equals(debugJDIDataInfo.dj) && this.clazz.equals(debugJDIDataInfo.clazz) && (this.value == null ? debugJDIDataInfo.value == null : this.value.equals(debugJDIDataInfo.value));
        }
        return false;
    }

    public Value getJDIValue() {
        return this.value;
    }
}

