/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.Mirror;
import com.sun.jdi.ShortValue;
import com.sun.jdi.Value;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataInfo;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugDataPrimitiveInfo;

final class DebugJDIDataPrimitiveInfo
extends DebugJDIDataInfo
implements DebugDataPrimitiveInfo {
    DebugJDIDataPrimitiveInfo(DebugJDI debugJDI, DebugJDIClassInfo debugJDIClassInfo, Value value, Object object) {
        super(debugJDI, debugJDIClassInfo, value, object);
    }

    public String getValue() {
        this.throwIfExpired();
        if (this.value instanceof CharValue) {
            char[] cArray = new char[]{'\'', ((CharValue)this.value).value(), '\''};
            return new String(cArray);
        }
        return ((Mirror)this.value).toString();
    }

    public String getHexValue() {
        this.throwIfExpired();
        long l = 0L;
        int n = 0;
        if (this.value instanceof BooleanValue) {
            if (((BooleanValue)this.value).value()) {
                return "01";
            }
            return "00";
        }
        if (this.value instanceof ByteValue) {
            l = ((ByteValue)this.value).value();
            n = 2;
        } else if (this.value instanceof CharValue) {
            l = ((CharValue)this.value).value();
            n = 4;
        } else if (this.value instanceof DoubleValue) {
            l = Double.doubleToLongBits(((DoubleValue)this.value).value());
            n = 16;
        } else if (this.value instanceof FloatValue) {
            l = Float.floatToIntBits(((FloatValue)this.value).value());
            n = 8;
        } else if (this.value instanceof IntegerValue) {
            l = ((IntegerValue)this.value).value();
            n = 8;
        } else if (this.value instanceof LongValue) {
            l = ((LongValue)this.value).value();
            n = 16;
        } else if (this.value instanceof ShortValue) {
            l = ((ShortValue)this.value).value();
            n = 4;
        }
        String string = Long.toHexString(l).toUpperCase();
        return DebugShared.prepadOrTrunc(string, '0', n);
    }

    public boolean equals(Object object) {
        if (object instanceof DebugJDIDataPrimitiveInfo) {
            return super.equals(object);
        }
        return false;
    }
}

