/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;

final class DebugJDIFieldInfo
extends JDIInformationProvider
implements DebugFieldInfo {
    DebugJDI dj;
    Field field;
    DebugJDIClassInfo declaringClass;
    ObjectReference or;
    int stoppedCount;
    boolean isStatic;
    private int hashCode;

    DebugJDIFieldInfo(DebugJDI debugJDI, Field field, DebugJDIClassInfo debugJDIClassInfo, ObjectReference objectReference) {
        this.dj = debugJDI;
        this.field = field;
        this.declaringClass = debugJDIClassInfo;
        this.or = objectReference;
        this.stoppedCount = debugJDI.stoppedCount;
        this.isStatic = field.isStatic();
    }

    public boolean hasExpired() {
        if (this.dj.stoppedCount != this.stoppedCount && !this.isStatic && !this.declaringClass.hasExpired()) {
            this.stoppedCount = this.dj.stoppedCount;
        }
        return this.dj.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Field has expired");
        }
    }

    public DebugClassInfo getClassInfo() {
        DebugJDIClassInfo debugJDIClassInfo;
        this.throwIfExpired();
        try {
            DebugJDIClassInfo debugJDIClassInfo2 = this.dj.findClassByType(this.field.type());
            if (debugJDIClassInfo2 != null) {
                DebugJDIClassInfo debugJDIClassInfo3 = debugJDIClassInfo2;
                return debugJDIClassInfo3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Value value = null;
        if (this.or != null) {
            value = this.or.getValue(this.field);
        } else if (this.isStatic) {
            value = this.declaringClass.getReferenceType().getValue(this.field);
        }
        if (value != null && (debugJDIClassInfo = this.dj.findClassByType(value.type())) != null) {
            return debugJDIClassInfo;
        }
        return this.dj.findClassByName(this.field.typeName(), true);
    }

    public String getGenericSignature() {
        return this.field.genericSignature();
    }

    public DebugClassInfo getDeclaringClassInfo() {
        this.hasExpired();
        return this.dj.findClassByType(this.field.declaringType());
    }

    public boolean isStatic() {
        this.throwIfExpired();
        return this.isStatic;
    }

    public boolean isFinal() {
        this.throwIfExpired();
        return this.field.isFinal();
    }

    public String getName() {
        this.throwIfExpired();
        return this.field.name();
    }

    public int getAccess() {
        this.throwIfExpired();
        return this.field.modifiers();
    }

    public DebugDataInfo getDataInfo() {
        this.throwIfExpired();
        boolean bl = false;
        Value value = null;
        if (this.or != null) {
            value = this.or.getValue(this.field);
            bl = true;
        } else if (this.isStatic) {
            value = this.declaringClass.getReferenceType().getValue(this.field);
            bl = true;
        }
        if (bl) {
            DebugJDIDataInfo debugJDIDataInfo = value != null ? this.dj.makeData(value, this) : this.dj.makeNullData((DebugJDIClassInfo)this.getClassInfo(), this);
            if (this.isStatic) {
                debugJDIDataInfo.setStaticField(this);
            }
            return debugJDIDataInfo;
        }
        return null;
    }

    Value updateStaticFieldValue() {
        return this.declaringClass.getReferenceType().getValue(this.field);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.field.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugJDIFieldInfo) {
            DebugJDIFieldInfo debugJDIFieldInfo = (DebugJDIFieldInfo)object;
            return this.field.equals(debugJDIFieldInfo.field);
        }
        return false;
    }

    public Field getJDIField() {
        return this.field;
    }
}

