/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.util.List;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIMethodInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;

public final class DebugJDILocation
implements DebugLocation {
    DebugJDI dj;
    Location location;
    DebugJDIClassInfo clazz;
    Method m;
    DebugJDIMethodInfo method;
    int line;
    boolean exactLine;

    DebugJDILocation(DebugJDI debugJDI, Location location) {
        this.dj = debugJDI;
        this.location = location;
        ReferenceType referenceType = location.declaringType();
        String string = referenceType.defaultStratum();
        this.clazz = debugJDI.findClass(referenceType);
        this.m = location.method();
        this.method = new DebugJDIMethodInfo(debugJDI, this.clazz, this.m);
        try {
            if (!this.m.isNative()) {
                this.line = DebugJDI.getLineNumber(location, string);
            }
        }
        catch (InternalError internalError) {
            // empty catch block
        }
        if (this.line > 0) {
            try {
                List list = DebugJDI.getLocationsOfLine(this.m, null, null, this.line);
                Location location2 = DebugJDI.getFirstLocation(list);
                if (location2 != null && location2.codeIndex() == location.codeIndex()) {
                    this.exactLine = true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public DebugMethodInfo getMethod() {
        return this.method;
    }

    public DebugClassInfo getClassInfo() {
        return this.clazz;
    }

    public String getPath() {
        try {
            String string = this.location.sourcePath();
            return string;
        }
        catch (AbsentInformationException absentInformationException) {
            return "";
        }
    }

    public String getFilename() {
        try {
            String string = this.location.sourceName();
            return string;
        }
        catch (AbsentInformationException absentInformationException) {
        }
        catch (InternalError internalError) {
            // empty catch block
        }
        return "";
    }

    public long getAddress() {
        return 0L;
    }

    public int getBytecodeOffset() {
        if (!this.m.isNative()) {
            return (int)this.location.codeIndex();
        }
        return -1;
    }

    public boolean isBytecodeExact() {
        return true;
    }

    public int getLine() {
        return this.line;
    }

    public boolean isLineExact() {
        return this.exactLine;
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DebugJDILocation) {
            DebugJDILocation debugJDILocation = (DebugJDILocation)object;
            return this.location.equals(debugJDILocation.location);
        }
        return false;
    }
}

