/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.model.Project;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataObjectInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDILocation;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.shared.DebugSharedDisassemble;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDisassembleInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

final class DebugJDIMethodInfo
implements DebugMethodInfo {
    static final String javaStratum = "Java";
    DebugJDI dj;
    DebugJDIClassInfo ci;
    Method m;
    String name;
    private static Map hashBytecodes;
    private static Map hashBytecodesStoppedCount;
    private List javaLineLocations;
    private int hashCode;

    DebugJDIMethodInfo(DebugJDI debugJDI, DebugJDIClassInfo debugJDIClassInfo, Method method) {
        this.dj = debugJDI;
        this.ci = debugJDIClassInfo;
        this.m = method;
        this.name = DebugJDIMethodInfo.getFullMethodName(debugJDIClassInfo.name, method);
        if (hashBytecodes == null) {
            hashBytecodes = new HashMap();
            hashBytecodesStoppedCount = new HashMap();
        }
    }

    public DebugVirtualMachine getVM() {
        return this.dj;
    }

    public boolean hasExpired() {
        return this.ci.hasExpired();
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Method has expired");
        }
    }

    public DebugClassInfo getClassInfo() {
        return this.ci;
    }

    public boolean isCompiled() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getNameWithoutClass() {
        return DebugShared.getNameWithoutClass(this.name);
    }

    public String getNameWithoutSignature() {
        return DebugShared.getNameWithoutSignature(this.name);
    }

    public String getNameWithoutClassOrSignature() {
        return DebugShared.getNameWithoutClassOrSignature(this.name);
    }

    public String getParameterSignature() {
        return DebugShared.getMethodParameterSignature(this.name);
    }

    public int getAccess() {
        this.throwIfExpired();
        return this.m.modifiers();
    }

    private List getJavaLineLocations() {
        if (this.javaLineLocations == null) {
            try {
                List<String> list;
                ReferenceType referenceType = this.ci.getReferenceType();
                if (referenceType != null && (list = referenceType.sourceNames(javaStratum)) != null && list.size() >= 1) {
                    String string = list.get(0);
                    this.javaLineLocations = this.m.allLineLocations(javaStratum, string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.javaLineLocations;
    }

    private byte[] getOldBytecodes() {
        return (byte[])hashBytecodes.get(this.name);
    }

    private byte[] getBytecodesSmart() {
        int n;
        byte[] byArray = (byte[])hashBytecodes.get(this.name);
        Integer n2 = (Integer)hashBytecodesStoppedCount.get(this.name);
        int n3 = n = n2 != null ? n2 : 0;
        if (byArray == null || n != this.dj.stoppedCount) {
            this.dj.tempDisableBreakpoints();
            try {
                try {
                    byArray = this.m.bytecodes();
                    n = this.dj.stoppedCount;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    byArray = new byte[]{};
                    n = this.dj.stoppedCount;
                }
            }
            finally {
                this.dj.tempReenableBreakpoints();
            }
            hashBytecodes.put(this.name, byArray);
            hashBytecodesStoppedCount.put(this.name, new Integer(n));
        }
        return byArray;
    }

    public int[] getMethodLineRange() {
        this.throwIfExpired();
        int[] nArray = new int[]{0, 0};
        List list = this.getJavaLineLocations();
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                Location location = (Location)list.get(n);
                int n2 = DebugJDI.getLineNumber(location, javaStratum);
                if (n2 < nArray[0] || nArray[0] == 0) {
                    nArray[0] = n2;
                }
                if (n2 > nArray[1] || nArray[1] == 0) {
                    nArray[1] = n2;
                }
                ++n;
            }
        }
        return nArray;
    }

    public int[] getMethodLines() {
        this.throwIfExpired();
        List list = this.getJavaLineLocations();
        if (list != null) {
            int[] nArray = new int[list.size()];
            int n = 0;
            while (n < list.size()) {
                Location location = (Location)list.get(n);
                nArray[n] = DebugJDI.getLineNumber(location, javaStratum);
                ++n;
            }
            return nArray;
        }
        return new int[0];
    }

    public int[] getCodeCoverage() {
        return new int[0];
    }

    public double getCodeCoverageRatio() {
        return 0.0;
    }

    public DebugLocation getFirstLocation() {
        this.throwIfExpired();
        try {
            int n = 0;
            Location location = null;
            String string = this.ci.getReferenceType().defaultStratum();
            List list = this.getJavaLineLocations();
            if (list != null) {
                int n2 = 0;
                while (n2 < list.size()) {
                    int n3;
                    Location location2 = (Location)list.get(n2);
                    if (DebugJDI.getLineNumber(location2, string) != -1 && ((n3 = DebugJDI.getLineNumber(location2, javaStratum)) < n || n == 0)) {
                        n = n3;
                        location = location2;
                    }
                    ++n2;
                }
            }
            if (location != null) {
                DebugJDILocation debugJDILocation = this.dj.makeLocation(location);
                return debugJDILocation;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public DebugLocation getLocation(String string, int n) {
        this.throwIfExpired();
        try {
            ReferenceType referenceType = this.ci.getReferenceType();
            if (referenceType != null) {
                List<String> list = referenceType.availableStrata();
                for (String string2 : list) {
                    List list2 = DebugJDI.getLocationsOfLine(this.m, string2, string, n);
                    Location location = DebugJDI.getFirstLocation(list2);
                    if (location == null) continue;
                    DebugJDILocation debugJDILocation = this.dj.makeLocation(location);
                    return debugJDILocation;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public DebugDisassembleInfo[] disassembleMethod(boolean bl, boolean bl2, boolean bl3, Project project) {
        if (this.dj.canDisassembleMethod()) {
            int[] nArray = null;
            int[] nArray2 = null;
            if (bl) {
                List list = this.getJavaLineLocations();
                int n = list.size();
                nArray = new int[n];
                nArray2 = new int[n];
                int n2 = 0;
                while (n2 < n) {
                    Location location = (Location)list.get(n2);
                    nArray[n2] = DebugJDI.getLineNumber(location, javaStratum);
                    nArray2[n2] = (int)location.codeIndex();
                    ++n2;
                }
            }
            String string = this.getClassInfo().getName();
            DebugSharedDisassemble debugSharedDisassemble = new DebugSharedDisassemble(bl, bl2, this.getBytecodesSmart(), nArray, nArray2, project, string);
            return debugSharedDisassemble.getArray();
        }
        return new DebugDisassembleInfo[0];
    }

    public boolean hasMethodChanged() {
        byte[] byArray = this.getOldBytecodes();
        if (byArray == null) {
            return true;
        }
        byte[] byArray2 = this.getBytecodesSmart();
        if (byArray == byArray2) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return true;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public byte[] getBytecodes() {
        byte[] byArray = this.getBytecodesSmart();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public byte getBytecode(int n) {
        byte[] byArray = this.getBytecodesSmart();
        if (n >= 0 && n < byArray.length) {
            return byArray[n];
        }
        return 0;
    }

    public DebugDataInfo invoke(List list) {
        if (this.dj.eventThread != null) {
            Value value;
            block14: {
                Object e;
                int n = list.size();
                int n2 = 0;
                ArrayList<Value> arrayList = new ArrayList<Value>(n);
                ClassType classType = null;
                ObjectReference objectReference = null;
                if (this.m.isStatic()) {
                    classType = (ClassType)this.ci.getReferenceType();
                } else if ((e = list.get(n2++)) instanceof DebugJDIDataObjectInfo) {
                    DebugJDIDataObjectInfo debugJDIDataObjectInfo = (DebugJDIDataObjectInfo)e;
                    objectReference = (ObjectReference)debugJDIDataObjectInfo.value;
                } else if (e instanceof String) {
                    objectReference = this.dj.makeStringValue((String)e);
                }
                while (n2 < n) {
                    Object e2 = list.get(n2++);
                    Value value2 = this.dj.makeValue(e2);
                    arrayList.add(value2);
                }
                value = null;
                List list2 = this.dj.tempDisableRequests();
                try {
                    try {
                        if (classType != null) {
                            value = classType.invokeMethod(this.dj.eventThread, this.m, arrayList, 1);
                            break block14;
                        }
                        value = objectReference.invokeMethod(this.dj.eventThread, this.m, arrayList, 3);
                    }
                    catch (Exception exception) {}
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this.dj);
                    this.dj.tempReenableRequests(list2);
                }
            }
            if (value != null) {
                return this.dj.makeData(value, null);
            }
        }
        return null;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.m.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugJDIMethodInfo) {
            DebugJDIMethodInfo debugJDIMethodInfo = (DebugJDIMethodInfo)object;
            return this.m.equals(debugJDIMethodInfo.m);
        }
        return false;
    }

    static String getFullMethodName(String string, Method method) {
        String string2 = method.returnTypeName() + " " + string + "." + method.name() + "(";
        List<String> list = method.argumentTypeNames();
        int n = 0;
        while (n < list.size()) {
            string2 = string2 + list.get(n);
            if (n + 1 < list.size()) {
                string2 = string2 + ", ";
            }
            ++n;
        }
        string2 = string2 + ")";
        return string2;
    }
}

