/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import java.util.ArrayList;
import java.util.List;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIThreadInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;

final class DebugJDIMonitorInfo
implements DebugMonitorInfo {
    DebugJDI dj;
    ObjectReference or;
    int stoppedCount;
    private int hashCode;

    DebugJDIMonitorInfo(DebugJDI debugJDI, ObjectReference objectReference) {
        this.dj = debugJDI;
        this.or = objectReference;
        this.stoppedCount = debugJDI.stoppedCount;
    }

    public boolean hasExpired() {
        return this.dj.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("MonitorInfo has expired");
        }
    }

    public boolean isClassMonitor() {
        return this.or instanceof ClassObjectReference;
    }

    public boolean isInstanceMonitor() {
        return this.or instanceof ClassObjectReference ^ true;
    }

    public int getEntryCount() {
        this.throwIfExpired();
        try {
            int n = this.or.entryCount();
            return n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public int getWaiterCount() {
        this.throwIfExpired();
        try {
            int n = 0;
            List<ThreadReference> list = this.or.waitingThreads();
            int n2 = 0;
            while (n2 < list.size()) {
                ThreadReference threadReference = list.get(n2);
                if (threadReference.status() == 4) {
                    ++n;
                }
                ++n2;
            }
            List list2 = this.dj.getOtherWaitingThreads(this.or);
            if (list2 != null) {
                int n3 = 0;
                while (n3 < list2.size()) {
                    ThreadReference threadReference = (ThreadReference)list2.get(n3);
                    if (!list.contains(threadReference)) {
                        ++n;
                    }
                    ++n3;
                }
            }
            int n4 = n;
            return n4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public DebugThreadInfo getOwnerThread() {
        this.throwIfExpired();
        try {
            ThreadReference threadReference = this.or.owningThread();
            if (threadReference != null) {
                DebugJDIThreadInfo debugJDIThreadInfo = DebugJDIThreadInfo.makeThreadInfo(this.dj, threadReference);
                return debugJDIThreadInfo;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public DebugThreadInfo[] listWaitingThreads() {
        this.throwIfExpired();
        try {
            ArrayList<DebugJDIThreadInfo> arrayList = new ArrayList<DebugJDIThreadInfo>();
            List<ThreadReference> list = this.or.waitingThreads();
            int n = 0;
            while (n < list.size()) {
                ThreadReference threadReference = list.get(n);
                if (threadReference.status() == 4) {
                    arrayList.add(DebugJDIThreadInfo.makeThreadInfo(this.dj, threadReference));
                }
                ++n;
            }
            List list2 = this.dj.getOtherWaitingThreads(this.or);
            if (list2 != null) {
                int n2 = 0;
                while (n2 < list2.size()) {
                    ThreadReference threadReference = (ThreadReference)list2.get(n2);
                    if (!list.contains(threadReference)) {
                        arrayList.add(DebugJDIThreadInfo.makeThreadInfo(this.dj, threadReference));
                    }
                    ++n2;
                }
            }
            DebugThreadInfo[] debugThreadInfoArray = new DebugThreadInfo[arrayList.size()];
            DebugThreadInfo[] debugThreadInfoArray2 = arrayList.toArray(debugThreadInfoArray);
            return debugThreadInfoArray2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new DebugThreadInfo[0];
        }
    }

    public DebugThreadInfo[] listBlockedThreads() {
        this.throwIfExpired();
        try {
            List<ThreadReference> list = this.or.waitingThreads();
            ArrayList<DebugJDIThreadInfo> arrayList = new ArrayList<DebugJDIThreadInfo>();
            int n = 0;
            while (n < list.size()) {
                ThreadReference threadReference = list.get(n);
                if (threadReference.status() == 3) {
                    arrayList.add(DebugJDIThreadInfo.makeThreadInfo(this.dj, threadReference));
                }
                ++n;
            }
            DebugThreadInfo[] debugThreadInfoArray = new DebugThreadInfo[arrayList.size()];
            DebugThreadInfo[] debugThreadInfoArray2 = arrayList.toArray(debugThreadInfoArray);
            return debugThreadInfoArray2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new DebugThreadInfo[0];
        }
    }

    public DebugDataCompositeInfo getAssociatedObject() {
        this.throwIfExpired();
        return (DebugDataCompositeInfo)((Object)this.dj.makeData(this.or, null));
    }

    public DebugLocation getEntryLocation() {
        return null;
    }

    public boolean canDoNotify() {
        try {
            if (this.dj.eventThread != null && this.dj.eventThread == this.or.owningThread()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void doNotify() {
        this.invokeNotify("notify");
    }

    public void doNotifyAll() {
        this.invokeNotify("notifyAll");
    }

    private void invokeNotify(String string) {
        Method method;
        DebugJDIClassInfo debugJDIClassInfo;
        if (this.canDoNotify() && (debugJDIClassInfo = this.dj.findClassByName("java.lang.Object", false)) != null && debugJDIClassInfo.type instanceof ClassType && (method = ((ClassType)debugJDIClassInfo.type).concreteMethodByName(string, "()V")) != null) {
            List list = this.dj.tempDisableRequests();
            try {
                try {
                    this.or.invokeMethod(this.dj.eventThread, method, new ArrayList(), 1);
                }
                catch (Exception exception) {}
            }
            finally {
                DebugJDIStackFrameInfo.rebuildCache(this.dj);
                this.dj.tempReenableRequests(list);
            }
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.or.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugJDIMonitorInfo) {
            DebugJDIMonitorInfo debugJDIMonitorInfo = (DebugJDIMonitorInfo)object;
            return this.or.equals(debugJDIMonitorInfo.or);
        }
        return false;
    }
}

