/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import java.util.List;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugArrayElementInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;

final class DebugJDIPlsqlTableElement {
    static String parseTableElement(String string, List list) {
        int n;
        int n2 = string.indexOf("(");
        if (n2 != -1 && (n = string.indexOf(")", n2 + 1)) == string.length() - 1) {
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1, n);
            list.add(string3);
            return string2;
        }
        return null;
    }

    private static DebugDataInfo getTableElementData(DebugDataInfo debugDataInfo, String string) {
        DebugDataObjectInfo debugDataObjectInfo;
        DebugDataInfo debugDataInfo2;
        DebugClassInfo debugClassInfo = debugDataInfo.getClassInfo();
        String string2 = debugClassInfo.getName();
        if (string2.startsWith("$Oracle.") && debugDataInfo instanceof DebugDataObjectInfo && (debugDataInfo2 = DebugShared.findFieldData(debugDataObjectInfo = (DebugDataObjectInfo)debugDataInfo, "_values", null)) instanceof DebugDataArrayInfo) {
            DebugDataArrayInfo debugDataArrayInfo = (DebugDataArrayInfo)debugDataInfo2;
            int n = debugDataArrayInfo.getArrayCount();
            int n2 = 0;
            while (n2 < n) {
                DebugDataInfo debugDataInfo3;
                String string3;
                DebugDataObjectInfo debugDataObjectInfo2;
                DebugDataInfo debugDataInfo4;
                DebugArrayElementInfo debugArrayElementInfo;
                DebugDataInfo debugDataInfo5;
                DebugArrayElementInfo[] debugArrayElementInfoArray = debugDataArrayInfo.getArrayElements(n2, 1);
                if (debugArrayElementInfoArray != null && debugArrayElementInfoArray.length == 1 && (debugDataInfo5 = (debugArrayElementInfo = debugArrayElementInfoArray[0]).getDataInfo()) instanceof DebugDataObjectInfo && (debugDataInfo4 = DebugShared.findFieldData(debugDataObjectInfo2 = (DebugDataObjectInfo)debugDataInfo5, "_key", null)) instanceof DebugDataCompositeInfo && string.equals(string3 = DebugShared.makeCourtesyValue((DebugDataCompositeInfo)debugDataInfo4)) && (debugDataInfo3 = DebugShared.findFieldData(debugDataObjectInfo2, "_value", null)) != null) {
                    return debugDataInfo3;
                }
                ++n2;
            }
        }
        return null;
    }

    static DebugVariableInfo getTableElementVariable(DebugVariableInfo[] debugVariableInfoArray, String string, List list, DebugJDI debugJDI, String string2, boolean bl, boolean bl2) {
        if (list.size() == 1) {
            String string3 = (String)list.get(0);
            int n = debugVariableInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                DebugDataInfo debugDataInfo;
                DebugDataInfo debugDataInfo2;
                DebugVariableInfo debugVariableInfo = debugVariableInfoArray[n2];
                if (debugVariableInfo.getName().equals(string) && (debugDataInfo2 = DebugJDIPlsqlTableElement.getTableElementData(debugDataInfo = debugVariableInfo.getDataInfo(), string3)) != null) {
                    return new VariableInfo(debugJDI, string2, debugDataInfo2, bl, bl2);
                }
                ++n2;
            }
        }
        return null;
    }

    static DebugFieldInfo getTableElementField(DebugFieldInfo[] debugFieldInfoArray, String string, List list, DebugJDI debugJDI, String string2, DebugClassInfo debugClassInfo, boolean bl) {
        if (list.size() == 1) {
            String string3 = (String)list.get(0);
            int n = debugFieldInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                DebugDataInfo debugDataInfo;
                DebugDataInfo debugDataInfo2;
                DebugFieldInfo debugFieldInfo = debugFieldInfoArray[n2];
                if (debugFieldInfo.getName().equals(string) && (debugDataInfo2 = DebugJDIPlsqlTableElement.getTableElementData(debugDataInfo = debugFieldInfo.getDataInfo(), string3)) != null) {
                    return new FieldInfo(debugJDI, string2, debugDataInfo2, debugClassInfo, bl);
                }
                ++n2;
            }
        }
        return null;
    }

    DebugJDIPlsqlTableElement() {
    }

    static class VariableInfo
    implements DebugVariableInfo {
        private DebugJDI dj;
        private String name;
        private DebugDataInfo dataInfo;
        private boolean argument;
        private boolean local;
        private int stoppedCount;

        VariableInfo(DebugJDI debugJDI, String string, DebugDataInfo debugDataInfo, boolean bl, boolean bl2) {
            this.dj = debugJDI;
            this.name = string;
            this.dataInfo = debugDataInfo;
            this.argument = bl;
            this.local = bl2;
            this.stoppedCount = debugJDI.stoppedCount;
        }

        public boolean hasExpired() {
            return this.stoppedCount != this.dj.stoppedCount;
        }

        public DebugClassInfo getClassInfo() {
            return this.dataInfo.getClassInfo();
        }

        public String getGenericSignature() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInScope() {
            return true;
        }

        public boolean isArgument() {
            return this.argument;
        }

        public boolean isLocal() {
            return this.local;
        }

        public boolean isReturn() {
            return false;
        }

        public boolean isReturned() {
            return false;
        }

        public DebugDataInfo getDataInfo() {
            return this.dataInfo;
        }

        public int getSlotSize() {
            return 1;
        }
    }

    static class FieldInfo
    implements DebugFieldInfo {
        private DebugJDI dj;
        private String name;
        private DebugDataInfo dataInfo;
        private DebugClassInfo declaringClass;
        private boolean isStatic;
        private int stoppedCount;

        FieldInfo(DebugJDI debugJDI, String string, DebugDataInfo debugDataInfo, DebugClassInfo debugClassInfo, boolean bl) {
            this.dj = debugJDI;
            this.name = string;
            this.dataInfo = debugDataInfo;
            this.declaringClass = debugClassInfo;
            this.isStatic = bl;
            this.stoppedCount = debugJDI.stoppedCount;
        }

        public boolean hasExpired() {
            return this.stoppedCount != this.dj.stoppedCount;
        }

        public DebugClassInfo getClassInfo() {
            return this.dataInfo.getClassInfo();
        }

        public String getGenericSignature() {
            return null;
        }

        public DebugClassInfo getDeclaringClassInfo() {
            return this.declaringClass;
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public boolean isFinal() {
            return false;
        }

        public String getName() {
            return this.name;
        }

        public int getAccess() {
            return 0;
        }

        public DebugDataInfo getDataInfo() {
            return this.dataInfo;
        }
    }
}

