/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDILocation;
import oracle.jdevimpl.debugger.jdi.DebugJDIPlsqlTableElement;
import oracle.jdevimpl.debugger.jdi.DebugJDIStoppedListener;
import oracle.jdevimpl.debugger.jdi.DebugJDIVariableInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugStackSlotInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;

final class DebugJDIStackFrameInfo
extends JDIInformationProvider
implements DebugJDIStoppedListener,
DebugStackFrameInfo {
    DebugJDI dj;
    ThreadReference tr;
    int frameNumber;
    StackFrame sf;
    int stoppedCount;
    boolean popped;
    DebugJDILocation location;
    private boolean stoppedListener;
    private SoftReference sfThisObject;
    private SoftReference sfMethodVariables;
    private SoftReference sfArguments;
    private SoftReference sfLocals;
    private int hashCode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DebugJDIStackFrameInfo makeStackFrameInfo(DebugJDI debugJDI, ThreadReference threadReference, int n, StackFrame stackFrame) {
        Map map = debugJDI.stackFrameInfos;
        synchronized (map) {
            try {
                DebugJDIStackFrameInfo debugJDIStackFrameInfo;
                SoftReference softReference = (SoftReference)debugJDI.stackFrameInfos.get(stackFrame);
                if (softReference != null && (debugJDIStackFrameInfo = (DebugJDIStackFrameInfo)softReference.get()) != null) {
                    DebugJDIStackFrameInfo debugJDIStackFrameInfo2 = debugJDIStackFrameInfo;
                    return debugJDIStackFrameInfo2;
                }
            }
            catch (Exception exception) {
                DebugJDIStackFrameInfo.clearCache(debugJDI);
            }
            DebugJDIStackFrameInfo debugJDIStackFrameInfo = new DebugJDIStackFrameInfo(debugJDI, threadReference, n, stackFrame);
            debugJDI.stackFrameInfos.put(stackFrame, new SoftReference<DebugJDIStackFrameInfo>(debugJDIStackFrameInfo));
            DebugJDIStackFrameInfo debugJDIStackFrameInfo3 = debugJDIStackFrameInfo;
            return debugJDIStackFrameInfo3;
        }
    }

    private DebugJDIStackFrameInfo(DebugJDI debugJDI, ThreadReference threadReference, int n, StackFrame stackFrame) {
        this.dj = debugJDI;
        this.tr = threadReference;
        this.frameNumber = n;
        this.sf = stackFrame;
        this.stoppedCount = debugJDI.stoppedCount;
        this.location = debugJDI.makeLocation(stackFrame.location());
    }

    public void stopped(boolean bl) {
        this.clearSoftReferences();
        this.stoppedListener = false;
        this.dj.removeStoppedListener(this);
    }

    private void clearSoftReferences() {
        this.sfThisObject = null;
        this.sfMethodVariables = null;
        this.sfArguments = null;
        this.sfLocals = null;
    }

    public boolean hasExpired() {
        return this.stoppedCount != this.dj.stoppedCount || this.popped;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("StackFrame has expired");
        }
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public DebugLocation getLocation() {
        return this.location;
    }

    private ObjectReference getThisObject() {
        try {
            Object t;
            if (this.sfThisObject != null && (t = this.sfThisObject.get()) != null) {
                ObjectReference objectReference = (ObjectReference)t;
                return objectReference;
            }
            if (this.dj.isMethodObsolete(this.sf.location().method())) {
                ObjectReference objectReference = null;
                return objectReference;
            }
            ObjectReference objectReference = this.sf.thisObject();
            if (objectReference != null) {
                this.sfThisObject = new SoftReference<ObjectReference>(objectReference);
                if (!this.stoppedListener) {
                    this.stoppedListener = true;
                    this.dj.addStoppedListener(this);
                }
            }
            ObjectReference objectReference2 = objectReference;
            return objectReference2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private List getVariables() {
        try {
            Object t;
            if (this.sfMethodVariables != null && (t = this.sfMethodVariables.get()) != null) {
                List list = (List)t;
                return list;
            }
            Method method = this.sf.location().method();
            ArrayList<Object> arrayList = method.isNative() ? new ArrayList(0) : new ArrayList<LocalVariable>(method.variables());
            if (arrayList != null) {
                Collections.sort(arrayList, new 1());
                this.sfMethodVariables = new SoftReference(arrayList);
                if (!this.stoppedListener) {
                    this.stoppedListener = true;
                    this.dj.addStoppedListener(this);
                }
            }
            ArrayList<Object> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (AbsentInformationException absentInformationException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private DebugVariableInfo findVariableByName(DebugVariableInfo[] debugVariableInfoArray, String string) {
        int n = debugVariableInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (string.equals(debugVariableInfoArray[n2].getName())) {
                return debugVariableInfoArray[n2];
            }
            ++n2;
        }
        return null;
    }

    public DebugVariableInfo[] listArguments() {
        List list;
        Object t;
        this.throwIfExpired();
        if (this.sfArguments != null && (t = this.sfArguments.get()) != null) {
            return (DebugVariableInfo[])t;
        }
        ArrayList<DebugJDIVariableInfo> arrayList = new ArrayList<DebugJDIVariableInfo>();
        ObjectReference objectReference = this.getThisObject();
        if (objectReference != null) {
            arrayList.add(new DebugJDIVariableInfo(this.dj, objectReference));
        }
        if ((list = this.getVariables()) != null) {
            int n = 0;
            while (n < list.size()) {
                LocalVariable localVariable = (LocalVariable)list.get(n);
                if (localVariable.isArgument()) {
                    arrayList.add(new DebugJDIVariableInfo(this.dj, this, localVariable, true, false));
                }
                ++n;
            }
        }
        DebugVariableInfo[] debugVariableInfoArray = arrayList.toArray(new DebugVariableInfo[arrayList.size()]);
        this.sfArguments = new SoftReference<DebugVariableInfo[]>(debugVariableInfoArray);
        if (!this.stoppedListener) {
            this.stoppedListener = true;
            this.dj.addStoppedListener(this);
        }
        return debugVariableInfoArray;
    }

    public DebugVariableInfo[] listLocals() {
        Object t;
        this.throwIfExpired();
        if (this.sfLocals != null && (t = this.sfLocals.get()) != null) {
            return (DebugVariableInfo[])t;
        }
        ArrayList<DebugJDIVariableInfo> arrayList = new ArrayList<DebugJDIVariableInfo>();
        List list = this.getVariables();
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                LocalVariable localVariable = (LocalVariable)list.get(n);
                if (!localVariable.isArgument()) {
                    arrayList.add(new DebugJDIVariableInfo(this.dj, this, localVariable, false, true));
                }
                ++n;
            }
        }
        DebugVariableInfo[] debugVariableInfoArray = arrayList.toArray(new DebugVariableInfo[arrayList.size()]);
        this.sfLocals = new SoftReference<DebugVariableInfo[]>(debugVariableInfoArray);
        if (!this.stoppedListener) {
            this.stoppedListener = true;
            this.dj.addStoppedListener(this);
        }
        return debugVariableInfoArray;
    }

    public DebugVariableInfo getVariable(String string) {
        block6: {
            this.throwIfExpired();
            try {
                if (this.getLanguage() == 2) {
                    ArrayList arrayList = new ArrayList();
                    String string2 = DebugJDIPlsqlTableElement.parseTableElement(string, arrayList);
                    if (string2 != null) {
                        DebugVariableInfo debugVariableInfo = DebugJDIPlsqlTableElement.getTableElementVariable(this.listArguments(), string2, arrayList, this.dj, string, true, false);
                        if (debugVariableInfo == null) {
                            debugVariableInfo = DebugJDIPlsqlTableElement.getTableElementVariable(this.listLocals(), string2, arrayList, this.dj, string, false, true);
                        }
                        DebugVariableInfo debugVariableInfo2 = debugVariableInfo;
                        return debugVariableInfo2;
                    }
                    break block6;
                }
                DebugVariableInfo debugVariableInfo = this.findVariableByName(this.listArguments(), string);
                if (debugVariableInfo == null) {
                    debugVariableInfo = this.findVariableByName(this.listLocals(), string);
                }
                DebugVariableInfo debugVariableInfo3 = debugVariableInfo;
                return debugVariableInfo3;
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) break block6;
                throw (ThreadDeath)throwable;
            }
        }
        return null;
    }

    public DebugStackSlotInfo[] listSlots() {
        this.throwIfExpired();
        return new DebugStackSlotInfo[0];
    }

    public int getLanguage() {
        DebugClassInfo debugClassInfo;
        if (this.location != null && (debugClassInfo = this.location.getClassInfo()) != null) {
            return debugClassInfo.getLanguage();
        }
        return 0;
    }

    public boolean popBackToHere() {
        int n;
        this.throwIfExpired();
        if (this.dj.canPopFrames() && (n = this.frameNumber - 1) >= 0) {
            try {
                DebugJDIStackFrameInfo.clearCache(this.dj);
                this.tr.popFrames(this.tr.frame(n));
                this.dj.incrementStoppedCount(false);
                boolean bl = true;
                return bl;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.tr.hashCode() + this.frameNumber;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugJDIStackFrameInfo) {
            DebugJDIStackFrameInfo debugJDIStackFrameInfo = (DebugJDIStackFrameInfo)object;
            return this.dj.equals(debugJDIStackFrameInfo.dj) && this.tr.equals(debugJDIStackFrameInfo.tr) && this.frameNumber == debugJDIStackFrameInfo.frameNumber && (this.location == null ? debugJDIStackFrameInfo.location == null : this.location.equals(debugJDIStackFrameInfo.location));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache(DebugJDI debugJDI) {
        Map map = debugJDI.stackFrameInfos;
        synchronized (map) {
            debugJDI.stackFrameInfos.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void rebuildCache(DebugJDI debugJDI) {
        Map map = debugJDI.stackFrameInfos;
        synchronized (map) {
            ArrayList<DebugJDIStackFrameInfo> arrayList = new ArrayList<DebugJDIStackFrameInfo>();
            for (SoftReference softReference : debugJDI.stackFrameInfos.values()) {
                DebugJDIStackFrameInfo debugJDIStackFrameInfo;
                if (softReference == null || (debugJDIStackFrameInfo = (DebugJDIStackFrameInfo)softReference.get()) == null) continue;
                arrayList.add(debugJDIStackFrameInfo);
                boolean bl = false;
                try {
                    debugJDIStackFrameInfo.sf.equals(debugJDIStackFrameInfo.sf);
                }
                catch (Exception exception) {
                    bl = true;
                }
                try {
                    if (!bl) continue;
                    debugJDIStackFrameInfo.sf = debugJDIStackFrameInfo.tr.frame(debugJDIStackFrameInfo.frameNumber);
                    debugJDIStackFrameInfo.clearSoftReferences();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            debugJDI.stackFrameInfos.clear();
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                DebugJDIStackFrameInfo debugJDIStackFrameInfo = (DebugJDIStackFrameInfo)arrayList.get(n2);
                debugJDI.stackFrameInfos.put(debugJDIStackFrameInfo.sf, new SoftReference<DebugJDIStackFrameInfo>(debugJDIStackFrameInfo));
                ++n2;
            }
        }
    }

    public Location getJDILocation() {
        try {
            Location location = this.sf.location();
            return location;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Method getJDIMethod() {
        try {
            Method method = this.sf.location().method();
            return method;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public StackFrame getJDIStackFrame() {
        return this.sf;
    }

    final class 1
    implements Comparator {
        public int compare(LocalVariable localVariable, LocalVariable localVariable2) {
            return localVariable.compareTo(localVariable2);
        }
    }
}

