/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.List;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIThreadInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;

final class DebugJDIThreadGroupInfo
extends JDIInformationProvider
implements DebugThreadGroupInfo {
    DebugJDI dj;
    ThreadGroupReference tgr;
    int stoppedCount;
    private int hashCode;

    DebugJDIThreadGroupInfo(DebugJDI debugJDI, ThreadGroupReference threadGroupReference) {
        this.dj = debugJDI;
        this.tgr = threadGroupReference;
        this.stoppedCount = debugJDI.stoppedCount;
    }

    public boolean hasExpired() {
        return this.stoppedCount != this.dj.stoppedCount;
    }

    public String getName() {
        return this.tgr.name();
    }

    public DebugDataObjectInfo getThreadGroupObject() {
        return (DebugDataObjectInfo)((Object)this.dj.makeData(this.tgr, null));
    }

    public DebugThreadGroupInfo getParent() {
        ThreadGroupReference threadGroupReference = this.tgr.parent();
        if (threadGroupReference == null) {
            return null;
        }
        return new DebugJDIThreadGroupInfo(this.dj, threadGroupReference);
    }

    public DebugThreadGroupInfo[] listGroups() {
        List<ThreadGroupReference> list = this.tgr.threadGroups();
        DebugThreadGroupInfo[] debugThreadGroupInfoArray = new DebugThreadGroupInfo[list.size()];
        int n = 0;
        while (n < list.size()) {
            debugThreadGroupInfoArray[n] = new DebugJDIThreadGroupInfo(this.dj, list.get(n));
            ++n;
        }
        return debugThreadGroupInfoArray;
    }

    public DebugThreadInfo[] listThreads() {
        List<ThreadReference> list = this.tgr.threads();
        DebugThreadInfo[] debugThreadInfoArray = new DebugThreadInfo[list.size()];
        int n = 0;
        while (n < list.size()) {
            debugThreadInfoArray[n] = DebugJDIThreadInfo.makeThreadInfo(this.dj, list.get(n));
            ++n;
        }
        return debugThreadInfoArray;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.tgr.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugJDIThreadGroupInfo) {
            DebugJDIThreadGroupInfo debugJDIThreadGroupInfo = (DebugJDIThreadGroupInfo)object;
            return this.tgr.equals(debugJDIThreadGroupInfo.tgr);
        }
        return false;
    }

    public Value getJDIValue() {
        return this.tgr;
    }
}

