/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassLoaderInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataObjectInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIMonitorInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIThreadGroupInfo;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.shared.DebugSharedDisassemble;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugRegisterInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;

final class DebugJDIThreadInfo
extends JDIInformationProvider
implements DebugThreadInfo {
    DebugJDI dj;
    ThreadReference tr;
    boolean suspended;
    private int hashCode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DebugJDIThreadInfo makeThreadInfo(DebugJDI debugJDI, ThreadReference threadReference) {
        Map map = debugJDI.threadInfos;
        synchronized (map) {
            DebugJDIThreadInfo debugJDIThreadInfo;
            SoftReference softReference = (SoftReference)debugJDI.threadInfos.get(threadReference);
            if (softReference != null && (debugJDIThreadInfo = (DebugJDIThreadInfo)softReference.get()) != null) {
                DebugJDIThreadInfo debugJDIThreadInfo2 = debugJDIThreadInfo;
                return debugJDIThreadInfo2;
            }
            DebugJDIThreadInfo debugJDIThreadInfo3 = new DebugJDIThreadInfo(debugJDI, threadReference);
            debugJDI.threadInfos.put(threadReference, new SoftReference<DebugJDIThreadInfo>(debugJDIThreadInfo3));
            DebugJDIThreadInfo debugJDIThreadInfo4 = debugJDIThreadInfo3;
            return debugJDIThreadInfo4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getThreadContextClassLoaders(DebugJDI debugJDI) {
        Map map = debugJDI.threadInfos;
        synchronized (map) {
            if (debugJDI.stoppedCountThreadContextClassLoaders == debugJDI.stoppedCount) {
                return;
            }
            ArrayList arrayList = new ArrayList();
            Iterator iterator = debugJDI.threadInfos.keySet().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            for (ThreadReference threadReference : arrayList) {
                DebugJDIThreadInfo debugJDIThreadInfo = DebugJDIThreadInfo.makeThreadInfo(debugJDI, threadReference);
                debugJDIThreadInfo.getContextClassLoader();
            }
            debugJDI.stoppedCountThreadContextClassLoaders = debugJDI.stoppedCount;
        }
    }

    private DebugJDIThreadInfo(DebugJDI debugJDI, ThreadReference threadReference) {
        this.dj = debugJDI;
        this.tr = threadReference;
    }

    public boolean hasExited() {
        try {
            boolean bl = this.tr.status() == 0;
            return bl;
        }
        catch (ObjectCollectedException objectCollectedException) {
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public long getThreadId() {
        return this.tr.uniqueID();
    }

    public String getName() {
        return this.tr.name();
    }

    public String getGroupName() {
        return this.tr.threadGroup().name();
    }

    public DebugThreadGroupInfo getThreadGroup() {
        return new DebugJDIThreadGroupInfo(this.dj, this.tr.threadGroup());
    }

    public int getStatus() {
        try {
            switch (this.tr.status()) {
                default: {
                    int n = 0;
                    return n;
                }
                case 5: {
                    int n = 1;
                    return n;
                }
                case 3: {
                    int n = 2;
                    return n;
                }
                case 4: {
                    int n = 3;
                    return n;
                }
                case 2: {
                    int n = 4;
                    return n;
                }
                case 1: {
                    int n = 5;
                    return n;
                }
                case 0: 
            }
            int n = 6;
            return n;
        }
        catch (ObjectCollectedException objectCollectedException) {
            int n = 6;
            return n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public boolean isThreadSuspended() {
        return this.suspended;
    }

    public void suspendThread() {
        if (!this.suspended) {
            this.suspended = true;
            this.tr.suspend();
        }
    }

    public void resumeThread() {
        if (this.suspended) {
            this.suspended = false;
            this.tr.resume();
        }
    }

    public DebugDataObjectInfo getThreadObject() {
        return (DebugDataObjectInfo)((Object)this.dj.makeData(this.tr, null));
    }

    public void stepInto() {
        this.dj.stepInto(this);
    }

    public void stepOver() {
        this.dj.stepOver(this);
    }

    public void stepIntoBC() {
        this.dj.stepIntoBC(this);
    }

    public void stepOverBC() {
        this.dj.stepOverBC(this);
    }

    public void stepOut() {
        this.dj.stepOut(this);
    }

    public boolean isAtEndOfMethod() {
        try {
            short s;
            StackFrame stackFrame = this.tr.frame(0);
            Location location = stackFrame.location();
            Method method = location.method();
            long l = location.codeIndex();
            byte[] byArray = method.bytecodes();
            if (l >= 0L && l < (long)byArray.length && DebugSharedDisassemble.isReturnBytecode(s = (short)(byArray[(int)l] & 0xFF))) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void stepToEndOfMethod() {
        this.dj.stepToEndOfMethod(this);
    }

    public int getStackFrameCount() {
        try {
            int n = this.tr.frameCount();
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public DebugStackFrameInfo getStackFrame(int n) {
        try {
            if (n < this.tr.frameCount()) {
                DebugJDIStackFrameInfo debugJDIStackFrameInfo = DebugJDIStackFrameInfo.makeStackFrameInfo(this.dj, this.tr, n, this.tr.frame(n));
                return debugJDIStackFrameInfo;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public DebugStackFrameInfo[] listStack() {
        try {
            List<StackFrame> list = this.tr.frames();
            int n = list.size();
            DebugStackFrameInfo[] debugStackFrameInfoArray = new DebugStackFrameInfo[n];
            int n2 = 0;
            while (n2 < n) {
                debugStackFrameInfoArray[n2] = DebugJDIStackFrameInfo.makeStackFrameInfo(this.dj, this.tr, n2, list.get(n2));
                ++n2;
            }
            DebugStackFrameInfo[] debugStackFrameInfoArray2 = debugStackFrameInfoArray;
            return debugStackFrameInfoArray2;
        }
        catch (Exception exception) {
            return new DebugStackFrameInfo[0];
        }
    }

    public DebugMonitorInfo[] listOwnedMonitors() {
        if (this.dj.canGetMonitors()) {
            try {
                List<ObjectReference> list = this.tr.ownedMonitors();
                DebugMonitorInfo[] debugMonitorInfoArray = new DebugMonitorInfo[list.size()];
                int n = 0;
                while (n < list.size()) {
                    ObjectReference objectReference = list.get(n);
                    debugMonitorInfoArray[n] = new DebugJDIMonitorInfo(this.dj, objectReference);
                    ++n;
                }
                DebugMonitorInfo[] debugMonitorInfoArray2 = debugMonitorInfoArray;
                return debugMonitorInfoArray2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new DebugMonitorInfo[0];
    }

    public DebugMonitorInfo getMonitorThreadWaitingFor() {
        if (this.dj.canGetMonitors()) {
            try {
                ObjectReference objectReference = this.dj.getWaitMonitor(this.tr);
                if (objectReference != null) {
                    DebugJDIMonitorInfo debugJDIMonitorInfo = new DebugJDIMonitorInfo(this.dj, objectReference);
                    return debugJDIMonitorInfo;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public DebugMonitorInfo getMonitorThreadBlockedFor() {
        if (this.dj.canGetMonitors()) {
            try {
                ObjectReference objectReference;
                if (this.tr.status() == 3 && (objectReference = this.tr.currentContendedMonitor()) != null) {
                    DebugJDIMonitorInfo debugJDIMonitorInfo = new DebugJDIMonitorInfo(this.dj, objectReference);
                    return debugJDIMonitorInfo;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public DebugRegisterInfo[] listRegisters() {
        return new DebugRegisterInfo[0];
    }

    public DebugRegisterInfo[] listFloatRegisters() {
        return new DebugRegisterInfo[0];
    }

    public DebugVariableInfo getReturnValue() {
        return null;
    }

    public DebugVariableInfo getReturnedValue() {
        return null;
    }

    public boolean setLocation(DebugLocation debugLocation) {
        return false;
    }

    public DebugDataObjectInfo getContextClassLoaderObject() {
        return DebugShared.getContextClassLoaderObject(this);
    }

    public DebugClassLoaderInfo getContextClassLoader() {
        DebugJDIDataObjectInfo debugJDIDataObjectInfo = (DebugJDIDataObjectInfo)this.getContextClassLoaderObject();
        if (debugJDIDataObjectInfo != null) {
            ClassLoaderReference classLoaderReference = (ClassLoaderReference)debugJDIDataObjectInfo.value;
            return DebugJDIClassLoaderInfo.makeClassLoaderInfo(this.dj, classLoaderReference);
        }
        return null;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.tr.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugJDIThreadInfo) {
            DebugJDIThreadInfo debugJDIThreadInfo = (DebugJDIThreadInfo)object;
            return this.tr.equals(debugJDIThreadInfo.tr);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache(DebugJDI debugJDI, boolean bl) {
        Map map = debugJDI.threadInfos;
        synchronized (map) {
            ArrayList<ThreadReference> arrayList = new ArrayList<ThreadReference>();
            boolean bl2 = bl && debugJDI.isConnected();
            for (Map.Entry entry : debugJDI.threadInfos.entrySet()) {
                ThreadReference threadReference = (ThreadReference)entry.getKey();
                if (bl2 && debugJDI.isObjectCollected(threadReference)) {
                    arrayList.add(threadReference);
                    continue;
                }
                SoftReference softReference = (SoftReference)entry.getValue();
                if (softReference == null || softReference.get() != null) continue;
                arrayList.add(threadReference);
            }
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                debugJDI.threadInfos.remove(arrayList.get(n2));
                ++n2;
            }
        }
    }

    public Value getJDIValue() {
        return this.tr;
    }
}

