/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;

final class DebugJDIVariableInfo
extends JDIInformationProvider
implements DebugVariableInfo {
    DebugJDI dj;
    DebugJDIStackFrameInfo djsf;
    LocalVariable lv;
    boolean argument;
    boolean local;
    ObjectReference thisObject;
    int stoppedCount;
    private int hashCode;

    DebugJDIVariableInfo(DebugJDI debugJDI, DebugJDIStackFrameInfo debugJDIStackFrameInfo, LocalVariable localVariable, boolean bl, boolean bl2) {
        this.dj = debugJDI;
        this.djsf = debugJDIStackFrameInfo;
        this.lv = localVariable;
        this.argument = bl;
        this.local = bl2;
        this.stoppedCount = debugJDI.stoppedCount;
    }

    DebugJDIVariableInfo(DebugJDI debugJDI, ObjectReference objectReference) {
        this.dj = debugJDI;
        this.thisObject = objectReference;
        this.argument = true;
        this.local = false;
        this.stoppedCount = debugJDI.stoppedCount;
    }

    public boolean hasExpired() {
        return this.stoppedCount != this.dj.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Variable has expired");
        }
    }

    public DebugClassInfo getClassInfo() {
        DebugJDIClassInfo debugJDIClassInfo;
        this.throwIfExpired();
        if (this.thisObject != null) {
            return this.dj.findClass(this.thisObject.referenceType());
        }
        try {
            DebugJDIClassInfo debugJDIClassInfo2 = this.dj.findClassByType(this.lv.type());
            if (debugJDIClassInfo2 != null) {
                DebugJDIClassInfo debugJDIClassInfo3 = debugJDIClassInfo2;
                return debugJDIClassInfo3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Value value = null;
        if (this.lv.isVisible(this.djsf.sf)) {
            value = this.djsf.sf.getValue(this.lv);
        }
        if (value != null && (debugJDIClassInfo = this.dj.findClassByType(value.type())) != null) {
            return debugJDIClassInfo;
        }
        return this.dj.findClassByName(this.lv.typeName(), true);
    }

    public String getGenericSignature() {
        return this.lv.genericSignature();
    }

    public String getName() {
        this.throwIfExpired();
        if (this.thisObject != null) {
            return "this";
        }
        return this.lv.name();
    }

    public boolean isInScope() {
        this.throwIfExpired();
        if (this.thisObject != null) {
            return true;
        }
        return this.lv.isVisible(this.djsf.sf);
    }

    public boolean isArgument() {
        return this.argument;
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isReturn() {
        return false;
    }

    public boolean isReturned() {
        return false;
    }

    public DebugDataInfo getDataInfo() {
        this.throwIfExpired();
        if (this.thisObject != null) {
            return this.dj.makeData(this.thisObject, this);
        }
        if (this.lv.isVisible(this.djsf.sf)) {
            Value value = this.djsf.sf.getValue(this.lv);
            if (value != null) {
                return this.dj.makeData(value, this);
            }
            return this.dj.makeNullData((DebugJDIClassInfo)this.getClassInfo(), this);
        }
        return null;
    }

    public int getSlotSize() {
        String string = this.lv.signature();
        if (string.equals("J") || string.equals("D")) {
            return 2;
        }
        return 1;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.thisObject != null ? this.thisObject.hashCode() : this.lv.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugJDIVariableInfo) {
            DebugJDIVariableInfo debugJDIVariableInfo = (DebugJDIVariableInfo)object;
            return this.dj.equals(debugJDIVariableInfo.dj) && (this.thisObject == null ? debugJDIVariableInfo.thisObject == null : this.thisObject.equals(debugJDIVariableInfo.thisObject)) && (this.lv == null ? debugJDIVariableInfo.lv == null : this.lv.equals(debugJDIVariableInfo.lv));
        }
        return false;
    }

    public LocalVariable getJDILocalVariable() {
        return this.lv;
    }
}

