/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.shared;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.ide.util.Encodings;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.IdeUtil;
import oracle.jdevimpl.debugger.jdi.DebugJDIArb;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.shared.GenericSignature;
import oracle.jdevimpl.debugger.support.DebugArrayElementInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.xslt.XSLTRunnerAddin;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.DATE;
import oracle.sql.NUMBER;

public final class DebugShared {
    private static Map defaultConnectArgValues = null;

    public static DebugThreadInfo[][] getDeadlockedThreads(DebugVirtualMachine debugVirtualMachine) {
        ArrayList<DebugThreadInfo[]> arrayList = new ArrayList<DebugThreadInfo[]>();
        DebugThreadInfo[] debugThreadInfoArray = debugVirtualMachine.listThreads();
        ArrayList<DebugThreadInfo> arrayList2 = new ArrayList<DebugThreadInfo>();
        int n = 0;
        while (n < debugThreadInfoArray.length) {
            arrayList2.add(debugThreadInfoArray[n]);
            ++n;
        }
        ArrayList<DebugThreadInfo> arrayList3 = new ArrayList<DebugThreadInfo>();
        while (arrayList2.size() > 0) {
            DebugThreadInfo debugThreadInfo = (DebugThreadInfo)arrayList2.get(0);
            DebugMonitorInfo debugMonitorInfo = null;
            do {
                arrayList3.add(debugThreadInfo);
                debugMonitorInfo = debugThreadInfo.getMonitorThreadBlockedFor();
            } while (debugMonitorInfo != null && (debugThreadInfo = debugMonitorInfo.getOwnerThread()) != null && !arrayList3.contains(debugThreadInfo));
            if (debugThreadInfo != null && debugMonitorInfo != null) {
                int n2 = arrayList3.indexOf(debugThreadInfo);
                DebugThreadInfo[] debugThreadInfoArray2 = new DebugThreadInfo[arrayList3.size() - n2];
                boolean bl = false;
                int n3 = n2;
                while (n3 < arrayList3.size()) {
                    DebugThreadInfo debugThreadInfo2 = (DebugThreadInfo)arrayList3.get(n3);
                    if (!arrayList2.contains(debugThreadInfo2)) {
                        bl = true;
                        break;
                    }
                    debugThreadInfoArray2[n3 - n2] = debugThreadInfo2;
                    ++n3;
                }
                if (!bl) {
                    arrayList.add(debugThreadInfoArray2);
                }
            }
            int n4 = 0;
            while (n4 < arrayList3.size()) {
                arrayList2.remove(arrayList3.get(n4));
                ++n4;
            }
            arrayList3.clear();
        }
        DebugThreadInfo[][] debugThreadInfoArrayArray = new DebugThreadInfo[arrayList.size()][];
        return (DebugThreadInfo[][])arrayList.toArray((T[])debugThreadInfoArrayArray);
    }

    public static String getPackage(String string) {
        int n;
        String string2 = "";
        if (string != null && string.length() > 0 && (n = string.lastIndexOf(".")) != -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static String getPackagePath(String string) {
        return DebugShared.getPackage(string).replace('.', File.separatorChar);
    }

    public static String getNameWithoutPackage(String string) {
        String string2 = "";
        if (string != null && string.length() > 0) {
            int n = string.lastIndexOf(".");
            string2 = n != -1 ? string.substring(n + 1) : string;
        }
        return string2;
    }

    public static String getNameWithoutClass(String string) {
        int n = string.indexOf("(");
        int n2 = string.lastIndexOf(" ", n) + 1;
        int n3 = string.lastIndexOf(".", n) + 1;
        return string.substring(0, n2) + string.substring(n3);
    }

    public static String getMethodClassName(String string) {
        int n = string.indexOf("(");
        int n2 = string.lastIndexOf(" ", n) + 1;
        int n3 = string.lastIndexOf(".", n);
        return string.substring(n2, n3);
    }

    public static String getNameWithoutSignature(String string) {
        int n = string.indexOf("(");
        int n2 = string.lastIndexOf(" ", n) + 1;
        return string.substring(n2, n);
    }

    public static String getNameWithoutClassOrSignature(String string) {
        int n = string.indexOf("(");
        int n2 = string.lastIndexOf(".", n) + 1;
        return string.substring(n2, n);
    }

    public static String getMethodParameterSignature(String string) {
        int n = string.indexOf("(");
        return string.substring(n);
    }

    public static void putClass(Map map, String string, DebugClassInfo debugClassInfo) {
        Object v = map.get(string);
        if (v != null) {
            if (v instanceof DebugClassInfo) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(v);
                arrayList.add(debugClassInfo);
                map.put(string, arrayList);
            } else if (v instanceof List) {
                List list = (List)v;
                list.add(debugClassInfo);
            }
        } else {
            map.put(string, debugClassInfo);
        }
    }

    public static void removeClass(Map map, String string, DebugClassInfo debugClassInfo) {
        Object v = map.get(string);
        if (v != null) {
            if (v instanceof DebugClassInfo) {
                map.remove(string);
            } else if (v instanceof List) {
                List list = (List)v;
                list.remove(debugClassInfo);
            }
        }
    }

    public static DebugClassInfo getFirstClass(Map map, String string) {
        Object v = map.get(string);
        if (v != null) {
            if (v instanceof DebugClassInfo) {
                return (DebugClassInfo)v;
            }
            if (v instanceof List) {
                List list = (List)v;
                return (DebugClassInfo)list.get(0);
            }
        }
        return null;
    }

    public static String prepadOrTrunc(String string, char c, int n) {
        int n2 = string.length();
        if (n2 > n) {
            return string.substring(n2 - n);
        }
        return DebugShared.prepad(string, '0', n);
    }

    public static String prepad(String string, char c, int n) {
        return IdeUtil.prepad((String)string, (char)c, (int)n);
    }

    public static String makeCourtesyName(Object object) {
        try {
            DebugDataInfo debugDataInfo;
            DebugArrayElementInfo debugArrayElementInfo;
            DebugDataInfo debugDataInfo2;
            DebugClassInfo debugClassInfo;
            String string;
            if (object instanceof DebugArrayElementInfo && (string = (debugClassInfo = (debugDataInfo2 = (debugArrayElementInfo = (DebugArrayElementInfo)object).getDataInfo()).getClassInfo()).getName()).startsWith("$Oracle.") && string.endsWith("$element") && (debugDataInfo = DebugShared.findFieldData((DebugDataObjectInfo)debugDataInfo2, "_key", null)) instanceof DebugDataCompositeInfo) {
                String string2;
                DebugDataCompositeInfo debugDataCompositeInfo = (DebugDataCompositeInfo)debugDataInfo;
                String string3 = string2 = debugDataCompositeInfo.isNull() ? "NULL" : DebugShared.makeCourtesyValueInternal(debugDataCompositeInfo, true, false);
                if (string2 != null && string2.length() > 0) {
                    FastStringBuffer fastStringBuffer = new FastStringBuffer();
                    fastStringBuffer.append("[");
                    fastStringBuffer.append(string2);
                    fastStringBuffer.append("]");
                    String string4 = fastStringBuffer.toString();
                    return string4;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static String makeCourtesyValue(DebugDataCompositeInfo debugDataCompositeInfo) {
        try {
            if (debugDataCompositeInfo != null) {
                String string = DebugShared.makeCourtesyValueInternal(debugDataCompositeInfo, true, true);
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String makeCourtesyValue(DebugDataCompositeInfo debugDataCompositeInfo, boolean bl, boolean bl2) {
        try {
            if (debugDataCompositeInfo != null) {
                String string = DebugShared.makeCourtesyValueInternal(debugDataCompositeInfo, bl, bl2);
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String makeCourtesyValueInternal(DebugDataCompositeInfo debugDataCompositeInfo, boolean bl, boolean bl2) throws Exception {
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        String string = DebugShared.prepareCourtesyValue(debugDataCompositeInfo, blArray, blArray2);
        if (string != null) {
            DebugClassInfo debugClassInfo;
            if (bl2 && !blArray2[0] && string.length() > 100) {
                string = string.substring(0, 100);
            }
            if (bl && !blArray[0] && (debugClassInfo = debugDataCompositeInfo.getClassInfo()) != null) {
                String string2 = debugClassInfo.getName();
                if (string2.equals("java.lang.String") || string2.equals("java.lang.StringBuffer") || string2.equals("char[]") || string2.equals("byte[]") || string2.equals("$oracle.xml.xslt.XMLString")) {
                    FastStringBuffer fastStringBuffer = new FastStringBuffer(string.length() + 2);
                    fastStringBuffer.append('\"').append(string).append('\"');
                    string = fastStringBuffer.toString();
                } else if (string2.equals("$Oracle.Builtin.VARCHAR2") || string2.equals("$Oracle.Builtin.CLOB") || string2.equals("$Oracle.Builtin.BLOB") || string2.equals("$Oracle.Builtin.BFILE") || string2.equals("$Oracle.Builtin.CHAR") || string2.equals("$Oracle.Builtin.NCHAR")) {
                    FastStringBuffer fastStringBuffer = new FastStringBuffer(string.length() + 2);
                    fastStringBuffer.append('\'').append(string).append('\'');
                    string = fastStringBuffer.toString();
                }
            }
        }
        return string;
    }

    private static String prepareCourtesyValue(DebugDataCompositeInfo debugDataCompositeInfo, boolean[] blArray, boolean[] blArray2) throws Exception {
        String string = debugDataCompositeInfo.getCourtesyValue();
        if (string != null) {
            return string;
        }
        DebugDataObjectInfo debugDataObjectInfo = null;
        if (debugDataCompositeInfo instanceof DebugDataObjectInfo) {
            debugDataObjectInfo = (DebugDataObjectInfo)debugDataCompositeInfo;
        }
        DebugClassInfo debugClassInfo = debugDataCompositeInfo.getClassInfo();
        while (debugClassInfo != null) {
            String string2 = debugClassInfo.getName();
            if (string2.equals("byte[]")) {
                DebugDataArrayInfo debugDataArrayInfo = (DebugDataArrayInfo)debugDataCompositeInfo;
                byte[] byArray = null;
                if (blArray2[0] || debugDataArrayInfo.getArrayCount() <= 100) {
                    Object object = debugDataArrayInfo.getWholeThing();
                    if (object instanceof byte[]) {
                        byArray = (byte[])object;
                    }
                } else {
                    DebugArrayElementInfo[] debugArrayElementInfoArray = debugDataArrayInfo.getArrayElements(0, 100);
                    int n = debugArrayElementInfoArray.length;
                    byArray = new byte[n];
                    int n2 = 0;
                    while (n2 < n) {
                        byArray[n2] = DebugSharedPrimitives.byteFromHexString(debugArrayElementInfoArray[n2].getDataInfo().getHexValue());
                        ++n2;
                    }
                }
                if (byArray != null) {
                    string = new String(byArray, Encodings.getDefaultEncoding());
                    if (!blArray2[0] && string.length() > 100) {
                        string = string.substring(0, 100);
                    }
                    return string;
                }
            } else if (string2.equals("java.awt.Label") || string2.equals("java.awt.TextComponent") || string2.equals("java.awt.TextField") || string2.equals("javax.swing.JLabel") || string2.equals("javax.swing.AbstractButton") || string2.equals("javax.swing.JTextField")) {
                DebugDataCompositeInfo debugDataCompositeInfo2 = (DebugDataCompositeInfo)DebugShared.findFieldData(debugDataObjectInfo, "text", "java.lang.String");
                if (debugDataCompositeInfo2 != null && !debugDataCompositeInfo2.isNull()) {
                    return DebugShared.makeCourtesyValueInternal(debugDataCompositeInfo2, false, false);
                }
            } else if (string2.equals("java.awt.Button") || string2.equals("java.awt.Checkbox") || string2.equals("java.awt.MenuItem")) {
                DebugDataCompositeInfo debugDataCompositeInfo3 = (DebugDataCompositeInfo)DebugShared.findFieldData(debugDataObjectInfo, "label", "java.lang.String");
                if (debugDataCompositeInfo3 != null && !debugDataCompositeInfo3.isNull()) {
                    return DebugShared.makeCourtesyValueInternal(debugDataCompositeInfo3, false, false);
                }
            } else if (string2.equals("java.io.File")) {
                blArray2[0] = true;
                DebugDataCompositeInfo debugDataCompositeInfo4 = (DebugDataCompositeInfo)DebugShared.findFieldData(debugDataObjectInfo, "path", "java.lang.String", debugClassInfo);
                if (debugDataCompositeInfo4 != null && !debugDataCompositeInfo4.isNull()) {
                    return DebugShared.makeCourtesyValueInternal(debugDataCompositeInfo4, false, false);
                }
            } else if (string2.equals("java.lang.Boolean")) {
                DebugDataInfo debugDataInfo = DebugShared.findFieldData(debugDataObjectInfo, "value", "boolean", debugClassInfo);
                if (debugDataInfo != null) {
                    return debugDataInfo.getValue();
                }
            } else if (string2.equals("java.lang.Byte")) {
                DebugDataInfo debugDataInfo = DebugShared.findFieldData(debugDataObjectInfo, "value", "byte", debugClassInfo);
                if (debugDataInfo != null) {
                    return debugDataInfo.getValue();
                }
            } else if (string2.equals("java.lang.Character")) {
                DebugDataInfo debugDataInfo = DebugShared.findFieldData(debugDataObjectInfo, "value", "char", debugClassInfo);
                if (debugDataInfo != null) {
                    return debugDataInfo.getValue();
                }
            } else if (string2.equals("java.lang.Double")) {
                DebugDataInfo debugDataInfo = DebugShared.findFieldData(debugDataObjectInfo, "value", "double", debugClassInfo);
                if (debugDataInfo != null) {
                    return debugDataInfo.getValue();
                }
            } else if (string2.equals("java.lang.Float")) {
                DebugDataInfo debugDataInfo = DebugShared.findFieldData(debugDataObjectInfo, "value", "float", debugClassInfo);
                if (debugDataInfo != null) {
                    return debugDataInfo.getValue();
                }
            } else if (string2.equals("java.lang.Integer")) {
                DebugDataInfo debugDataInfo = DebugShared.findFieldData(debugDataObjectInfo, "value", "int", debugClassInfo);
                if (debugDataInfo != null) {
                    return debugDataInfo.getValue();
                }
            } else if (string2.equals("java.lang.Long")) {
                DebugDataInfo debugDataInfo = DebugShared.findFieldData(debugDataObjectInfo, "value", "long", debugClassInfo);
                if (debugDataInfo != null) {
                    return debugDataInfo.getValue();
                }
            } else if (string2.equals("java.lang.Short")) {
                DebugDataInfo debugDataInfo = DebugShared.findFieldData(debugDataObjectInfo, "value", "short", debugClassInfo);
                if (debugDataInfo != null) {
                    return debugDataInfo.getValue();
                }
            } else if (string2.equals("java.lang.Thread")) {
                DebugDataArrayInfo debugDataArrayInfo = (DebugDataArrayInfo)DebugShared.findFieldData(debugDataObjectInfo, "name", "char[]", debugClassInfo);
                if (debugDataArrayInfo != null && !debugDataArrayInfo.isNull()) {
                    return DebugShared.makeCourtesyValueInternal(debugDataArrayInfo, false, false);
                }
            } else if (string2.equals("java.lang.ThreadGroup")) {
                DebugDataCompositeInfo debugDataCompositeInfo5 = (DebugDataCompositeInfo)DebugShared.findFieldData(debugDataObjectInfo, "name", "java.lang.String", debugClassInfo);
                if (debugDataCompositeInfo5 != null && !debugDataCompositeInfo5.isNull()) {
                    return DebugShared.makeCourtesyValueInternal(debugDataCompositeInfo5, false, false);
                }
            } else if (string2.equals("java.lang.Throwable")) {
                DebugDataCompositeInfo debugDataCompositeInfo6 = (DebugDataCompositeInfo)DebugShared.findFieldData(debugDataObjectInfo, "detailMessage", "java.lang.String", debugClassInfo);
                if (debugDataCompositeInfo6 != null && !debugDataCompositeInfo6.isNull()) {
                    return DebugShared.makeCourtesyValueInternal(debugDataCompositeInfo6, false, false);
                }
            } else if (string2.equals("java.lang.ref.Reference")) {
                DebugDataCompositeInfo debugDataCompositeInfo7 = (DebugDataCompositeInfo)DebugShared.findFieldData(debugDataObjectInfo, "referent", null, debugClassInfo);
                if (debugDataCompositeInfo7 != null && !debugDataCompositeInfo7.isNull()) {
                    return DebugShared.makeCourtesyValueInternal(debugDataCompositeInfo7, false, false);
                }
            } else if (string2.equals("java.math.BigDecimal")) {
                BigInteger bigInteger;
                DebugDataObjectInfo debugDataObjectInfo2 = (DebugDataObjectInfo)DebugShared.findFieldData(debugDataObjectInfo, "intVal", "java.math.BigInteger", debugClassInfo);
                DebugDataInfo debugDataInfo = DebugShared.findFieldData(debugDataObjectInfo, "scale", "int", debugClassInfo);
                if (debugDataObjectInfo2 != null && !debugDataObjectInfo2.isNull() && debugDataInfo != null && (bigInteger = DebugShared.makeBigInteger(debugDataObjectInfo2)) != null) {
                    int n = DebugSharedPrimitives.intFromHexString(debugDataInfo.getHexValue());
                    BigDecimal bigDecimal = new BigDecimal(bigInteger, n);
                    return bigDecimal.toString();
                }
            } else if (string2.equals("java.math.BigInteger")) {
                BigInteger bigInteger = DebugShared.makeBigInteger(debugDataObjectInfo);
                if (bigInteger != null) {
                    return bigInteger.toString();
                }
            } else {
                DebugDataInfo debugDataInfo;
                if (string2.equals("java.net.URL")) {
                    blArray2[0] = true;
                    return DebugShared.urlToString(debugDataObjectInfo);
                }
                if (string2.equals("java.sql.Date")) {
                    Long l = DebugShared.findDateFastTime(debugDataObjectInfo);
                    if (l != null) {
                        Date date = new Date(l);
                        return date.toString();
                    }
                } else if (string2.equals("java.sql.Time")) {
                    Long l = DebugShared.findDateFastTime(debugDataObjectInfo);
                    if (l != null) {
                        Time time = new Time(l);
                        return time.toString();
                    }
                } else if (string2.equals("java.sql.Timestamp")) {
                    Long l = DebugShared.findDateFastTime(debugDataObjectInfo);
                    DebugDataInfo debugDataInfo2 = DebugShared.findFieldData(debugDataObjectInfo, "nanos", "int");
                    if (l != null && debugDataInfo2 != null) {
                        int n = DebugSharedPrimitives.intFromHexString(debugDataInfo2.getHexValue());
                        Timestamp timestamp = new Timestamp(l);
                        timestamp.setNanos(n);
                        return timestamp.toString();
                    }
                } else if (string2.equals("java.util.Date")) {
                    Long l = DebugShared.findDateFastTime(debugDataObjectInfo);
                    if (l != null) {
                        java.util.Date date = new java.util.Date(l);
                        return date.toString();
                    }
                } else if (string2.equals("java.util.ArrayList") || string2.equals("java.util.LinkedList") || string2.equals("java.util.TreeMap")) {
                    DebugDataInfo debugDataInfo3 = DebugShared.findFieldData(debugDataObjectInfo, "size", "int");
                    if (debugDataInfo3 != null) {
                        return "size " + debugDataInfo3.getValue();
                    }
                } else if (string2.equals("java.util.Vector")) {
                    DebugDataInfo debugDataInfo4 = DebugShared.findFieldData(debugDataObjectInfo, "elementCount", "int", debugClassInfo);
                    if (debugDataInfo4 != null) {
                        return "size " + debugDataInfo4.getValue();
                    }
                } else if (string2.equals("java.util.HashMap")) {
                    DebugDataInfo debugDataInfo5 = DebugShared.findFieldData(debugDataObjectInfo, "size", "int", debugClassInfo);
                    if (debugDataInfo5 != null) {
                        return "size " + debugDataInfo5.getValue();
                    }
                } else if (string2.equals("java.util.Hashtable")) {
                    DebugDataInfo debugDataInfo6 = DebugShared.findFieldData(debugDataObjectInfo, "count", "int", debugClassInfo);
                    if (debugDataInfo6 != null) {
                        return "size " + debugDataInfo6.getValue();
                    }
                } else if (string2.equals("java.util.HashSet")) {
                    DebugDataCompositeInfo debugDataCompositeInfo8 = (DebugDataCompositeInfo)DebugShared.findFieldData(debugDataObjectInfo, "map", "java.util.HashMap", debugClassInfo);
                    if (debugDataCompositeInfo8 != null && !debugDataCompositeInfo8.isNull()) {
                        return DebugShared.makeCourtesyValueInternal(debugDataCompositeInfo8, false, false);
                    }
                } else if (string2.equals("java.util.TreeSet")) {
                    DebugDataCompositeInfo debugDataCompositeInfo9 = (DebugDataCompositeInfo)DebugShared.findFieldData(debugDataObjectInfo, "m", "java.util.SortedMap", debugClassInfo);
                    if (debugDataCompositeInfo9 != null && !debugDataCompositeInfo9.isNull()) {
                        return DebugShared.makeCourtesyValueInternal(debugDataCompositeInfo9, false, false);
                    }
                } else if (string2.equals("java.util.WeakHashMap")) {
                    DebugDataCompositeInfo debugDataCompositeInfo10 = (DebugDataCompositeInfo)DebugShared.findFieldData(debugDataObjectInfo, "hash", "java.util.Map", debugClassInfo);
                    if (debugDataCompositeInfo10 != null && !debugDataCompositeInfo10.isNull()) {
                        return DebugShared.makeCourtesyValueInternal(debugDataCompositeInfo10, false, false);
                    }
                } else if (string2.equals("java.util.HashMap$Entry") || string2.equals("java.util.Hashtable$Entry") || string2.equals("java.util.WeakHashMap$Entry")) {
                    String string3;
                    String string4;
                    DebugDataCompositeInfo debugDataCompositeInfo11;
                    DebugDataCompositeInfo debugDataCompositeInfo12 = (DebugDataCompositeInfo)DebugShared.findFieldData(debugDataObjectInfo, "key", "java.lang.Object");
                    if (debugDataCompositeInfo12 != null && !debugDataCompositeInfo12.isNull() && (debugDataCompositeInfo11 = (DebugDataCompositeInfo)DebugShared.findFieldData(debugDataObjectInfo, "value", "java.lang.Object")) != null && !debugDataCompositeInfo11.isNull() && (string4 = DebugShared.makeCourtesyValueInternal(debugDataCompositeInfo12, true, false)) != null && string4.length() > 0 && (string3 = DebugShared.makeCourtesyValueInternal(debugDataCompositeInfo11, true, false)) != null && string3.length() > 0) {
                        return string4 + " -> " + string3;
                    }
                } else if (string2.equals("oracle.jbo.domain.Char")) {
                    byte[] byArray = DebugShared.getByteArrayField(debugDataObjectInfo, "data");
                    if (byArray != null) {
                        CharacterSet characterSet = null;
                        DebugDataInfo debugDataInfo7 = DebugShared.findFieldData(debugDataObjectInfo, "oracleId", "int");
                        if (debugDataInfo7 != null) {
                            int n = DebugSharedPrimitives.intFromHexString(debugDataInfo7.getHexValue());
                            characterSet = CharacterSet.make((int)n);
                        }
                        if (characterSet == null) {
                            characterSet = CHAR.DEFAULT_CHARSET;
                        }
                        CHAR cHAR = new CHAR(byArray, characterSet);
                        return "\"" + cHAR.stringValue() + "\"";
                    }
                } else if (string2.equals("oracle.jbo.domain.Date")) {
                    Long l;
                    byte[] byArray = DebugShared.getByteArrayField(debugDataObjectInfo, "data");
                    if (byArray != null) {
                        DATE dATE = new DATE(byArray);
                        return dATE.stringValue();
                    }
                    DebugDataObjectInfo debugDataObjectInfo3 = (DebugDataObjectInfo)DebugShared.findFieldData(debugDataObjectInfo, "m_data", "java.sql.Timestamp");
                    if (debugDataObjectInfo3 != null && !debugDataObjectInfo3.isNull() && (l = DebugShared.findDateFastTime(debugDataObjectInfo3)) != null) {
                        Date date = new Date(l);
                        return date.toString();
                    }
                } else if (string2.equals("oracle.jbo.domain.Number")) {
                    byte[] byArray = DebugShared.getByteArrayField(debugDataObjectInfo, "data");
                    if (byArray != null) {
                        NUMBER nUMBER = new NUMBER(byArray);
                        return nUMBER.stringValue();
                    }
                    DebugDataCompositeInfo debugDataCompositeInfo13 = (DebugDataCompositeInfo)DebugShared.findFieldData(debugDataObjectInfo, "m_data", "java.lang.Number");
                    if (debugDataCompositeInfo13 != null && !debugDataCompositeInfo13.isNull()) {
                        return DebugShared.makeCourtesyValueInternal(debugDataCompositeInfo13, false, false);
                    }
                } else if (string2.equals("javax.xml.namespace.QName")) {
                    DebugDataCompositeInfo debugDataCompositeInfo14 = (DebugDataCompositeInfo)DebugShared.findFieldData(debugDataObjectInfo, "prefix", "java.lang.String");
                    DebugDataCompositeInfo debugDataCompositeInfo15 = (DebugDataCompositeInfo)DebugShared.findFieldData(debugDataObjectInfo, "localPart", "java.lang.String");
                    if (debugDataCompositeInfo14 != null && debugDataCompositeInfo15 != null) {
                        String string5 = (String)debugDataCompositeInfo14.getWholeThing();
                        String string6 = (String)debugDataCompositeInfo15.getWholeThing();
                        if (string5 != null && string5.length() > 0) {
                            return string5 + ":" + string6;
                        }
                        return string6;
                    }
                } else if (string2.equals("oracle.xml.parser.v2.XMLElement")) {
                    DebugDataCompositeInfo debugDataCompositeInfo16;
                    int n;
                    long l;
                    int n3;
                    DebugArrayElementInfo[] debugArrayElementInfoArray;
                    DebugDataArrayInfo debugDataArrayInfo = (DebugDataArrayInfo)DebugShared.findFieldData(debugDataObjectInfo, "data", "java.lang.Object[]");
                    DebugDataInfo debugDataInfo8 = DebugShared.findFieldData(debugDataObjectInfo, "nodeId", "long");
                    DebugDataInfo debugDataInfo9 = DebugShared.findStaticFieldData(debugDataObjectInfo, "ELEM_QXNAME", "int");
                    if (debugDataArrayInfo != null && debugDataInfo8 != null && debugDataInfo9 != null && (debugArrayElementInfoArray = debugDataArrayInfo.getArrayElements(n3 = (int)(l = DebugSharedPrimitives.longFromHexString(debugDataInfo8.getHexValue())) + (n = DebugSharedPrimitives.intFromHexString(debugDataInfo9.getHexValue())), 1)) != null && debugArrayElementInfoArray.length == 1 && !(debugDataCompositeInfo16 = (DebugDataCompositeInfo)debugArrayElementInfoArray[0].getDataInfo()).isNull()) {
                        return DebugShared.makeCourtesyValueInternal(debugDataCompositeInfo16, false, false);
                    }
                } else if (string2.startsWith("$Oracle.Builtin.") && debugDataObjectInfo != null) {
                    DebugDataCompositeInfo debugDataCompositeInfo17 = (DebugDataCompositeInfo)DebugShared.findFieldData(debugDataObjectInfo, "_value", "java.lang.String");
                    if (debugDataCompositeInfo17 != null) {
                        if (!debugDataCompositeInfo17.isNull()) {
                            return DebugShared.makeCourtesyValueInternal(debugDataCompositeInfo17, false, false);
                        }
                        blArray[0] = true;
                        return "NULL";
                    }
                } else if (string2.startsWith("$Oracle.") && string2.endsWith("$element")) {
                    DebugDataInfo debugDataInfo10 = DebugShared.findFieldData(debugDataObjectInfo, "_value", null);
                    if (debugDataInfo10 instanceof DebugDataCompositeInfo) {
                        DebugDataCompositeInfo debugDataCompositeInfo18 = (DebugDataCompositeInfo)debugDataInfo10;
                        if (!debugDataCompositeInfo18.isNull()) {
                            return DebugShared.makeCourtesyValueInternal(debugDataCompositeInfo18, true, false);
                        }
                        blArray[0] = true;
                        return "NULL";
                    }
                } else if (string2.startsWith("$Oracle.") && debugDataObjectInfo != null) {
                    DebugDataCompositeInfo debugDataCompositeInfo19;
                    DebugDataInfo debugDataInfo11 = DebugShared.findFieldData(debugDataObjectInfo, "_values", null);
                    if (debugDataInfo11 instanceof DebugDataArrayInfo && (debugDataCompositeInfo19 = (DebugDataCompositeInfo)DebugShared.findStaticFieldData(debugDataObjectInfo, "_type", "java.lang.String")) != null && !debugDataCompositeInfo19.isNull()) {
                        return DebugShared.makeCourtesyValueInternal(debugDataCompositeInfo19, false, false);
                    }
                } else if (string2.equals("$oracle.xml.xslt.XMLString")) {
                    Object object;
                    DebugDataArrayInfo debugDataArrayInfo = (DebugDataArrayInfo)DebugShared.findFieldData(debugDataObjectInfo, "value", "char[]");
                    if (debugDataArrayInfo != null && !debugDataArrayInfo.isNull() && (object = debugDataArrayInfo.getWholeThing()) instanceof String) {
                        String string7 = (String)object;
                        DebugDataInfo debugDataInfo12 = DebugShared.findFieldData(debugDataObjectInfo, "length", "int");
                        if (debugDataInfo12 != null) {
                            int n = DebugSharedPrimitives.intFromHexString(debugDataInfo12.getHexValue());
                            if (n < string7.length()) {
                                string7 = string7.substring(0, n);
                            }
                            return string7;
                        }
                    }
                } else if (string2.equals("$oracle.xml.xslt.XMLNode") && (debugDataInfo = DebugShared.findFieldData(debugDataObjectInfo, "type", "short")) != null) {
                    int n = -1;
                    try {
                        String string8 = debugDataInfo.getValue();
                        n = Short.decode(string8).shortValue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n != -1) {
                        DebugDataCompositeInfo debugDataCompositeInfo20;
                        String string9 = null;
                        String string10 = null;
                        if (n == 1 || n == 2) {
                            DebugDataCompositeInfo debugDataCompositeInfo21;
                            DebugDataCompositeInfo debugDataCompositeInfo22 = (DebugDataCompositeInfo)DebugShared.findFieldData(debugDataObjectInfo, "prefix", "$oracle.xml.xslt.XMLString");
                            if (debugDataCompositeInfo22 != null && !debugDataCompositeInfo22.isNull()) {
                                string9 = DebugShared.makeCourtesyValueInternal(debugDataCompositeInfo22, false, false);
                            }
                            if ((debugDataCompositeInfo21 = (DebugDataCompositeInfo)DebugShared.findFieldData(debugDataObjectInfo, "localName", "$oracle.xml.xslt.XMLString")) != null && !debugDataCompositeInfo21.isNull()) {
                                string10 = DebugShared.makeCourtesyValueInternal(debugDataCompositeInfo21, false, false);
                            }
                        }
                        String string11 = null;
                        if (!(n != 2 && n != 3 && n != 4 && n != 7 && n != 8 || (debugDataCompositeInfo20 = (DebugDataCompositeInfo)DebugShared.findFieldData(debugDataObjectInfo, "value", "$oracle.xml.xslt.XMLString")) == null || debugDataCompositeInfo20.isNull())) {
                            string11 = DebugShared.makeCourtesyValueInternal(debugDataCompositeInfo20, false, false);
                        }
                        switch (n) {
                            case 1: {
                                if (string10 == null || string10.length() <= 0) break;
                                if (string9 != null && string9.length() > 0) {
                                    return '<' + string9 + ':' + string10 + '>';
                                }
                                return '<' + string10 + '>';
                            }
                            case 2: {
                                if (string10 == null || string10.length() <= 0 || string11 == null || string11.length() <= 0) break;
                                if (string9 != null && string9.length() > 0) {
                                    return string9 + ':' + string10 + "=\"" + string11 + '\"';
                                }
                                return string10 + "=\"" + string11 + '\"';
                            }
                            case 3: {
                                if (string11 == null || string11.length() <= 0) break;
                                return '\"' + string11 + '\"';
                            }
                            case 4: {
                                if (string11 == null || string11.length() <= 0) break;
                                return '\"' + string11 + '\"';
                            }
                            case 5: {
                                break;
                            }
                            case 6: {
                                break;
                            }
                            case 7: {
                                if (string11 == null || string11.length() <= 0) break;
                                return '\"' + string11 + '\"';
                            }
                            case 8: {
                                if (string11 == null || string11.length() <= 0) break;
                                return '\"' + string11 + '\"';
                            }
                            case 9: {
                                break;
                            }
                            case 10: {
                                break;
                            }
                            case 11: {
                                break;
                            }
                        }
                    }
                }
            }
            debugClassInfo = debugClassInfo.getSuperClass(1);
        }
        return null;
    }

    public static String makeCourtesyClassName(DebugClassInfo debugClassInfo, boolean bl) {
        String string = DebugShared.makeCourtesyClassNameInternal(debugClassInfo, bl);
        if (string != null) {
            return string;
        }
        if (bl) {
            return debugClassInfo.getName();
        }
        return debugClassInfo.getNameWithoutPackage();
    }

    private static String makeCourtesyClassNameInternal(DebugClassInfo debugClassInfo, boolean bl) {
        String string;
        int n = debugClassInfo.getLanguage();
        if (n == 4 && XSLTRunnerAddin.isXSLTStylesheet(debugClassInfo)) {
            return XSLTRunnerAddin.getStylesheetName(debugClassInfo, bl);
        }
        if (n == 2 && (string = debugClassInfo.getPackage()).startsWith("$Oracle.Block.")) {
            String string2 = DebugJDIArb.getString(3);
            if (bl) {
                return string + "." + string2;
            }
            return string2;
        }
        return null;
    }

    public static String makeCourtesyPackage(DebugClassInfo debugClassInfo) {
        if (XSLTRunnerAddin.isXSLTStylesheet(debugClassInfo)) {
            return "";
        }
        return debugClassInfo.getPackage();
    }

    public static String makeCourtesyMethodName(DebugMethodInfo debugMethodInfo, boolean bl, boolean bl2, DebugStackFrameInfo debugStackFrameInfo) {
        if (XSLTRunnerAddin.isXSLTStylesheet(debugMethodInfo.getClassInfo())) {
            return XSLTRunnerAddin.getTemplateName(debugMethodInfo, debugStackFrameInfo);
        }
        if (bl) {
            if (bl2) {
                return debugMethodInfo.getName();
            }
            return debugMethodInfo.getNameWithoutSignature();
        }
        if (bl2) {
            return debugMethodInfo.getNameWithoutClass();
        }
        return debugMethodInfo.getNameWithoutClassOrSignature();
    }

    public static String makeCourtesyMethodSignature(DebugMethodInfo debugMethodInfo, DebugVirtualMachine debugVirtualMachine) {
        String string = debugMethodInfo.getParameterSignature();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.startsWith("(") && string.endsWith(")")) {
            string = string.substring(1, string.length() - 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken().trim());
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(string.length() + 1);
        fastStringBuffer.append("(");
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)arrayList.get(n2);
            DebugClassInfo debugClassInfo = debugVirtualMachine.findFirstClassByName(string2);
            if (debugClassInfo != null) {
                String string3 = DebugShared.makeCourtesyClassName(debugClassInfo, true);
                fastStringBuffer.append(string3);
            } else {
                fastStringBuffer.append(string2);
            }
            if (n2 < n - 1) {
                fastStringBuffer.append(", ");
            }
            ++n2;
        }
        fastStringBuffer.append(")");
        return fastStringBuffer.toString();
    }

    public static String makeCourtesyType(DebugDataInfo debugDataInfo, DebugClassInfo debugClassInfo, boolean bl, Object object) {
        String string = null;
        String string2 = null;
        if (debugClassInfo != null) {
            String string3 = null;
            if (object instanceof DebugFieldInfo) {
                string3 = ((DebugFieldInfo)object).getGenericSignature();
            } else if (object instanceof DebugVariableInfo) {
                string3 = ((DebugVariableInfo)object).getGenericSignature();
            }
            if (string3 != null) {
                string = GenericSignature.processGenericSignature(string3, true);
                string2 = GenericSignature.processGenericSignature(string3, false);
                if (string == null) {
                    // empty if block
                }
            }
            if (string == null) {
                string = debugClassInfo.getName();
                string2 = debugClassInfo.getNameWithoutPackage();
            }
            try {
                String string4;
                DebugDataObjectInfo debugDataObjectInfo = null;
                if (debugDataInfo instanceof DebugDataObjectInfo) {
                    debugDataObjectInfo = (DebugDataObjectInfo)debugDataInfo;
                }
                DebugDataArrayInfo debugDataArrayInfo = null;
                if (debugDataInfo instanceof DebugDataArrayInfo) {
                    debugDataArrayInfo = (DebugDataArrayInfo)debugDataInfo;
                }
                if (string.startsWith("$Oracle.") && string.endsWith("$element[]") && debugDataArrayInfo != null && !debugDataArrayInfo.isNull()) {
                    int n = debugDataArrayInfo.getArrayCount();
                    FastStringBuffer fastStringBuffer = new FastStringBuffer(bl ? string : string2);
                    int n2 = fastStringBuffer.lastIndexOf(new FastStringBuffer('$', 1), fastStringBuffer.length() - 1);
                    if (n2 != -1) {
                        fastStringBuffer.replaceCharAt(n2, ' ');
                    }
                    fastStringBuffer.insert(fastStringBuffer.length() - 1, Integer.toString(n));
                    String string5 = fastStringBuffer.toString();
                    return string5;
                }
                if (string.endsWith("[]") && debugDataArrayInfo != null && !debugDataArrayInfo.isNull()) {
                    int n = debugDataArrayInfo.getArrayCount();
                    FastStringBuffer fastStringBuffer = new FastStringBuffer(bl ? string : string2);
                    fastStringBuffer.insert(fastStringBuffer.length() - 1, Integer.toString(n));
                    String string6 = fastStringBuffer.toString();
                    return string6;
                }
                if (string.startsWith("$Oracle.Builtin.") && debugDataObjectInfo != null && !debugDataObjectInfo.isNull()) {
                    if (string.equals("$Oracle.Builtin.PLS_INTEGER")) {
                        String string7 = "PLS_INTEGER";
                        DebugDataInfo debugDataInfo2 = DebugShared.findFieldData(debugDataObjectInfo, "_minValue", "int");
                        DebugDataInfo debugDataInfo3 = DebugShared.findFieldData(debugDataObjectInfo, "_maxValue", "int");
                        if (debugDataInfo2 != null && debugDataInfo3 != null) {
                            String string8 = debugDataInfo2.getValue();
                            String string9 = debugDataInfo3.getValue();
                            if (string8.equals("0") && string9.equals("0")) {
                                String string10 = string7;
                                return string10;
                            }
                            FastStringBuffer fastStringBuffer = new FastStringBuffer(string7);
                            fastStringBuffer.append("(");
                            fastStringBuffer.append(string8);
                            fastStringBuffer.append("..");
                            fastStringBuffer.append(string9);
                            fastStringBuffer.append(")");
                            String string11 = fastStringBuffer.toString();
                            return string11;
                        }
                    } else if (string.equals("$Oracle.Builtin.NUMBER")) {
                        String string12 = "NUMBER";
                        DebugDataInfo debugDataInfo4 = DebugShared.findFieldData(debugDataObjectInfo, "_precision", "int");
                        DebugDataInfo debugDataInfo5 = DebugShared.findFieldData(debugDataObjectInfo, "_scale", "int");
                        if (debugDataInfo4 != null && debugDataInfo5 != null) {
                            String string13 = debugDataInfo4.getValue();
                            String string14 = debugDataInfo5.getValue();
                            if (string13.equals("0") && string14.equals("0")) {
                                String string15 = string12;
                                return string15;
                            }
                            FastStringBuffer fastStringBuffer = new FastStringBuffer(string12);
                            fastStringBuffer.append("(");
                            fastStringBuffer.append(string13);
                            fastStringBuffer.append(",");
                            fastStringBuffer.append(string14);
                            fastStringBuffer.append(")");
                            String string16 = fastStringBuffer.toString();
                            return string16;
                        }
                    } else if (string.equals("$Oracle.Builtin.FLOAT")) {
                        String string17 = "FLOAT";
                        DebugDataInfo debugDataInfo6 = DebugShared.findFieldData(debugDataObjectInfo, "_binaryPrecision", "int");
                        if (debugDataInfo6 != null) {
                            FastStringBuffer fastStringBuffer = new FastStringBuffer(string17);
                            fastStringBuffer.append("(");
                            fastStringBuffer.append(debugDataInfo6.getValue());
                            fastStringBuffer.append(")");
                            String string18 = fastStringBuffer.toString();
                            return string18;
                        }
                    } else if (string.equals("$Oracle.Builtin.CHAR") || string.equals("$Oracle.Builtin.NCHAR")) {
                        int n = string.lastIndexOf(".");
                        String string19 = string.substring(n + 1);
                        DebugDataInfo debugDataInfo7 = DebugShared.findFieldData(debugDataObjectInfo, "_length", "int");
                        if (debugDataInfo7 != null) {
                            String string20 = debugDataInfo7.getValue();
                            if (string20.equals("0")) {
                                String string21 = string19;
                                return string21;
                            }
                            FastStringBuffer fastStringBuffer = new FastStringBuffer(string19);
                            fastStringBuffer.append("(");
                            fastStringBuffer.append(string20);
                            fastStringBuffer.append(")");
                            String string22 = fastStringBuffer.toString();
                            return string22;
                        }
                    } else if (string.equals("$Oracle.Builtin.VARCHAR2") || string.equals("$Oracle.Builtin.NVARCHAR2") || string.equals("$Oracle.Builtin.RAW") || string.equals("$Oracle.Builtin.LONGRAW") || string.equals("$Oracle.Builtin.LONG")) {
                        int n = string.lastIndexOf(".");
                        String string23 = string.substring(n + 1);
                        DebugDataInfo debugDataInfo8 = DebugShared.findFieldData(debugDataObjectInfo, "_maxLength", "int");
                        if (debugDataInfo8 != null) {
                            String string24 = debugDataInfo8.getValue();
                            if (string24.equals("0")) {
                                String string25 = string23;
                                return string25;
                            }
                            FastStringBuffer fastStringBuffer = new FastStringBuffer(string23);
                            fastStringBuffer.append("(");
                            fastStringBuffer.append(string24);
                            fastStringBuffer.append(")");
                            String string26 = fastStringBuffer.toString();
                            return string26;
                        }
                    }
                } else {
                    String string27;
                    short s;
                    String string28;
                    DebugDataInfo debugDataInfo9;
                    if (string.startsWith("$Oracle.") && string.endsWith("$element")) {
                        FastStringBuffer fastStringBuffer = new FastStringBuffer(bl ? string : string2);
                        int n = fastStringBuffer.lastIndexOf(new FastStringBuffer('$', 1), fastStringBuffer.length() - 1);
                        if (n != -1) {
                            fastStringBuffer.replaceCharAt(n, ' ');
                        }
                        String string29 = fastStringBuffer.toString();
                        return string29;
                    }
                    if (string.equals("$oracle.xml.xslt.XMLNode") && (debugDataInfo9 = DebugShared.findFieldData(debugDataObjectInfo, "type", "short")) != null && (string28 = XSLTRunnerAddin.getXMLNodeTypeName(s = Short.decode(string27 = debugDataInfo9.getValue()).shortValue())) != null) {
                        FastStringBuffer fastStringBuffer = new FastStringBuffer(bl ? string : string2);
                        fastStringBuffer.append(" (");
                        fastStringBuffer.append(string28);
                        fastStringBuffer.append(")");
                        String string30 = fastStringBuffer.toString();
                        return string30;
                    }
                }
                if ((string4 = DebugShared.makeCourtesyClassNameInternal(debugClassInfo, bl)) != null) {
                    String string31 = string4;
                    return string31;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl ? string : string2;
    }

    public static DebugDataInfo findFieldData(DebugDataObjectInfo debugDataObjectInfo, String string) {
        return DebugShared.findFieldData(debugDataObjectInfo, string, null, (DebugClassInfo)null);
    }

    public static DebugDataInfo findFieldData(DebugDataObjectInfo debugDataObjectInfo, String string, String string2) {
        return DebugShared.findFieldData(debugDataObjectInfo, string, string2, (DebugClassInfo)null);
    }

    public static DebugDataInfo findFieldData(DebugDataObjectInfo debugDataObjectInfo, String string, String string2, String string3) {
        DebugClassInfo debugClassInfo = null;
        if (string3 != null) {
            DebugClassInfo debugClassInfo2 = debugDataObjectInfo.getClassInfo();
            while (debugClassInfo2 != null) {
                if (debugClassInfo2.getName().equals(string3)) {
                    debugClassInfo = debugClassInfo2;
                    break;
                }
                debugClassInfo2 = debugClassInfo2.getSuperClass(1);
            }
        }
        return DebugShared.findFieldData(debugDataObjectInfo, string, string2, debugClassInfo);
    }

    public static DebugDataInfo findFieldData(DebugDataObjectInfo debugDataObjectInfo, String string, String string2, DebugClassInfo debugClassInfo) {
        DebugFieldInfo debugFieldInfo;
        if (debugDataObjectInfo.canGetFieldByName() && (debugFieldInfo = debugClassInfo != null ? debugDataObjectInfo.getField(string, debugClassInfo) : debugDataObjectInfo.getField(string)) != null) {
            if (string2 == null) {
                return debugFieldInfo.getDataInfo();
            }
            if (debugFieldInfo.getClassInfo().getName().equals(string2)) {
                return debugFieldInfo.getDataInfo();
            }
        }
        DebugFieldInfo[] debugFieldInfoArray = debugDataObjectInfo.getFields(-1, false, true);
        int n = debugFieldInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugFieldInfo debugFieldInfo2 = debugFieldInfoArray[n2];
            if (debugFieldInfo2.getName().equals(string)) {
                if (string2 == null) {
                    return debugFieldInfo2.getDataInfo();
                }
                if (debugFieldInfo2.getClassInfo().getName().equals(string2)) {
                    return debugFieldInfo2.getDataInfo();
                }
            }
            ++n2;
        }
        return null;
    }

    private static DebugDataInfo findStaticFieldData(DebugDataObjectInfo debugDataObjectInfo, String string, String string2) {
        DebugClassInfo debugClassInfo;
        DebugFieldInfo debugFieldInfo;
        if (debugDataObjectInfo.canGetFieldByName() && (debugFieldInfo = debugDataObjectInfo.getField(string)) != null && debugFieldInfo.isStatic()) {
            if (string2 == null) {
                return debugFieldInfo.getDataInfo();
            }
            if (debugFieldInfo.getClassInfo().getName().equals(string2)) {
                return debugFieldInfo.getDataInfo();
            }
        }
        if ((debugClassInfo = debugDataObjectInfo.getClassInfo()) != null) {
            return DebugShared.findStaticFieldData(debugClassInfo, string, string2);
        }
        return null;
    }

    public static DebugDataInfo findStaticFieldData(DebugClassInfo debugClassInfo, String string) {
        return DebugShared.findStaticFieldData(debugClassInfo, string, null);
    }

    private static DebugDataInfo findStaticFieldData(DebugClassInfo debugClassInfo, String string, String string2) {
        DebugFieldInfo[] debugFieldInfoArray = debugClassInfo.getStaticFields(-1);
        int n = debugFieldInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugFieldInfo debugFieldInfo = debugFieldInfoArray[n2];
            if (debugFieldInfo.getName().equals(string)) {
                if (string2 == null) {
                    return debugFieldInfo.getDataInfo();
                }
                if (debugFieldInfo.getClassInfo().getName().equals(string2)) {
                    return debugFieldInfo.getDataInfo();
                }
            }
            ++n2;
        }
        return null;
    }

    private static byte[] getByteArrayField(DebugDataObjectInfo debugDataObjectInfo, String string) {
        DebugDataArrayInfo debugDataArrayInfo = (DebugDataArrayInfo)DebugShared.findFieldData(debugDataObjectInfo, string, "byte[]");
        if (debugDataArrayInfo != null && !debugDataArrayInfo.isNull()) {
            DebugArrayElementInfo[] debugArrayElementInfoArray = debugDataArrayInfo.getArrayElements();
            int n = debugArrayElementInfoArray.length;
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = DebugSharedPrimitives.byteFromHexString(debugArrayElementInfoArray[n2].getDataInfo().getHexValue());
                ++n2;
            }
            return byArray;
        }
        return null;
    }

    private static BigInteger makeBigInteger(DebugDataObjectInfo debugDataObjectInfo) {
        DebugDataInfo debugDataInfo = DebugShared.findFieldData(debugDataObjectInfo, "signum", "int", "java.math.BigInteger");
        if (debugDataInfo != null) {
            int n = DebugSharedPrimitives.intFromHexString(debugDataInfo.getHexValue());
            DebugDataArrayInfo debugDataArrayInfo = (DebugDataArrayInfo)DebugShared.findFieldData(debugDataObjectInfo, "mag", "int[]", "java.math.BigInteger");
            if (debugDataArrayInfo != null && !debugDataArrayInfo.isNull()) {
                DebugArrayElementInfo[] debugArrayElementInfoArray = debugDataArrayInfo.getArrayElements();
                int n2 = debugArrayElementInfoArray.length;
                byte[] byArray = new byte[n2 * 4];
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = DebugSharedPrimitives.intFromHexString(debugArrayElementInfoArray[n3].getDataInfo().getHexValue());
                    byArray[n3 * 4] = (byte)(n4 >> 24 & 0xFF);
                    byArray[n3 * 4 + 1] = (byte)(n4 >> 16 & 0xFF);
                    byArray[n3 * 4 + 2] = (byte)(n4 >> 8 & 0xFF);
                    byArray[n3 * 4 + 3] = (byte)(n4 & 0xFF);
                    ++n3;
                }
                return new BigInteger(n, byArray);
            }
            byte[] byArray = DebugShared.getByteArrayField(debugDataObjectInfo, "magnitude");
            if (byArray != null) {
                return new BigInteger(n, byArray);
            }
        }
        return null;
    }

    private static Long findDateFastTime(DebugDataObjectInfo debugDataObjectInfo) {
        DebugDataObjectInfo debugDataObjectInfo2 = (DebugDataObjectInfo)DebugShared.findFieldData(debugDataObjectInfo, "cal", "java.util.Calendar");
        DebugDataInfo debugDataInfo = DebugShared.findFieldData(debugDataObjectInfo, "fastTime", "long");
        if (debugDataObjectInfo2 != null && debugDataInfo != null && debugDataObjectInfo2.isNull()) {
            long l = DebugSharedPrimitives.longFromHexString(debugDataInfo.getHexValue());
            return new Long(l);
        }
        return null;
    }

    private static String urlToString(DebugDataObjectInfo debugDataObjectInfo) {
        DebugDataCompositeInfo debugDataCompositeInfo = (DebugDataCompositeInfo)DebugShared.findFieldData(debugDataObjectInfo, "protocol", "java.lang.String", "java.net.URL");
        DebugDataCompositeInfo debugDataCompositeInfo2 = (DebugDataCompositeInfo)DebugShared.findFieldData(debugDataObjectInfo, "authority", "java.lang.String", "java.net.URL");
        DebugDataCompositeInfo debugDataCompositeInfo3 = (DebugDataCompositeInfo)DebugShared.findFieldData(debugDataObjectInfo, "file", "java.lang.String", "java.net.URL");
        DebugDataCompositeInfo debugDataCompositeInfo4 = (DebugDataCompositeInfo)DebugShared.findFieldData(debugDataObjectInfo, "ref", "java.lang.String", "java.net.URL");
        if (debugDataCompositeInfo != null && debugDataCompositeInfo2 != null && debugDataCompositeInfo3 != null && debugDataCompositeInfo4 != null) {
            String string = (String)debugDataCompositeInfo.getWholeThing();
            String string2 = (String)debugDataCompositeInfo2.getWholeThing();
            String string3 = (String)debugDataCompositeInfo3.getWholeThing();
            String string4 = (String)debugDataCompositeInfo4.getWholeThing();
            FastStringBuffer fastStringBuffer = new FastStringBuffer(string);
            fastStringBuffer.append(":");
            if (string2 != null && string2.length() > 0) {
                fastStringBuffer.append("//");
                fastStringBuffer.append(string2);
            }
            if (string3 != null) {
                fastStringBuffer.append(string3);
            }
            if (string4 != null) {
                fastStringBuffer.append("#");
                fastStringBuffer.append(string4);
            }
            return fastStringBuffer.toString();
        }
        return null;
    }

    private static boolean findNameInPackageList(String string, List list) {
        int n = string.length();
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            String string2 = (String)list.get(n3);
            int n4 = string2.length();
            if (string.startsWith(string2) && (n == n4 || string.charAt(n4) == '.')) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static boolean isClassOrPackageDebuggable(String string, List list, List list2) {
        if (list.size() == 0 || DebugShared.findNameInPackageList(string, list)) {
            return !DebugShared.findNameInPackageList(string, list2);
        }
        return false;
    }

    public static DebugDataObjectInfo getContextClassLoaderObject(DebugThreadInfo debugThreadInfo) {
        DebugDataObjectInfo debugDataObjectInfo;
        DebugDataObjectInfo debugDataObjectInfo2 = debugThreadInfo.getThreadObject();
        if (debugDataObjectInfo2 != null && !debugDataObjectInfo2.isNull() && (debugDataObjectInfo = (DebugDataObjectInfo)DebugShared.findFieldData(debugDataObjectInfo2, "contextClassLoader", "java.lang.ClassLoader", "java.lang.Thread")) != null) {
            return debugDataObjectInfo;
        }
        return null;
    }

    public static DebugDataObjectInfo getParentClassLoaderObject(DebugDataObjectInfo debugDataObjectInfo) {
        DebugDataObjectInfo debugDataObjectInfo2 = (DebugDataObjectInfo)DebugShared.findFieldData(debugDataObjectInfo, "parent", "java.lang.ClassLoader", "java.lang.ClassLoader");
        if (debugDataObjectInfo2 != null) {
            return debugDataObjectInfo2;
        }
        return null;
    }

    public static DebugDataObjectInfo getSystemClassLoaderObject(DebugClassInfo debugClassInfo) {
        DebugDataObjectInfo debugDataObjectInfo = (DebugDataObjectInfo)DebugShared.findStaticFieldData(debugClassInfo, "scl", "java.lang.ClassLoader");
        if (debugDataObjectInfo != null) {
            return debugDataObjectInfo;
        }
        return null;
    }

    public static void exploreClassLoaderParents(DebugClassLoaderInfo debugClassLoaderInfo) {
        while (debugClassLoaderInfo != null) {
            debugClassLoaderInfo = debugClassLoaderInfo.getParent();
        }
    }

    public static DebugConnectArg findConnectArg(DebugConnectArg[] debugConnectArgArray, String string) {
        int n = debugConnectArgArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugConnectArg debugConnectArg = debugConnectArgArray[n2];
            if (debugConnectArg.getName().equals(string)) {
                return debugConnectArg;
            }
            ++n2;
        }
        return null;
    }

    public static synchronized String getDefaultConnectArgValue(int n, String string) {
        if (defaultConnectArgValues == null) {
            defaultConnectArgValues = new HashMap();
            defaultConnectArgValues.put("hostname", "");
            defaultConnectArgValues.put("port", "4000");
            defaultConnectArgValues.put("timeout", "2");
        }
        if (n == 2 && string.equals("timeout")) {
            return "0";
        }
        return (String)defaultConnectArgValues.get(string);
    }
}

