/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.shared;

import java.util.Set;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointClass;
import oracle.jdevimpl.debugger.support.DebugBreakpointFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethod;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethodBytecode;
import oracle.jdevimpl.debugger.support.DebugBreakpointWatchpoint;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;

public class DebugSharedBreakpoint {
    public boolean isInstanceFilterAppropriate(DebugDataObjectInfo debugDataObjectInfo, Set set) {
        if (this instanceof DebugBreakpointWatchpoint) {
            String string;
            if (set.isEmpty()) {
                DebugSharedBreakpoint.fillClassNamesSet(debugDataObjectInfo, set);
            }
            if (set.contains(string = ((DebugBreakpointWatchpoint)((Object)this)).getWatchpointClassname())) {
                return true;
            }
        } else if (this instanceof DebugBreakpointFileLine || this instanceof DebugBreakpointMethod || this instanceof DebugBreakpointMethodBytecode || this instanceof DebugBreakpointClass) {
            if (set.isEmpty()) {
                DebugSharedBreakpoint.fillClassNamesSet(debugDataObjectInfo, set);
            }
            DebugLocation[] debugLocationArray = ((DebugBreakpoint)((Object)this)).getLocations();
            int n = debugLocationArray.length - 1;
            while (n >= 0) {
                String string = debugLocationArray[n].getClassInfo().getName();
                if (set.contains(string)) {
                    return true;
                }
                --n;
            }
        }
        return false;
    }

    private static void fillClassNamesSet(DebugDataObjectInfo debugDataObjectInfo, Set set) {
        DebugClassInfo debugClassInfo = debugDataObjectInfo.getClassInfo();
        while (debugClassInfo != null) {
            set.add(debugClassInfo.getName());
            debugClassInfo = debugClassInfo.getSuperClass(1);
        }
    }
}

