/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.shared;

import java.io.File;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;

public final class DebugSharedLocation
implements DebugLocation {
    DebugMethodInfo method;
    long address;
    int bytecodeOffset;
    boolean exactBC;
    String path;
    String filename;
    int line;
    boolean exactLine;

    public DebugSharedLocation(DebugMethodInfo debugMethodInfo, long l, int n, boolean bl, String string, String string2, int n2, boolean bl2) {
        this.method = debugMethodInfo;
        this.address = l;
        this.bytecodeOffset = n;
        this.exactBC = bl;
        if (string == null) {
            string = debugMethodInfo.getClassInfo().getPackage().replace('.', File.separatorChar) + File.separator + string2;
        }
        this.path = string;
        this.filename = string2;
        this.line = n2;
        this.exactLine = bl2;
    }

    public DebugMethodInfo getMethod() {
        return this.method;
    }

    public DebugClassInfo getClassInfo() {
        return this.method.getClassInfo();
    }

    public String getPath() {
        return this.path;
    }

    public String getFilename() {
        return this.filename;
    }

    public long getAddress() {
        return this.address;
    }

    public int getBytecodeOffset() {
        return this.bytecodeOffset;
    }

    public boolean isBytecodeExact() {
        return this.exactBC;
    }

    public int getLine() {
        return this.line;
    }

    public boolean isLineExact() {
        return this.exactLine;
    }

    public void setLine(int n) {
        this.line = n;
    }

    public void setLineExact(boolean bl) {
        this.exactLine = bl;
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DebugSharedLocation) {
            DebugSharedLocation debugSharedLocation = (DebugSharedLocation)object;
            return this.method.equals(debugSharedLocation.method) && this.address == debugSharedLocation.address && this.bytecodeOffset == debugSharedLocation.bytecodeOffset && this.exactBC == debugSharedLocation.exactBC && this.line == debugSharedLocation.line && this.exactLine == debugSharedLocation.exactLine;
        }
        return false;
    }
}

