/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.shared;

import java.util.HashMap;
import java.util.Map;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;

public final class DebugSharedPrimitives {
    private static String[] hexPrefixes = new String[]{"#", "0X", "0x"};
    private static Map mapPrimitiveClasses = null;

    public static boolean booleanDecode(String string) throws IllegalArgumentException {
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException(string);
    }

    public static byte byteFromHexString(String string) throws NumberFormatException {
        int n;
        boolean bl = false;
        if (string.length() == 2 && (n = Character.digit(string.charAt(0), 16)) >= 8 && n <= 15) {
            bl = true;
            char c = Character.forDigit(n - 8, 16);
            string = c + string.substring(1);
        }
        byte by = Byte.parseByte(string, 16);
        if (bl) {
            by = (byte)(by | 0x80);
        }
        return by;
    }

    public static byte byteDecode(String string) throws NumberFormatException {
        int n = hexPrefixes.length - 1;
        while (n >= 0) {
            if (string.startsWith(hexPrefixes[n])) {
                return DebugSharedPrimitives.byteFromHexString(string.substring(hexPrefixes[n].length()));
            }
            --n;
        }
        return Byte.decode(string);
    }

    public static char charDecode(String string) throws IllegalArgumentException, NumberFormatException {
        int n = hexPrefixes.length - 1;
        while (n >= 0) {
            if (string.startsWith(hexPrefixes[n])) {
                return (char)DebugSharedPrimitives.intFromHexString(string.substring(hexPrefixes[n].length()));
            }
            --n;
        }
        if (string.startsWith("\\u")) {
            return (char)DebugSharedPrimitives.intFromHexString(string.substring(2));
        }
        char c = string.charAt(0);
        if (Character.isDigit(c)) {
            return (char)Integer.parseInt(string);
        }
        if (c == '\'' && string.length() == 3 && string.charAt(2) == '\'') {
            return string.charAt(1);
        }
        throw new IllegalArgumentException();
    }

    public static short shortFromHexString(String string) throws NumberFormatException {
        int n;
        boolean bl = false;
        if (string.length() == 4 && (n = Character.digit(string.charAt(0), 16)) >= 8 && n <= 15) {
            bl = true;
            char c = Character.forDigit(n - 8, 16);
            string = c + string.substring(1);
        }
        short s = Short.parseShort(string, 16);
        if (bl) {
            s = (short)(s | 0x8000);
        }
        return s;
    }

    public static short shortDecode(String string) throws NumberFormatException {
        int n = hexPrefixes.length - 1;
        while (n >= 0) {
            if (string.startsWith(hexPrefixes[n])) {
                return DebugSharedPrimitives.shortFromHexString(string.substring(hexPrefixes[n].length()));
            }
            --n;
        }
        return Short.decode(string);
    }

    public static int intFromHexString(String string) throws NumberFormatException {
        int n;
        boolean bl = false;
        if (string.length() == 8 && (n = Character.digit(string.charAt(0), 16)) >= 8 && n <= 15) {
            bl = true;
            char c = Character.forDigit(n - 8, 16);
            string = c + string.substring(1);
        }
        int n2 = Integer.parseInt(string, 16);
        if (bl) {
            n2 |= Integer.MIN_VALUE;
        }
        return n2;
    }

    public static int intDecode(String string) throws NumberFormatException {
        int n = hexPrefixes.length - 1;
        while (n >= 0) {
            if (string.startsWith(hexPrefixes[n])) {
                return DebugSharedPrimitives.intFromHexString(string.substring(hexPrefixes[n].length()));
            }
            --n;
        }
        return Integer.decode(string);
    }

    public static long longFromHexString(String string) throws NumberFormatException {
        int n;
        boolean bl = false;
        if (string.length() == 16 && (n = Character.digit(string.charAt(0), 16)) >= 8 && n <= 15) {
            bl = true;
            char c = Character.forDigit(n - 8, 16);
            string = c + string.substring(1);
        }
        long l = Long.parseLong(string, 16);
        if (bl) {
            l |= Long.MIN_VALUE;
        }
        return l;
    }

    public static long longDecode(String string) throws NumberFormatException {
        int n = hexPrefixes.length - 1;
        while (n >= 0) {
            if (string.startsWith(hexPrefixes[n])) {
                return DebugSharedPrimitives.longFromHexString(string.substring(hexPrefixes[n].length()));
            }
            --n;
        }
        return Long.decode(string);
    }

    public static float floatDecode(String string) throws NumberFormatException {
        int n = hexPrefixes.length - 1;
        while (n >= 0) {
            if (string.startsWith(hexPrefixes[n])) {
                return Float.intBitsToFloat(DebugSharedPrimitives.intFromHexString(string.substring(hexPrefixes[n].length())));
            }
            --n;
        }
        return Float.parseFloat(string);
    }

    public static double doubleDecode(String string) throws NumberFormatException {
        int n = hexPrefixes.length - 1;
        while (n >= 0) {
            if (string.startsWith(hexPrefixes[n])) {
                return Double.longBitsToDouble(DebugSharedPrimitives.longFromHexString(string.substring(hexPrefixes[n].length())));
            }
            --n;
        }
        return Double.parseDouble(string);
    }

    public static synchronized DebugClassInfo getPrimitiveClassInfo(String string) {
        if (mapPrimitiveClasses == null) {
            mapPrimitiveClasses = new HashMap();
            mapPrimitiveClasses.put("boolean", new DebugPrimitiveClassInfo("boolean"));
            mapPrimitiveClasses.put("byte", new DebugPrimitiveClassInfo("byte"));
            mapPrimitiveClasses.put("char", new DebugPrimitiveClassInfo("char"));
            mapPrimitiveClasses.put("double", new DebugPrimitiveClassInfo("double"));
            mapPrimitiveClasses.put("float", new DebugPrimitiveClassInfo("float"));
            mapPrimitiveClasses.put("int", new DebugPrimitiveClassInfo("int"));
            mapPrimitiveClasses.put("long", new DebugPrimitiveClassInfo("long"));
            mapPrimitiveClasses.put("short", new DebugPrimitiveClassInfo("short"));
        }
        return (DebugClassInfo)mapPrimitiveClasses.get(string);
    }

    public static class DebugPrimitiveClassInfo
    implements DebugClassInfo {
        private final String name;

        public DebugPrimitiveClassInfo(String string) {
            this.name = string;
        }

        public boolean hasExpired() {
            return false;
        }

        public String getName() {
            return this.name;
        }

        public String getPackage() {
            return "";
        }

        public String getPackagePath() {
            return "";
        }

        public String getNameWithoutPackage() {
            return this.name;
        }

        public String getGenericSignature() {
            return null;
        }

        public int getAccess() {
            return 0;
        }

        public boolean isInterface() {
            return false;
        }

        public boolean isPrimitive() {
            return true;
        }

        public boolean isObject() {
            return false;
        }

        public boolean isArray() {
            return false;
        }

        public int getSizeOfObject() {
            if (this.name.equals("boolean")) {
                return 1;
            }
            if (this.name.equals("byte")) {
                return 1;
            }
            if (this.name.equals("char")) {
                return 2;
            }
            if (this.name.equals("double")) {
                return 8;
            }
            if (this.name.equals("float")) {
                return 4;
            }
            if (this.name.equals("integer")) {
                return 4;
            }
            if (this.name.equals("long")) {
                return 8;
            }
            if (this.name.equals("short")) {
                return 2;
            }
            return 0;
        }

        public int countObjectsOfClass() {
            return 0;
        }

        public int countMemoryOfClass() {
            return 0;
        }

        public DebugDataObjectInfo getClassObject() {
            return null;
        }

        public DebugDataObjectInfo getClassLoaderObject() {
            return null;
        }

        public DebugClassLoaderInfo getClassLoader() {
            return null;
        }

        public String getPrimarySourceFilename() {
            return "";
        }

        public String getSourceFilename() {
            return "";
        }

        public DebugClassInfo getSuperClass(int n) {
            return null;
        }

        public int getMethodCount() {
            return 0;
        }

        public DebugMethodInfo[] getMethods() {
            return new DebugMethodInfo[0];
        }

        public int getStaticFieldCount() {
            return 0;
        }

        public DebugFieldInfo[] getStaticFields() {
            return new DebugFieldInfo[0];
        }

        public DebugFieldInfo getStaticField(int n) {
            return null;
        }

        public int getStaticFieldCount(int n) {
            return 0;
        }

        public DebugFieldInfo[] getStaticFields(int n) {
            return new DebugFieldInfo[0];
        }

        public DebugFieldInfo getStaticField(int n, int n2) {
            return null;
        }

        public int getStaticFieldCount(int n, boolean bl) {
            return 0;
        }

        public DebugFieldInfo[] getStaticFields(int n, boolean bl) {
            return new DebugFieldInfo[0];
        }

        public DebugFieldInfo getStaticField(int n, boolean bl, int n2) {
            return null;
        }

        public DebugFieldInfo getStaticField(String string) {
            return null;
        }

        public int getFieldCount(int n) {
            return 0;
        }

        public DebugFieldInfo[] getFields(int n) {
            return new DebugFieldInfo[0];
        }

        public DebugFieldInfo getField(int n, int n2) {
            return null;
        }

        public int getFieldCount(int n, boolean bl) {
            return 0;
        }

        public DebugFieldInfo[] getFields(int n, boolean bl) {
            return new DebugFieldInfo[0];
        }

        public DebugFieldInfo getField(int n, boolean bl, int n2) {
            return null;
        }

        public int getFieldCount(int n, boolean bl, boolean bl2) {
            return 0;
        }

        public DebugFieldInfo[] getFields(int n, boolean bl, boolean bl2) {
            return new DebugFieldInfo[0];
        }

        public DebugFieldInfo getField(int n, boolean bl, boolean bl2, int n2) {
            return null;
        }

        public boolean isDebuggable() {
            return false;
        }

        public void setDebuggable(boolean bl) {
        }

        public boolean isObfuscated() {
            return false;
        }

        public boolean isCodeCoverage() {
            return false;
        }

        public void setCodeCoverage(boolean bl) {
        }

        public void discardCodeCoverage() {
        }

        public double getCodeCoverageRatio() {
            return 0.0;
        }

        public DebugClassInfo[] getInterfaces() {
            return new DebugClassInfo[0];
        }

        public DebugClassInfo[] getInterfaces(int n) {
            return new DebugClassInfo[0];
        }

        public int getLanguage() {
            return 1;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof DebugPrimitiveClassInfo) {
                DebugPrimitiveClassInfo debugPrimitiveClassInfo = (DebugPrimitiveClassInfo)object;
                return this.name.equals(this.name);
            }
            return false;
        }
    }
}

