/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.shared;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;

final class GenericSignature {
    private final boolean showPackage;
    private final ReadTextBuffer buffer;
    private final JavaLexer lexer;
    private int curToken;

    static String processGenericSignature(String string, boolean bl) {
        try {
            String string2 = new GenericSignature(string, bl).parseTypeSignature0();
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private GenericSignature(String string, boolean bl) {
        this.buffer = TextBufferFactory.createReadTextBuffer((String)string);
        this.showPackage = bl;
        this.lexer = new JavaLexer(3);
        this.lexer.setTextBuffer(this.buffer);
        this.lexer.setPosition(0);
        this.skipToken();
    }

    private void nextToken(short s) {
        if (this.curToken == s) {
            this.skipToken();
        } else {
            this.error();
        }
    }

    private void nextToken(short s, short s2) {
        if (this.curToken == s || this.curToken == s2) {
            this.skipToken();
        } else {
            this.error();
        }
    }

    private boolean optionalToken(short s) {
        if (this.curToken != s) {
            return false;
        }
        this.skipToken();
        return true;
    }

    private boolean optionalToken(short s, short s2) {
        if (this.curToken != s && this.curToken != s2) {
            return false;
        }
        this.skipToken();
        return true;
    }

    private void skipToken() {
        this.curToken = this.lexer.lex();
    }

    private final String getToken(short s) {
        if (this.curToken == s) {
            int n = this.lexer.getStartOffset();
            int n2 = this.lexer.getEndOffset();
            String string = this.buffer.getString(n, n2 - n);
            this.skipToken();
            return string;
        }
        this.error();
        return null;
    }

    private String parseTypeArgument0() {
        switch (this.curToken) {
            case 63: {
                this.skipToken();
                return "*";
            }
            case 67: {
                this.skipToken();
                break;
            }
            case 59: {
                this.skipToken();
            }
        }
        return this.parseTypeSignature0();
    }

    private String parseTypeArguments_opt0() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.optionalToken((short)58)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            while (this.curToken != 46 && this.curToken != 0) {
                arrayList.add(this.parseTypeArgument0());
            }
            this.nextToken((short)46);
            stringBuffer.append("<");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append(string);
                if (!iterator.hasNext()) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(">");
        }
        return stringBuffer.toString();
    }

    private String parseTypeSignature0() {
        PrimitiveType primitiveType;
        int n = this.lexer.getStartOffset();
        if (n == -1) {
            GenericSignature.panic("No token");
        }
        char c = this.buffer.getChar(n);
        this.lexer.setPosition(n + 1);
        this.skipToken();
        switch (c) {
            case 'L': {
                int n2;
                int n3;
                StringBuffer stringBuffer = new StringBuffer();
                int n4 = n + 1;
                do {
                    if (this.curToken != 4) {
                        this.error();
                    }
                    n3 = this.lexer.getEndOffset();
                    this.skipToken();
                } while (this.optionalToken((short)41));
                String string = this.buffer.getString(n4, n3 - n4);
                string = string.replace('/', '.');
                if (!this.showPackage && (n2 = string.lastIndexOf(46)) != -1) {
                    string = string.substring(n2 + 1);
                }
                stringBuffer.append(string);
                stringBuffer.append(this.parseTypeArguments_opt0());
                while (this.optionalToken((short)43)) {
                    stringBuffer.append("$");
                    stringBuffer.append(this.getToken((short)4));
                    stringBuffer.append(this.parseTypeArguments_opt0());
                }
                this.nextToken((short)75);
                return stringBuffer.toString();
            }
            case 'T': {
                StringBuffer stringBuffer = new StringBuffer();
                int n5 = n + 1;
                if (this.curToken != 4) {
                    this.error();
                }
                int n6 = this.lexer.getEndOffset();
                String string = this.buffer.getString(n5, n6 - n5);
                this.skipToken();
                this.nextToken((short)75);
                stringBuffer.append(string);
                return stringBuffer.toString();
            }
            case '[': {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.parseTypeSignature0());
                stringBuffer.append("[]");
                return stringBuffer.toString();
            }
        }
        if (c < 'A' || 'Z' < c) {
            this.error();
        }
        if ((primitiveType = PrimitiveType.PRIMITIVE_alpha[c - 65]) == null) {
            this.error();
        }
        return primitiveType.getName();
    }

    private void error() {
        String string = this.buffer.getString(0, this.buffer.getLength());
        GenericSignature.panic(string);
    }

    private static void panic(String string) {
        throw new IllegalStateException(string);
    }
}

