/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.support;

import oracle.jdevimpl.debugger.ant.DebugAntConnector;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariConnector;
import oracle.jdevimpl.debugger.jdi.DebugJDIConnectorAttach;
import oracle.jdevimpl.debugger.jdi.DebugJDIConnectorListen;
import oracle.jdevimpl.debugger.support.DebugConnector;

public final class DebugFactory {
    public static final int FACTORY_Ferrari_Attach = 0;
    public static final int FACTORY_Ferrari = 0;
    public static final int FACTORY_JPDA_Attach = 1;
    public static final int FACTORY_JPDA = 1;
    public static final int FACTORY_JPDA_Listen = 2;
    public static final int FACTORY_Probe_Attach = 3;
    public static final int FACTORY_Probe = 3;
    public static final int FACTORY_ANT_Attach = 4;
    private static final int FACTORY_COUNT = 5;
    private static final String[] names = new String[]{"OJVM", "JPDA Attach", "JPDA Listen", "Probe", "Apache Ant"};
    private static final String[] versions = new String[5];
    private static final Class[] connectorClasses = new Class[5];

    private DebugFactory() {
    }

    static {
        DebugFactory.registerDebugConnector(0, DebugFerrariConnector.class, DebugFerrariConnector.getVersion());
        DebugFactory.registerDebugConnector(1, DebugJDIConnectorAttach.class, DebugJDIConnectorAttach.getVersion());
        DebugFactory.registerDebugConnector(2, DebugJDIConnectorListen.class, DebugJDIConnectorListen.getVersion());
        DebugFactory.registerDebugConnector(4, DebugAntConnector.class, DebugAntConnector.getVersion());
    }

    public static void registerDebugConnector(int n, Class clazz, String string) {
        if (n >= 0 && n < 5) {
            DebugFactory.versions[n] = string;
            DebugFactory.connectorClasses[n] = clazz;
        }
    }

    public static String[] getNames() {
        String[] stringArray = new String[5];
        System.arraycopy(names, 0, stringArray, 0, 5);
        return stringArray;
    }

    public static String getName(int n) {
        if (n >= 0 && n < 5) {
            return names[n];
        }
        return null;
    }

    public static int getFactoryForName(String string) {
        if (string != null) {
            int n = 0;
            while (n < 5) {
                if (string.equals(names[n])) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public static String[] getVersions() {
        String[] stringArray = new String[5];
        System.arraycopy(versions, 0, stringArray, 0, 5);
        return stringArray;
    }

    public static String getVersion(int n) {
        if (n >= 0 && n < 5) {
            return versions[n];
        }
        return null;
    }

    public static DebugConnector newInstance(int n) {
        Class clazz;
        if (n >= 0 && n < 5 && (clazz = connectorClasses[n]) != null) {
            try {
                DebugConnector debugConnector = (DebugConnector)clazz.newInstance();
                return debugConnector;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

