/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.support;

import java.util.ArrayList;
import java.util.List;
import oracle.jdevimpl.debugger.support.DebugHeapSubset;

public final class DebugHeapSubsetClasses
extends DebugHeapSubset {
    private List classes = new ArrayList();
    private List subclasses = new ArrayList();

    public DebugHeapSubsetClasses() {
        this(null);
    }

    public DebugHeapSubsetClasses(String string) {
        super(string);
    }

    public synchronized int countClasses() {
        return this.classes.size();
    }

    public synchronized String[] getClasses() {
        String[] stringArray = new String[this.classes.size()];
        return this.classes.toArray(stringArray);
    }

    public synchronized void addClass(String string, boolean bl) {
        this.classes.add(string);
        this.subclasses.add(new Boolean(bl));
    }

    public synchronized void removeClass(String string) {
        int n = this.classes.indexOf(string);
        if (n != -1) {
            this.classes.remove(n);
            this.subclasses.remove(n);
        }
    }

    public synchronized void removeClass(int n) {
        this.classes.remove(n);
        this.subclasses.remove(n);
    }

    public synchronized boolean getIncludeSubclasses(String string) {
        int n = this.classes.indexOf(string);
        if (n != -1) {
            return (Boolean)this.subclasses.get(n);
        }
        return false;
    }

    public synchronized void setIncludeSubclasses(String string, boolean bl) {
        int n = this.classes.indexOf(string);
        if (n != -1) {
            this.subclasses.set(n, new Boolean(bl));
        }
    }

    public synchronized void removeAllClasses() {
        this.classes.clear();
        this.subclasses.clear();
    }
}

