/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.externaltools;

import java.awt.Window;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.PropertyResolver;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.externaltools.ExternalTool;
import oracle.jdeveloper.externaltools.ExternalToolManager;
import oracle.jdeveloper.externaltools.ToolRunException;
import oracle.jdevimpl.externaltools.MenuManager;
import oracle.jdevimpl.externaltools.Util;

final class ExternalToolAction {
    private static final String EXTERNAL_TOOL_PROPERTY = "externalToolInstance";
    private static final Controller s_externalToolController = new ETController(null);

    private ExternalToolAction() {
    }

    static ExternalTool getExternalTool(IdeAction ideAction) {
        return (ExternalTool)ideAction.getValue(EXTERNAL_TOOL_PROPERTY);
    }

    static IdeAction getExternalToolAction(int n, ExternalTool externalTool) {
        IdeAction ideAction = IdeAction.get((int)n);
        if (ExternalToolAction.getExternalTool(ideAction) == null) {
            ETPropertyResolver eTPropertyResolver = new ETPropertyResolver(externalTool, null);
            ideAction.addPropertyResolver((PropertyResolver)eTPropertyResolver);
            ideAction.putValue("Category", (Object)IdeMainWindow.ACTION_CATEGORY_TOOLS);
            ideAction.addController(s_externalToolController);
        }
        return ideAction;
    }

    private static final class ETController
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            ExternalTool externalTool = ExternalToolAction.getExternalTool(ideAction);
            if (externalTool != null) {
                try {
                    externalTool.run(ExternalToolManager.getExternalToolManager(), context);
                }
                catch (ToolRunException toolRunException) {
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)toolRunException);
                }
            }
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            ExternalTool externalTool = ExternalToolAction.getExternalTool(ideAction);
            boolean bl = MenuManager.isToolEnabledInContext(externalTool, context);
            ideAction.setEnabled(bl);
            return true;
        }

        private ETController() {
        }

        ETController(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class ETPropertyResolver
    extends PropertyResolver {
        private final ExternalTool _tool;

        private ETPropertyResolver(ExternalTool externalTool) {
            this._tool = externalTool;
        }

        public Object get(String string) {
            if (string == "SmallIcon") {
                return Util.getToolIcon(this._tool, Context.newIdeContext());
            }
            if (string == "MnemonicKey") {
                String string2 = this._tool.getCaption();
                if (string2 != null) {
                    int n = StringUtils.getMnemonicKeyCode((String)string2);
                    return new Integer(n);
                }
            } else if (string == "Name") {
                String string3 = this._tool.getCaption();
                if (string3 != null) {
                    return StringUtils.stripMnemonic((String)string3);
                }
            } else {
                if (string == "ShortDescription") {
                    return this._tool.getToolTipText();
                }
                if (string == ExternalToolAction.EXTERNAL_TOOL_PROPERTY) {
                    return this._tool;
                }
            }
            return null;
        }

        ETPropertyResolver(ExternalTool externalTool, 1 var2_2) {
            this(externalTool);
        }

        public final class 1 {
        }
    }
}

