/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.externaltools;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.DefaultKeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.controls.JMenuSorter;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.externaltools.ExternalTool;
import oracle.jdevimpl.externaltools.ExternalToolAction;
import oracle.jdevimpl.externaltools.ExternalToolAddin;
import oracle.jdevimpl.externaltools.ui.ToolListPanel;
import oracle.jdevimpl.resource.ExternalToolsArb;

class MenuManager
implements ContextMenuListener,
Controller {
    private ExternalToolAddin m_externalToolAddin;
    private ArrayList m_menuItems;
    private ArrayList m_mainToolBarItems;
    private ArrayList m_activeContextItems;
    private ToolKeyStrokeContext m_keyStrokeContext;
    private IdeAction m_externalToolsAction;
    private static final String EXTERNAL_TOOLS_CMD = "ExternalTools";

    MenuManager(ExternalToolAddin externalToolAddin) {
        this.m_externalToolAddin = externalToolAddin;
    }

    private void deregisterAction(ExternalTool externalTool) {
        IdeAction ideAction = this.getIdeActionForTool(externalTool);
        if (ideAction != null) {
            IdeAction.remove((int)ideAction.getCommandId());
        }
    }

    private void removeMenu(ExternalTool externalTool) {
        if (this.m_menuItems != null && externalTool.hasIntegration(1)) {
            IdeAction ideAction = this.getIdeActionForTool(externalTool);
            for (JMenuItem jMenuItem : this.m_menuItems) {
                if (jMenuItem.getAction() != ideAction) continue;
                Ide.getMenubar().remove((Component)jMenuItem, oracle.ide.controller.MenuManager.getJMenu((String)"Tools"));
                jMenuItem.setAction(null);
                this.m_menuItems.remove(jMenuItem);
                if (this.m_menuItems.size() != 0) break;
                this.m_menuItems = null;
                break;
            }
        }
    }

    private void removeToolBarItems(ExternalTool externalTool) {
        if (this.m_mainToolBarItems != null && externalTool.hasIntegration(8)) {
            IdeAction ideAction = this.getIdeActionForTool(externalTool);
            for (JMenuItem jMenuItem : this.m_mainToolBarItems) {
                if (jMenuItem.getAction() != ideAction) continue;
                Ide.getToolbar().remove((Component)jMenuItem);
                jMenuItem.setAction(null);
                this.m_mainToolBarItems.remove(jMenuItem);
                if (this.m_mainToolBarItems.size() == 0) {
                    this.m_mainToolBarItems = null;
                }
                Ide.getToolbar().invalidate();
                Ide.getToolbar().validate();
                Ide.getToolbar().repaint();
                break;
            }
        }
    }

    private void addMenu(ExternalTool externalTool) {
        if (externalTool.hasIntegration(1)) {
            if (this.m_menuItems == null) {
                this.m_menuItems = new ArrayList();
            }
            JMenu jMenu = oracle.ide.controller.MenuManager.getJMenu((String)"Tools");
            IdeAction ideAction = this.getIdeActionForTool(externalTool);
            JMenuItem jMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)ideAction);
            this.m_menuItems.add(jMenuItem);
            Ide.getMenubar().add((Component)jMenuItem, jMenu, JDeveloperMenuConstants.SECTION_TOOLS_EXTERNAL_TOOLS);
            if (JMenuSorter.isSorted((JMenu)jMenu)) {
                JMenuSorter.registerExclusionGroup((JMenu)jMenu, (Component)jMenuItem);
            }
        }
    }

    private void createMenus() {
        Iterator iterator = this.m_externalToolAddin.getAllExternalTools();
        while (iterator.hasNext()) {
            this.addMenu((ExternalTool)iterator.next());
        }
    }

    private void deregisterActions() {
        Iterator iterator = this.m_externalToolAddin.getAllExternalTools();
        while (iterator.hasNext()) {
            ExternalTool externalTool = (ExternalTool)iterator.next();
            this.deregisterAction(externalTool);
        }
    }

    private void removeMenus() {
        if (this.m_menuItems == null) {
            return;
        }
        JMenu jMenu = oracle.ide.controller.MenuManager.getJMenu((String)"Tools");
        for (JMenuItem jMenuItem : this.m_menuItems) {
            jMenuItem.setAction(null);
            Ide.getMenubar().remove((Component)jMenuItem, jMenu);
        }
        this.m_menuItems = null;
    }

    private void addToolBarItem(ExternalTool externalTool, boolean bl) {
        if (externalTool.hasIntegration(8)) {
            if (this.m_mainToolBarItems == null) {
                this.m_mainToolBarItems = new ArrayList();
            }
            IdeAction ideAction = this.getIdeActionForTool(externalTool);
            this.m_mainToolBarItems.add(Ide.getToolbar().add((ToggleAction)ideAction));
            if (bl) {
                Ide.getToolbar().validate();
                Ide.getToolbar().repaint();
            }
        }
    }

    private void createToolBarItems() {
        this.m_mainToolBarItems = new ArrayList();
        boolean bl = true;
        Iterator iterator = this.m_externalToolAddin.getAllExternalTools();
        while (iterator.hasNext()) {
            ExternalTool externalTool = (ExternalTool)iterator.next();
            if (!externalTool.hasIntegration(8)) continue;
            if (bl) {
                Ide.getToolbar().addSeparator();
                Component component = Ide.getToolbar().getComponentAtIndex(Ide.getToolbar().getComponentCount() - 1);
                this.m_mainToolBarItems.add(component);
                bl = false;
            }
            this.addToolBarItem(externalTool, false);
        }
        if (!bl) {
            Ide.getToolbar().validate();
            Ide.getToolbar().repaint();
        }
    }

    private void removeToolBarItems() {
        if (this.m_mainToolBarItems != null) {
            for (Component component : this.m_mainToolBarItems) {
                Ide.getToolbar().remove(component);
                if (!(component instanceof AbstractButton)) continue;
                ((AbstractButton)component).setAction(null);
            }
            Ide.getToolbar().invalidate();
            Ide.getToolbar().validate();
            Ide.getToolbar().repaint();
            this.m_mainToolBarItems = null;
        }
    }

    private IdeAction getIdeActionForTool(ExternalTool externalTool) {
        String string = "ExternalTool." + StringUtils.stripMnemonic((String)externalTool.getCaption()).replace(' ', '_');
        return ExternalToolAction.getExternalToolAction(Ide.findOrCreateCmdID((String)string), externalTool);
    }

    void addToolsMenuItem() {
        JMenu jMenu = oracle.ide.controller.MenuManager.getJMenu((String)"Tools");
        JMenuItem jMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)this.m_externalToolsAction, 1.0f);
        Ide.getMenubar().add((Component)jMenuItem, jMenu, JDeveloperMenuConstants.SECTION_TOOLS_EXTERNAL_TOOLS);
        if (JMenuSorter.isSorted((JMenu)jMenu)) {
            JMenuSorter.registerExclusionGroup((JMenu)jMenu, (Component)jMenuItem);
        }
    }

    void addItem(ExternalTool externalTool) {
        this.addMenu(externalTool);
        this.addToolBarItem(externalTool, true);
        this.deinstallKeystrokes();
        this.installKeystrokes();
    }

    void removeItem(ExternalTool externalTool) {
        this.removeMenu(externalTool);
        this.removeToolBarItems(externalTool);
        this.deinstallKeystrokes();
        this.deregisterAction(externalTool);
        this.installKeystrokes();
    }

    void installItems() {
        this.createMenus();
        this.createToolBarItems();
        this.installKeystrokes();
    }

    void uninstallItems() {
        this.removeMenus();
        this.removeToolBarItems();
        this.deinstallKeystrokes();
        this.deregisterActions();
    }

    void initialize() {
        String string = ExternalToolsArb.getString(85);
        this.m_externalToolsAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)EXTERNAL_TOOLS_CMD), null, (String)StringUtils.stripMnemonic((String)string), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), null, null, (boolean)true);
        this.m_externalToolsAction.addController((Controller)this);
        this.m_externalToolsAction.setEnabled(true);
        NavigatorManager.getWorkspaceNavigatorManager().addContextMenuListener((ContextMenuListener)this, null);
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)this);
    }

    private void installKeystrokes() {
        this.m_keyStrokeContext = new ToolKeyStrokeContext(null);
        Ide.getKeyStrokeContextRegistry().addContext((KeyStrokeContext)this.m_keyStrokeContext);
        Ide.getSettings().getKeyStrokeOptions().solvePostponedMaps();
    }

    private void deinstallKeystrokes() {
        if (this.m_keyStrokeContext != null) {
            Ide.getKeyStrokeContextRegistry().removeContext((KeyStrokeContext)this.m_keyStrokeContext);
        }
    }

    private static boolean isValidElement(Element element) {
        return element != null && element instanceof Locatable && ((Locatable)element).getURL() != null;
    }

    static boolean isToolEnabledInContext(ExternalTool externalTool, Context context) {
        Object object = context.getElement() != null ? context.getElement() : context.getNode();
        if (externalTool.getAvailability() == 0) {
            return true;
        }
        if (externalTool.getAvailability() == 1) {
            return MenuManager.isValidElement(object);
        }
        if (externalTool.getAvailability() == 2) {
            if (MenuManager.isValidElement(object)) {
                try {
                    URL uRL = ((Locatable)object).getURL();
                    String string = URLFileSystem.getPlatformPathName((URL)uRL);
                    Pattern pattern = Pattern.compile(externalTool.getAvailabilityExpression());
                    Matcher matcher = pattern.matcher(string);
                    boolean bl = matcher.matches();
                    return bl;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    boolean bl = false;
                    return bl;
                }
            }
        } else if (externalTool.getAvailability() == 3 && MenuManager.isValidElement(object)) {
            URL uRL = ((Locatable)object).getURL();
            String string = URLFileSystem.getSuffix((URL)uRL);
            List list = externalTool.getAvailableTypes();
            DocumentExtensions documentExtensions = (DocumentExtensions)Ide.getSettings().getData("document-extensions-options");
            boolean bl = URLFileSystem.isLocalFileSystemCaseSensitive();
            if (documentExtensions != null) {
                Collection collection = documentExtensions.getDocuments();
                for (DocumentExtensions.DocRecord docRecord : collection) {
                    if (!list.contains(docRecord.getDocClassName())) continue;
                    for (DocumentExtensions.ExtInfo extInfo : docRecord.getExtensions()) {
                        String string2 = extInfo.getExtension();
                        if ((!bl || !string2.equals(string)) && (bl || !string2.equalsIgnoreCase(string))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        if (this.m_activeContextItems != null) {
            for (JMenuItem jMenuItem : this.m_activeContextItems) {
                jMenuItem.setAction(null);
            }
            this.m_activeContextItems = null;
        }
        Iterator iterator = this.m_externalToolAddin.getAllExternalTools();
        while (iterator.hasNext()) {
            boolean bl;
            ExternalTool externalTool = (ExternalTool)iterator.next();
            boolean bl2 = bl = externalTool.hasIntegration(4) && contextMenu.getContext().getView() instanceof NavigatorWindow || externalTool.hasIntegration(2) && contextMenu.getContext().getView() instanceof CodeEditor;
            if (!bl || !MenuManager.isToolEnabledInContext(externalTool, contextMenu.getContext())) continue;
            IdeAction ideAction = this.getIdeActionForTool(externalTool);
            JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)ideAction);
            float f = JDeveloperMenuConstants.SECTION_TOOLS_EXTERNAL_TOOLS;
            if (contextMenu.getContext().getView() instanceof CodeEditor) {
                f += 0.05f;
            }
            contextMenu.add((Component)jMenuItem, f);
            if (this.m_activeContextItems == null) {
                this.m_activeContextItems = new ArrayList();
            }
            this.m_activeContextItems.add(jMenuItem);
            this.update(ideAction, contextMenu.getContext());
        }
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        ToolListPanel toolListPanel = new ToolListPanel();
        toolListPanel.setToolManager(this.m_externalToolAddin);
        toolListPanel.runDialog((Component)Ide.getMainWindow(), new ExternalToolsDialogRunnable(toolListPanel));
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    static ExternalToolAddin ra$m_externalToolAddin(MenuManager menuManager) {
        return menuManager.m_externalToolAddin;
    }

    static IdeAction mav$getIdeActionForTool(MenuManager menuManager, ExternalTool externalTool) {
        return menuManager.getIdeActionForTool(externalTool);
    }

    static IdeAction ra$m_externalToolsAction(MenuManager menuManager) {
        return menuManager.m_externalToolsAction;
    }

    private class ToolKeyStrokeContext
    extends DefaultKeyStrokeContext {
        public String getName() {
            return "ToolManager";
        }

        public Set getAllActions(boolean bl) {
            if (bl) {
                HashSet<IdeAction> hashSet = new HashSet<IdeAction>();
                Iterator iterator = MenuManager.ra$m_externalToolAddin(MenuManager.this).getAllExternalTools();
                while (iterator.hasNext()) {
                    hashSet.add(MenuManager.mav$getIdeActionForTool(MenuManager.this, (ExternalTool)iterator.next()));
                }
                hashSet.add(MenuManager.ra$m_externalToolsAction(MenuManager.this));
                return hashSet;
            }
            return null;
        }

        protected void addGlobalKeyStrokes(KeyStrokeMap keyStrokeMap) {
        }

        private ToolKeyStrokeContext() {
        }

        ToolKeyStrokeContext(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ExternalToolsDialogRunnable
    implements Runnable {
        private ToolListPanel m_listPanel;

        ExternalToolsDialogRunnable(ToolListPanel toolListPanel) {
            this.m_listPanel = toolListPanel;
        }

        public void run() {
            MenuManager.ra$m_externalToolAddin(MenuManager.this).setToolList(this.m_listPanel.getTools());
            MenuManager.ra$m_externalToolAddin(MenuManager.this).saveTools();
        }
    }
}

