/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.externaltools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.externaltools.ExternalTool;
import oracle.jdevimpl.externaltools.program.ExternalProgramTool;
import oracle.jdevimpl.externaltools.program.ExternalProgramType;
import oracle.xml.parser.v2.XMLDocument;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ToolPersistence {
    static final String TOOL_DEFINITION_FILENAME = "tools.xml";
    private static final String TOP_TAG = "tools";
    private static final String NS_905 = "http://xmlns.oracle.com/jdeveloper/905/externaltools";
    private static final String STYLE_904_TO_905 = "tools-904-to-905.xsl";
    private static final String ENCODING = "UTF-8";
    static final int VERSION_904 = 0;
    static final int VERSION_905 = 1;
    static final int VERSION_UNRECOGNIZED = -1;
    static final int SUPPORTED_VERSION = 1;

    static int getDefinitionRevision(File file) throws IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(false);
        ToolFileRecognizerHandler toolFileRecognizerHandler = new ToolFileRecognizerHandler(null);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(file, (DefaultHandler)toolFileRecognizerHandler);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new IOException(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new IOException(sAXException.getMessage());
        }
        return toolFileRecognizerHandler.getVersion();
    }

    static ArrayList loadDefinitions(File file) throws IOException {
        Object2Dom object2Dom = Object2Dom.newInstance();
        URL uRL = URLFactory.newFileURL((File)file);
        object2Dom.setDocumentURL(uRL);
        return (ArrayList)object2Dom.toObject(uRL);
    }

    static void saveDefinitions(File file, ArrayList arrayList) throws IOException {
        if (arrayList == null) {
            return;
        }
        Object2Dom object2Dom = Object2Dom.newInstance();
        object2Dom.setNamespaceURI(NS_905);
        object2Dom.setDocumentURL(URLFactory.newFileURL((File)file));
        XMLDocument xMLDocument = object2Dom.toDocument((Object)arrayList, TOP_TAG);
        xMLDocument.setEncoding(ENCODING);
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING));
        xMLDocument.print(printWriter);
        printWriter.close();
    }

    static void convertDefinitions(File file, File file2, int n) throws IOException {
        if (n == -1) {
            n = ToolPersistence.getDefinitionRevision(file);
        }
        if (n == 1) {
            URL uRL = URLFactory.newFileURL((File)file);
            URL uRL2 = URLFactory.newFileURL((File)file2);
            URLFileSystem.copy((URL)uRL, (URL)uRL2);
            return;
        }
        if (n == 0) {
            ToolPersistence.convert904To905(file, file2);
        }
    }

    private static void convert904To905(File file, File file2) throws IOException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            StreamSource streamSource = new StreamSource(ToolPersistence.class.getResource(STYLE_904_TO_905).toString());
            Transformer transformer = transformerFactory.newTransformer(streamSource);
            StreamSource streamSource2 = new StreamSource(file);
            if (!file2.exists()) {
                file2.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            StreamResult streamResult = new StreamResult(fileOutputStream);
            transformer.transform(streamSource2, streamResult);
            ArrayList arrayList = ToolPersistence.loadDefinitions(file2);
            boolean bl = false;
            for (ExternalTool externalTool : arrayList) {
                ExternalProgramTool externalProgramTool;
                if (!(externalTool instanceof ExternalProgramTool) || (externalProgramTool = (ExternalProgramTool)externalTool).getIconURL() != null) continue;
                externalProgramTool.setIconURL(ExternalProgramType.class.getResource("programtool.gif"));
                bl = true;
            }
            if (bl) {
                ToolPersistence.saveDefinitions(file2, arrayList);
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
            throw new IOException(transformerConfigurationException.getMessage());
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
            throw new IOException(transformerException.getMessage());
        }
    }

    ToolPersistence() {
    }

    private static class ToolFileRecognizerHandler
    extends DefaultHandler {
        private int m_version;

        void $init$() {
            this.m_version = -1;
        }

        public int getVersion() {
            return this.m_version;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (ToolPersistence.TOP_TAG.equals(string2)) {
                this.m_version = ToolPersistence.NS_905.equals(string) ? 1 : 0;
            }
        }

        private ToolFileRecognizerHandler() {
            this.$init$();
        }

        ToolFileRecognizerHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

