/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.externaltools;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import oracle.ide.natives.NativeHandler;
import oracle.ide.natives.registry.Registry;
import oracle.ide.natives.registry.RegistryException;
import oracle.ide.natives.registry.RegistryKey;
import oracle.ide.natives.registry.RegistryNotAvailableException;
import oracle.javatools.util.EnvironmentVariables;
import oracle.jdeveloper.externaltools.ExternalTool;
import oracle.jdeveloper.externaltools.ExternalToolManager;
import oracle.jdeveloper.externaltools.ExternalToolScanner;
import oracle.jdevimpl.externaltools.program.ExternalProgramTool;

class WindowsToolScanner
implements ExternalToolScanner {
    private static final String[][] REGISTRY_APPS = new String[][]{{"Dreamweaver.exe", "Dreamweaver"}, {"cvsnt.exe", "CVS for NT"}, {"firefox.exe", "Mozilla Firefox"}, {"IEXPLORE.EXE", "Internet Explorer"}, {"msdev.exe", "Microsoft Visual Studio"}, {"TextPad.exe", "TextPad"}, {"Winword.exe", "Word"}, {"winzip32.exe", "WinZip"}, {"wordpad.exe", "Wordpad"}};

    public String getId() {
        return "windowsimpl";
    }

    public boolean canScan() {
        String string = System.getProperty("os.name");
        return string.toLowerCase().indexOf("windows") >= 0;
    }

    public ExternalTool[] findTools(Collection collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (ExternalTool externalTool : collection) {
            String string = externalTool.getScannerTag();
            if (string == null) continue;
            hashSet.add(externalTool.getScannerTag());
        }
        ArrayList arrayList = new ArrayList();
        String string = EnvironmentVariables.getVariable((String)"SYSTEMROOT");
        File file = new File(string);
        if (file.exists()) {
            File file2;
            File file3 = new File(file, "explorer.exe");
            if (file3.exists()) {
                this.addWindowsTool(arrayList, hashSet, "Explore Directory", file3.getPath(), "\"${file.dir}\"");
            }
            if ((file2 = new File(file, "notepad.exe")).exists()) {
                this.addWindowsTool(arrayList, hashSet, "Notepad", file2.getPath(), "\"${file.path}\"");
            }
            int n = 0;
            while (n < REGISTRY_APPS.length) {
                this.findRegistryApp(arrayList, hashSet, REGISTRY_APPS[n][0], REGISTRY_APPS[n][1], "\"${file.path}\"");
                ++n;
            }
            return arrayList.toArray(new ExternalTool[arrayList.size()]);
        }
        return new ExternalTool[0];
    }

    private void findRegistryApp(List list, Collection collection, String string, String string2, String string3) {
        try {
            Registry registry = NativeHandler.getRegistry();
            try {
                RegistryKey registryKey = registry.getLocalMachineKey();
                RegistryKey registryKey2 = registryKey.openKey("Software\\Microsoft\\Windows\\CurrentVersion\\App Paths\\" + string, 131097L);
                try {
                    File file;
                    String string4 = registryKey2.getStringValue(null);
                    if (string4 != null && (file = new File(string4)).exists()) {
                        this.addWindowsTool(list, collection, string2, file.getPath(), string3);
                    }
                }
                finally {
                    registryKey2.close();
                }
            }
            catch (RegistryException registryException) {}
        }
        catch (RegistryNotAvailableException registryNotAvailableException) {
            // empty catch block
        }
    }

    private void addWindowsTool(Collection collection, Collection collection2, String string, String string2, String string3) {
        String string4 = this.getId() + "." + string;
        if (!collection2.contains(string4)) {
            ExternalTool externalTool = this.createWindowsTool(string, string2, string3);
            externalTool.setScannerTag(string4);
            collection.add(externalTool);
        }
    }

    private ExternalTool createWindowsTool(String string, String string2, String string3) {
        ExternalProgramTool externalProgramTool = new ExternalProgramTool();
        externalProgramTool.setExecutable(string2);
        externalProgramTool.setCaption(string);
        externalProgramTool.setArguments(string3);
        externalProgramTool.setAvailability(1);
        externalProgramTool.setIntegrationMask(15);
        externalProgramTool.setIconURL(ExternalToolManager.getExternalToolManager().getType(externalProgramTool).getDefaultIconURL(externalProgramTool));
        return externalProgramTool;
    }

    WindowsToolScanner() {
    }
}

