/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.externaltools.program;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.externaltools.ExternalTool;
import oracle.jdeveloper.externaltools.ExternalToolOptionsEnvironment;
import oracle.jdeveloper.externaltools.ExternalToolOptionsPage;
import oracle.jdeveloper.externaltools.macro.MacroExpander;
import oracle.jdeveloper.externaltools.macro.MacroTextField;
import oracle.jdevimpl.externaltools.program.ExternalProgramTool;
import oracle.jdevimpl.resource.ExternalToolsArb;

public class ExternalProgramOptions
extends JPanel
implements ExternalToolOptionsPage {
    private static URL s_lastExecutablePath;
    private static URL s_lastRunDirectory;
    private ExternalToolOptionsEnvironment m_env;
    private GridBagLayout gblDetailsPanel;
    private JLabel labHint;
    private JLabel labExecutable;
    private MacroTextField tfExecutable;
    private JButton btnBrowseExecutable;
    private JLabel labArguments;
    private MacroTextField tfArguments;
    private JButton btnBrowseArguments;
    private JLabel labRunInDirectory;
    private MacroTextField tfRunInDirectory;
    private JButton btnBrowseDirectory;
    private JButton btnDirectoryMacros;
    private JLabel labCommandSample;
    private JTextField tfCommandSample;
    private JPanel dummyPanel;
    private boolean _isRunDirectoryModified;
    private boolean _isAutoSettingRunDirectory;

    void $init$() {
        this.gblDetailsPanel = new GridBagLayout();
        this.labHint = new JLabel();
        this.labExecutable = new JLabel();
        this.btnBrowseExecutable = new JButton();
        this.labArguments = new JLabel();
        this.btnBrowseArguments = new JButton();
        this.labRunInDirectory = new JLabel();
        this.btnBrowseDirectory = new JButton();
        this.btnDirectoryMacros = new JButton();
        this.labCommandSample = new JLabel();
        this.tfCommandSample = new JTextField();
        this.dummyPanel = new JPanel();
        this._isRunDirectoryModified = false;
        this._isAutoSettingRunDirectory = false;
    }

    public ExternalProgramOptions() {
        this.$init$();
        this.jbInit();
    }

    public String getHelpTopicID() {
        return "f1_idedexternaltools2_html";
    }

    private void jbInit() {
        this.tfRunInDirectory = new MacroTextField();
        this.tfArguments = new MacroTextField();
        this.tfExecutable = new MacroTextField();
        this.tfExecutable.getDocument().addDocumentListener(new 3());
        this.tfRunInDirectory.getDocument().addDocumentListener(new 2());
        ActionDispatcher actionDispatcher = new ActionDispatcher(null);
        this.btnBrowseDirectory.addActionListener(actionDispatcher);
        this.btnBrowseExecutable.addActionListener(actionDispatcher);
        this.btnBrowseArguments.addActionListener(actionDispatcher);
        this.btnDirectoryMacros.addActionListener(actionDispatcher);
        this.setLayout(this.gblDetailsPanel);
        this.btnBrowseArguments.setEnabled(false);
        this.labHint.setText("<html>" + ExternalToolsArb.getString(99) + "</html>");
        ResourceUtils.resLabel((JLabel)this.labExecutable, (Component)((Object)this.tfExecutable), (String)ExternalToolsArb.getString(100));
        ResourceUtils.resButton((AbstractButton)this.btnBrowseExecutable, (String)ExternalToolsArb.getString(101));
        ResourceUtils.resLabel((JLabel)this.labArguments, (Component)((Object)this.tfArguments), (String)ExternalToolsArb.getString(102));
        ResourceUtils.resButton((AbstractButton)this.btnBrowseArguments, (String)ExternalToolsArb.getString(103));
        ResourceUtils.resLabel((JLabel)this.labRunInDirectory, (Component)((Object)this.tfRunInDirectory), (String)ExternalToolsArb.getString(104));
        ResourceUtils.resButton((AbstractButton)this.btnBrowseDirectory, (String)ExternalToolsArb.getString(105));
        ResourceUtils.resButton((AbstractButton)this.btnDirectoryMacros, (String)ExternalToolsArb.getString(106));
        ResourceUtils.resLabel((JLabel)this.labCommandSample, (Component)this.tfCommandSample, (String)ExternalToolsArb.getString(108));
        this.tfCommandSample.setEditable(false);
        this.add((Component)this.labHint, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add((Component)this.labExecutable, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)((Object)this.tfExecutable), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.btnBrowseExecutable, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add((Component)this.labArguments, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)((Object)this.tfArguments), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.btnBrowseArguments, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add((Component)this.labRunInDirectory, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)((Object)this.tfRunInDirectory), new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.btnBrowseDirectory, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add((Component)this.btnDirectoryMacros, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add((Component)this.labCommandSample, new GridBagConstraints(0, 8, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.tfCommandSample, new GridBagConstraints(0, 9, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.dummyPanel, new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public Component getInitialFocus() {
        return this.tfExecutable;
    }

    private void doBrowseExecutable() {
        URL uRL = null;
        uRL = this.tfExecutable.getText().trim().length() == 0 ? (s_lastExecutablePath == null ? URLFactory.newFileURL((String)Ide.getHomeDirectory()) : s_lastExecutablePath) : URLFactory.newFileURL((String)this.tfExecutable.getText());
        URLChooser uRLChooser = uRL != null && URLFileSystem.exists((URL)uRL) ? DialogUtil.newURLChooser((URL)uRL) : DialogUtil.newURLChooser();
        uRLChooser.setSelectionMode(0);
        if (uRLChooser.showOpenDialog((Component)this, ExternalToolsArb.getString(107)) == 0) {
            URL uRL2 = uRLChooser.getSelectedURL();
            this.tfExecutable.setText(URLFileSystem.getPlatformPathName((URL)uRL2));
        }
        s_lastExecutablePath = uRLChooser.getSelectedURL();
    }

    private void doBrowseDirectory() {
        URL uRL = null;
        uRL = this.tfRunInDirectory.getText().trim().length() == 0 ? (s_lastRunDirectory == null ? URLFactory.newFileURL((String)Ide.getHomeDirectory()) : s_lastRunDirectory) : URLFactory.newFileURL((String)this.tfRunInDirectory.getText());
        URLChooser uRLChooser = uRL != null && URLFileSystem.exists((URL)uRL) && URLFileSystem.isDirectory((URL)uRL) ? DialogUtil.newURLChooser((URL)uRL) : DialogUtil.newURLChooser();
        uRLChooser.setSelectionScope(1);
        uRLChooser.setSelectionMode(0);
        if (uRLChooser.showOpenDialog((Component)this, ExternalToolsArb.getString(109)) == 0) {
            URL uRL2 = uRLChooser.getSelectedURL();
            this.tfRunInDirectory.setText(URLFileSystem.getPlatformPathName((URL)uRL2));
        }
        s_lastRunDirectory = uRLChooser.getSelectedURL();
    }

    private void doBrowseArguments() {
        this.runMacroPicker(false, (JTextField)((Object)this.tfArguments));
    }

    private void doBrowseDirectoryMacros() {
        this.runMacroPicker(true, (JTextField)((Object)this.tfRunInDirectory));
    }

    private void runMacroPicker(boolean bl, JTextField jTextField) {
        MacroExpander macroExpander;
        if (this.m_env != null && (macroExpander = this.m_env.getMacroPicker(bl).runDialog(this)) != null) {
            try {
                jTextField.getDocument().insertString(jTextField.getCaretPosition(), macroExpander.toMacroString(), null);
            }
            catch (BadLocationException badLocationException) {
                ExceptionDialog.showExceptionDialog((Component)this.getGUI(), (Throwable)badLocationException);
            }
            jTextField.requestFocus();
        }
    }

    private void updateCommandSample() {
        View view = Ide.getMainWindow().getLastActiveView();
        Context context = null;
        if (view != null) {
            context = view.getContext();
        }
        if (this.m_env != null) {
            String string = this.m_env.getMacroRegistry().expand(this.tfExecutable.getText(), context, true);
            String string2 = this.m_env.getMacroRegistry().expand(this.tfArguments.getText(), context, true);
            this.tfCommandSample.setText(string + " " + string2);
        } else {
            this.tfCommandSample.setText(this.tfExecutable.getText() + " " + this.tfArguments.getText());
        }
    }

    public void setEnvironment(ExternalToolOptionsEnvironment externalToolOptionsEnvironment) {
        this.m_env = externalToolOptionsEnvironment;
        this.tfExecutable.configure(externalToolOptionsEnvironment.getMacroRegistry(), externalToolOptionsEnvironment.getType(), false);
        this.tfRunInDirectory.configure(externalToolOptionsEnvironment.getMacroRegistry(), externalToolOptionsEnvironment.getType(), true);
        this.tfArguments.configure(externalToolOptionsEnvironment.getMacroRegistry(), externalToolOptionsEnvironment.getType(), false);
        1 var2_2 = new 1();
        this.tfExecutable.getDocument().addDocumentListener(var2_2);
        this.tfArguments.getDocument().addDocumentListener(var2_2);
        this.btnBrowseArguments.setEnabled(true);
    }

    public JComponent getGUI() {
        return this;
    }

    public String getPageName() {
        return ExternalToolsArb.getString(98);
    }

    public boolean isComplete() {
        boolean bl = this.tfExecutable.getText().trim().length() > 0;
        this.m_env.setUserCanFinishNow(bl);
        return bl;
    }

    public boolean validateOptions() {
        return true;
    }

    public void saveOptions(ExternalTool externalTool, boolean bl) {
        ExternalProgramTool externalProgramTool = (ExternalProgramTool)externalTool;
        externalProgramTool.setExecutable(this.tfExecutable.getText());
        externalProgramTool.setRunDirectory(this.tfRunInDirectory.getText());
        externalProgramTool.setArguments(this.tfArguments.getText());
        if (bl) {
            String string = this.tfExecutable.getText();
            if (externalProgramTool.getCaption() == null) {
                int n;
                String string2 = string;
                int n2 = string2.lastIndexOf(File.separatorChar);
                if (n2 != 1) {
                    string2 = string2.substring(n2 + 1);
                }
                if ((n = string2.lastIndexOf(46)) != -1) {
                    string2 = string2.substring(0, n);
                }
                StringBuffer stringBuffer = new StringBuffer(string2.toLowerCase());
                stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
                string2 = stringBuffer.toString();
                if (!this.m_env.isUniqueToolName(string2)) {
                    string2 = this.m_env.makeUniqueName(string2);
                }
                externalProgramTool.setCaption(string2);
            }
            if (externalProgramTool.getIconURL() == null) {
                externalProgramTool.setIconURL(this.m_env.getType().getDefaultIconURL(externalProgramTool));
            }
        }
    }

    public void loadOptions(ExternalTool externalTool, boolean bl) {
        ExternalProgramTool externalProgramTool = (ExternalProgramTool)externalTool;
        this.tfExecutable.setText(externalProgramTool.getExecutable());
        this.tfRunInDirectory.setText(externalProgramTool.getRunDirectory());
        this.tfArguments.setText(externalProgramTool.getArguments());
        if (!bl) {
            this._isRunDirectoryModified = true;
        }
    }

    static boolean ra$_isRunDirectoryModified(ExternalProgramOptions externalProgramOptions) {
        return externalProgramOptions._isRunDirectoryModified;
    }

    static void wa$_isAutoSettingRunDirectory(ExternalProgramOptions externalProgramOptions, boolean bl) {
        externalProgramOptions._isAutoSettingRunDirectory = bl;
    }

    static MacroTextField ra$tfExecutable(ExternalProgramOptions externalProgramOptions) {
        return externalProgramOptions.tfExecutable;
    }

    static MacroTextField ra$tfRunInDirectory(ExternalProgramOptions externalProgramOptions) {
        return externalProgramOptions.tfRunInDirectory;
    }

    static boolean ra$_isAutoSettingRunDirectory(ExternalProgramOptions externalProgramOptions) {
        return externalProgramOptions._isAutoSettingRunDirectory;
    }

    static void wa$_isRunDirectoryModified(ExternalProgramOptions externalProgramOptions, boolean bl) {
        externalProgramOptions._isRunDirectoryModified = bl;
    }

    static JButton ra$btnBrowseExecutable(ExternalProgramOptions externalProgramOptions) {
        return externalProgramOptions.btnBrowseExecutable;
    }

    static void mav$doBrowseExecutable(ExternalProgramOptions externalProgramOptions) {
        externalProgramOptions.doBrowseExecutable();
    }

    static JButton ra$btnBrowseDirectory(ExternalProgramOptions externalProgramOptions) {
        return externalProgramOptions.btnBrowseDirectory;
    }

    static void mav$doBrowseDirectory(ExternalProgramOptions externalProgramOptions) {
        externalProgramOptions.doBrowseDirectory();
    }

    static JButton ra$btnBrowseArguments(ExternalProgramOptions externalProgramOptions) {
        return externalProgramOptions.btnBrowseArguments;
    }

    static void mav$doBrowseArguments(ExternalProgramOptions externalProgramOptions) {
        externalProgramOptions.doBrowseArguments();
    }

    static JButton ra$btnDirectoryMacros(ExternalProgramOptions externalProgramOptions) {
        return externalProgramOptions.btnDirectoryMacros;
    }

    static void mav$doBrowseDirectoryMacros(ExternalProgramOptions externalProgramOptions) {
        externalProgramOptions.doBrowseDirectoryMacros();
    }

    static void mav$updateCommandSample(ExternalProgramOptions externalProgramOptions) {
        externalProgramOptions.updateCommandSample();
    }

    public final class 3
    implements DocumentListener {
        protected void doIt() {
            try {
                if (!ExternalProgramOptions.ra$_isRunDirectoryModified(ExternalProgramOptions.this)) {
                    try {
                        File file;
                        ExternalProgramOptions.wa$_isAutoSettingRunDirectory(ExternalProgramOptions.this, true);
                        if (ExternalProgramOptions.ra$tfExecutable(ExternalProgramOptions.this).getText().trim().length() == 0) {
                            ExternalProgramOptions.ra$tfRunInDirectory(ExternalProgramOptions.this).setText("");
                        }
                        if ((file = new File(ExternalProgramOptions.ra$tfExecutable(ExternalProgramOptions.this).getText())) != null) {
                            String string = file.getParent();
                            if (string != null) {
                                ExternalProgramOptions.ra$tfRunInDirectory(ExternalProgramOptions.this).setText(string);
                            }
                        } else {
                            ExternalProgramOptions.ra$tfRunInDirectory(ExternalProgramOptions.this).setText("");
                        }
                    }
                    finally {
                        ExternalProgramOptions.wa$_isAutoSettingRunDirectory(ExternalProgramOptions.this, false);
                    }
                }
                boolean bl = ExternalProgramOptions.this.isComplete();
                ExternalProgramOptions.this.firePropertyChange("isComplete", bl ^ true, bl);
            }
            catch (RuntimeException runtimeException) {
                ExceptionDialog.showExceptionDialog((Component)ExternalProgramOptions.this.getGUI(), (Throwable)runtimeException);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.doIt();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.doIt();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.doIt();
        }
    }

    public final class 2
    implements DocumentListener {
        private void doIt() {
            if (!ExternalProgramOptions.ra$_isAutoSettingRunDirectory(ExternalProgramOptions.this)) {
                ExternalProgramOptions.wa$_isRunDirectoryModified(ExternalProgramOptions.this, true);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.doIt();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.doIt();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.doIt();
        }
    }

    private class ActionDispatcher
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JButton jButton = (JButton)actionEvent.getSource();
                if (ExternalProgramOptions.ra$btnBrowseExecutable(ExternalProgramOptions.this) == jButton) {
                    ExternalProgramOptions.mav$doBrowseExecutable(ExternalProgramOptions.this);
                } else if (ExternalProgramOptions.ra$btnBrowseDirectory(ExternalProgramOptions.this) == jButton) {
                    ExternalProgramOptions.mav$doBrowseDirectory(ExternalProgramOptions.this);
                } else if (ExternalProgramOptions.ra$btnBrowseArguments(ExternalProgramOptions.this) == jButton) {
                    ExternalProgramOptions.mav$doBrowseArguments(ExternalProgramOptions.this);
                } else if (ExternalProgramOptions.ra$btnDirectoryMacros(ExternalProgramOptions.this) == jButton) {
                    ExternalProgramOptions.mav$doBrowseDirectoryMacros(ExternalProgramOptions.this);
                }
            }
            catch (RuntimeException runtimeException) {
                ExceptionDialog.showExceptionDialog((Component)ExternalProgramOptions.this, (Throwable)runtimeException);
            }
        }

        private ActionDispatcher() {
        }

        ActionDispatcher(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    public final class 1
    implements DocumentListener {
        private void doUpdate() {
            try {
                ExternalProgramOptions.mav$updateCommandSample(ExternalProgramOptions.this);
            }
            catch (RuntimeException runtimeException) {
                ExceptionDialog.showExceptionDialog((Component)ExternalProgramOptions.this, (Throwable)runtimeException);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.doUpdate();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.doUpdate();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.doUpdate();
        }
    }
}

