/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.externaltools.program;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.model.NodeUtil;
import oracle.ide.runner.RunProcessListener;
import oracle.ide.runner.SimpleProcess;
import oracle.jdeveloper.externaltools.ExternalTool;
import oracle.jdeveloper.externaltools.ExternalToolManager;
import oracle.jdeveloper.externaltools.ToolRunException;
import oracle.jdevimpl.externaltools.program.ExternalProgramType;
import oracle.jdevimpl.resource.ExternalToolsArb;

public class ExternalProgramTool
extends ExternalTool {
    private String m_command;
    private String m_workingDirectory;
    private String m_arguments;
    private static Icon s_defaultIcon;

    public Icon getIconWhenRequired() {
        if (s_defaultIcon == null) {
            s_defaultIcon = new ImageIcon(ExternalProgramTool.class.getResource("programtool.gif"));
        }
        return s_defaultIcon;
    }

    public String getExecutable() {
        return this.m_command;
    }

    public void setExecutable(String string) {
        this.m_command = string;
    }

    public String getRunDirectory() {
        return this.m_workingDirectory;
    }

    public void setRunDirectory(String string) {
        this.m_workingDirectory = string;
    }

    public String getArguments() {
        return this.m_arguments;
    }

    public void setArguments(String string) {
        this.m_arguments = string;
    }

    private static String[] buildCmdArray(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\" ", true);
        boolean bl = false;
        StringBuffer stringBuffer = null;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if ("\"".equals(string4)) {
                if (bl) {
                    bl = false;
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = null;
                    continue;
                }
                bl = true;
                stringBuffer = new StringBuffer();
                continue;
            }
            if (" ".equals(string4)) {
                if (bl) {
                    stringBuffer.append(string4);
                    continue;
                }
                if (string3 == null) continue;
                arrayList.add(string3);
                string3 = null;
                continue;
            }
            if (bl) {
                stringBuffer.append(string4);
                continue;
            }
            string3 = string4;
        }
        if (string3 != null) {
            arrayList.add(string3);
        }
        if (bl && stringBuffer != null) {
            arrayList.add(stringBuffer.toString());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public void run(ExternalToolManager externalToolManager, Context context) throws ToolRunException {
        String string = externalToolManager.getMacroRegistry().expand(this.m_command, context);
        String string2 = externalToolManager.getMacroRegistry().expand(this.m_workingDirectory, context);
        String string3 = externalToolManager.getMacroRegistry().expand(this.m_arguments, context);
        SimpleProcess simpleProcess = new SimpleProcess(ExternalProgramTool.buildCmdArray(string, string3));
        simpleProcess.setLabel(StringUtils.stripMnemonic((String)super.getCaption()));
        if (string2 != null && string2.trim().length() != 0) {
            boolean bl;
            File file = new File(string2);
            if (!(file.exists() && file.isDirectory() || (bl = MessageDialog.confirm((Component)context.getView().getGUI(), (Object)ExternalToolsArb.getString(78), (String)ExternalToolsArb.getString(79), null)))) {
                return;
            }
            simpleProcess.setWorkingDirectory(file);
        }
        if (this.getReloadBuffers()) {
            HashMap hashMap = new HashMap();
            NodeUtil.storeAllTimestamps(hashMap);
            simpleProcess.setRunProcessListener((RunProcessListener)new 1(this, hashMap, simpleProcess));
        }
        simpleProcess.exec();
        if (simpleProcess.getExecException() != null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)ExternalToolsArb.format(81, this.getCaption()), (String)ExternalToolsArb.getString(80), null);
        }
    }

    public Object copyTo(Object object) {
        ExternalProgramTool externalProgramTool = object != null ? (ExternalProgramTool)object : new ExternalProgramTool();
        this.copyToImpl(externalProgramTool);
        return externalProgramTool;
    }

    public void copyToImpl(ExternalTool externalTool) {
        super.copyToImpl(externalTool);
        ExternalProgramTool externalProgramTool = (ExternalProgramTool)externalTool;
        externalProgramTool.setExecutable(this.getExecutable());
        externalProgramTool.setRunDirectory(this.getRunDirectory());
        externalProgramTool.setArguments(this.getArguments());
    }

    public Class getType() {
        return ExternalProgramType.class;
    }

    public final class 1
    implements RunProcessListener {
        private final /* synthetic */ HashMap v$timestampMap;
        private final /* synthetic */ SimpleProcess v$sp;
        final /* synthetic */ ExternalProgramTool this$0;

        public void processFinished(int n) {
            NodeUtil.reloadBuffers((Map)this.v$timestampMap);
            this.v$sp.setRunProcessListener(null);
        }

        public 1(ExternalProgramTool externalProgramTool, HashMap hashMap, SimpleProcess simpleProcess) {
            this.v$sp = simpleProcess;
            this.v$timestampMap = hashMap;
            this.this$0 = externalProgramTool;
        }
    }
}

