/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.externaltools.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Displayable;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.SimpleListModel;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.externaltools.ExternalToolType;
import oracle.jdeveloper.externaltools.macro.MacroExpander;
import oracle.jdeveloper.externaltools.macro.MacroPicker;
import oracle.jdeveloper.externaltools.macro.MacroRegistry;
import oracle.jdeveloper.externaltools.macro.Parameter;
import oracle.jdeveloper.externaltools.macro.ParameterizedMacro;
import oracle.jdevimpl.resource.ExternalToolsArb;

public final class MacroPickerImpl
extends JPanel
implements MacroPicker {
    private static final String COMPLETE = "complete";
    private GridBagLayout layout;
    private JLabel lblHint;
    private JLabel lblMacro;
    private JScrollPane spMacro;
    private JLabel lblDescription;
    private JScrollPane spDescription;
    private JLabel lblSample;
    private JScrollPane spSample;
    private JList lstMacro;
    private JTextArea taDescription;
    private JTextArea taSample;
    private JPanel panParameters;
    private DocumentListener paramDocListener;

    void $init$() {
        this.layout = new GridBagLayout();
        this.lblHint = new JLabel();
        this.lblMacro = new JLabel();
        this.spMacro = new JScrollPane();
        this.lblDescription = new JLabel();
        this.spDescription = new JScrollPane();
        this.lblSample = new JLabel();
        this.spSample = new JScrollPane();
        this.lstMacro = new JList();
        this.taDescription = new JTextArea();
        this.taSample = new JTextArea();
        this.panParameters = new JPanel();
        this.paramDocListener = new 4();
    }

    public MacroPickerImpl() {
        this.$init$();
        this.jbInit();
        this.addListSelectionListener(new DetailUpdateListener(null));
    }

    private void updateSample() {
        MacroExpander macroExpander = this.getSelectedMacro();
        String string = macroExpander == null ? "" : macroExpander.getSampleExpansion(Ide.getMainWindow().getLastActiveView().getContext());
        this.taSample.setText(string);
        this.taSample.setCaretPosition(0);
    }

    private void updateDetails() {
        MacroExpander macroExpander = this.getSelectedMacroImpl();
        String string = macroExpander == null ? "" : macroExpander.getLongLabel();
        this.taDescription.setText(string);
        this.taDescription.setCaretPosition(0);
        this.lstMacro.requestFocus();
        if (macroExpander instanceof ParameterizedMacro) {
            this.disposeParameterPanel();
            ParameterizedMacro parameterizedMacro = (ParameterizedMacro)macroExpander;
            for (Parameter parameter : parameterizedMacro.getSupportedParameters()) {
                ParameterPanel parameterPanel = new ParameterPanel(parameterizedMacro, parameter, null);
                this.panParameters.add(parameterPanel);
            }
            this.panParameters.setVisible(true);
            this.packParentDialog();
        } else if (this.panParameters.isVisible()) {
            this.panParameters.setVisible(false);
            this.packParentDialog();
        }
        this.updateSample();
        this.fireCompleteChanged();
    }

    private void disposeParameterPanel() {
        int n = 0;
        while (n < this.panParameters.getComponentCount()) {
            ParameterPanel parameterPanel = (ParameterPanel)this.panParameters.getComponent(n);
            parameterPanel.dispose();
            ++n;
        }
        this.panParameters.removeAll();
    }

    private void fireCompleteChanged() {
        boolean bl = this.isComplete();
        this.firePropertyChange(COMPLETE, bl ^ true, bl);
    }

    private void packParentDialog() {
        this.validate();
        Dialog dialog = this.getDialogParent(this);
        if (dialog != null) {
            dialog.pack();
        }
    }

    public boolean isComplete() {
        return this.getSelectedMacroImpl() != null && this.areAllParametersSet();
    }

    private boolean areAllParametersSet() {
        if (!this.panParameters.isVisible()) {
            return true;
        }
        int n = 0;
        while (n < this.panParameters.getComponentCount()) {
            ParameterPanel parameterPanel = (ParameterPanel)this.panParameters.getComponent(n);
            if (!parameterPanel.hasValue()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private Dialog getDialogParent(Component component) {
        if (component == null || component instanceof Dialog) {
            return (Dialog)component;
        }
        return this.getDialogParent(component.getParent());
    }

    private SimpleListModel getListModel() {
        return (SimpleListModel)this.lstMacro.getModel();
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.lstMacro.addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.lstMacro.removeListSelectionListener(listSelectionListener);
    }

    public MacroExpander runDialog(Component component) {
        JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)component, (String)ExternalToolsArb.getString(90), (int)7);
        jEWTDialog.setResizable(true);
        jEWTDialog.setContent((Component)this);
        jEWTDialog.setOKButtonEnabled(this.isComplete());
        3 var3_3 = new 3(this, jEWTDialog);
        this.addPropertyChangeListener(var3_3);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_idedexternaltoolsmacros_html");
        try {
            if (jEWTDialog.runDialog()) {
                MacroExpander macroExpander = this.getSelectedMacro();
                this.removePropertyChangeListener(var3_3);
                jEWTDialog.dispose();
                this.disposeParameterPanel();
                return macroExpander;
            }
            MacroExpander macroExpander = null;
            this.removePropertyChangeListener(var3_3);
            jEWTDialog.dispose();
            this.disposeParameterPanel();
            return macroExpander;
        }
        catch (Throwable throwable) {
            this.removePropertyChangeListener(var3_3);
            jEWTDialog.dispose();
            this.disposeParameterPanel();
            throw throwable;
        }
    }

    public void populate(MacroRegistry macroRegistry, ExternalToolType externalToolType, boolean bl) {
        ArrayList<MacroExpander> arrayList = new ArrayList<MacroExpander>();
        Iterator iterator = macroRegistry.iterator();
        while (iterator.hasNext()) {
            MacroExpander macroExpander = (MacroExpander)iterator.next();
            if (externalToolType != null && !macroExpander.isAvailableForType(externalToolType)) continue;
            if (bl && macroExpander.isDirectoryMacro()) {
                arrayList.add(macroExpander);
                continue;
            }
            if (bl) continue;
            arrayList.add(macroExpander);
        }
        2 var7_7 = new 2();
        Collections.sort(arrayList, var7_7);
        this.lstMacro.setModel(new SimpleListModel(arrayList));
    }

    public Component getComponent() {
        return this;
    }

    public MacroExpander getSelectedMacro() {
        MacroExpander macroExpander = this.getSelectedMacroImpl();
        if (macroExpander instanceof ParameterizedMacro) {
            ParameterizedMacro parameterizedMacro = (ParameterizedMacro)macroExpander;
            int n = 0;
            while (n < this.panParameters.getComponentCount()) {
                ParameterPanel parameterPanel = (ParameterPanel)this.panParameters.getComponent(n);
                Parameter parameter = ParameterPanel.ra$_parameter(parameterPanel);
                parameterizedMacro.setValue(parameter, parameterPanel.getValue());
                ++n;
            }
        }
        return macroExpander;
    }

    private MacroExpander getSelectedMacroImpl() {
        return (MacroExpander)this.lstMacro.getSelectedValue();
    }

    private void jbInit() {
        this.setLayout(this.layout);
        ResourceUtils.resLabel((JLabel)this.lblMacro, (Component)this.lstMacro, (String)ExternalToolsArb.getString(87));
        ResourceUtils.resLabel((JLabel)this.lblDescription, (Component)this.taDescription, (String)ExternalToolsArb.getString(88));
        ResourceUtils.resLabel((JLabel)this.lblSample, (Component)this.taSample, (String)ExternalToolsArb.getString(89));
        this.lblHint.setText(ExternalToolsArb.getString(86));
        this.taDescription.setEditable(false);
        this.taDescription.setRows(3);
        this.taDescription.setOpaque(false);
        this.taDescription.setFont(this.lblHint.getFont());
        this.taDescription.setWrapStyleWord(true);
        this.taDescription.setLineWrap(true);
        this.taSample.setEditable(false);
        this.taSample.setRows(3);
        this.taSample.setOpaque(false);
        this.taSample.setLineWrap(true);
        this.lstMacro.setSelectionMode(0);
        this.lstMacro.setCellRenderer(new 1());
        this.add((Component)this.lblHint, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add((Component)this.lblMacro, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.spMacro.getViewport().add((Component)this.lstMacro, null);
        this.add((Component)this.spMacro, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.panParameters, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lblDescription, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.spDescription.getViewport().add((Component)this.taDescription, null);
        this.add((Component)this.spDescription, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lblSample, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.spSample.getViewport().add((Component)this.taSample, null);
        this.add((Component)this.spSample, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panParameters.setLayout(new BoxLayout(this.panParameters, 1));
        this.panParameters.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
    }

    static void mav$fireCompleteChanged(MacroPickerImpl macroPickerImpl) {
        macroPickerImpl.fireCompleteChanged();
    }

    static void mav$updateSample(MacroPickerImpl macroPickerImpl) {
        macroPickerImpl.updateSample();
    }

    static void mav$updateDetails(MacroPickerImpl macroPickerImpl) {
        macroPickerImpl.updateDetails();
    }

    static DocumentListener ra$paramDocListener(MacroPickerImpl macroPickerImpl) {
        return macroPickerImpl.paramDocListener;
    }

    public final class 4
    implements DocumentListener {
        private void update() {
            MacroPickerImpl.mav$fireCompleteChanged(MacroPickerImpl.this);
            MacroPickerImpl.mav$updateSample(MacroPickerImpl.this);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }
    }

    public final class 3
    implements PropertyChangeListener {
        private final /* synthetic */ JEWTDialog v$jd;
        final /* synthetic */ MacroPickerImpl this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (MacroPickerImpl.COMPLETE.equals(propertyChangeEvent.getPropertyName())) {
                this.v$jd.setOKButtonEnabled(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
            }
        }

        public 3(MacroPickerImpl macroPickerImpl, JEWTDialog jEWTDialog) {
            this.v$jd = jEWTDialog;
            this.this$0 = macroPickerImpl;
        }
    }

    public final class 2
    implements Comparator {
        Collator _collator;

        void $init$() {
            this._collator = Collator.getInstance();
        }

        public int compare(Object object, Object object2) {
            if (object instanceof MacroExpander && object2 instanceof MacroExpander) {
                String string = ((MacroExpander)object).getShortLabel();
                String string2 = ((MacroExpander)object2).getShortLabel();
                return this._collator.compare(string, string2);
            }
            return 0;
        }

        public 2() {
            this.$init$();
        }
    }

    public final class 1
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof Displayable) {
                super.setText(((Displayable)object).getShortLabel());
            }
            return component;
        }
    }

    private class DetailUpdateListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            try {
                MacroPickerImpl.mav$updateDetails(MacroPickerImpl.this);
            }
            catch (RuntimeException runtimeException) {
                ExceptionDialog.showExceptionDialog((Component)MacroPickerImpl.this, (Throwable)runtimeException);
            }
        }

        private DetailUpdateListener() {
        }

        DetailUpdateListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ParameterPanel
    extends JPanel {
        private final ParameterizedMacro _macro;
        private final Parameter _parameter;
        private final JLabel _label;
        private final JTextField _field;

        void $init$() {
            this._label = new JLabel();
            this._field = new JTextField();
        }

        private ParameterPanel(ParameterizedMacro parameterizedMacro, Parameter parameter) {
            this.$init$();
            this._macro = parameterizedMacro;
            this._parameter = parameter;
            String string = this._parameter.getLabel();
            if (!string.endsWith(":")) {
                string = string + ':';
            }
            int n = StringUtils.getMnemonicKeyCode((String)string);
            int n2 = StringUtils.getMnemonicIndex((String)string);
            string = StringUtils.stripMnemonic((String)string);
            this._label.setText(string);
            if (n >= 0) {
                this._label.setDisplayedMnemonic(n);
                this._label.setDisplayedMnemonicIndex(n2);
            }
            this._label.setLabelFor(this._field);
            this.setLayout(new BorderLayout(0, 5));
            this.add((Component)this._label, "North");
            this.add((Component)this._field, "Center");
            this._field.getDocument().addDocumentListener(MacroPickerImpl.ra$paramDocListener(MacroPickerImpl.this));
        }

        public boolean hasValue() {
            return this._field.getText().trim().length() > 0;
        }

        public String getValue() {
            return this._field.getText();
        }

        public void dispose() {
            this._field.getDocument().removeDocumentListener(MacroPickerImpl.ra$paramDocListener(MacroPickerImpl.this));
        }

        static Parameter ra$_parameter(ParameterPanel parameterPanel) {
            return parameterPanel._parameter;
        }

        ParameterPanel(ParameterizedMacro parameterizedMacro, Parameter parameter, 1 var4_4) {
            this(parameterizedMacro, parameter);
        }

        public final class 1 {
        }
    }
}

