/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.externaltools.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.model.ImageNode;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.externaltools.ExternalTool;
import oracle.jdeveloper.externaltools.ExternalToolOptionsEnvironment;
import oracle.jdeveloper.externaltools.ExternalToolOptionsPage;
import oracle.jdevimpl.resource.ExternalToolsArb;

public class ToolDisplayPanel
extends JPanel
implements ExternalToolOptionsPage {
    private static final int MAX_CAPTION = 70;
    private static final int STD_ICON_WIDTH = 16;
    private static final int STD_ICON_HEIGHT = 16;
    private GridBagLayout gridBagLayout1;
    private JLabel m_hintText;
    private JLabel m_labCaption;
    private JTextField m_tfCaption;
    private JLabel m_labCaptionHint;
    private JLabel m_labToolTip;
    private JTextField m_tfToolTip;
    private JLabel m_lblIconLocation;
    private JTextField m_tfIconLocation;
    private JButton m_btnBrowse;
    private JButton m_defaultIconButton;
    private JLabel m_labPreviewLabel;
    private JLabel m_labPreview;
    private ExternalToolOptionsEnvironment m_env;

    void $init$() {
        this.gridBagLayout1 = new GridBagLayout();
        this.m_hintText = new JLabel();
        this.m_labCaption = new JLabel();
        this.m_tfCaption = new JTextField();
        this.m_labCaptionHint = new JLabel();
        this.m_labToolTip = new JLabel();
        this.m_tfToolTip = new JTextField();
        this.m_lblIconLocation = new JLabel();
        this.m_tfIconLocation = new FileField();
        this.m_btnBrowse = new JButton();
        this.m_defaultIconButton = new JButton();
        this.m_labPreviewLabel = new JLabel();
        this.m_labPreview = new JLabel();
    }

    public ToolDisplayPanel() {
        this.$init$();
        this.jbInit();
        this.m_defaultIconButton.addActionListener(new 4());
        this.m_btnBrowse.addActionListener(new 3());
        2 var1_1 = new 2();
        this.m_tfCaption.getDocument().addDocumentListener(var1_1);
        this.m_tfIconLocation.getDocument().addDocumentListener(new 1());
    }

    public String getHelpTopicID() {
        return "f1_idedexternaltools3_html";
    }

    private void updatePreviewIcon() {
        try {
            URL uRL;
            this.m_labPreview.setIcon(IdeIcons.getIcon((int)0));
            String string = this.m_tfIconLocation.getText();
            if (string.trim().length() != 0 && (uRL = URLFactory.newURL((String)string)) != null) {
                if ("ide.fileicon".equals(uRL.getProtocol())) {
                    String string2 = URLFileSystem.getPath((URL)uRL);
                    File file = new File(string2);
                    if (file != null && file.exists()) {
                        this.m_labPreview.setIcon(FileSystemView.getFileSystemView().getSystemIcon(file));
                    }
                } else {
                    ImageIcon imageIcon = new ImageIcon(uRL);
                    if (imageIcon != null && imageIcon.getImageLoadStatus() == 8) {
                        this.m_labPreview.setIcon(imageIcon);
                    }
                }
            }
        }
        catch (RuntimeException runtimeException) {
            ExceptionDialog.showExceptionDialog((Component)this, (Throwable)runtimeException);
        }
    }

    private void updatePreviewText() {
        try {
            this.m_labPreview.setText(StringUtils.stripMnemonic((String)this.m_tfCaption.getText()));
            int n = StringUtils.getMnemonicKeyCode((String)this.m_tfCaption.getText());
            this.m_labPreview.setDisplayedMnemonic(n);
        }
        catch (RuntimeException runtimeException) {
            ExceptionDialog.showExceptionDialog((Component)this, (Throwable)runtimeException);
        }
    }

    public Component getInitialFocus() {
        return this.m_tfCaption;
    }

    public void saveOptions(ExternalTool externalTool, boolean bl) {
        externalTool.setToolTipText(this.m_tfToolTip.getText().trim().length() == 0 ? null : this.m_tfToolTip.getText());
        String string = this.m_tfIconLocation.getText();
        if (string.trim().length() == 0) {
            externalTool.setIconURL(null);
        } else {
            externalTool.setIconURL(URLFactory.newURL((String)string));
        }
        externalTool.setCaption(this.m_tfCaption.getText());
    }

    public void loadOptions(ExternalTool externalTool, boolean bl) {
        if (externalTool == null) {
            this.m_tfCaption.setText("");
            this.m_tfToolTip.setText("");
            this.m_tfIconLocation.setText("");
            this.m_labPreview.setText(" ");
            this.m_labPreview.setIcon(null);
            this.m_labPreview.setDisplayedMnemonic('\u0000');
        } else {
            this.m_tfCaption.setText(externalTool.getCaption());
            this.m_tfToolTip.setText(externalTool.getToolTipText() == null ? "" : externalTool.getToolTipText());
            URL uRL = externalTool.getIconURL();
            if (uRL != null) {
                if ("file".equals(uRL.getProtocol())) {
                    this.m_tfIconLocation.setText(URLFileSystem.getPlatformPathName((URL)uRL));
                } else {
                    this.m_tfIconLocation.setText(uRL.toString());
                }
            } else {
                uRL = this.m_env.getType().getDefaultIconURL(externalTool);
                this.m_tfIconLocation.setText(uRL.toString());
            }
            this.updatePreviewIcon();
            this.updatePreviewText();
        }
    }

    public boolean validateOptions() {
        URL uRL = URLFactory.newURL((String)this.m_tfIconLocation.getText());
        if (uRL != null) {
            if ("ide.fileicon".equals(uRL.getProtocol())) {
                String string = uRL.getPath();
                File file = new File(string);
                if (!file.exists()) {
                    this.m_tfIconLocation.requestFocus();
                    this.m_tfIconLocation.selectAll();
                    MessageDialog.error((Component)this, (Object)ExternalToolsArb.getString(123), (String)ExternalToolsArb.getString(122), null);
                    return false;
                }
                return true;
            }
            ImageIcon imageIcon = new ImageIcon(uRL);
            if (imageIcon == null || imageIcon.getImageLoadStatus() != 8) {
                this.m_tfIconLocation.requestFocus();
                this.m_tfIconLocation.selectAll();
                MessageDialog.error((Component)this, (Object)ExternalToolsArb.getString(123), (String)ExternalToolsArb.getString(122), null);
                return false;
            }
            if (imageIcon.getIconWidth() > 16 || imageIcon.getIconHeight() > 16) {
                this.m_tfIconLocation.requestFocus();
                this.m_tfIconLocation.selectAll();
                MessageDialog.error((Component)this, (Object)ExternalToolsArb.format(124, String.valueOf(16), String.valueOf(16)), (String)ExternalToolsArb.getString(125), null);
                return false;
            }
        }
        return true;
    }

    private void doBrowseIcon() {
        URL uRL = this.m_tfIconLocation.getText().trim().length() == 0 ? URLFactory.newFileURL((String)Ide.getHomeDirectory()) : URLFactory.newFileURL((String)this.m_tfIconLocation.getText());
        URLChooser uRLChooser = URLFileSystem.exists((URL)uRL) ? DialogUtil.newURLChooser((URL)uRL) : DialogUtil.newURLChooser();
        uRLChooser.setSelectionMode(0);
        URLFilter uRLFilter = ImageNode.getImageURLFilter();
        uRLChooser.setURLFilter(uRLFilter);
        if (uRLChooser.showOpenDialog((Component)this, ExternalToolsArb.getString(126)) == 0) {
            URL uRL2 = uRLChooser.getSelectedURL();
            if ("file".equals(uRL2.getProtocol())) {
                this.m_tfIconLocation.setText(URLFileSystem.getPlatformPathName((URL)uRL2));
            } else {
                this.m_tfIconLocation.setText(uRL2.toString());
            }
        }
    }

    private void jbInit() {
        this.setLayout(this.gridBagLayout1);
        this.m_hintText.setText("<html>" + ExternalToolsArb.getString(114) + "</html>");
        ResourceUtils.resLabel((JLabel)this.m_labCaption, (Component)this.m_tfCaption, (String)ExternalToolsArb.getString(115));
        this.m_labCaptionHint.setText(ExternalToolsArb.getString(116));
        ResourceUtils.resLabel((JLabel)this.m_labToolTip, (Component)this.m_tfToolTip, (String)ExternalToolsArb.getString(117));
        ResourceUtils.resLabel((JLabel)this.m_lblIconLocation, (Component)this.m_tfIconLocation, (String)ExternalToolsArb.getString(118));
        ResourceUtils.resButton((AbstractButton)this.m_btnBrowse, (String)ExternalToolsArb.getString(119));
        ResourceUtils.resButton((AbstractButton)this.m_defaultIconButton, (String)ExternalToolsArb.getString(120));
        ResourceUtils.resLabel((JLabel)this.m_labPreviewLabel, (Component)this.m_labPreview, (String)ExternalToolsArb.getString(121));
        this.m_labPreview.setBorder(BorderFactory.createCompoundBorder(this.m_tfCaption.getBorder(), BorderFactory.createEmptyBorder(1, 0, 1, 0)));
        this.m_tfCaption.setDocument(new LimitedLengthDocument(70));
        this.add((Component)this.m_hintText, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add((Component)this.m_labCaption, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_tfCaption, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_labCaptionHint, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 5, 0), 0, 0));
        this.add((Component)this.m_labToolTip, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_tfToolTip, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_lblIconLocation, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_tfIconLocation, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_btnBrowse, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add((Component)this.m_defaultIconButton, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.m_labPreviewLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 5, 0), 0, 0));
        this.add((Component)this.m_labPreview, new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public String getPageName() {
        return ExternalToolsArb.getString(113);
    }

    public boolean isComplete() {
        return this.m_tfCaption.getText().trim().length() > 0;
    }

    public JComponent getGUI() {
        return this;
    }

    public void setEnvironment(ExternalToolOptionsEnvironment externalToolOptionsEnvironment) {
        this.m_env = externalToolOptionsEnvironment;
    }

    static ExternalToolOptionsEnvironment ra$m_env(ToolDisplayPanel toolDisplayPanel) {
        return toolDisplayPanel.m_env;
    }

    static JTextField ra$m_tfIconLocation(ToolDisplayPanel toolDisplayPanel) {
        return toolDisplayPanel.m_tfIconLocation;
    }

    static void mav$doBrowseIcon(ToolDisplayPanel toolDisplayPanel) {
        toolDisplayPanel.doBrowseIcon();
    }

    static void mav$updatePreviewText(ToolDisplayPanel toolDisplayPanel) {
        toolDisplayPanel.updatePreviewText();
    }

    static void mav$updatePreviewIcon(ToolDisplayPanel toolDisplayPanel) {
        toolDisplayPanel.updatePreviewIcon();
    }

    public final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                URL uRL = ToolDisplayPanel.ra$m_env(ToolDisplayPanel.this).getType().getDefaultIconURL(ToolDisplayPanel.ra$m_env(ToolDisplayPanel.this).getTool());
                if ("file".equals(uRL.getProtocol())) {
                    ToolDisplayPanel.ra$m_tfIconLocation(ToolDisplayPanel.this).setText(URLFileSystem.getPlatformPathName((URL)uRL));
                } else {
                    ToolDisplayPanel.ra$m_tfIconLocation(ToolDisplayPanel.this).setText(uRL.toString());
                }
            }
            catch (RuntimeException runtimeException) {
                ExceptionDialog.showExceptionDialog((Component)ToolDisplayPanel.this, (Throwable)runtimeException);
            }
        }
    }

    public final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                ToolDisplayPanel.mav$doBrowseIcon(ToolDisplayPanel.this);
            }
            catch (RuntimeException runtimeException) {
                ExceptionDialog.showExceptionDialog((Component)ToolDisplayPanel.this, (Throwable)runtimeException);
            }
        }
    }

    public final class 2
    implements DocumentListener {
        protected void doIt() {
            try {
                ToolDisplayPanel.mav$updatePreviewText(ToolDisplayPanel.this);
                boolean bl = ToolDisplayPanel.this.isComplete();
                ToolDisplayPanel.this.firePropertyChange("isComplete", bl ^ true, bl);
            }
            catch (RuntimeException runtimeException) {
                ExceptionDialog.showExceptionDialog((Component)ToolDisplayPanel.this.getGUI(), (Throwable)runtimeException);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.doIt();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.doIt();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.doIt();
        }
    }

    public final class 1
    implements DocumentListener {
        public void changedUpdate(DocumentEvent documentEvent) {
            ToolDisplayPanel.mav$updatePreviewIcon(ToolDisplayPanel.this);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            ToolDisplayPanel.mav$updatePreviewIcon(ToolDisplayPanel.this);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            ToolDisplayPanel.mav$updatePreviewIcon(ToolDisplayPanel.this);
        }
    }

    private class LimitedLengthDocument
    extends PlainDocument {
        private int m_maxLength;

        LimitedLengthDocument(int n) {
            this.m_maxLength = n;
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                string = "";
            }
            if (this.getLength() + string.length() <= this.m_maxLength) {
                super.insertString(n, string, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

