/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.externaltools.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.help.HelpSystem;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.SimpleListModel;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.externaltools.ExternalTool;
import oracle.jdeveloper.externaltools.ExternalToolManager;
import oracle.jdeveloper.externaltools.ExternalToolScanner;
import oracle.jdevimpl.externaltools.Util;
import oracle.jdevimpl.externaltools.ui.ExternalToolsWizard;
import oracle.jdevimpl.resource.ExternalToolsArb;

public final class ToolListPanel
extends JPanel {
    private GridBagLayout gbl;
    private JLabel cmdLabel;
    private JScrollPane cmdScrollPane;
    private JList cmdList;
    private JButton btnMoveUp;
    private JButton btnMoveDown;
    private JButton btnRemoveCommand;
    private JButton btnAddCommand;
    private JButton btnEditCommand;
    private JButton btnFindTools;
    private ButtonBar bbAddRemove;
    private ButtonBar bbMoveUpDown;
    private ExternalToolManager m_manager;
    private boolean m_dialogChanges;
    public static final String COMMIT_PENDING_PROPERTY = "commitPending";

    void $init$() {
        this.gbl = new GridBagLayout();
        this.cmdLabel = new JLabel();
        this.cmdScrollPane = new JScrollPane();
        this.cmdList = new JList();
        this.btnMoveUp = new JButton();
        this.btnMoveDown = new JButton();
        this.btnRemoveCommand = new JButton();
        this.btnAddCommand = new JButton();
        this.btnEditCommand = new JButton();
        this.btnFindTools = new JButton();
        this.bbAddRemove = new ButtonBar();
        this.bbMoveUpDown = new ButtonBar();
        this.m_dialogChanges = false;
    }

    public ToolListPanel() {
        this.$init$();
        this.jbInit();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_idedexternaltools_html");
        this.cmdList.addListSelectionListener(new 7());
        this.cmdList.setCellRenderer(new ListRenderer(null));
        this.cmdList.addMouseListener(new 6());
        this.cmdList.addKeyListener(new 5());
    }

    private void fireCommitPending() {
        if (!this.m_dialogChanges) {
            this.m_dialogChanges = true;
            super.firePropertyChange(COMMIT_PENDING_PROPERTY, false, true);
        }
    }

    public boolean isCommitPending() {
        return this.m_dialogChanges;
    }

    public void runDialog(Component component, Runnable runnable) {
        this.btnFindTools.setVisible(false);
        for (ExternalToolScanner externalToolScanner : this.m_manager.getScanners()) {
            if (!externalToolScanner.canScan()) continue;
            this.btnFindTools.setVisible(true);
            break;
        }
        JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)component, (String)ExternalToolsArb.getString(97), (int)7);
        jEWTDialog.setResizable(true);
        jEWTDialog.setOKButtonEnabled(this.isCommitPending());
        jEWTDialog.setContent((Component)this);
        jEWTDialog.pack();
        Dimension dimension = jEWTDialog.getPreferredSize();
        jEWTDialog.setPreferredSize(new Dimension(Math.max(500, dimension.width), Math.max(350, dimension.height)));
        4 var7_7 = new 4(this, jEWTDialog);
        this.addPropertyChangeListener(COMMIT_PENDING_PROPERTY, var7_7);
        3 var8_8 = null;
        if (runnable != null) {
            var8_8 = new 3(this, runnable);
            jEWTDialog.addVetoableChangeListener((VetoableChangeListener)var8_8);
        }
        jEWTDialog.addWindowListener((WindowListener)new 2(this, jEWTDialog));
        jEWTDialog.runDialog();
        this.removePropertyChangeListener(COMMIT_PENDING_PROPERTY, var7_7);
        if (var8_8 != null) {
            jEWTDialog.removeVetoableChangeListener((VetoableChangeListener)var8_8);
        }
        jEWTDialog.dispose();
    }

    private void autoCheckToolScanners() {
        List list = this.getValidAutoScanners();
        if (!list.isEmpty()) {
            boolean bl = MessageDialog.confirm((Component)this, (Object)ExternalToolsArb.getString(156), (String)ExternalToolsArb.getString(155), null);
            try {
                if (bl) {
                    this.scanForTools(list);
                }
            }
            finally {
                this.disableAutoScan(list);
            }
        }
    }

    private void scanForTools(List list) {
        WaitCursor waitCursor = new WaitCursor((Component)this);
        waitCursor.attach((RootPaneContainer)((Object)SwingUtilities.getRoot(this)));
        waitCursor.show();
        1 var3_3 = new 1(this, list, waitCursor);
        Thread thread = new Thread((Runnable)var3_3, "External Tool Scanner");
        thread.start();
    }

    private void runDefaultToolsDialog(List list) {
        ((SimpleListModel)this.cmdList.getModel()).addElements(list.iterator());
        this.fireCommitPending();
        this.cmdList.requestFocus();
        if (list.size() > 0) {
            this.cmdList.setSelectionInterval(this.cmdList.getModel().getSize() - list.size(), this.cmdList.getModel().getSize() - 1);
        }
    }

    private List getValidAutoScanners() {
        ArrayList<ExternalToolScanner> arrayList = new ArrayList<ExternalToolScanner>();
        for (ExternalToolScanner externalToolScanner : this.m_manager.getScanners()) {
            if (!this.isAutoScanEnabled(externalToolScanner) || !externalToolScanner.canScan()) continue;
            arrayList.add(externalToolScanner);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private boolean isAutoScanEnabled(ExternalToolScanner externalToolScanner) {
        return Ide.getDTCache().getBoolean(this.getKey(externalToolScanner), true);
    }

    private void disableAutoScan(List list) {
        for (ExternalToolScanner externalToolScanner : list) {
            Ide.getDTCache().putBoolean(this.getKey(externalToolScanner), Boolean.FALSE);
        }
    }

    private String getKey(ExternalToolScanner externalToolScanner) {
        StringBuffer stringBuffer = new StringBuffer(31 + externalToolScanner.getId().length());
        stringBuffer.append("externaltools.scanners.");
        stringBuffer.append(externalToolScanner.getId());
        stringBuffer.append(".enabled");
        return stringBuffer.toString();
    }

    public List getTools() {
        ArrayList arrayList = new ArrayList(this.cmdList.getModel().getSize());
        int n = 0;
        while (n < this.cmdList.getModel().getSize()) {
            arrayList.add(this.cmdList.getModel().getElementAt(n));
            ++n;
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void setToolManager(ExternalToolManager externalToolManager) {
        this.m_manager = externalToolManager;
        Iterator iterator = this.m_manager.getAllExternalTools();
        while (iterator.hasNext()) {
            ExternalTool externalTool = (ExternalTool)iterator.next();
            ((SimpleListModel)this.cmdList.getModel()).addElement(externalTool.copyTo(null));
        }
        if (this.cmdList.getModel().getSize() > 0) {
            this.cmdList.setSelectedIndex(0);
        }
        this.commandListSelectionChanged();
    }

    private void jbInit() {
        Icon icon = IdeIcons.getIcon((int)15);
        Icon icon2 = IdeIcons.getIcon((int)16);
        this.bbAddRemove.setOrientation(0);
        this.bbAddRemove.setAlignment(4);
        this.bbMoveUpDown.setOrientation(1);
        this.bbMoveUpDown.setAlignment(0);
        ButtonListener buttonListener = new ButtonListener(null);
        this.setLayout(this.gbl);
        ResourceUtils.resLabel((JLabel)this.cmdLabel, (Component)this.cmdList, (String)ExternalToolsArb.getString(91));
        this.cmdScrollPane.setPreferredSize(new Dimension(0, 0));
        this.btnMoveUp.setIcon(icon);
        this.btnMoveUp.setMargin(new Insets(1, 1, 1, 1));
        this.btnMoveUp.addActionListener(buttonListener);
        this.btnMoveUp.setToolTipText(ExternalToolsArb.getString(92));
        this.btnMoveDown.setIcon(icon2);
        this.btnMoveDown.setMargin(new Insets(1, 1, 1, 1));
        this.btnMoveDown.addActionListener(buttonListener);
        this.btnMoveDown.setToolTipText(ExternalToolsArb.getString(93));
        ResourceUtils.resButton((AbstractButton)this.btnRemoveCommand, (String)ExternalToolsArb.getString(94));
        this.btnRemoveCommand.addActionListener(buttonListener);
        ResourceUtils.resButton((AbstractButton)this.btnAddCommand, (String)ExternalToolsArb.getString(95));
        this.btnAddCommand.addActionListener(buttonListener);
        ResourceUtils.resButton((AbstractButton)this.btnEditCommand, (String)ExternalToolsArb.getString(96));
        this.btnEditCommand.addActionListener(buttonListener);
        ResourceUtils.resButton((AbstractButton)this.btnFindTools, (String)ExternalToolsArb.getString(161));
        this.btnFindTools.addActionListener(buttonListener);
        this.bbAddRemove.add((Component)this.btnFindTools);
        this.bbAddRemove.add((Component)this.btnAddCommand);
        this.bbAddRemove.add((Component)this.btnEditCommand);
        this.bbAddRemove.add((Component)this.btnRemoveCommand);
        this.bbMoveUpDown.add((Component)this.btnMoveUp);
        this.bbMoveUpDown.add((Component)this.btnMoveDown);
        this.cmdList.setModel(new SimpleListModel());
        this.cmdList.setSelectionMode(2);
        this.add((Component)this.cmdLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.cmdScrollPane.getViewport().add((Component)this.cmdList, null);
        this.add((Component)this.cmdScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.bbMoveUpDown, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.bbAddRemove, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0));
    }

    private void commandListSelectionChanged() {
        if (this.cmdList.getSelectedIndices().length > 1) {
            this.btnRemoveCommand.setEnabled(true);
            this.btnEditCommand.setEnabled(false);
            this.btnMoveUp.setEnabled(false);
            this.btnMoveDown.setEnabled(false);
        } else {
            int n = this.cmdList.getSelectedIndex();
            this.btnMoveUp.setEnabled(n > 0);
            this.btnMoveDown.setEnabled(n != -1 && n < this.cmdList.getModel().getSize() - 1);
            if (n == -1) {
                this.btnRemoveCommand.setEnabled(false);
                this.btnEditCommand.setEnabled(false);
            } else {
                this.btnRemoveCommand.setEnabled(true);
                this.btnEditCommand.setEnabled(true);
            }
        }
    }

    private void doAddCommand() {
        ExternalTool externalTool = new ExternalToolsWizard().runCreateWizard(this.getTools(), this.m_manager, this, null);
        if (externalTool != null) {
            ((SimpleListModel)this.cmdList.getModel()).addElement((Object)externalTool);
            this.cmdList.setSelectedIndex(this.cmdList.getModel().getSize() - 1);
            this.cmdList.ensureIndexIsVisible(this.cmdList.getModel().getSize() - 1);
        }
        this.fireCommitPending();
    }

    private void doEditCommand() {
        ExternalTool externalTool;
        ExternalTool externalTool2 = (ExternalTool)this.cmdList.getSelectedValue();
        if (externalTool2 != null && (externalTool = new ExternalToolsWizard().runEditWizard(this.getTools(), this.m_manager, this, externalTool2)) != null) {
            int n = this.cmdList.getSelectedIndex();
            ToolListPanel.removeSelectedItems(this.cmdList);
            ((SimpleListModel)this.cmdList.getModel()).insertAt(n, (Object)externalTool);
            this.cmdList.setSelectedIndex(n);
            this.fireCommitPending();
        }
    }

    private void doRemoveCommand() {
        ToolListPanel.removeSelectedItems(this.cmdList);
        if (this.cmdList.getModel().getSize() == 0) {
            this.commandListSelectionChanged();
        }
        this.fireCommitPending();
    }

    static void removeSelectedItems(JList jList) {
        int[] nArray = jList.getSelectedIndices();
        boolean bl = nArray.length == 1;
        ((SimpleListModel)jList.getModel()).removeIndices(nArray);
        if (bl) {
            int n = nArray[0];
            if (n < jList.getModel().getSize()) {
                jList.setSelectedIndex(n);
            } else if (jList.getModel().getSize() > 0) {
                jList.setSelectedIndex(jList.getModel().getSize() - 1);
            }
        } else {
            jList.getSelectionModel().clearSelection();
        }
    }

    static void moveSelectionUp(JList jList) {
        int n = jList.getSelectedIndex();
        ((SimpleListModel)jList.getModel()).moveUp(n);
        jList.setSelectedIndex(n - 1);
    }

    static void moveSelectionDown(JList jList) {
        int n = jList.getSelectedIndex();
        ((SimpleListModel)jList.getModel()).moveDown(n);
        jList.setSelectedIndex(n + 1);
    }

    private void doMoveToolUp() {
        ToolListPanel.moveSelectionUp(this.cmdList);
        this.fireCommitPending();
    }

    private void doMoveToolDown() {
        ToolListPanel.moveSelectionDown(this.cmdList);
        this.fireCommitPending();
    }

    private void doFindTools() {
        this.scanForTools(this.m_manager.getScanners());
    }

    static void mav$commandListSelectionChanged(ToolListPanel toolListPanel) {
        toolListPanel.commandListSelectionChanged();
    }

    static JList ra$cmdList(ToolListPanel toolListPanel) {
        return toolListPanel.cmdList;
    }

    static void mav$doEditCommand(ToolListPanel toolListPanel) {
        toolListPanel.doEditCommand();
    }

    static void mav$doRemoveCommand(ToolListPanel toolListPanel) {
        toolListPanel.doRemoveCommand();
    }

    static void mav$autoCheckToolScanners(ToolListPanel toolListPanel) {
        toolListPanel.autoCheckToolScanners();
    }

    static void mav$runDefaultToolsDialog(ToolListPanel toolListPanel, List list) {
        toolListPanel.runDefaultToolsDialog(list);
    }

    static JButton ra$btnAddCommand(ToolListPanel toolListPanel) {
        return toolListPanel.btnAddCommand;
    }

    static void mav$doAddCommand(ToolListPanel toolListPanel) {
        toolListPanel.doAddCommand();
    }

    static JButton ra$btnRemoveCommand(ToolListPanel toolListPanel) {
        return toolListPanel.btnRemoveCommand;
    }

    static JButton ra$btnMoveUp(ToolListPanel toolListPanel) {
        return toolListPanel.btnMoveUp;
    }

    static void mav$doMoveToolUp(ToolListPanel toolListPanel) {
        toolListPanel.doMoveToolUp();
    }

    static JButton ra$btnMoveDown(ToolListPanel toolListPanel) {
        return toolListPanel.btnMoveDown;
    }

    static void mav$doMoveToolDown(ToolListPanel toolListPanel) {
        toolListPanel.doMoveToolDown();
    }

    static JButton ra$btnEditCommand(ToolListPanel toolListPanel) {
        return toolListPanel.btnEditCommand;
    }

    static JButton ra$btnFindTools(ToolListPanel toolListPanel) {
        return toolListPanel.btnFindTools;
    }

    static void mav$doFindTools(ToolListPanel toolListPanel) {
        toolListPanel.doFindTools();
    }

    public final class 7
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            try {
                ToolListPanel.mav$commandListSelectionChanged(ToolListPanel.this);
            }
            catch (RuntimeException runtimeException) {
                ExceptionDialog.showExceptionDialog((Component)ToolListPanel.this, (Throwable)runtimeException);
            }
        }
    }

    public final class 6
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1 && ToolListPanel.ra$cmdList(ToolListPanel.this).getSelectedValue() != null) {
                    ToolListPanel.mav$doEditCommand(ToolListPanel.this);
                }
            }
            catch (RuntimeException runtimeException) {
                ExceptionDialog.showExceptionDialog((Component)ToolListPanel.this, (Throwable)runtimeException);
            }
        }
    }

    public final class 5
    extends KeyAdapter {
        public void keyReleased(KeyEvent keyEvent) {
            try {
                if (keyEvent.getKeyCode() == 127 && ToolListPanel.ra$cmdList(ToolListPanel.this).getSelectedValue() != null) {
                    ToolListPanel.mav$doRemoveCommand(ToolListPanel.this);
                }
            }
            catch (RuntimeException runtimeException) {
                ExceptionDialog.showExceptionDialog((Component)ToolListPanel.this, (Throwable)runtimeException);
            }
        }
    }

    public final class 4
    implements PropertyChangeListener {
        private final /* synthetic */ JEWTDialog v$jd;
        final /* synthetic */ ToolListPanel this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.v$jd.setOKButtonEnabled(this.this$0.isCommitPending());
        }

        public 4(ToolListPanel toolListPanel, JEWTDialog jEWTDialog) {
            this.v$jd = jEWTDialog;
            this.this$0 = toolListPanel;
        }
    }

    public final class 3
    implements VetoableChangeListener {
        private final /* synthetic */ Runnable v$commitRunnable;
        final /* synthetic */ ToolListPanel this$0;

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                try {
                    this.v$commitRunnable.run();
                }
                catch (RuntimeException runtimeException) {
                    ExceptionDialog.showExceptionDialog((Component)this.this$0, (Throwable)runtimeException);
                    throw new PropertyVetoException("", propertyChangeEvent);
                }
            }
        }

        public 3(ToolListPanel toolListPanel, Runnable runnable) {
            this.v$commitRunnable = runnable;
            this.this$0 = toolListPanel;
        }
    }

    public final class 2
    extends WindowAdapter {
        private final /* synthetic */ JEWTDialog v$jd;
        final /* synthetic */ ToolListPanel this$0;

        public void windowOpened(WindowEvent windowEvent) {
            ToolListPanel.mav$autoCheckToolScanners(this.this$0);
            this.v$jd.removeWindowListener((WindowListener)this);
        }

        public 2(ToolListPanel toolListPanel, JEWTDialog jEWTDialog) {
            this.v$jd = jEWTDialog;
            this.this$0 = toolListPanel;
        }
    }

    public final class oracle.jdevimpl.externaltools.ui.ToolListPanel$1
    implements Runnable {
        private final /* synthetic */ List v$scanners;
        private final /* synthetic */ WaitCursor v$wc;
        final /* synthetic */ ToolListPanel this$0;

        public void run() {
            ArrayList<ExternalTool> arrayList = new ArrayList<ExternalTool>();
            try {
                try {
                    for (ExternalToolScanner externalToolScanner : this.v$scanners) {
                        ExternalTool[] externalToolArray = externalToolScanner.findTools(this.this$0.getTools());
                        int n = 0;
                        while (n < externalToolArray.length) {
                            arrayList.add(externalToolArray[n]);
                            ++n;
                        }
                    }
                }
                catch (RuntimeException runtimeException) {
                    ExceptionDialog.showExceptionDialog((Component)this.this$0, (Throwable)runtimeException);
                }
            }
            finally {
                SwingUtilities.invokeLater(new 3());
            }
            if (arrayList.size() == 0) {
                SwingUtilities.invokeLater(new 2());
            } else {
                SwingUtilities.invokeLater(new 1(this, arrayList));
            }
        }

        public oracle.jdevimpl.externaltools.ui.ToolListPanel$1(ToolListPanel toolListPanel, List list, WaitCursor waitCursor) {
            this.v$wc = waitCursor;
            this.v$scanners = list;
            this.this$0 = toolListPanel;
        }

        static WaitCursor ra$v$wc(oracle.jdevimpl.externaltools.ui.ToolListPanel$1 var0) {
            return var0.v$wc;
        }

        public final class 3
        implements Runnable {
            public void run() {
                oracle.jdevimpl.externaltools.ui.ToolListPanel$1.ra$v$wc(1.this).hide();
                oracle.jdevimpl.externaltools.ui.ToolListPanel$1.ra$v$wc(1.this).detach((RootPaneContainer)((Object)SwingUtilities.getRoot(1.this.this$0)));
            }
        }

        public final class 2
        implements Runnable {
            public void run() {
                MessageDialog.information((Component)1.this.this$0, (Object)ExternalToolsArb.getString(159), (String)ExternalToolsArb.getString(160), null);
            }
        }

        public final class 1
        implements Runnable {
            private final /* synthetic */ List v$tools;
            final /* synthetic */ oracle.jdevimpl.externaltools.ui.ToolListPanel$1 this$0;

            public void run() {
                ToolListPanel.mav$runDefaultToolsDialog(this.this$0.this$0, Collections.unmodifiableList(this.v$tools));
            }

            public 1(oracle.jdevimpl.externaltools.ui.ToolListPanel$1 var1_1, List list) {
                this.v$tools = list;
                this.this$0 = var1_1;
            }
        }
    }

    private class ButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JButton jButton = (JButton)actionEvent.getSource();
                if (ToolListPanel.ra$btnAddCommand(ToolListPanel.this) == jButton) {
                    ToolListPanel.mav$doAddCommand(ToolListPanel.this);
                } else if (ToolListPanel.ra$btnRemoveCommand(ToolListPanel.this) == jButton) {
                    ToolListPanel.mav$doRemoveCommand(ToolListPanel.this);
                } else if (ToolListPanel.ra$btnMoveUp(ToolListPanel.this) == jButton) {
                    ToolListPanel.mav$doMoveToolUp(ToolListPanel.this);
                } else if (ToolListPanel.ra$btnMoveDown(ToolListPanel.this) == jButton) {
                    ToolListPanel.mav$doMoveToolDown(ToolListPanel.this);
                } else if (ToolListPanel.ra$btnEditCommand(ToolListPanel.this) == jButton) {
                    ToolListPanel.mav$doEditCommand(ToolListPanel.this);
                } else if (ToolListPanel.ra$btnFindTools(ToolListPanel.this) == jButton) {
                    ToolListPanel.mav$doFindTools(ToolListPanel.this);
                }
                if (jButton.isEnabled()) {
                    jButton.requestFocus();
                }
            }
            catch (RuntimeException runtimeException) {
                ExceptionDialog.showExceptionDialog((Component)ToolListPanel.this, (Throwable)runtimeException);
            }
        }

        private ButtonListener() {
        }

        ButtonListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ListRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof ExternalTool) {
                ExternalTool externalTool = (ExternalTool)object;
                this.setIcon(Util.getToolIcon(externalTool, Context.newIdeContext()));
            }
            return component;
        }

        private ListRenderer() {
        }

        ListRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

