/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.externaltools.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import oracle.ide.model.Displayable;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.externaltools.ExternalTool;
import oracle.jdeveloper.externaltools.ExternalToolManager;
import oracle.jdeveloper.externaltools.ExternalToolOptionsEnvironment;
import oracle.jdeveloper.externaltools.ExternalToolOptionsPage;
import oracle.jdeveloper.externaltools.ExternalToolType;
import oracle.jdevimpl.externaltools.ui.ExternalToolsWizard;
import oracle.jdevimpl.resource.ExternalToolsArb;

public class ToolTypePanel
extends JPanel
implements ExternalToolOptionsPage {
    private GridBagLayout gridBagLayout1;
    private JLabel m_hintLabel;
    private JLabel m_toolTypeLabel;
    private JComboBox m_toolTypeCombo;
    private JLabel m_descriptionLabel;
    private boolean m_populated;
    private ExternalToolsWizard m_wizard;

    void $init$() {
        this.gridBagLayout1 = new GridBagLayout();
        this.m_hintLabel = new JLabel();
        this.m_toolTypeLabel = new JLabel();
        this.m_toolTypeCombo = new JComboBox();
        this.m_descriptionLabel = new JLabel();
        this.m_populated = false;
    }

    public ToolTypePanel() {
        this.$init$();
        this.jbInit();
        this.m_toolTypeCombo.addActionListener(EventHandler.create(ActionListener.class, this, "comboChanged"));
        this.m_toolTypeCombo.setRenderer(new DisplayableComboRenderer(null));
    }

    public Component getInitialFocus() {
        return this.m_toolTypeCombo;
    }

    public String getHelpTopicID() {
        return "f1_idedexternaltools1_html";
    }

    private void loadTypes() {
        try {
            InitialContext initialContext = new InitialContext();
            ExternalToolManager externalToolManager = (ExternalToolManager)initialContext.lookup("jdeveloper/external-tool-manager");
            Iterator iterator = externalToolManager.getRegisteredTypes();
            while (iterator.hasNext()) {
                ExternalToolType externalToolType = (ExternalToolType)iterator.next();
                this.m_toolTypeCombo.addItem(externalToolType);
            }
        }
        catch (NamingException namingException) {
            ExceptionDialog.showExceptionDialog((Component)this, (Throwable)namingException);
        }
    }

    public void comboChanged() {
        Object object = this.m_toolTypeCombo.getSelectedItem();
        if (object instanceof ExternalToolType) {
            this.m_descriptionLabel.setText("<html>" + ((ExternalToolType)object).getLongLabel() + "</html>");
        }
    }

    private void jbInit() {
        this.setLayout(this.gridBagLayout1);
        this.m_hintLabel.setText(ExternalToolsArb.getString(111));
        ResourceUtils.resLabel((JLabel)this.m_toolTypeLabel, (Component)this.m_toolTypeCombo, (String)ExternalToolsArb.getString(112));
        this.m_descriptionLabel.setVerticalAlignment(1);
        this.add((Component)this.m_hintLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add((Component)this.m_toolTypeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 12), 0, 0));
        this.add((Component)this.m_toolTypeCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_descriptionLabel, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setEnvironment(ExternalToolOptionsEnvironment externalToolOptionsEnvironment) {
        this.m_wizard = (ExternalToolsWizard)externalToolOptionsEnvironment;
    }

    public JComponent getGUI() {
        return this;
    }

    public String getPageName() {
        return ExternalToolsArb.getString(110);
    }

    public boolean isComplete() {
        return true;
    }

    public boolean validateOptions() {
        return true;
    }

    public void saveOptions(ExternalTool externalTool, boolean bl) {
        if (bl) {
            ExternalToolType externalToolType = (ExternalToolType)this.m_toolTypeCombo.getSelectedItem();
            if (externalTool == null || ExternalToolManager.getExternalToolManager().getType(externalTool) != externalToolType) {
                this.m_wizard.setType(externalToolType);
                this.m_wizard.setExternalTool(externalToolType.createExternalTool());
            }
        }
    }

    public void loadOptions(ExternalTool externalTool, boolean bl) {
        if (!this.m_populated) {
            this.loadTypes();
            this.m_populated = true;
        }
    }

    private class DisplayableComboRenderer
    extends BasicComboBoxRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof Displayable) {
                this.setText(((Displayable)object).getShortLabel());
                Icon icon = ((Displayable)object).getIcon();
                if (icon != null) {
                    this.setIcon(icon);
                }
            }
            return component;
        }

        private DisplayableComboRenderer() {
        }

        DisplayableComboRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

