/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import oracle.help.common.Topic;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.library.Library;
import oracle.help.topicDisplay.BrowserTopicDisplay;
import oracle.help.topicDisplay.TopicDisplayException;
import oracle.jdevimpl.help.CueCardOverviewPanel;
import oracle.jdevimpl.help.CueCardSet;

public class BrowserCueCardDisplay
extends BrowserTopicDisplay {
    private CueCardSet _cueCardSet;
    private CueCardOverviewPanel _overviewPanel;

    public BrowserCueCardDisplay(HTMLBrowser hTMLBrowser) {
        super(hTMLBrowser);
    }

    public BrowserCueCardDisplay(HTMLBrowser hTMLBrowser, Library library) {
        super(hTMLBrowser, library);
    }

    public void displayTopic(Topic topic) throws TopicDisplayException {
        Topic topic2 = null;
        if (topic instanceof CueCardSet) {
            this._cueCardSet = (CueCardSet)topic;
            topic2 = this._cueCardSet.getCurrentTopic();
            this._handleOverviewPanel();
        } else {
            topic2 = topic;
            this._cueCardSet.setCurrentTopic(topic);
        }
        super.displayTopic(topic2);
    }

    public void clear() {
        this._cueCardSet = null;
        super.clear();
    }

    public void dispose() {
        this._cueCardSet = null;
        if (this._overviewPanel != null) {
            this._overviewPanel.dispose();
            this._overviewPanel = null;
        }
        super.dispose();
    }

    CueCardSet getCueCardSet() {
        return this._cueCardSet;
    }

    private void _handleOverviewPanel() {
        if (this._overviewPanel == null) {
            this._overviewPanel = new CueCardOverviewPanel();
        }
        this._overviewPanel.setCueCardSet(this._cueCardSet);
    }
}

