/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.help.common.Topic;
import oracle.help.common.View;
import oracle.help.navigator.LazyNavigator;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.help.CueCardCategory;
import oracle.jdevimpl.help.CueCardCategoryNode;
import oracle.jdevimpl.help.CueCardSet;
import oracle.jdevimpl.help.CueCardSetNode;
import oracle.jdevimpl.help.CueCardTreeModel;
import oracle.jdevimpl.help.HelpArb;

public class CueCardNavigator
extends LazyNavigator {
    private JScrollPane _scrollPane;
    private JTree _tree;
    private CueCardTreeModel _treeModel;

    protected void doInitializationNow() {
        View[] viewArray = this.getInitialViewsArray();
        this._treeModel = new CueCardTreeModel();
        if (viewArray != null) {
            int n = 0;
            while (n < viewArray.length) {
                this.addViewNow(viewArray[n]);
                ++n;
            }
        }
        this._tree = new JTree(this._treeModel);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._scrollPane = new JScrollPane(this._tree);
        this._scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._tree, (String)HelpArb.getString(104));
        this.add(jLabel, "North");
        this.add(this._scrollPane, "Center");
        this._tree.getSelectionModel().setSelectionMode(1);
        CueCardTreeCellRenderer cueCardTreeCellRenderer = new CueCardTreeCellRenderer(null);
        this.addTreeCellRenderer(cueCardTreeCellRenderer);
        this._tree.getInputMap().put(KeyStroke.getKeyStroke("SPACE"), "pressed");
        this._tree.getActionMap().put("pressed", new PressAction(null));
        ToolTipManager.sharedInstance().registerComponent(this._tree);
        this.addMouseListener(this._tree);
    }

    protected void addMouseListener(JTree jTree) {
        CueCardMouseAdapter cueCardMouseAdapter = new CueCardMouseAdapter(null);
        jTree.addMouseListener(cueCardMouseAdapter);
    }

    protected void addTreeCellRenderer(DefaultTreeCellRenderer defaultTreeCellRenderer) {
        this._tree.setCellRenderer(defaultTreeCellRenderer);
    }

    protected void addViewNow(View view) {
        try {
            CueCardCategory[] cueCardCategoryArray = (CueCardCategory[])view.getViewData();
            if (cueCardCategoryArray != null) {
                int n = 0;
                while (n < cueCardCategoryArray.length) {
                    CueCardCategoryNode cueCardCategoryNode = this._treeModel.addCategoryNode(cueCardCategoryArray[n].getCategoryName());
                    CueCardSet[] cueCardSetArray = cueCardCategoryArray[n].getCueCardSets();
                    this._treeModel.addCueCardSetNodes(cueCardCategoryNode, cueCardSetArray);
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void removeViewNow(View view) {
    }

    public String getDefaultLabel() {
        return null;
    }

    public Topic getCurrentSelection() {
        if (this._tree == null) {
            return null;
        }
        Object object = this._tree.getLastSelectedPathComponent();
        if (object == null || object instanceof CueCardCategoryNode) {
            return null;
        }
        if (object instanceof CueCardSetNode) {
            CueCardSet cueCardSet = ((CueCardSetNode)object).getCueCardSet();
            return cueCardSet;
        }
        return null;
    }

    protected CueCardSet getCueCardSet(MouseEvent mouseEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        CueCardSet cueCardSet = null;
        JTree jTree = (JTree)mouseEvent.getComponent();
        TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()) != null && defaultMutableTreeNode.getUserObject() instanceof CueCardSet) {
            cueCardSet = (CueCardSet)defaultMutableTreeNode.getUserObject();
        }
        return cueCardSet;
    }

    static void mav$fireTopicActivated(CueCardNavigator cueCardNavigator, Topic topic) {
        cueCardNavigator.fireTopicActivated(topic);
    }

    private static class CueCardTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object != null) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                Object object2 = defaultMutableTreeNode.getUserObject();
                if (object2 instanceof String) {
                    this.setText((String)object2);
                    this.setToolTipText((String)object2);
                } else if (object2 instanceof CueCardSet) {
                    CueCardSet cueCardSet = (CueCardSet)object2;
                    this.setText(cueCardSet.getDisplayText());
                    this.setToolTipText(cueCardSet.getDisplayText());
                }
            }
            return this;
        }

        private CueCardTreeCellRenderer() {
        }

        CueCardTreeCellRenderer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private class CueCardMouseAdapter
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            CueCardSet cueCardSet;
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1 && (cueCardSet = CueCardNavigator.this.getCueCardSet(mouseEvent)) != null) {
                CueCardNavigator.mav$fireTopicActivated(CueCardNavigator.this, cueCardSet);
            }
        }

        private CueCardMouseAdapter() {
        }

        CueCardMouseAdapter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class PressAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTree jTree = (JTree)actionEvent.getSource();
            TreePath treePath = jTree.getSelectionPath();
            Object object = treePath.getLastPathComponent();
            if (object != null && object instanceof CueCardSetNode) {
                CueCardSetNode cueCardSetNode = (CueCardSetNode)object;
                CueCardSet cueCardSet = cueCardSetNode.getCueCardSet();
                CueCardNavigator.mav$fireTopicActivated(CueCardNavigator.this, cueCardSet);
            }
        }

        private PressAction() {
        }

        PressAction(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

