/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.MouseInputAdapter;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.nls.StringUtils;
import oracle.help.common.SimpleTopic;
import oracle.help.common.Topic;
import oracle.help.topicDisplay.TopicDisplayEvent;
import oracle.help.topicDisplay.TopicDisplayListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.layout.ViewId;
import oracle.jdevimpl.help.CueCardOverviewWindow;
import oracle.jdevimpl.help.CueCardSet;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpWindow;

public class CueCardOverviewPanel
extends JPanel
implements ContextMenuListener,
Controller {
    private JList _list;
    private DefaultListModel _listModel;
    private CueCardSet _cueCardSet;
    private ListenerManager _listeners = new ListenerManager();
    private JLabel _cueCardSetLabel;
    private Color _linkFG;
    private ContextMenu _contextMenu;
    private JMenuItem _closeMenuItem;
    private JMenuItem _gotoMenuItem;
    private static final int CLOSE_PANEL_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.CueCardOverviewPanel.CloseOverviewPanelCmd");
    private static final int GOTO_TOPIC_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.CueCardOverviewPanel.GoToTopicCmd");
    private static final String MOUSE_EVENT = "mouseEvent";

    public CueCardOverviewPanel() {
        this.setLayout(new GridBagLayout());
        this._cueCardSetLabel = new JLabel();
        this.add((Component)this._cueCardSetLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this._listModel = new DefaultListModel();
        this._list = new JList(this._listModel);
        JScrollPane jScrollPane = new JScrollPane(this._list);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 4, 1.0, 1.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this._list.setCellRenderer(new CueCardListCellRenderer(null));
        CueCardMouseAdapter cueCardMouseAdapter = new CueCardMouseAdapter(null);
        this._list.addMouseMotionListener(cueCardMouseAdapter);
        this._list.addMouseListener(cueCardMouseAdapter);
        this._list.getInputMap().put(KeyStroke.getKeyStroke("SPACE"), "pressed");
        this._list.getActionMap().put("pressed", new PressAction(null));
    }

    public void setCueCardSet(CueCardSet cueCardSet) {
        this._cueCardSet = cueCardSet;
        this._cueCardSetLabel.setText(this._cueCardSet.getLabel());
        List list = this._cueCardSet.getStepList();
        DefaultListModel defaultListModel = new DefaultListModel();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            defaultListModel.addElement(list.get(n2));
            ++n2;
        }
        this._list.setModel(defaultListModel);
        this._listModel = defaultListModel;
    }

    public void selectMatchingURL(URL uRL) {
        List list = this._cueCardSet.getStepList();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Topic topic = (Topic)list.get(n2);
            try {
                URL uRL2 = topic.getTarget().getURL();
                if (uRL.equals(uRL2)) {
                    this._list.setSelectedIndex(n2);
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
    }

    public JList getList() {
        return this._list;
    }

    public void setLinkFG(Color color) {
        this._linkFG = color;
    }

    public void dispose() {
        this._listeners = null;
    }

    public void addTopicDisplayListener(TopicDisplayListener topicDisplayListener) {
        if (topicDisplayListener != null) {
            this._listeners.addListener((EventListener)topicDisplayListener);
        }
    }

    public void removeTopicDisplayListener(TopicDisplayListener topicDisplayListener) {
        if (topicDisplayListener != null) {
            this._listeners.removeListener((EventListener)topicDisplayListener);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == CLOSE_PANEL_CMD_ID) {
            HelpWindow helpWindow = (HelpWindow)DockStation.getDockStation().getDockable(new ViewId("HelpSystemAddin.HelpWindow"));
            CueCardOverviewWindow cueCardOverviewWindow = helpWindow.getCueCardOverviewWindow(false);
            if (cueCardOverviewWindow != null) {
                cueCardOverviewWindow.close();
            }
            return true;
        }
        if (n == GOTO_TOPIC_CMD_ID) {
            if (ideAction.getValue(MOUSE_EVENT) != null) {
                Topic topic = this._getTopic((MouseEvent)ideAction.getValue(MOUSE_EVENT));
                this._fireEventForTopic(topic);
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == CLOSE_PANEL_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == GOTO_TOPIC_CMD_ID) {
            ideAction.setEnabled(true);
            ideAction.putValue(MOUSE_EVENT, (Object)context.getEvent());
            return true;
        }
        return false;
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        contextMenu.add((Component)this._gotoMenuItem);
        contextMenu.addSeparator();
        contextMenu.add((Component)this._closeMenuItem);
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    private void _fireTopicDisplayEvent(TopicDisplayEvent topicDisplayEvent) {
        Enumeration enumeration = this._listeners.getListeners();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TopicDisplayListener topicDisplayListener = (TopicDisplayListener)enumeration.nextElement();
                topicDisplayListener.topicDisplayChanged(topicDisplayEvent);
            }
        }
    }

    private ContextMenu _getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu();
            String string = HelpArb.getString(115);
            IdeAction ideAction = IdeAction.get((int)CLOSE_PANEL_CMD_ID, null, (String)StringUtils.stripMnemonic((String)string), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), null, null, null, (boolean)true);
            ideAction.addController((Controller)this);
            this._closeMenuItem = this._contextMenu.createMenuItem((ToggleAction)ideAction);
            string = HelpArb.getString(116);
            ideAction = IdeAction.get((int)GOTO_TOPIC_CMD_ID, null, (String)StringUtils.stripMnemonic((String)string), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), null, null, null, (boolean)true);
            ideAction.addController((Controller)this);
            this._gotoMenuItem = this._contextMenu.createMenuItem((ToggleAction)ideAction);
            this._contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
        return this._contextMenu;
    }

    private void _fireEventForTopic(Topic topic) {
        if (topic != null) {
            try {
                URL uRL = topic.getTarget().getURL();
                TopicDisplayEvent topicDisplayEvent = new TopicDisplayEvent((Object)this._list, 2000, 0, uRL, null);
                this._fireTopicDisplayEvent(topicDisplayEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private Topic _getTopic(MouseEvent mouseEvent) {
        Topic topic = null;
        JList jList = (JList)mouseEvent.getComponent();
        int n = jList.locationToIndex(new Point(mouseEvent.getX(), mouseEvent.getY()));
        if (n != -1) {
            ListModel listModel = jList.getModel();
            topic = (Topic)listModel.getElementAt(n);
        }
        return topic;
    }

    static Color ra$_linkFG(CueCardOverviewPanel cueCardOverviewPanel) {
        return cueCardOverviewPanel._linkFG;
    }

    static Topic mav$_getTopic(CueCardOverviewPanel cueCardOverviewPanel, MouseEvent mouseEvent) {
        return cueCardOverviewPanel._getTopic(mouseEvent);
    }

    static void mav$_fireEventForTopic(CueCardOverviewPanel cueCardOverviewPanel, Topic topic) {
        cueCardOverviewPanel._fireEventForTopic(topic);
    }

    static ContextMenu mav$_getContextMenu(CueCardOverviewPanel cueCardOverviewPanel) {
        return cueCardOverviewPanel._getContextMenu();
    }

    private class CueCardListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object != null) {
                SimpleTopic simpleTopic = (SimpleTopic)object;
                String string = simpleTopic.getLabel();
                this.setForeground(CueCardOverviewPanel.ra$_linkFG(CueCardOverviewPanel.this));
                if (bl) {
                    this.setText("<html><u><b>" + string + "</u></b></html>");
                    this.setBackground(jList.getSelectionBackground());
                } else {
                    this.setText("<html><u>" + string + "</u></html>");
                    this.setBackground(jList.getBackground());
                }
                this.setToolTipText(string);
            }
            return this;
        }

        private CueCardListCellRenderer() {
        }

        CueCardListCellRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class CueCardMouseAdapter
    extends MouseInputAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this._showContextMenu(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this._showContextMenu(mouseEvent);
            }
        }

        private void _showContextMenu(MouseEvent mouseEvent) {
            Context context = Context.newIdeContext();
            context.setEvent((EventObject)mouseEvent);
            CueCardOverviewPanel.mav$_getContextMenu(CueCardOverviewPanel.this).show(context);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Topic topic = CueCardOverviewPanel.mav$_getTopic(CueCardOverviewPanel.this, mouseEvent);
            if (topic != null) {
                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            } else {
                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 1) {
                Topic topic = CueCardOverviewPanel.mav$_getTopic(CueCardOverviewPanel.this, mouseEvent);
                CueCardOverviewPanel.mav$_fireEventForTopic(CueCardOverviewPanel.this, topic);
            }
        }

        private CueCardMouseAdapter() {
        }

        CueCardMouseAdapter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class PressAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JList jList = (JList)actionEvent.getSource();
            Topic topic = (Topic)jList.getSelectedValue();
            CueCardOverviewPanel.mav$_fireEventForTopic(CueCardOverviewPanel.this, topic);
        }

        private PressAction() {
        }

        PressAction(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

