/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.help.common.util.LocaleUtils;
import oracle.help.common.xml.Parser;
import oracle.help.common.xml.ParserFactory;
import oracle.help.common.xml.XMLNode;
import oracle.help.common.xml.XMLParseException;
import oracle.jdevimpl.help.DynamicLinkMap;
import oracle.jdevimpl.help.MultipleTypeTopic;

public final class DynamicLinkParser {
    public static final String TAG_DYNAMIC_LINKS = "dynamicLinks";
    public static final String TAG_LINK_LIST = "linkList";
    public static final String TAG_ENTRY = "entry";
    public static final String TAG_TOPIC_LIST = "topicList";
    public static final String TAG_TOPIC_ENTRY = "topicEntry";
    public static final String TAG_TOPIC_ID = "topicId";
    public static final String TAG_TOPIC_TYPE = "topicType";
    public static final String TAG_ID = "id";
    public static final String TAG_DISPLAY_TEXT = "displayText";
    private byte[] buffer;
    private final int BUF_SIZE;

    void $init$() {
        this.buffer = null;
        this.BUF_SIZE = 256;
    }

    public static void getData(URL uRL, String string, DynamicLinkMap dynamicLinkMap) {
        DynamicLinkParser dynamicLinkParser = new DynamicLinkParser();
        try {
            InputStream inputStream = DynamicLinkParser.openInputStream(uRL);
            BufferedReader bufferedReader = new BufferedReader(LocaleUtils.createInputStreamReader((InputStream)inputStream, (String)string));
            dynamicLinkParser.parseLinks(bufferedReader, dynamicLinkMap);
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private DynamicLinkParser() {
        this.$init$();
        this.buffer = new byte[256];
    }

    private void parseLinks(BufferedReader bufferedReader, DynamicLinkMap dynamicLinkMap) throws IOException, XMLParseException {
        Parser parser = ParserFactory.createParser((Reader)bufferedReader);
        XMLNode xMLNode = parser.getRoot();
        this._handleData(xMLNode.getFirstChild(), dynamicLinkMap);
    }

    private void _handleData(XMLNode xMLNode, DynamicLinkMap dynamicLinkMap) throws XMLParseException {
        if (!xMLNode.getTokenValue().equalsIgnoreCase(TAG_DYNAMIC_LINKS)) {
            throw new XMLParseException("Toplevel tag is not dynamicLinks " + xMLNode.getTokenValue());
        }
        xMLNode = xMLNode.getFirstChild();
        while (xMLNode != null) {
            if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_LINK_LIST)) {
                this._handleLinkList(xMLNode, dynamicLinkMap);
            }
            xMLNode = xMLNode.getNextSibling();
        }
    }

    private void _handleLinkList(XMLNode xMLNode, DynamicLinkMap dynamicLinkMap) {
        xMLNode = xMLNode.getFirstChild();
        while (xMLNode != null) {
            if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_ENTRY)) {
                this._handleEntry(xMLNode, dynamicLinkMap);
            }
            xMLNode = xMLNode.getNextSibling();
        }
    }

    private void _handleEntry(XMLNode xMLNode, DynamicLinkMap dynamicLinkMap) {
        String string = null;
        String string2 = null;
        List list = null;
        xMLNode = xMLNode.getFirstChild();
        while (xMLNode != null) {
            if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_ID)) {
                string = xMLNode.getString();
            } else if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_DISPLAY_TEXT)) {
                string2 = xMLNode.getString();
            } else if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_TOPIC_LIST)) {
                list = this._handleTopicList(xMLNode);
            }
            xMLNode = xMLNode.getNextSibling();
        }
        dynamicLinkMap.addEntry(string, string2, list);
    }

    private List _handleTopicList(XMLNode xMLNode) {
        ArrayList arrayList = new ArrayList();
        xMLNode = xMLNode.getFirstChild();
        while (xMLNode != null) {
            if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_TOPIC_ENTRY)) {
                this._handleTopicEntry(xMLNode, arrayList);
            }
            xMLNode = xMLNode.getNextSibling();
        }
        return arrayList;
    }

    private void _handleTopicEntry(XMLNode xMLNode, List list) {
        String string = null;
        String string2 = null;
        String string3 = "dynamiclink";
        xMLNode = xMLNode.getFirstChild();
        while (xMLNode != null) {
            if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_TOPIC_ID)) {
                string = xMLNode.getString();
            } else if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_DISPLAY_TEXT)) {
                string2 = xMLNode.getString();
            } else if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_TOPIC_TYPE)) {
                string3 = xMLNode.getString();
            }
            xMLNode = xMLNode.getNextSibling();
        }
        MultipleTypeTopic multipleTypeTopic = new MultipleTypeTopic(string2, string, string3);
        list.add(multipleTypeTopic);
    }

    private static InputStream openInputStream(URL uRL) throws IOException {
        InputStream inputStream = null;
        if (uRL.getProtocol().equals("file")) {
            try {
                inputStream = new FileInputStream(uRL.getFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (inputStream == null) {
            inputStream = uRL.openStream();
        }
        return inputStream;
    }
}

