/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.help.common.Topic;
import oracle.help.library.Library;
import oracle.help.navigator.LazyNavigator;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockStation;
import oracle.ide.help.DynamicHelpProvider;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.palette.PaletteEvent;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteListener;
import oracle.ide.palette.PaletteWindow;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.ModelUtil;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.jdevimpl.help.DynamicLinkEntry;
import oracle.jdevimpl.help.DynamicLinkMap;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpTopicDocument;
import oracle.jdevimpl.help.HelpWindow;
import oracle.jdevimpl.help.JDevHelpSystemImpl;
import oracle.jdevimpl.help.MultipleTypeTopic;
import oracle.jdevimpl.uieditor.uicanvas.ModelNode;

public final class DynamicLinksNavigator
extends LazyNavigator
implements ViewSelectionListener,
ActiveViewListener {
    private JScrollPane _scrollPane;
    private JTree _tree;
    private DefaultTreeModel _treeModel;
    private DefaultMutableTreeNode _rootNode;
    private DefaultMutableTreeNode _selectionTopNode;
    private DefaultMutableTreeNode _documentTopNode;
    private DefaultMutableTreeNode _viewTopNode;
    private DefaultMutableTreeNode _selectionDebugNode;
    private DefaultMutableTreeNode _documentDebugNode;
    private DefaultMutableTreeNode _viewDebugNode;
    private View _currentView;
    private DynamicLinkMap _dynamicLinkMap;
    private Toolbar _toolbar;
    private boolean _pinState;
    private HelpWindow _helpWindow;
    private DLPaletteWindowListener _paletteWindowListener;
    private JMultiLineLabel _label;
    private boolean _labelAdded;
    private boolean _activated;
    private static final int SELECTION_DATA = 0;
    private static final int DOCUMENT_DATA = 1;
    private static final int VIEW_DATA = 2;

    void $init$() {
        this._tree = new JTree();
        this._label = new JMultiLineLabel(HelpArb.getString(108));
    }

    public DynamicLinksNavigator() {
        this.$init$();
    }

    protected void doInitializationNow() {
        this._rootNode = new DefaultMutableTreeNode(new DynamicLinkTreeNodeData("rootNode"));
        this._treeModel = new DefaultTreeModel(this._rootNode);
        this._selectionTopNode = new DefaultMutableTreeNode(new DynamicLinkTreeNodeData(HelpArb.getString(106)));
        this._documentTopNode = new DefaultMutableTreeNode(new DynamicLinkTreeNodeData("Document Links"));
        this._viewTopNode = new DefaultMutableTreeNode(new DynamicLinkTreeNodeData("View Links:"));
        if (JDevHelpSystemImpl.isDocWriter()) {
            this._selectionDebugNode = new DefaultMutableTreeNode(new DynamicLinkTreeNodeData("Debug: Selection View Keys"));
            this._rootNode.add(this._selectionDebugNode);
            this._documentDebugNode = new DefaultMutableTreeNode(new DynamicLinkTreeNodeData("Debug:Document Keys:"));
            this._rootNode.add(this._documentDebugNode);
            this._viewDebugNode = new DefaultMutableTreeNode(new DynamicLinkTreeNodeData("Debug:View Keys"));
            this._rootNode.add(this._viewDebugNode);
        }
        this._tree.setModel(this._treeModel);
        DynamicLinkTreeCellRenderer dynamicLinkTreeCellRenderer = new DynamicLinkTreeCellRenderer();
        this._tree.getInputMap().put(KeyStroke.getKeyStroke("SPACE"), "pressed");
        this._tree.getActionMap().put("pressed", new PressAction(null));
        ToolTipManager.sharedInstance().registerComponent(this._tree);
        LinkMouseInputAdapter linkMouseInputAdapter = new LinkMouseInputAdapter(null);
        this._tree.addMouseListener(linkMouseInputAdapter);
        this._tree.setCellRenderer(dynamicLinkTreeCellRenderer);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._scrollPane = new JScrollPane(this._tree);
        this._scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._toolbar = new Toolbar();
        IdeAction ideAction = IdeAction.find((int)68);
        ideAction.addController((Controller)this._helpWindow);
        if (ideAction != null) {
            ideAction = ideAction.newLocalAction((View)this._helpWindow);
            ideAction.putValue("State", (Object)(this.getPinState() ? Boolean.TRUE : Boolean.FALSE));
            ideAction.setEnabled(true);
            ideAction.addController((Controller)this._helpWindow);
            this._toolbar.addToggleButton((ToggleAction)ideAction);
        }
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        this.add((Component)this._toolbar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add(this._scrollPane, new GridBagConstraints(0, 2, 1, 2, 1.0, 1.0, 17, 1, insets, 0, 0));
        oracle.help.common.View[] viewArray = this.getInitialViewsArray();
        if (viewArray != null) {
            int n = 0;
            while (n < viewArray.length) {
                this.addViewNow(viewArray[n]);
                ++n;
            }
        }
    }

    protected void addViewNow(oracle.help.common.View view) {
        try {
            this._dynamicLinkMap = (DynamicLinkMap)view.getViewData();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void removeViewNow(oracle.help.common.View view) {
    }

    public String getDefaultLabel() {
        return null;
    }

    public Topic getCurrentSelection() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        MultipleTypeTopic multipleTypeTopic = null;
        TreePath treePath = this._tree.getSelectionPath();
        if (treePath != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()) != null) {
            DynamicLinkTreeNodeData dynamicLinkTreeNodeData = (DynamicLinkTreeNodeData)defaultMutableTreeNode.getUserObject();
            multipleTypeTopic = dynamicLinkTreeNodeData.getTopic();
        }
        return multipleTypeTopic;
    }

    public Component getTree() {
        return this._tree;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.activate();
        } else {
            this.deactivate();
        }
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    void setHelpWindow(HelpWindow helpWindow) {
        this._helpWindow = helpWindow;
    }

    boolean getPinState() {
        return this._pinState;
    }

    void setPinState(boolean bl) {
        this._pinState = bl;
    }

    void activate() {
        if (!this._activated) {
            Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
            View view = Ide.getMainWindow().getLastActiveView();
            this.activeViewChanged(new ActiveViewEvent((Object)this, null, view));
            this._activated = true;
        }
    }

    void deactivate() {
        if (this._activated) {
            Ide.getMainWindow().removeActiveViewListener((ActiveViewListener)this);
            this.removeViewListeners();
            this._activated = false;
        }
    }

    private void addViewListeners(View view) {
        this._currentView = view;
        this._currentView.addViewSelectionListener((ViewSelectionListener)this);
        if (view instanceof PaletteWindow) {
            this._paletteWindowListener = new DLPaletteWindowListener(view);
            ((PaletteWindow)view).addPaletteListener((PaletteListener)this._paletteWindowListener);
        }
    }

    private void removeViewListeners() {
        if (this._currentView != null) {
            this._currentView.removeViewSelectionListener((ViewSelectionListener)this);
            if (this._currentView instanceof PaletteWindow) {
                ((PaletteWindow)this._currentView).removePaletteListener((PaletteListener)this._paletteWindowListener);
                this._paletteWindowListener = null;
            }
        }
    }

    private void updateNodeForKey(DefaultMutableTreeNode defaultMutableTreeNode, List list, int n) {
        boolean bl = this._tree.isCollapsed(new TreePath(defaultMutableTreeNode.getPath()));
        DynamicLinkTreeNodeData dynamicLinkTreeNodeData = (DynamicLinkTreeNodeData)defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode != this._selectionTopNode) {
            dynamicLinkTreeNodeData.setLabel(null);
        }
        ArrayList<DynamicLinkTreeNodeData> arrayList = new ArrayList<DynamicLinkTreeNodeData>();
        DynamicLinkEntry dynamicLinkEntry = null;
        int n2 = list.size();
        Object var9_9 = null;
        int n3 = 0;
        while (n3 < n2) {
            var9_9 = list.get(n3);
            if (var9_9 instanceof String && (((String)var9_9).startsWith("java.") || ((String)var9_9).startsWith("javax."))) {
                MultipleTypeTopic multipleTypeTopic = new MultipleTypeTopic(HelpArb.format(138, var9_9), var9_9, "language");
                arrayList.add(new DynamicLinkTreeNodeData(multipleTypeTopic));
            } else {
                dynamicLinkEntry = this.getEntryForKey(var9_9);
                if (dynamicLinkEntry != null) {
                    List list2;
                    if (defaultMutableTreeNode != this._selectionTopNode && dynamicLinkTreeNodeData.getLabel() == null) {
                        dynamicLinkTreeNodeData.setLabel(dynamicLinkEntry.getUserText());
                        this._treeModel.nodeChanged(defaultMutableTreeNode);
                    }
                    if ((list2 = dynamicLinkEntry.getTopicList()) != null) {
                        int n4 = list2.size();
                        MultipleTypeTopic multipleTypeTopic = null;
                        int n5 = 0;
                        while (n5 < n4) {
                            multipleTypeTopic = (MultipleTypeTopic)((Object)list2.get(n5));
                            arrayList.add(new DynamicLinkTreeNodeData(multipleTypeTopic));
                            ++n5;
                        }
                    }
                }
            }
            ++n3;
        }
        int n6 = defaultMutableTreeNode.getChildCount();
        int[] nArray = new int[n6];
        Object[] objectArray = new Object[n6];
        int n7 = 0;
        while (n7 < n6) {
            nArray[n7] = n7;
            objectArray[n7] = defaultMutableTreeNode.getChildAt(n7);
            ++n7;
        }
        defaultMutableTreeNode.removeAllChildren();
        this._treeModel.nodesWereRemoved(defaultMutableTreeNode, nArray, objectArray);
        if (defaultMutableTreeNode == this._selectionTopNode) {
            Enumeration<TreeNode> enumeration = this._rootNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                if (this.getNodeType(defaultMutableTreeNode2) != -1) continue;
                this._rootNode.remove(defaultMutableTreeNode2);
                nArray = new int[]{0};
                objectArray = new Object[]{defaultMutableTreeNode2};
                this._treeModel.nodesWereRemoved(this._rootNode, nArray, objectArray);
            }
        }
        int n8 = arrayList.size();
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        int n9 = 0;
        while (n9 < n8) {
            DynamicLinkTreeNodeData dynamicLinkTreeNodeData2 = (DynamicLinkTreeNodeData)arrayList.get(n9);
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(dynamicLinkTreeNodeData2);
            if (defaultMutableTreeNode == this._selectionTopNode && n8 == 1) {
                this._treeModel.insertNodeInto(defaultMutableTreeNode4, this._rootNode, 0);
            } else if (n9 > 4) {
                if (defaultMutableTreeNode3 == null) {
                    DynamicLinkTreeNodeData dynamicLinkTreeNodeData3 = new DynamicLinkTreeNodeData(HelpArb.getString(105));
                    defaultMutableTreeNode3 = new DefaultMutableTreeNode(dynamicLinkTreeNodeData3);
                    this._treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    this._treeModel.insertNodeInto(defaultMutableTreeNode4, defaultMutableTreeNode3, defaultMutableTreeNode3.getChildCount());
                } else {
                    this._treeModel.insertNodeInto(defaultMutableTreeNode4, defaultMutableTreeNode3, defaultMutableTreeNode3.getChildCount());
                }
            } else {
                this._treeModel.insertNodeInto(defaultMutableTreeNode4, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            }
            ++n9;
        }
        this._treeModel.nodeChanged(defaultMutableTreeNode);
        if (defaultMutableTreeNode.getChildCount() > 0) {
            if (defaultMutableTreeNode.getParent() == null) {
                this._treeModel.insertNodeInto(defaultMutableTreeNode, this._rootNode, this.getInsertLocation(n));
                this._tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
            } else if (!bl) {
                this._tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
            }
        } else if (defaultMutableTreeNode.getParent() != null) {
            this._treeModel.removeNodeFromParent(defaultMutableTreeNode);
        }
    }

    private int getInsertLocation(int n) {
        int n2 = 0;
        if (n == 0) {
            n2 = 0;
        } else {
            Enumeration<TreeNode> enumeration = this._rootNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                int n3 = this.getNodeType(defaultMutableTreeNode);
                if (n < n3) break;
                ++n2;
            }
        }
        return n2;
    }

    private int getNodeType(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == this._selectionTopNode) {
            return 0;
        }
        if (defaultMutableTreeNode == this._documentTopNode) {
            return 1;
        }
        if (defaultMutableTreeNode == this._viewTopNode) {
            return 2;
        }
        if (defaultMutableTreeNode == this._selectionDebugNode) {
            return 3;
        }
        if (defaultMutableTreeNode == this._documentDebugNode) {
            return 4;
        }
        if (defaultMutableTreeNode == this._viewDebugNode) {
            return 5;
        }
        return -1;
    }

    private DynamicLinkEntry getEntryForKey(Object object) {
        DynamicLinkEntry dynamicLinkEntry = null;
        if (object instanceof String) {
            dynamicLinkEntry = this._dynamicLinkMap.getEntryForKey((String)object);
        } else if (object instanceof List) {
            dynamicLinkEntry = new DynamicLinkEntry(null, (List)object);
        }
        return dynamicLinkEntry;
    }

    private void updateDebugNode(DefaultMutableTreeNode defaultMutableTreeNode, List list) {
        if (JDevHelpSystemImpl.isDocWriter()) {
            defaultMutableTreeNode.removeAllChildren();
            this._treeModel.reload(defaultMutableTreeNode);
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DynamicLinkTreeNodeData((String)list.get(n2)));
                this._treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                ++n2;
            }
            if (defaultMutableTreeNode.getChildCount() > 0) {
                this._treeModel.reload(defaultMutableTreeNode);
                this._tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
            }
        }
    }

    private boolean ignoreView(View view) {
        String string = view.getClass().getName();
        return string.equals("oracle.jdevimpl.help.HelpWindow") || string.equals("oracle.ideimpl.MainWindowImpl") || string.equals("oracle.jdevimpl.help.HelpTopicEditor") || string.indexOf("IdeMainWindow") != -1;
    }

    private void handleView(View view) {
        if (this._dynamicLinkMap != null) {
            String string = view.getClass().getName();
            if (string.equals("oracle.jdevimpl.help.HelpWindow") || string.equals("oracle.ideimpl.MainWindowImpl") || string.equals("oracle.jdevimpl.help.HelpTopicEditor")) {
                this.provideDefaultTopics();
                return;
            }
            this.removeViewListeners();
            ArrayList arrayList = new ArrayList();
            List list = this.buildDocumentKeyList(view, arrayList);
            List list2 = this.buildSelectionKeyList(view, arrayList);
            List list3 = this.buildViewKeyList(view, arrayList);
            this.updateNodeForKey(this._selectionTopNode, list2, 0);
            this.updateNodeForKey(this._documentTopNode, list, 1);
            this.updateNodeForKey(this._viewTopNode, list3, 2);
            this.updateDebugNode(this._selectionDebugNode, list2);
            this.updateDebugNode(this._documentDebugNode, list);
            this.updateDebugNode(this._viewDebugNode, list3);
            this.provideDefaultTopics();
            this.addViewListeners(view);
        }
    }

    private List buildDocumentKeyList(View view, List list) {
        ArrayList arrayList = new ArrayList();
        Context context = view.getContext();
        Node node = context.getNode();
        if (node != null) {
            String string = node.getShortLabel();
            if (ModelUtil.hasLength((String)string)) {
                this.addKeyToList(string, arrayList, list);
            }
            String string2 = node.getClass().getName();
            this.addKeyToList(string2, arrayList, list);
        } else if (view instanceof NavigatorWindow) {
            Element element = context.getElement();
            if (element instanceof Workspaces) {
                Workspaces workspaces = Ide.getWorkspaces();
                Class clazz = workspaces.getClass();
                String string = clazz.getName();
                this.addKeyToList(string, arrayList, list);
            } else {
                if (element instanceof Displayable) {
                    this.addKeyToList(element.getShortLabel(), arrayList, list);
                }
                if (element != null) {
                    this.handleElement(element, arrayList, list);
                }
            }
        }
        return arrayList;
    }

    private List buildSelectionKeyList(View view, List list) {
        Element[] elementArray = view.getSelection();
        ArrayList arrayList = new ArrayList();
        if (elementArray != null) {
            int n = 0;
            while (n < elementArray.length) {
                this.handleElement(elementArray[n], arrayList, list);
                ++n;
            }
        }
        this.addKeyToList("reference-info", arrayList, list);
        return arrayList;
    }

    private void handleElement(Element element, List list, List list2) {
        if (element instanceof ModelNode) {
            String string = ((ModelNode)element).getLiveComponent().getClass().getName();
            this.addKeyToList(string, list, list2);
        } else if (element instanceof PaletteItem) {
            String string = ((PaletteItem)element).getClassName();
            this.addKeyToList(string, list, list2);
        } else if (element instanceof DynamicHelpProvider) {
            Collection collection = ((DynamicHelpProvider)element).getDynamicHelpIds();
            if (collection != null && collection.size() > 0) {
                HelpSystem helpSystem = HelpSystem.getHelpSystem();
                JDevHelpSystemImpl jDevHelpSystemImpl = null;
                if (helpSystem instanceof JDevHelpSystemImpl) {
                    jDevHelpSystemImpl = (JDevHelpSystemImpl)helpSystem;
                    ArrayList<MultipleTypeTopic> arrayList = new ArrayList<MultipleTypeTopic>();
                    String string2 = null;
                    for (String string2 : collection) {
                        if (list2.contains(string2)) continue;
                        list2.add(string2);
                        Topic topic = jDevHelpSystemImpl.getTopicForString(string2, false);
                        if (topic == null) continue;
                        String string3 = topic.getLabel();
                        if (string3 == null && topic.hasTarget()) {
                            try {
                                string3 = HelpTopicDocument.getTitleFromURL(topic.getTarget().getURL());
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                        }
                        if (string3 == null) continue;
                        MultipleTypeTopic multipleTypeTopic = new MultipleTypeTopic(string3, string2, "dynamiclink");
                        arrayList.add(multipleTypeTopic);
                    }
                    list.add(arrayList);
                }
            }
        } else {
            this.addKeyToList(element.getClass().getName(), list, list2);
        }
    }

    private List buildViewKeyList(View view, List list) {
        ArrayList arrayList = new ArrayList();
        String string = null;
        if (view instanceof NavigatorWindow) {
            string = view.getId();
            string = string.replaceAll("\\d", "");
        } else {
            string = view.getClass().getName();
        }
        if (string != null) {
            this.addKeyToList(string, arrayList, list);
        }
        return arrayList;
    }

    private void addKeyToList(String string, List list, List list2) {
        if (!list2.contains(string)) {
            list.add(string);
            list2.add(string);
        }
    }

    private void showTopic(MultipleTypeTopic multipleTypeTopic) {
        if (multipleTypeTopic != null) {
            int n = multipleTypeTopic.getTopicType();
            switch (n) {
                case 3: {
                    try {
                        URL uRL = multipleTypeTopic.getTarget().getURL();
                        BrowserRunner.getBrowserRunner().runBrowserOnURL(uRL, null, null);
                    }
                    catch (MalformedURLException malformedURLException) {}
                    break;
                }
                case 2: {
                    DockStation dockStation;
                    HelpWindow helpWindow;
                    JDevHelpSystemImpl jDevHelpSystemImpl;
                    Library library;
                    HelpSystem helpSystem = HelpSystem.getHelpSystem();
                    if (helpSystem == null || !(helpSystem instanceof JDevHelpSystemImpl) || (library = (jDevHelpSystemImpl = (JDevHelpSystemImpl)helpSystem).getLibrary()) == null || (helpWindow = (HelpWindow)(dockStation = DockStation.getDockStation()).findDockable(HelpWindow.getHelpWindowViewId())) == null) break;
                    helpWindow.showCueCardSetForId(multipleTypeTopic.getCueCardId());
                    break;
                }
                default: {
                    HelpSystem helpSystem = HelpSystem.getHelpSystem();
                    JDevHelpSystemImpl jDevHelpSystemImpl = (JDevHelpSystemImpl)helpSystem;
                    jDevHelpSystemImpl.showTopic((Topic)multipleTypeTopic);
                }
            }
        }
    }

    private void provideDefaultTopics() {
        if (this._tree.getRowCount() == 0) {
            if (!this._labelAdded) {
                this.add((Component)this._label, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                this._labelAdded = true;
            }
            DynamicLinkTreeNodeData dynamicLinkTreeNodeData = (DynamicLinkTreeNodeData)this._viewTopNode.getUserObject();
            dynamicLinkTreeNodeData.setLabel(HelpArb.getString(117));
            List list = this.getDefaultTopicList();
            if (list != null) {
                int n = list.size();
                MultipleTypeTopic multipleTypeTopic = null;
                int n2 = 0;
                while (n2 < n) {
                    multipleTypeTopic = (MultipleTypeTopic)((Object)list.get(n2));
                    DynamicLinkTreeNodeData dynamicLinkTreeNodeData2 = new DynamicLinkTreeNodeData(multipleTypeTopic);
                    DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(dynamicLinkTreeNodeData2);
                    this._treeModel.insertNodeInto(defaultMutableTreeNode, this._viewTopNode, this._viewTopNode.getChildCount());
                    ++n2;
                }
                this._treeModel.nodeChanged(this._viewTopNode);
                if (this._viewTopNode.getParent() == null) {
                    this._treeModel.insertNodeInto(this._viewTopNode, this._rootNode, Math.min(2, this._rootNode.getChildCount()));
                    this._tree.expandPath(new TreePath(this._viewTopNode.getPath()));
                } else if (!this._tree.isCollapsed(new TreePath(this._viewTopNode.getPath()))) {
                    this._tree.expandPath(new TreePath(this._viewTopNode.getPath()));
                }
            }
        }
    }

    private List getDefaultTopicList() {
        String[] stringArray = new String[]{HelpArb.getString(120), HelpArb.getString(121), HelpArb.getString(123), HelpArb.getString(125), HelpArb.getString(127), HelpArb.getString(129), HelpArb.getString(130), HelpArb.getString(131), HelpArb.getString(136), HelpArb.getString(137)};
        String[] stringArray2 = new String[]{"cc_jdevmain_html", HelpArb.getString(122), HelpArb.getString(124), HelpArb.getString(126), HelpArb.getString(128), "ide_ajdeveloper_html", "ide_psourcefilesworkingwith_html", "ide_papplicationsprojectsmanaging_html", "ide_ponlinehelpusing_html", "ide_ponlinehelpusingdlinks_html"};
        ArrayList<MultipleTypeTopic> arrayList = new ArrayList<MultipleTypeTopic>(9);
        int n = 0;
        while (n < stringArray.length) {
            arrayList.add(new MultipleTypeTopic(stringArray[n], stringArray2[n], stringArray2[n].startsWith("http") ? "external" : "dynamiclink"));
            ++n;
        }
        return arrayList;
    }

    public void activeViewChanged(ActiveViewEvent activeViewEvent) {
        View view;
        this._currentView = view = activeViewEvent.getNewView();
        if (this._dynamicLinkMap != null && !this.ignoreView(view)) {
            this.removeViewListeners();
            this.remove((Component)this._label);
            this._labelAdded = false;
            ArrayList arrayList = new ArrayList();
            List list = this.buildDocumentKeyList(view, arrayList);
            List list2 = this.buildSelectionKeyList(view, arrayList);
            List list3 = this.buildViewKeyList(view, arrayList);
            this.updateNodeForKey(this._selectionTopNode, list2, 0);
            this.updateNodeForKey(this._documentTopNode, list, 1);
            this.updateNodeForKey(this._viewTopNode, list3, 2);
            this.updateDebugNode(this._selectionDebugNode, list2);
            this.updateDebugNode(this._documentDebugNode, list);
            this.updateDebugNode(this._viewDebugNode, list3);
            if (this._tree.getRowCount() == 0) {
                this.add((Component)this._label, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                this._labelAdded = true;
            }
            this.addViewListeners(view);
        }
        this.provideDefaultTopics();
    }

    public void viewSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
        View view;
        if (this.getPinState()) {
            return;
        }
        View view2 = viewSelectionEvent.getView();
        if (view2 != (view = Ide.getMainWindow().getLastActiveView())) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        List list = this.buildDocumentKeyList(view2, arrayList);
        List list2 = this.buildSelectionKeyList(view2, arrayList);
        this.updateNodeForKey(this._selectionTopNode, list2, 0);
        this.updateNodeForKey(this._documentTopNode, list, 1);
        this.updateDebugNode(this._selectionDebugNode, list2);
        this.updateDebugNode(this._documentDebugNode, list);
    }

    static void mav$showTopic(DynamicLinksNavigator dynamicLinksNavigator, MultipleTypeTopic multipleTypeTopic) {
        dynamicLinksNavigator.showTopic(multipleTypeTopic);
    }

    static void mav$handleView(DynamicLinksNavigator dynamicLinksNavigator, View view) {
        dynamicLinksNavigator.handleView(view);
    }

    private static class DynamicLinkTreeNodeData {
        private String _label;
        private MultipleTypeTopic _topic;

        public DynamicLinkTreeNodeData(String string) {
            this._label = string;
        }

        public DynamicLinkTreeNodeData(MultipleTypeTopic multipleTypeTopic) {
            this._topic = multipleTypeTopic;
        }

        public String toString() {
            if (this._topic == null) {
                return this._label;
            }
            return this._topic.getLabel();
        }

        public String getLabel() {
            return this.toString();
        }

        public void setLabel(String string) {
            this._label = string;
        }

        public MultipleTypeTopic getTopic() {
            return this._topic;
        }
    }

    private static class DynamicLinkTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private Icon defaultLeafIcon = IdeIcons.getIcon((int)2);

        public DynamicLinkTreeCellRenderer() {
            super.setOpenIcon(IdeArb.getIcon((int)55));
            super.setClosedIcon(IdeIcons.getIcon((int)4));
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object != null) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                DynamicLinkTreeNodeData dynamicLinkTreeNodeData = (DynamicLinkTreeNodeData)defaultMutableTreeNode.getUserObject();
                this.setToolTipText(dynamicLinkTreeNodeData.getLabel());
                this.setText(dynamicLinkTreeNodeData.getLabel());
                MultipleTypeTopic multipleTypeTopic = dynamicLinkTreeNodeData.getTopic();
                if (multipleTypeTopic != null) {
                    int n2 = multipleTypeTopic.getTopicType();
                    if (n2 == 2) {
                        this.setIcon(HelpArb.getIcon(103));
                    } else if (n2 == 3) {
                        this.setIcon(HelpArb.getIcon(107));
                    } else {
                        this.setIcon(this.defaultLeafIcon);
                    }
                }
            }
            return this;
        }
    }

    private class LinkMouseInputAdapter
    extends MouseInputAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            MultipleTypeTopic multipleTypeTopic;
            if (mouseEvent.getClickCount() == 2 && (multipleTypeTopic = this.getTopic(mouseEvent)) != null) {
                DynamicLinksNavigator.mav$showTopic(DynamicLinksNavigator.this, multipleTypeTopic);
            }
        }

        private MultipleTypeTopic getTopic(MouseEvent mouseEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            JTree jTree = (JTree)mouseEvent.getComponent();
            TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()) != null) {
                DynamicLinkTreeNodeData dynamicLinkTreeNodeData = (DynamicLinkTreeNodeData)defaultMutableTreeNode.getUserObject();
                return dynamicLinkTreeNodeData.getTopic();
            }
            return null;
        }

        private LinkMouseInputAdapter() {
        }

        LinkMouseInputAdapter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class PressAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTree jTree = (JTree)actionEvent.getSource();
            TreePath treePath = jTree.getSelectionPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            DynamicLinkTreeNodeData dynamicLinkTreeNodeData = (DynamicLinkTreeNodeData)defaultMutableTreeNode.getUserObject();
            MultipleTypeTopic multipleTypeTopic = dynamicLinkTreeNodeData.getTopic();
            DynamicLinksNavigator.mav$showTopic(DynamicLinksNavigator.this, multipleTypeTopic);
        }

        private PressAction() {
        }

        PressAction(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DLPaletteWindowListener
    implements PaletteListener {
        private View _view;

        public DLPaletteWindowListener(View view) {
            this._view = view;
        }

        public void itemPressed(PaletteEvent paletteEvent) {
            DynamicLinksNavigator.mav$handleView(DynamicLinksNavigator.this, this._view);
        }

        public void paletteClosed(PaletteEvent paletteEvent) {
        }

        public void paletteOpened(PaletteEvent paletteEvent) {
        }

        public void stickyModeActivated(PaletteEvent paletteEvent) {
        }

        public void stickyModeDeactivated(PaletteEvent paletteEvent) {
        }

        public void selectionChanged(PaletteEvent paletteEvent) {
            DynamicLinksNavigator.mav$handleView(DynamicLinksNavigator.this, this._view);
        }
    }
}

