/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.help.CustomProtocolHandler;
import oracle.help.common.IndirectTarget;
import oracle.help.common.Topic;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.htmlBrowser.ICEBrowser;
import oracle.help.library.Library;
import oracle.help.navigator.favoritesNavigator.FavoritesActionUtils;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;
import oracle.help.navigator.tocNavigator.TOCNavigator;
import oracle.help.topicDisplay.BrowserTopicDisplay;
import oracle.help.topicDisplay.CustomProtocolRegistry;
import oracle.help.topicDisplay.SimpleTopicDisplayPanel;
import oracle.help.topicDisplay.TopicDisplay;
import oracle.help.topicDisplay.TopicDisplayEvent;
import oracle.help.topicDisplay.TopicDisplayListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.cmd.NewWorkspaceCommand;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockStation;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.keyboard.MultiInputMap;
import oracle.ide.keyboard.MultiMapAdapter;
import oracle.ide.layout.URL2String;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.NewWorkspacePanel;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Pair;
import oracle.ide.view.View;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.ideri.importexport.ExportWizard;
import oracle.ideri.importexport.ImportWizard;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.help.AbstractCustomProtocolHandler;
import oracle.jdevimpl.help.BrowserCueCardDisplay;
import oracle.jdevimpl.help.CueCardOverviewWindow;
import oracle.jdevimpl.help.CueCardSet;
import oracle.jdevimpl.help.DynamicLinkTarget;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpContentWindow;
import oracle.jdevimpl.help.HelpSystemConstants;
import oracle.jdevimpl.help.HelpTopicEditor;
import oracle.jdevimpl.help.HelpWindow;
import oracle.jdevimpl.help.JDevHelpSystemImpl;
import oracle.jdevimpl.help.ModalHelpContentDialog;

public class HelpContentPanel
extends View
implements ContextMenuListener,
TopicDisplayListener {
    private Object _parent;
    private HTMLBrowser _browser;
    private TopicDisplay _topicDisplay;
    private SimpleTopicDisplayPanel _displayPanel;
    private boolean _helpSystemDependent;
    private boolean _syncTOCWithSelection;
    private Library _library;
    private boolean _displayedInModalDialog;
    private IdeAction _backwardAction;
    private ToolButton _backwardBtn;
    private JMenuItem _backwardMenu;
    private IdeAction _forwardAction;
    private ToolButton _forwardBtn;
    private IdeAction _copyAction;
    private JMenuItem _forwardMenu;
    private IdeAction _printAction;
    private ToolButton _printBtn;
    private JMenuItem _printMenu;
    private IdeAction _findAction;
    private ToolButton _findBtn;
    private JMenuItem _findMenu;
    private JMenuItem _copyMenu;
    private IdeAction _openOverviewAction;
    private IdeAction _openOverviewLocalAction;
    private ToggleToolButton _openOverviewBtn;
    private JMenuItem _openOverviewMenu;
    private JPanel _mainPanel;
    private Controller _controller;
    Toolbar _toolbar;
    private ContextMenu _contextMenu;
    private MouseListener _mouseListener;
    private IdeAction _contextMenuAction;
    private IdeAction _exitAction;
    private IdeAction _selectAllAction;
    private JMenuItem _selectAllMenu;
    private IdeAction _addFavoriteAction;
    private ToolButton _addFavoriteBtn;
    private JMenuItem _addFavoriteMenu;
    private boolean _cueCardViewer;
    private ModalHelpContentDialog _helpDialog;
    private boolean _displayToolbar;
    private ChangeListener _changeListener;
    private static final List _protocolRegistryList = new ArrayList();
    private static final String VIEWID_STRING = "HelpSystemAddin.HelpContentPanel";
    private static final Class HTML_BROWSER_CLASS = ICEBrowser.class;

    void $init$() {
        this._displayToolbar = true;
    }

    public HelpContentPanel(Library library, boolean bl, boolean bl2, Object object) {
        super(VIEWID_STRING);
        this.$init$();
        this._library = library;
        this._helpSystemDependent = true;
        this._syncTOCWithSelection = bl;
        this._displayedInModalDialog = bl2;
        this._parent = object;
        this._init();
    }

    public HelpContentPanel(Library library, boolean bl, Object object) {
        this(library, bl, false, object);
    }

    public HelpContentPanel(Library library, Object object) {
        this(library, true, false, object);
    }

    public HelpContentPanel(Object object) {
        super(VIEWID_STRING);
        this.$init$();
        this._parent = object;
        this._helpSystemDependent = false;
        this._displayedInModalDialog = false;
        this._init();
    }

    public HelpContentPanel(JEWTDialog jEWTDialog) {
        super(VIEWID_STRING);
        this.$init$();
        this._parent = jEWTDialog;
        this._helpSystemDependent = false;
        this._displayedInModalDialog = false;
        this._displayToolbar = false;
        this._init();
    }

    public HelpContentPanel(Library library) {
        super(VIEWID_STRING);
        this.$init$();
        this._library = library;
        this._cueCardViewer = true;
        this._helpSystemDependent = true;
        this._displayedInModalDialog = false;
        this._init();
    }

    public void displayTopic(Topic topic) {
        block3: {
            try {
                this._displayPanel.displayTopic(topic);
            }
            catch (Exception exception) {
                String string = null;
                if (!topic.hasTarget()) break block3;
                if (topic.getTarget() instanceof IndirectTarget) {
                    IndirectTarget indirectTarget = (IndirectTarget)topic.getTarget();
                    string = indirectTarget.getTargetName();
                }
                if (!(topic.getTarget() instanceof DynamicLinkTarget)) break block3;
                DynamicLinkTarget dynamicLinkTarget = (DynamicLinkTarget)topic.getTarget();
                string = dynamicLinkTarget.getTopicId();
            }
        }
    }

    public HTMLBrowser getBrowser() {
        return this._browser;
    }

    public TopicDisplay getTopicPanel() {
        return this._displayPanel;
    }

    BrowserCueCardDisplay getBrowserCueCardDisplay() {
        if (this._cueCardViewer) {
            return (BrowserCueCardDisplay)this._topicDisplay;
        }
        return null;
    }

    public void runFindDialog() {
        this._browser.runFindDialog();
    }

    public Controller getController() {
        return this._controller;
    }

    public ContextMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu();
            this._backwardMenu = this._contextMenu.createMenuItem((ToggleAction)this._backwardAction);
            this._forwardMenu = this._contextMenu.createMenuItem((ToggleAction)this._forwardAction);
            this._printMenu = this._contextMenu.createMenuItem((ToggleAction)this._printAction);
            this._findMenu = this._contextMenu.createMenuItem((ToggleAction)this._findAction);
            this._copyMenu = this._contextMenu.createMenuItem((ToggleAction)this._copyAction);
            this._selectAllMenu = this._contextMenu.createMenuItem((ToggleAction)this._selectAllAction);
            this._addFavoriteMenu = this._contextMenu.createMenuItem((ToggleAction)this._addFavoriteAction);
            if (this._cueCardViewer) {
                this._openOverviewMenu = this._contextMenu.createMenuItem((ToggleAction)this._openOverviewLocalAction);
            }
            this._contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
        return this._contextMenu;
    }

    public Component getGUI() {
        return this._mainPanel;
    }

    public void dispose() {
        if (this._displayPanel != null) {
            this._displayPanel.dispose();
            this._displayPanel = null;
        }
        if (this._toolbar != null) {
            this._toolbar.dispose();
            this._toolbar = null;
        }
        if (this._changeListener != null) {
            KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
            keyStrokeOptions.removeChangeListener(this._changeListener);
            this._changeListener = null;
        }
        this._parent = null;
        if (this._controller != null) {
            this.removeControllerFromAction(this._backwardAction);
            this.removeControllerFromAction(this._forwardAction);
            this.removeControllerFromAction(this._copyAction);
            this.removeControllerFromAction(this._findAction);
            this.removeControllerFromAction(this._printAction);
            this.removeControllerFromAction(this._exitAction);
            this.removeControllerFromAction(this._contextMenuAction);
            this.removeControllerFromAction(this._selectAllAction);
            this.removeControllerFromAction(this._addFavoriteAction);
            this.removeControllerFromAction(IdeAction.find((int)22));
        }
    }

    boolean isCueCardViewer() {
        return this._cueCardViewer;
    }

    void setOverviewWindowBtnSelected(boolean bl) {
        this._openOverviewBtn.setSelected(bl);
    }

    public boolean canGoBackward() {
        return this._displayPanel.canGoBack();
    }

    public boolean canGoForward() {
        return this._displayPanel.canGoForward();
    }

    public void goBackward() {
        this._displayPanel.goBack();
    }

    public void goForward() {
        this._displayPanel.goForward();
    }

    public boolean isTextSelected() {
        return this._browser.getSelectedText() != null;
    }

    public void copy() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setText(this._browser.getSelectedText());
        jTextArea.selectAll();
        jTextArea.copy();
    }

    public static Class getHTMLBrowserClass() {
        return HTML_BROWSER_CLASS;
    }

    public static HTMLBrowser createHTMLBrowser() {
        HTMLBrowser hTMLBrowser = null;
        try {
            hTMLBrowser = (HTMLBrowser)HelpContentPanel.getHTMLBrowserClass().newInstance();
            hTMLBrowser.setLocale(StaticLocaleContext.getLocale());
            if (StaticLocaleContext.getEncoding() != null) {
                hTMLBrowser.setCharset(StaticLocaleContext.getEncoding());
            }
            HTMLBrowser hTMLBrowser2 = hTMLBrowser;
            return hTMLBrowser2;
        }
        catch (Exception exception) {
            HTMLBrowser hTMLBrowser3 = null;
            return hTMLBrowser3;
        }
    }

    public Object getParent() {
        return this._parent;
    }

    public void syncTOCToURL(URL uRL) {
        HelpWindow helpWindow = (HelpWindow)DockStation.getDockStation().getDockable(new ViewId("HelpSystemAddin.HelpWindow"));
        if (helpWindow == null) {
            return;
        }
        if (!this._cueCardViewer) {
            TOCNavigator tOCNavigator;
            if (this._syncTOCWithSelection && (tOCNavigator = helpWindow.getTOCNavigator()) != null && tOCNavigator.isVisible()) {
                tOCNavigator.selectMatchingTopic(uRL);
            }
        } else {
            CueCardOverviewWindow cueCardOverviewWindow = helpWindow.getCueCardOverviewWindow(false);
            if (cueCardOverviewWindow != null) {
                cueCardOverviewWindow.getCueCardOverviewPanel().selectMatchingURL(uRL);
            }
        }
    }

    public void menuWillShow(ContextMenu contextMenu) {
        float f = JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU;
        this._contextMenu.add((Component)this._backwardMenu, f);
        this._contextMenu.add((Component)this._forwardMenu, f);
        this._contextMenu.add((Component)this._copyMenu, f += 0.001f);
        this._contextMenu.add((Component)this._selectAllMenu, f += 0.001f);
        this._contextMenu.add((Component)this._findMenu, f += 0.001f);
        this._contextMenu.add((Component)this._printMenu, f += 0.001f);
        f += 0.001f;
        if (this._cueCardViewer) {
            this._contextMenu.add((Component)this._openOverviewMenu, f);
        } else {
            this._contextMenu.add((Component)this._addFavoriteMenu, f);
        }
        if (this.canGoBackward()) {
            this._backwardMenu.setEnabled(true);
        } else {
            this._backwardMenu.setEnabled(false);
        }
        if (this.canGoForward()) {
            this._forwardMenu.setEnabled(true);
        } else {
            this._forwardMenu.setEnabled(false);
        }
        if (this._browser.getSelectedText() != null) {
            this._copyMenu.setEnabled(true);
        } else {
            this._copyMenu.setEnabled(false);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void _createKeyMappings() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext keyStrokeContext = keyStrokeContextRegistry.getContext("oracle/jdevimpl/help/localaccelerators.xml");
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        MultiInputMap multiInputMap = MultiMapAdapter.getLocalMap((KeyStrokeOptions)keyStrokeOptions, (KeyStrokeContext)keyStrokeContext);
        InputMap inputMap = Ide.getIdeInputMap();
        multiInputMap.setParent(inputMap);
        this._mainPanel.setInputMap(1, (InputMap)multiInputMap);
        this.loadMyMap(multiInputMap, this._mainPanel.getActionMap(), keyStrokeOptions);
        this._changeListener = new 3(this, multiInputMap, keyStrokeOptions, keyStrokeContext);
        keyStrokeOptions.addChangeListener(this._changeListener);
        this._setButtonTooltips();
        JRootPane jRootPane = null;
        if (this._parent instanceof JDialog) {
            jRootPane = ((JDialog)this._parent).getRootPane();
        } else if (this._parent instanceof HelpTopicEditor && ((HelpTopicEditor)((Object)this._parent)).getParent() instanceof HelpContentWindow) {
            HelpTopicEditor helpTopicEditor = (HelpTopicEditor)((Object)this._parent);
            HelpContentWindow helpContentWindow = (HelpContentWindow)helpTopicEditor.getParent();
            jRootPane = helpContentWindow.getRootPane();
        }
        if (jRootPane != null) {
            this._contextMenuAction = IdeAction.newLocalAction((int)50, (View)this);
            this._contextMenuAction.addController(this._controller);
            this._exitAction = IdeAction.newLocalAction((int)4, (View)this);
            this._exitAction.addController(this._controller);
            MultiInputMap multiInputMap2 = new MultiInputMap(true);
            ActionMap actionMap = new ActionMap();
            this.loadMyMap(multiInputMap2, actionMap, keyStrokeOptions);
            ActionMap actionMap2 = jRootPane.getActionMap();
            actionMap2.setParent(actionMap);
            InputMap inputMap2 = jRootPane.getInputMap(1);
            inputMap2.setParent((InputMap)multiInputMap2);
            IdeAction.find((int)23).setEnabled(true);
            IdeAction.find((int)16).setEnabled(true);
            IdeAction.find((int)22).setEnabled(true);
            IdeAction.find((int)50).setEnabled(true);
        }
    }

    private void loadMyMap(MultiInputMap multiInputMap, ActionMap actionMap, KeyStrokeOptions keyStrokeOptions) {
        this.updateMyMapWithAction(keyStrokeOptions, actionMap, multiInputMap, 23, this._findAction);
        this._findAction.setEnabled(true);
        this.updateMyMapWithAction(keyStrokeOptions, actionMap, multiInputMap, 16, this._printAction);
        this._printAction.setEnabled(true);
        this.updateMyMapWithAction(keyStrokeOptions, actionMap, multiInputMap, 22, this._selectAllAction);
        this._selectAllAction.setEnabled(true);
        if (this._contextMenuAction != null) {
            this.updateMyMapWithAction(keyStrokeOptions, actionMap, multiInputMap, 50, this._contextMenuAction);
            this._contextMenuAction.setEnabled(true);
            this.updateMyMapWithAction(keyStrokeOptions, actionMap, multiInputMap, 4, this._exitAction);
            this._exitAction.setEnabled(true);
        }
        this.updateMyMapWithAction(keyStrokeOptions, actionMap, multiInputMap, HelpSystemConstants.FORWARD_CMD_ID, this._forwardAction);
        this.updateMyMapWithAction(keyStrokeOptions, actionMap, multiInputMap, HelpSystemConstants.BACKWARD_CMD_ID, this._backwardAction);
    }

    private void updateMyMapWithAction(KeyStrokeOptions keyStrokeOptions, ActionMap actionMap, MultiInputMap multiInputMap, int n, IdeAction ideAction) {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext keyStrokeContext = keyStrokeContextRegistry.getContext("oracle/jdevimpl/help/localaccelerators.xml");
        List list = this.getKeyStrokesFor(keyStrokeOptions, n, keyStrokeContext);
        if (list != Collections.EMPTY_LIST) {
            int n2 = list.size();
            Integer n3 = new Integer(n);
            int n4 = 0;
            while (n4 < n2) {
                actionMap.put(n3, (Action)ideAction);
                multiInputMap.put((KeyStrokes)list.get(n4), (Object)n3);
                ++n4;
            }
        }
    }

    private List getKeyStrokesFor(KeyStrokeOptions keyStrokeOptions, int n, KeyStrokeContext keyStrokeContext) {
        KeyStrokeMap keyStrokeMap = keyStrokeOptions.getGlobalKeyMap();
        List list = keyStrokeMap.getKeyStrokesFor(n);
        if (list == Collections.EMPTY_LIST) {
            keyStrokeMap = keyStrokeOptions.getLocalKeyMap(keyStrokeContext);
            list = keyStrokeMap.getKeyStrokesFor(n);
        }
        return list;
    }

    private void _setButtonTooltips() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext keyStrokeContext = keyStrokeContextRegistry.getContext("oracle/jdevimpl/help/localaccelerators.xml");
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeMap keyStrokeMap = keyStrokeOptions.getLocalKeyMap(keyStrokeContext);
        KeyStrokeMap keyStrokeMap2 = keyStrokeOptions.getGlobalKeyMap();
        this._setTooltipForButton(this._forwardBtn, keyStrokeMap, keyStrokeMap2);
        this._setTooltipForButton(this._backwardBtn, keyStrokeMap, keyStrokeMap2);
    }

    private void _setTooltipForButton(ToolButton toolButton, KeyStrokeMap keyStrokeMap, KeyStrokeMap keyStrokeMap2) {
        String string;
        IdeAction ideAction = (IdeAction)toolButton.getAction();
        String string2 = (String)ideAction.getValue("ShortDescription");
        if (string2 == null || string2.length() == 0) {
            string2 = (String)ideAction.getValue("Name");
        }
        if ((string = KeyUtil.getAcceleratorTooltip((KeyStrokeMap)keyStrokeMap, (int)ideAction.getCommandId())) == null || string.length() == 0) {
            string = KeyUtil.getAcceleratorTooltip((KeyStrokeMap)keyStrokeMap2, (int)ideAction.getCommandId());
        }
        if (string != null && string.length() != 0) {
            string2 = string2 + " (" + string + ")";
        }
        toolButton.setToolTipText(string2);
    }

    private void _init() {
        this._mainPanel = new JPanel(new BorderLayout());
        this._controller = new HelpTopicPanelController(null);
        String string = IdeArb.getString((int)415);
        this._browser = HelpContentPanel.createHTMLBrowser();
        this._topicDisplay = this._cueCardViewer ? new BrowserCueCardDisplay(this._browser, this._library) : (this._helpSystemDependent ? new BrowserTopicDisplay(this._browser, this._library) : new BrowserTopicDisplay(this._browser));
        this._registerProtocolHandlers();
        this._topicDisplay.addDisplayListener((TopicDisplayListener)this);
        this._displayPanel = new SimpleTopicDisplayPanel(this._topicDisplay, null, null);
        this._displayPanel.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        if (this._displayToolbar) {
            this._backwardAction = IdeAction.newLocalAction((int)HelpSystemConstants.BACKWARD_CMD_ID, (View)this);
            this._backwardAction.addController(this._controller);
            this._backwardBtn = new ToolButton((Action)this._backwardAction);
            this._forwardAction = IdeAction.newLocalAction((int)HelpSystemConstants.FORWARD_CMD_ID, (View)this);
            this._forwardAction.addController(this._controller);
            this._forwardBtn = new ToolButton((Action)this._forwardAction);
            this._printAction = IdeAction.newLocalAction((int)16, (View)this);
            this._printBtn = new ToolButton((Action)this._printAction);
            this._findAction = IdeAction.newLocalAction((int)23, (View)this);
            this._findAction.addController(this._controller);
            this._findBtn = new ToolButton((Action)this._findAction);
            this._copyAction = IdeAction.newLocalAction((int)18, (View)this);
            this._copyAction.addController(this._controller);
            if (this._cueCardViewer) {
                this._openOverviewAction = IdeAction.get((int)HelpSystemConstants.OPEN_OVERVIEW_WINDOW_CMD_ID, (String)"oracle.jdevimpl.help.OpenOverviewWindow", (String)StringUtils.stripMnemonic((String)HelpArb.getString(101)), (String)string, (Integer)HelpArb.getInteger(102), (ArrayResourceBundle)IdeArb.getInstance(), (int)172, null, (boolean)true);
                this._openOverviewLocalAction = this._openOverviewAction.newLocalAction((View)this);
                this._openOverviewLocalAction.addController(this._controller);
                this._openOverviewBtn = new ToggleToolButton((ToggleAction)this._openOverviewLocalAction);
            } else {
                this._addFavoriteAction = IdeAction.newLocalAction((int)HelpSystemConstants.ADD_FAVORITE_CMD_ID, (View)this);
                this._addFavoriteAction.addController(this._controller);
                this._addFavoriteBtn = new ToolButton((Action)this._addFavoriteAction);
            }
            this._selectAllAction = IdeAction.newLocalAction((int)22, (View)this);
            this._selectAllAction.addController(this._controller);
            IdeAction.find((int)22).addController(this._controller);
            this._createKeyMappings();
            this._toolbar = new Toolbar();
            this._toolbar.add((Component)this._printBtn);
            this._toolbar.add((Component)this._findBtn);
            this._toolbar.add((Component)this._backwardBtn);
            this._toolbar.add((Component)this._forwardBtn);
            if (this._cueCardViewer) {
                this._toolbar.add((Component)this._openOverviewBtn);
            } else {
                this._toolbar.add((Component)this._addFavoriteBtn);
            }
            this.installMouseListener();
            this._mainPanel.add((Component)this._toolbar, "North");
        }
        this._mainPanel.add((Component)this._displayPanel, "Center");
    }

    private void _registerProtocolHandlers() {
        if (_protocolRegistryList.size() == 0) {
            _protocolRegistryList.add(new Pair((Object)"external", (Object)new ExternalBrowserHandler(null)));
            _protocolRegistryList.add(new Pair((Object)"jdevIdeSettings", (Object)new IdeSettingsHandler(null)));
            _protocolRegistryList.add(new Pair((Object)"jdevInvokableWizard", (Object)new InvokableWizardHandler(null)));
            _protocolRegistryList.add(new Pair((Object)"jdevInvokableAction", (Object)new InvokableActionHandler(null)));
            _protocolRegistryList.add(new Pair((Object)"jdevProjectSettings", (Object)new IdeProjectSettingsHandler(null)));
            _protocolRegistryList.add(new Pair((Object)"jdevLoadIntoEditor", (Object)new LoadIntoEditorHandler(null)));
            _protocolRegistryList.add(new Pair((Object)"jdevFileReopen", (Object)new FileReopenHandler(null)));
            _protocolRegistryList.add(new Pair((Object)"jdevShowTopic", (Object)new InitAndInvokeHandler(null)));
            _protocolRegistryList.add(new Pair((Object)"jdevShowHelpInWindow", (Object)new ShowHelpInWindowHandler(null)));
            _protocolRegistryList.add(new Pair((Object)"jdevShowCueCard", (Object)new CueCardHandler(null)));
            _protocolRegistryList.add(new Pair((Object)"jdevShowCueCardList", (Object)new CueCardListHandler(null)));
            _protocolRegistryList.add(new Pair((Object)"jdevInvokeBrowserOnFile", (Object)new BrowserOnFileHandler(null)));
        }
        CustomProtocolRegistry customProtocolRegistry = new CustomProtocolRegistry(this._browser);
        int n = _protocolRegistryList.size();
        int n2 = 0;
        while (n2 < n) {
            Pair pair = (Pair)_protocolRegistryList.get(n2);
            customProtocolRegistry.registerCustomProtocolHandler((String)pair.getFirst(), (CustomProtocolHandler)pair.getSecond());
            ++n2;
        }
    }

    private void removeControllerFromAction(IdeAction ideAction) {
        if (ideAction != null) {
            ideAction.removeController(this._controller);
        }
    }

    public void topicDisplayChanged(TopicDisplayEvent topicDisplayEvent) {
        if (topicDisplayEvent.getID() == 2000 && (topicDisplayEvent.getChangeType() == 0 || topicDisplayEvent.getChangeType() == 2)) {
            if (this._parent instanceof HelpTopicEditor) {
                ((HelpTopicEditor)((Object)this._parent)).getHelpTopicDocument().setURL(topicDisplayEvent.getURL());
            }
            this.updateActions();
            if (topicDisplayEvent.getChangeType() == 0) {
                this.syncTOCToURL(topicDisplayEvent.getURL());
            }
            if (JDevHelpSystemImpl.isDocWriter() && HelpSystem.getHelpSystem() instanceof JDevHelpSystemImpl) {
                JDevHelpSystemImpl jDevHelpSystemImpl = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
                jDevHelpSystemImpl.printTopicForDebugging(null, null, topicDisplayEvent.getURL());
            }
        }
    }

    private void updateActions() {
        2 var1_1 = new 2();
        SwingUtilities.invokeLater(var1_1);
    }

    protected void installMouseListener() {
        JComponent jComponent;
        if (this._mouseListener == null) {
            this._mouseListener = new 1();
        }
        if ((jComponent = GraphicsUtils.getFocusableComponentOrChild((Component)this._displayPanel, (boolean)true)) != null) {
            jComponent.addMouseListener(this._mouseListener);
        }
    }

    protected void triggerPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            Component component = mouseEvent.getComponent();
            component.requestFocus();
            ContextMenu contextMenu = this.getContextMenu();
            if (contextMenu == null) {
                return;
            }
            Context context = this.getContext(mouseEvent);
            contextMenu.show(context);
        }
    }

    static JPanel ra$_mainPanel(HelpContentPanel helpContentPanel) {
        return helpContentPanel._mainPanel;
    }

    static void mav$loadMyMap(HelpContentPanel helpContentPanel, MultiInputMap multiInputMap, ActionMap actionMap, KeyStrokeOptions keyStrokeOptions) {
        helpContentPanel.loadMyMap(multiInputMap, actionMap, keyStrokeOptions);
    }

    static void mav$_setButtonTooltips(HelpContentPanel helpContentPanel) {
        helpContentPanel._setButtonTooltips();
    }

    static IdeAction ra$_printAction(HelpContentPanel helpContentPanel) {
        return helpContentPanel._printAction;
    }

    static IdeAction ra$_findAction(HelpContentPanel helpContentPanel) {
        return helpContentPanel._findAction;
    }

    static IdeAction ra$_selectAllAction(HelpContentPanel helpContentPanel) {
        return helpContentPanel._selectAllAction;
    }

    static IdeAction ra$_forwardAction(HelpContentPanel helpContentPanel) {
        return helpContentPanel._forwardAction;
    }

    static IdeAction ra$_backwardAction(HelpContentPanel helpContentPanel) {
        return helpContentPanel._backwardAction;
    }

    static TopicDisplay ra$_topicDisplay(HelpContentPanel helpContentPanel) {
        return helpContentPanel._topicDisplay;
    }

    static Library ra$_library(HelpContentPanel helpContentPanel) {
        return helpContentPanel._library;
    }

    static ModalHelpContentDialog ra$_helpDialog(HelpContentPanel helpContentPanel) {
        return helpContentPanel._helpDialog;
    }

    static void wa$_helpDialog(HelpContentPanel helpContentPanel, ModalHelpContentDialog modalHelpContentDialog) {
        helpContentPanel._helpDialog = modalHelpContentDialog;
    }

    public final class 3
    implements ChangeListener {
        private final /* synthetic */ MultiInputMap v$imap;
        private final /* synthetic */ KeyStrokeOptions v$kso;
        private final /* synthetic */ KeyStrokeContext v$ksc;
        final /* synthetic */ HelpContentPanel this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            MultiMapAdapter.fillLocalMap((MultiInputMap)this.v$imap, (KeyStrokeOptions)this.v$kso, (KeyStrokeContext)this.v$ksc);
            HelpContentPanel.mav$loadMyMap(this.this$0, this.v$imap, HelpContentPanel.ra$_mainPanel(this.this$0).getActionMap(), this.v$kso);
            HelpContentPanel.mav$_setButtonTooltips(this.this$0);
        }

        public 3(HelpContentPanel helpContentPanel, MultiInputMap multiInputMap, KeyStrokeOptions keyStrokeOptions, KeyStrokeContext keyStrokeContext) {
            this.v$ksc = keyStrokeContext;
            this.v$kso = keyStrokeOptions;
            this.v$imap = multiInputMap;
            this.this$0 = helpContentPanel;
        }
    }

    public final class 2
    implements Runnable {
        public void run() {
            if (HelpContentPanel.ra$_printAction(HelpContentPanel.this) != null) {
                HelpContentPanel.ra$_printAction(HelpContentPanel.this).setEnabled(true);
            }
            if (HelpContentPanel.ra$_findAction(HelpContentPanel.this) != null) {
                HelpContentPanel.ra$_findAction(HelpContentPanel.this).setEnabled(true);
            }
            if (HelpContentPanel.ra$_selectAllAction(HelpContentPanel.this) != null) {
                HelpContentPanel.ra$_selectAllAction(HelpContentPanel.this).setEnabled(true);
            }
            if (HelpContentPanel.ra$_forwardAction(HelpContentPanel.this) != null) {
                HelpContentPanel.ra$_forwardAction(HelpContentPanel.this).setEnabled(HelpContentPanel.this.canGoForward());
            }
            if (HelpContentPanel.ra$_backwardAction(HelpContentPanel.this) != null) {
                HelpContentPanel.ra$_backwardAction(HelpContentPanel.this).setEnabled(HelpContentPanel.this.canGoBackward());
            }
        }
    }

    public final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            HelpContentPanel.this.triggerPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            HelpContentPanel.this.triggerPopup(mouseEvent);
        }
    }

    private class HelpTopicPanelController
    implements Controller {
        public boolean update(IdeAction ideAction, Context context) {
            View view;
            if (context != null && ((view = context.getView()) instanceof HelpContentPanel || view instanceof HelpTopicEditor)) {
                int n = ideAction.getCommandId();
                if (n == 23) {
                    ideAction.setEnabled(true);
                    return true;
                }
                if (n == 50) {
                    ideAction.setEnabled(true);
                    return true;
                }
                if (n == HelpSystemConstants.FORWARD_CMD_ID) {
                    if (HelpContentPanel.this.canGoForward()) {
                        ideAction.setEnabled(true);
                    } else {
                        ideAction.setEnabled(false);
                    }
                    return true;
                }
                if (n == HelpSystemConstants.BACKWARD_CMD_ID) {
                    if (HelpContentPanel.this.canGoBackward()) {
                        ideAction.setEnabled(true);
                    } else {
                        ideAction.setEnabled(false);
                    }
                    return true;
                }
                if (n == 16) {
                    ideAction.setEnabled(true);
                    return true;
                }
                if (n == 18) {
                    ideAction.setEnabled(HelpContentPanel.this.isTextSelected());
                    return true;
                }
                if (n == HelpSystemConstants.ADD_FAVORITE_CMD_ID) {
                    ideAction.setEnabled(true);
                    return true;
                }
                if (n == 22) {
                    ideAction.setEnabled(true);
                    return true;
                }
                if (n == HelpSystemConstants.OPEN_OVERVIEW_WINDOW_CMD_ID) {
                    HelpContentPanel helpContentPanel;
                    boolean bl = false;
                    if (view instanceof HelpContentPanel && (helpContentPanel = (HelpContentPanel)view).isCueCardViewer()) {
                        bl = true;
                    }
                    ideAction.setEnabled(bl);
                    return true;
                }
                ideAction.setEnabled(false);
            }
            return false;
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (!(context.getView() instanceof HelpContentPanel) && !(context.getView() instanceof HelpTopicEditor)) {
                return false;
            }
            if (n == HelpSystemConstants.FORWARD_CMD_ID) {
                HelpContentPanel.this.goForward();
                return true;
            }
            if (n == HelpSystemConstants.BACKWARD_CMD_ID) {
                HelpContentPanel.this.goBackward();
                return true;
            }
            if (n == 23) {
                HelpContentPanel.this.runFindDialog();
                return true;
            }
            if (n == 18) {
                HelpContentPanel.this.copy();
                return true;
            }
            if (n == HelpSystemConstants.ADD_FAVORITE_CMD_ID) {
                HelpSystem helpSystem = HelpSystem.getHelpSystem();
                if (helpSystem != null && helpSystem instanceof JDevHelpSystemImpl) {
                    FavoritesModel favoritesModel = ((JDevHelpSystemImpl)helpSystem).getFavoritesModel();
                    if (favoritesModel != null) {
                        FavoritesActionUtils.addFavoriteItem((FavoritesModel)favoritesModel, (TopicDisplay)HelpContentPanel.ra$_topicDisplay(HelpContentPanel.this), (Frame)Ide.getMainWindow());
                    } else {
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), HelpArb.getString(85), HelpArb.getString(84), 0);
                    }
                }
                return true;
            }
            if (n == HelpSystemConstants.OPEN_OVERVIEW_WINDOW_CMD_ID) {
                HelpWindow helpWindow = (HelpWindow)DockStation.getDockStation().getDockable(new ViewId("HelpSystemAddin.HelpWindow"));
                CueCardOverviewWindow cueCardOverviewWindow = helpWindow.getCueCardOverviewWindow(false);
                if (cueCardOverviewWindow != null) {
                    cueCardOverviewWindow.close();
                } else {
                    cueCardOverviewWindow = helpWindow.getCueCardOverviewWindow(true);
                    CueCardSet cueCardSet = HelpContentPanel.this.getBrowserCueCardDisplay().getCueCardSet();
                    cueCardOverviewWindow.getCueCardOverviewPanel().setCueCardSet(cueCardSet);
                    URL uRL = HelpContentPanel.this.getBrowserCueCardDisplay().getCurrentURL();
                    cueCardOverviewWindow.getCueCardOverviewPanel().selectMatchingURL(uRL);
                }
                return true;
            }
            if (n == 22) {
                HelpContentPanel helpContentPanel = null;
                helpContentPanel = context.getView() instanceof HelpTopicEditor ? ((HelpTopicEditor)context.getView()).getHelpContentPanel() : (HelpContentPanel)context.getView();
                helpContentPanel.getBrowser().selectAll();
                return true;
            }
            if (n == 4 && ideAction.isLocalAction()) {
                HelpContentPanel helpContentPanel = (HelpContentPanel)context.getView();
                Object object = helpContentPanel.getParent();
                Window window = null;
                if (object instanceof JDialog) {
                    window = (Window)object;
                } else if (object instanceof HelpTopicEditor && ((HelpTopicEditor)((Object)object)).getParent() instanceof HelpContentWindow) {
                    window = (Window)((HelpTopicEditor)((Object)object)).getParent();
                }
                window.hide();
                window.dispose();
                return true;
            }
            if (n == 50) {
                int n2;
                int n3;
                JPanel jPanel = HelpContentPanel.ra$_mainPanel(HelpContentPanel.this);
                Container container = jPanel.getParent();
                if (jPanel.getParent() instanceof JViewport) {
                    JViewport jViewport = (JViewport)container;
                    Point point = jViewport.getViewPosition();
                    n3 = point.x;
                    n2 = point.y;
                } else {
                    n3 = ((Component)jPanel).getX();
                    n2 = ((Component)jPanel).getY();
                }
                MouseEvent mouseEvent = new MouseEvent(jPanel, 502, System.currentTimeMillis(), 0, n3, n2, 1, true);
                Context context2 = HelpContentPanel.this.getContext(mouseEvent);
                context2.setEvent((EventObject)mouseEvent);
                ContextMenu contextMenu = HelpContentPanel.this.getContextMenu();
                contextMenu.show(context2);
                return true;
            }
            return false;
        }

        private HelpTopicPanelController() {
        }

        HelpTopicPanelController(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class ExternalBrowserHandler
    implements CustomProtocolHandler {
        public static final String PROTOCOL_NAME = "external";

        public void handleValue(String string) {
            try {
                BrowserRunner.getBrowserRunner().runBrowserOnURL(new URL(string), null, null);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)HelpArb.format(139, string));
            }
        }

        private ExternalBrowserHandler() {
        }

        ExternalBrowserHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class IdeSettingsHandler
    extends AbstractCustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevIdeSettings";

        public void handleValue(String string) {
            if (string.equals("main")) {
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow());
            } else {
                String[] stringArray = this.parseString(string);
                if (stringArray != null) {
                    Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), stringArray);
                } else {
                    Ide.getSettings().showDialog((Frame)Ide.getMainWindow());
                }
            }
        }

        private String[] parseString(String string) {
            List list = super.parseInputString(string);
            return super.parseTranslatableTextList(list);
        }

        private IdeSettingsHandler() {
        }

        IdeSettingsHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class IdeProjectSettingsHandler
    extends AbstractCustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevProjectSettings";

        public void handleValue(String string) {
            Project project = null;
            if (Ide.getLastActiveNavigator() != null) {
                project = Ide.getLastActiveNavigator().getContext().getProject();
            }
            if (project == null) {
                project = Ide.getActiveProject();
            }
            if (project == null) {
                return;
            }
            if (string.equals("main")) {
                ProjectPropertiesDialog.showDialog((Project)project);
            } else {
                String[] stringArray = this.parseString(string);
                if (stringArray != null) {
                    ProjectPropertiesDialog.showDialog((Frame)Ide.getMainWindow(), (Project)project, (String[])stringArray);
                } else {
                    ProjectPropertiesDialog.showDialog((Project)project);
                }
            }
        }

        private String[] parseString(String string) {
            List list = super.parseInputString(string);
            return super.parseTranslatableTextList(list);
        }

        private IdeProjectSettingsHandler() {
        }

        IdeProjectSettingsHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class InvokableWizardHandler
    extends AbstractCustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevInvokableWizard";
        public static final String[] wizardsRequiringWorkspace = new String[]{"oracle.jdevimpl.wizard.project.NewApplicationProjectWizard", "oracle.jdevimpl.wizard.project.NewEmptyProjectWizard"};
        public static final String[] wizardsRequiringProject = new String[]{"oracle.jdeveloper.builder.cls.ClassBuilder", "oracle.jdeveloper.builder.ui.dialog.DialogBuilder", "oracle.jdeveloper.builder.iface.InterfaceBuilder", "oracle.jdeveloper.builder.application.ApplicationBuilder", "oracle.jdevimpl.webapp.jsp.wizards.JspWizard", "oracle.jbo.dt.jdevx.ui.JdxPKEntityAddin", "oracle.jdevimpl.webapp.jsp.taglibraries.jsf.JsfJspWizard", "oracle.jdevimpl.ejb.ejbwiz.NewSessionEjbWizard", "oracle.jdeveloper.offlinedb.wizard.ImportWizard", "oracle.toplink.addin.wizard.jobgeneration.JobWizard", "oracle.jdevimpl.ejb.ejbwiz.NewEjbWizard", "oracle.toplink.addin.wizard.mapcreation.TopLinkCMPMapWizard", "oracle.jdeveloper.dbmodeler.diagram.DBModelWizard", "oracle.jdeveloper.ejb.modeler.diagram.EJBModelWizard", "oracle.jdevimpl.ejb.ejbwiz.NewEjbEntityWizard"};

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void handleValue(String string) {
            List list = super.parseInputString(string);
            String string2 = (String)list.remove(0);
            int n = list.size();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = (String)list.get(n2);
                ++n2;
            }
            boolean bl = false;
            int n3 = 0;
            while (n3 < wizardsRequiringWorkspace.length) {
                if (string2.equals(wizardsRequiringWorkspace[n3])) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            boolean bl2 = false;
            int n4 = 0;
            while (n4 < wizardsRequiringProject.length) {
                if (string2.equals(wizardsRequiringProject[n4])) {
                    bl2 = true;
                    break;
                }
                ++n4;
            }
            Context context = null;
            if (Ide.getLastActiveNavigator() != null) {
                context = Ide.getLastActiveNavigator().getContext();
            } else {
                context = Context.newIdeContext();
                context.setWorkspace(Ide.getActiveWorkspace());
                context.setProject(Ide.getActiveProject());
            }
            if (bl && context.getWorkspace() == null) {
                NewWorkspacePanel newWorkspacePanel = new NewWorkspacePanel(false, false, true);
                if (!newWorkspacePanel.runDialog()) {
                    return;
                }
                URL uRL = newWorkspacePanel.getFileURL();
                try {
                    Workspace workspace = NewWorkspaceCommand.createEmptyWorkspace((Context)context, (URL)uRL);
                    context.setWorkspace(workspace);
                    Ide.setActiveWorkspace((Workspace)workspace);
                }
                catch (Exception exception) {
                    return;
                }
            }
            if (bl2 && context.getProject() == null) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), HelpArb.getString(142), HelpArb.getString(141), 0);
                return;
            }
            WizardManager wizardManager = WizardManager.getInstance();
            Wizard wizard = wizardManager.getWizard(string2);
            if (wizard != null) {
                if (wizardManager.invokeWizard(wizard, context, stringArray, null)) return;
            }
            try {
                Class<?> clazz = Class.forName(string2);
                if (ExportWizard.class.isAssignableFrom(clazz)) {
                    ExportWizard exportWizard = (ExportWizard)clazz.newInstance();
                    if (!exportWizard.isAvailableAsExportWizard(context)) return;
                    exportWizard.invokeExportWizard(context, stringArray);
                    return;
                } else {
                    ImportWizard importWizard;
                    if (!ImportWizard.class.isAssignableFrom(clazz) || !(importWizard = (ImportWizard)clazz.newInstance()).isAvailableAsImportWizard(context)) return;
                    importWizard.invokeImportWizard(context, stringArray);
                }
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private InvokableWizardHandler() {
        }

        InvokableWizardHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class InvokableActionHandler
    extends AbstractCustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevInvokableAction";

        public void handleValue(String string) {
            block10: {
                List list = super.parseInputString(string);
                String string2 = (String)list.remove(0);
                int n = list.size();
                String[] stringArray = new String[n];
                int n2 = 1;
                while (n2 < n) {
                    stringArray[n2] = (String)list.get(n2);
                    ++n2;
                }
                Context context = null;
                if (Ide.getLastActiveNavigator() != null) {
                    context = Ide.getLastActiveNavigator().getContext();
                } else {
                    context = Context.newIdeContext();
                    context.setWorkspace(Ide.getActiveWorkspace());
                    context.setProject(Ide.getActiveProject());
                }
                Integer n3 = Ide.findCmdID((String)string2);
                if (n3 == null) {
                    try {
                        Field field;
                        Object object;
                        int n4 = string2.lastIndexOf(46);
                        String string3 = string2.substring(0, n4);
                        String string4 = string2.substring(n4 + 1);
                        Class<?> clazz = Class.forName(string3);
                        if (clazz != null && (object = (field = clazz.getField(string4)).get(null)) != null && object instanceof Integer) {
                            n3 = (Integer)object;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return;
                    }
                }
                if (n3 == null) break block10;
                IdeAction ideAction = IdeAction.find((int)n3);
                ideAction.updateAction(context);
                if (ideAction != null && ideAction.isEnabled()) {
                    try {
                        ideAction.performAction(context);
                    }
                    catch (Exception exception) {}
                }
            }
        }

        private InvokableActionHandler() {
        }

        InvokableActionHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private final class LoadIntoEditorHandler
    implements CustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevLoadIntoEditor";

        public void handleValue(String string) {
            EditorManager editorManager;
            URL uRL;
            if (HelpContentPanel.ra$_library(HelpContentPanel.this) != null && (uRL = HelpContentPanel.ra$_library(HelpContentPanel.this).mapIDToURL(string)) != null && (editorManager = EditorManager.getEditorManager()) != null) {
                editorManager.openDefaultEditorInFrame(uRL);
            }
        }

        private LoadIntoEditorHandler() {
        }

        LoadIntoEditorHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class InitAndInvokeHandler
    implements CustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevShowTopic";

        public void handleValue(String string) {
            JDevHelpSystemImpl jDevHelpSystemImpl;
            Library library;
            HelpSystem helpSystem = HelpSystem.getHelpSystem();
            if (helpSystem != null && helpSystem instanceof JDevHelpSystemImpl && (library = (jDevHelpSystemImpl = (JDevHelpSystemImpl)helpSystem).getLibrary()) != null) {
                jDevHelpSystemImpl.goTo(string);
            }
        }

        private InitAndInvokeHandler() {
        }

        InitAndInvokeHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class ShowHelpInWindowHandler
    implements CustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevShowHelpInWindow";

        public void handleValue(String string) {
            HelpSystem helpSystem = HelpSystem.getHelpSystem();
            if (helpSystem != null && helpSystem instanceof JDevHelpSystemImpl) {
                JDevHelpSystemImpl jDevHelpSystemImpl = (JDevHelpSystemImpl)helpSystem;
                Library library = jDevHelpSystemImpl.getLibrary();
                Topic topic = jDevHelpSystemImpl.getTopicForString(string);
                if (topic != null && library != null) {
                    if (HelpContentPanel.ra$_helpDialog(HelpContentPanel.this) == null) {
                        HelpContentPanel.wa$_helpDialog(HelpContentPanel.this, new ModalHelpContentDialog((Frame)Ide.getMainWindow(), library, null));
                        HelpContentPanel.ra$_helpDialog(HelpContentPanel.this).addWindowListener(new HelpWindowAdapter(null));
                    }
                    HelpContentPanel.ra$_helpDialog(HelpContentPanel.this).show(topic);
                }
            }
        }

        private ShowHelpInWindowHandler() {
        }

        ShowHelpInWindowHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class HelpWindowAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            HelpContentPanel.wa$_helpDialog(HelpContentPanel.this, null);
        }

        public void windowClosed(WindowEvent windowEvent) {
            HelpContentPanel.wa$_helpDialog(HelpContentPanel.this, null);
        }

        private HelpWindowAdapter() {
        }

        HelpWindowAdapter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class FileReopenHandler
    implements CustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevFileReopen";

        public void handleValue(String string) {
            FileOpenHistory fileOpenHistory = FileOpenHistory.getInstance();
            String[] stringArray = fileOpenHistory.getFileHistory();
            URLDisplayWrapper uRLDisplayWrapper = null;
            if (stringArray == null) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), HelpArb.getString(88), HelpArb.getString(87), 1);
            } else {
                Object[] objectArray = new URLDisplayWrapper[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    URLDisplayWrapper uRLDisplayWrapper2 = new URLDisplayWrapper(URL2String.toURL((String)stringArray[n]));
                    objectArray[n] = uRLDisplayWrapper2;
                    ++n;
                }
                uRLDisplayWrapper = (URLDisplayWrapper)JOptionPane.showInputDialog((Component)Ide.getMainWindow(), HelpArb.getString(87), HelpArb.getString(86), 3, null, objectArray, objectArray[0]);
                if (uRLDisplayWrapper != null) {
                    URL uRL = uRLDisplayWrapper.getURL();
                    IdeAction ideAction = FileOpenHistory.getNewReopenAction((URL)uRL);
                    1 var10_10 = new 1(this, ideAction);
                    IdeUtil.invokeAfterRepaint((Runnable)var10_10);
                }
            }
        }

        private FileReopenHandler() {
        }

        FileReopenHandler(1 var2_2) {
            this();
        }

        public final class 1
        implements Runnable {
            private final /* synthetic */ IdeAction v$action;
            final /* synthetic */ FileReopenHandler this$0;

            public void run() {
                try {
                    this.v$action.performAction();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public 1(FileReopenHandler fileReopenHandler, IdeAction ideAction) {
                this.v$action = ideAction;
                this.this$0 = fileReopenHandler;
            }
        }
    }

    private final class CueCardHandler
    implements CustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevShowCueCard";

        public void handleValue(String string) {
            DockStation dockStation;
            HelpWindow helpWindow;
            JDevHelpSystemImpl jDevHelpSystemImpl;
            Library library;
            HelpSystem helpSystem = HelpSystem.getHelpSystem();
            if (helpSystem != null && helpSystem instanceof JDevHelpSystemImpl && (library = (jDevHelpSystemImpl = (JDevHelpSystemImpl)helpSystem).getLibrary()) != null && (helpWindow = (HelpWindow)(dockStation = DockStation.getDockStation()).findDockable(HelpWindow.getHelpWindowViewId())) != null) {
                helpWindow.showCueCardSetForId(string);
            }
        }

        private CueCardHandler() {
        }

        CueCardHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class CueCardListHandler
    implements CustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevShowCueCardList";

        public void handleValue(String string) {
            DockStation dockStation = DockStation.getDockStation();
            HelpWindow helpWindow = (HelpWindow)dockStation.findDockable(HelpWindow.getHelpWindowViewId());
            if (helpWindow != null) {
                helpWindow.switchNavigator(5);
                helpWindow.show();
            }
        }

        private CueCardListHandler() {
        }

        CueCardListHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class BrowserOnFileHandler
    implements CustomProtocolHandler {
        public static final String PROTOCOL_NAME = "jdevInvokeBrowserOnFile";

        public void handleValue(String string) {
            try {
                File file = new File(Ide.getHomeDirectory());
                File file2 = new File(file, string);
                URL uRL = URLFactory.newFileURL((File)file2);
                BrowserRunner.getBrowserRunner().runBrowserOnURL(uRL, null, null);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)HelpArb.format(139, string));
            }
        }

        private BrowserOnFileHandler() {
        }

        BrowserOnFileHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class URLDisplayWrapper {
        private URL _url;

        public URLDisplayWrapper(URL uRL) {
            this._url = uRL;
        }

        public URL getURL() {
            return this._url;
        }

        public String toString() {
            return URLFileSystem.getPlatformPathName((URL)this._url);
        }
    }
}

