/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockableListener;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpTopicDocument;
import oracle.jdevimpl.help.HelpTopicEditor;
import oracle.jdevimpl.help.JDevHelpSystemImpl;

public final class HelpContentWindow
extends JFrame
implements WindowFocusListener,
ViewListener,
Controller {
    private String _windowTitle;
    private HelpTopicEditor _helpTopicEditor;
    private DockableListener _dockableListener;
    private Context _context;
    private Controller _controller;
    static final String NODE_NAME = "HelpWindow";
    private static final String XPOS = "xpos";
    private static final String YPOS = "ypos";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String URL = "url";

    void $init$() {
        this._windowTitle = HelpArb.getString(57);
    }

    static {
        JFrame.setDefaultLookAndFeelDecorated(true);
    }

    public HelpContentWindow() {
        this.$init$();
        this._controller = this;
        this._helpTopicEditor = new HelpTopicEditor();
        this._helpTopicEditor.setParent(this);
        this.initialize();
        this.addWindowFocusListener(this);
    }

    public HelpContentWindow(Context context) {
        this();
        this._context = context;
        this._helpTopicEditor.setContext(context);
        this._helpTopicEditor.open();
    }

    protected JRootPane createRootPane() {
        HelpContentWindow helpContentWindow = this;
        3 var2_2 = new 3();
        JRootPane jRootPane = new JRootPane();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        jRootPane.registerKeyboardAction(var2_2, keyStroke, 2);
        return jRootPane;
    }

    public void activate() {
        if (this._helpTopicEditor != null) {
            this._helpTopicEditor.activate();
        }
    }

    public Component getGUI() {
        return this._helpTopicEditor.getGUI();
    }

    protected WindowListener getWindowListener() {
        return new 2();
    }

    protected void initGeometry() {
        this.setBounds(new Rectangle(0, 0, 400, 500));
        this.setLocationRelativeTo(null);
    }

    public HelpTopicEditor getHelpTopicEditor() {
        return this._helpTopicEditor;
    }

    public void close() {
        this.dispose();
    }

    public void dispose() {
        if (HelpSystem.getHelpSystem() instanceof JDevHelpSystemImpl) {
            ((JDevHelpSystemImpl)HelpSystem.getHelpSystem()).removeEditor(this._helpTopicEditor);
        }
        if (this._helpTopicEditor != null) {
            this._helpTopicEditor.close();
            this._helpTopicEditor = null;
        }
    }

    public void saveLayout(DefaultStructuredPropertyAccess defaultStructuredPropertyAccess) {
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess2 = new DefaultStructuredPropertyAccess(NODE_NAME);
        defaultStructuredPropertyAccess2.setProperty(XPOS, Integer.toString(this.getX()));
        defaultStructuredPropertyAccess2.setProperty(YPOS, Integer.toString(this.getY()));
        defaultStructuredPropertyAccess2.setProperty(WIDTH, Integer.toString(this.getWidth()));
        defaultStructuredPropertyAccess2.setProperty(HEIGHT, Integer.toString(this.getHeight()));
        defaultStructuredPropertyAccess2.setProperty(URL, this.getHelpTopicEditor().getHelpTopicDocument().getURL().toString());
        defaultStructuredPropertyAccess.appendChild((StructuredPropertyAccess)defaultStructuredPropertyAccess2);
    }

    public static void loadLayout(DefaultStructuredPropertyAccess defaultStructuredPropertyAccess) {
        String string = defaultStructuredPropertyAccess.getProperty(URL, "");
        if (string.length() > 0) {
            if (string.endsWith(".helpT")) {
                string = string.substring(0, string.length() - ".helpT".length());
            } else if (string.endsWith(".help")) {
                string = string.substring(0, string.length() - ".help".length());
            }
            SimpleURLTarget simpleURLTarget = new SimpleURLTarget(null, string);
            SimpleTopic simpleTopic = new SimpleTopic(null, (Target)simpleURLTarget, null);
            HelpTopicDocument helpTopicDocument = null;
            try {
                helpTopicDocument = new HelpTopicDocument((Topic)simpleTopic);
            }
            catch (Exception exception) {
                return;
            }
            Context context = Context.newIdeContext((Node)helpTopicDocument);
            context.setWorkspace(null);
            context.setProject(null);
            HelpContentWindow helpContentWindow = new HelpContentWindow(context);
            int n = Integer.parseInt(defaultStructuredPropertyAccess.getProperty(XPOS, "0"));
            int n2 = Integer.parseInt(defaultStructuredPropertyAccess.getProperty(YPOS, "0"));
            int n3 = Integer.parseInt(defaultStructuredPropertyAccess.getProperty(WIDTH, "0"));
            int n4 = Integer.parseInt(defaultStructuredPropertyAccess.getProperty(HEIGHT, "0"));
            helpContentWindow.setBounds(n, n2, n3, n4);
            1 var12_12 = new 1(helpContentWindow, simpleTopic);
            SwingUtilities.invokeLater(var12_12);
        }
    }

    public Controller getController() {
        return this;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == 23) {
            this._helpTopicEditor.getHelpContentPanel().runFindDialog();
            return true;
        }
        if (n == 16) {
            return this._helpTopicEditor.getController().handleEvent(ideAction, context);
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (ideAction == null) {
            return false;
        }
        int n = ideAction.getCommandId();
        if (n == 16) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == 23) {
            ideAction.setEnabled(true);
            return true;
        }
        return false;
    }

    public void viewActivated(ViewEvent viewEvent) {
        this._helpTopicEditor.activate();
    }

    public void viewDeactivated(ViewEvent viewEvent) {
    }

    public void viewClosed(ViewEvent viewEvent) {
        this.close();
    }

    public void windowLostFocus(WindowEvent windowEvent) {
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
        this.activate();
    }

    private void initialize() {
        this.setTitle(HelpArb.getString(40));
        this.setIconImage(HelpArb.getImage(43));
        this.addWindowListener(this.getWindowListener());
        this.initGeometry();
        this.getContentPane().add(this._helpTopicEditor.getGUI(), "Center");
        this.setVisible(true);
    }

    public final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            HelpContentWindow.this.hide();
            HelpContentWindow.this.dispose();
        }
    }

    public final class 2
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            HelpContentWindow.this.close();
        }
    }

    public static final class 1
    implements Runnable {
        private final /* synthetic */ HelpContentWindow v$helpContentWindow;
        private final /* synthetic */ SimpleTopic v$theTopic;

        public void run() {
            this.v$helpContentWindow.getGUI().requestFocus();
            this.v$helpContentWindow.activate();
            this.v$helpContentWindow.getHelpTopicEditor().displayTopic((Topic)this.v$theTopic);
        }

        public 1(HelpContentWindow helpContentWindow, SimpleTopic simpleTopic) {
            this.v$theTopic = simpleTopic;
            this.v$helpContentWindow = helpContentWindow;
        }
    }
}

