/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.net.VirtualFileSystem;
import oracle.ide.IdeHook;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFactory;

public final class HelpHook
extends IdeHook {
    public static final ElementName ELEMENT = HelpHook.element((String)"help");
    private static final ElementName ITEM = HelpHook.element((String)"item");
    private static final ElementName HELP_NAME = HelpHook.element((String)"helpName");
    private static final ElementName HELP_ACTION = HelpHook.element((String)"helpAction");
    private static final ElementName HELP_URL = HelpHook.element((String)"helpURL");
    private static final ElementName RELATIVE_TO = HelpHook.element((String)"relativeTo");
    private static final ElementName RELATIVE_POSITION = HelpHook.element((String)"relativePosition");
    private static final ElementName TIP_OF_DAY_URL = HelpHook.element((String)"tipOfDayURL");
    private static final String KEY_HELP_ITEM = "help-item";
    private static final String BEFORE = "before";
    private static final String REMOVE_ACTION = "remove";
    private final List _helpEntries;
    private final List _tipEntries;
    private final ElementVisitor _item;
    private final ElementVisitor _helpName;
    private final ElementVisitor _helpAction;
    private final ElementVisitor _helpURL;
    private final ElementVisitor _relativeTo;
    private final ElementVisitor _relativePosition;
    private final ElementVisitor _tipOfDayURL;

    void $init$() {
        this._helpEntries = new ArrayList();
        this._tipEntries = new ArrayList();
        this._item = new ItemHandler(null);
        this._helpName = new HelpNameHandler(null);
        this._helpAction = new HelpActionHandler(null);
        this._helpURL = new HelpURLHandler(null);
        this._relativeTo = new RelativeToHandler(null);
        this._relativePosition = new RelativePositionHandler(null);
        this._tipOfDayURL = new TipOfDayURLHandler(null);
    }

    public void start(ElementStartContext elementStartContext) {
        elementStartContext.registerChildVisitor(ITEM, this._item);
    }

    private static String[] splitJarPath(String string) {
        String[] stringArray = new String[2];
        int n = string.toLowerCase().indexOf(".jar!");
        if (n == -1) {
            stringArray[0] = string;
            stringArray[1] = null;
        } else {
            stringArray[0] = string.substring(0, n + 4);
            stringArray[1] = string.substring(n + 6);
        }
        return stringArray;
    }

    private URL getHelpURL(ElementContext elementContext, String string) {
        try {
            String[] stringArray = HelpHook.splitJarPath(string);
            URI uRI = this.resolvePath(elementContext, stringArray[0]);
            URL uRL = VirtualFileSystem.getVirtualFileSystem().toURL(uRI);
            if (stringArray[1] == null) {
                URL uRL2 = uRL;
                return uRL2;
            }
            URL uRL3 = URLFactory.newJarURL((URL)uRL, (String)stringArray[1]);
            return uRL3;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            URL uRL = null;
            return uRL;
        }
    }

    private HelpObject getHelp(ElementContext elementContext) {
        return (HelpObject)elementContext.getScopeData().get(KEY_HELP_ITEM);
    }

    void registerHelpSetJars(HelpSystem helpSystem) {
        for (HelpObject helpObject : this._helpEntries) {
            helpSystem.registerHelpSetURL(helpObject.getHelpName(), helpObject.getHelpAction(), helpObject.getHelpURL(), helpObject.getRelativeTo(), helpObject.getRelativePosition());
        }
        this._helpEntries.clear();
    }

    void registerHelpTipJars(HelpSystem helpSystem) {
        for (URL uRL : this._tipEntries) {
            helpSystem.registerTipOfDayURL(uRL);
        }
        this._tipEntries.clear();
    }

    public HelpHook() {
        this.$init$();
    }

    static List ra$_helpEntries(HelpHook helpHook) {
        return helpHook._helpEntries;
    }

    static HelpObject mav$getHelp(HelpHook helpHook, ElementContext elementContext) {
        return helpHook.getHelp(elementContext);
    }

    static ElementName ra$HELP_NAME() {
        return HELP_NAME;
    }

    static ElementVisitor ra$_helpName(HelpHook helpHook) {
        return helpHook._helpName;
    }

    static ElementName ra$HELP_ACTION() {
        return HELP_ACTION;
    }

    static ElementVisitor ra$_helpAction(HelpHook helpHook) {
        return helpHook._helpAction;
    }

    static ElementName ra$HELP_URL() {
        return HELP_URL;
    }

    static ElementVisitor ra$_helpURL(HelpHook helpHook) {
        return helpHook._helpURL;
    }

    static ElementName ra$RELATIVE_TO() {
        return RELATIVE_TO;
    }

    static ElementVisitor ra$_relativeTo(HelpHook helpHook) {
        return helpHook._relativeTo;
    }

    static ElementName ra$RELATIVE_POSITION() {
        return RELATIVE_POSITION;
    }

    static ElementVisitor ra$_relativePosition(HelpHook helpHook) {
        return helpHook._relativePosition;
    }

    static ElementName ra$TIP_OF_DAY_URL() {
        return TIP_OF_DAY_URL;
    }

    static ElementVisitor ra$_tipOfDayURL(HelpHook helpHook) {
        return helpHook._tipOfDayURL;
    }

    static URL mav$getHelpURL(HelpHook helpHook, ElementContext elementContext, String string) {
        return helpHook.getHelpURL(elementContext, string);
    }

    static URI mav$resolvePath(HelpHook helpHook, ElementContext elementContext, String string) {
        return helpHook.resolvePath(elementContext, string);
    }

    static List ra$_tipEntries(HelpHook helpHook) {
        return helpHook._tipEntries;
    }

    private final class ItemHandler
    extends ElementVisitor {
        public void start(ElementStartContext elementStartContext) {
            elementStartContext.getScopeData().put(HelpHook.KEY_HELP_ITEM, new HelpObject(null));
            elementStartContext.registerChildVisitor(HelpHook.ra$HELP_NAME(), HelpHook.ra$_helpName(HelpHook.this));
            elementStartContext.registerChildVisitor(HelpHook.ra$HELP_ACTION(), HelpHook.ra$_helpAction(HelpHook.this));
            elementStartContext.registerChildVisitor(HelpHook.ra$HELP_URL(), HelpHook.ra$_helpURL(HelpHook.this));
            elementStartContext.registerChildVisitor(HelpHook.ra$RELATIVE_TO(), HelpHook.ra$_relativeTo(HelpHook.this));
            elementStartContext.registerChildVisitor(HelpHook.ra$RELATIVE_POSITION(), HelpHook.ra$_relativePosition(HelpHook.this));
            elementStartContext.registerChildVisitor(HelpHook.ra$TIP_OF_DAY_URL(), HelpHook.ra$_tipOfDayURL(HelpHook.this));
        }

        public void end(ElementEndContext elementEndContext) {
            HelpHook.ra$_helpEntries(HelpHook.this).add(HelpHook.mav$getHelp(HelpHook.this, (ElementContext)elementEndContext));
        }

        private ItemHandler() {
        }

        ItemHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class HelpNameHandler
    extends ElementVisitor {
        public void end(ElementEndContext elementEndContext) {
            HelpHook.mav$getHelp(HelpHook.this, (ElementContext)elementEndContext).setHelpName(elementEndContext.getText().trim());
        }

        private HelpNameHandler() {
        }

        HelpNameHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class HelpActionHandler
    extends ElementVisitor {
        public void end(ElementEndContext elementEndContext) {
            HelpHook.mav$getHelp(HelpHook.this, (ElementContext)elementEndContext).setHelpAction(elementEndContext.getText().trim());
        }

        private HelpActionHandler() {
        }

        HelpActionHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class HelpURLHandler
    extends ElementVisitor {
        public final void end(ElementEndContext elementEndContext) {
            String string = elementEndContext.getText().trim();
            URL uRL = HelpHook.mav$getHelpURL(HelpHook.this, (ElementContext)elementEndContext, string);
            if (uRL == null) {
                this.log((ElementContext)elementEndContext, Level.SEVERE, "Unable to use help url " + string);
            } else {
                this.url((ElementContext)elementEndContext, uRL);
            }
        }

        protected void url(ElementContext elementContext, URL uRL) {
            HelpHook.mav$getHelp(HelpHook.this, elementContext).setHelpURL(uRL);
        }

        private HelpURLHandler() {
        }

        HelpURLHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class RelativeToHandler
    extends ElementVisitor {
        public void end(ElementEndContext elementEndContext) {
            HelpHook.mav$getHelp(HelpHook.this, (ElementContext)elementEndContext).setRelativeTo(elementEndContext.getText().trim());
        }

        private RelativeToHandler() {
        }

        RelativeToHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class RelativePositionHandler
    extends ElementVisitor {
        public void end(ElementEndContext elementEndContext) {
            HelpHook.mav$getHelp(HelpHook.this, (ElementContext)elementEndContext).setRelativePosition(elementEndContext.getText().trim());
        }

        private RelativePositionHandler() {
        }

        RelativePositionHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class TipOfDayURLHandler
    extends ElementVisitor {
        public void end(ElementEndContext elementEndContext) {
            String string = elementEndContext.getText();
            URI uRI = HelpHook.mav$resolvePath(HelpHook.this, (ElementContext)elementEndContext, string);
            try {
                URL uRL = VirtualFileSystem.getVirtualFileSystem().toURL(uRI);
                HelpHook.ra$_tipEntries(HelpHook.this).add(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }

        private TipOfDayURLHandler() {
        }

        TipOfDayURLHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class HelpObject {
        private String _helpName;
        private int _helpAction;
        private URL _helpURL;
        private String _relativeTo;
        private int _relativePos;

        void $init$() {
            this._relativePos = 1;
        }

        public String getHelpName() {
            return this._helpName;
        }

        public void setHelpName(String string) {
            this._helpName = string;
        }

        public int getHelpAction() {
            return this._helpAction;
        }

        public void setHelpAction(String string) {
            this._helpAction = string.equalsIgnoreCase(HelpHook.REMOVE_ACTION) ? 1 : 0;
        }

        public void setHelpURL(URL uRL) {
            this._helpURL = uRL;
        }

        public URL getHelpURL() {
            return this._helpURL;
        }

        public void setRelativeTo(String string) {
            this._relativeTo = string;
        }

        public String getRelativeTo() {
            return this._relativeTo;
        }

        public void setRelativePosition(String string) {
            this._relativePos = string.equalsIgnoreCase(HelpHook.BEFORE) ? 0 : 1;
        }

        public int getRelativePosition() {
            return this._relativePos;
        }

        private HelpObject() {
            this.$init$();
        }

        HelpObject(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

