/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.ide.extension.ExtensionRegistry;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.Node;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.Navigable;
import oracle.ide.print.PrintManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.MenuSpec;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.ideimpl.ProductHook;
import oracle.ideimpl.ProductInformation;
import oracle.ideri.util.Product;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.bookmarks.resource.BookmarkArb;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpContentPanel;
import oracle.jdevimpl.help.HelpContentWindow;
import oracle.jdevimpl.help.HelpOptions;
import oracle.jdevimpl.help.HelpOptionsPanel;
import oracle.jdevimpl.help.HelpSystemConstants;
import oracle.jdevimpl.help.HelpSystemDockableFactory;
import oracle.jdevimpl.help.HelpTopicDocument;
import oracle.jdevimpl.help.HelpTopicDocumentPrintFactory;
import oracle.jdevimpl.help.HelpTopicEditor;
import oracle.jdevimpl.help.HelpWindow;
import oracle.jdevimpl.help.JDevHelpSystemImpl;
import oracle.jdevimpl.javadoc.JavadocArb;

public final class HelpSystemAddin
extends EditorAddin
implements Controller,
ShutdownHook {
    private static HelpSystem _helpSystem;
    private MenuSpec _menuSpec;
    private boolean _readmeFileExists;
    private boolean _educationFileExists;
    private static final String GLOBAL_ACCELERATORS = "oracle/jdevimpl/help/accelerators.xml";
    static final String LOCAL_ACCELERATORS = "oracle/jdevimpl/help/localaccelerators.xml";
    private static final String WEBLINK_EDUCATION_FILENAME = "education.html";
    private static final String WEBLINK_README_FILENAME = "readme.html";
    private static final String WELCOME_PAGE_FILENAME = "welcome";
    private static final String WELCOME_PAGE_FILE_EXT = ".html";
    private static final String WELCOME_DIR = "doc/welcome";
    static final int DOCERROR_URL_FAILED = 0;
    static final int DOCERROR_SYMBOL_NOT_FOUND = 1;
    static final int DOCERROR_SYMBOL_NOT_DETERMINED = 2;

    public final void initialize() {
        File file;
        File file2;
        JDevHelpSystemImpl jDevHelpSystemImpl = new JDevHelpSystemImpl();
        _helpSystem = jDevHelpSystemImpl;
        this._initHelpProvider();
        if (Product.isRaptor()) {
            int[] nArray = new int[]{0, 1, 2};
            jDevHelpSystemImpl.supportsNavigators(nArray);
        } else {
            int[] nArray = new int[]{0, 1, 2, 3, 5, 4};
            jDevHelpSystemImpl.supportsNavigators(nArray);
        }
        WindowUtils.registerWindow((Window)Ide.getMainWindow());
        Menubar menubar = Ide.getMenubar();
        AddinManager addinManager = AddinManager.getAddinManager();
        JMenu jMenu = MenuManager.getJMenu((String)"Help");
        File file3 = new File(Ide.getHomeDirectory());
        String string = IdeArb.getString((int)415);
        URL uRL = this.getWelcomePageUrl();
        if (uRL != null) {
            this._createActionAndMenu(menubar, jMenu, HelpSystemConstants.SHOW_WELCOME_PAGE_CMD_ID, "oracle.jdevimpl.help.welcomePage", string, HelpArb.getString(5), 1.0f, 1.0f);
        }
        if (jDevHelpSystemImpl.isNavigatorSupported(0)) {
            this._createActionAndMenu(menubar, jMenu, HelpSystemConstants.SHOW_TOC_CMD_ID, "oracle.jdevimpl.help.TableOfContents", string, HelpArb.getString(19), JDeveloperMenuConstants.WEIGHT_HELP_TOC, 1.0f);
        }
        if (jDevHelpSystemImpl.isNavigatorSupported(4)) {
            this._createActionAndMenu(menubar, jMenu, HelpSystemConstants.SHOW_DYNAMIC_LINKS_CMD_ID, "oracle.jdevimpl.help.DynamicLinks", string, HelpArb.getString(23), JDeveloperMenuConstants.WEIGHT_HELP_DYNAMIC_LINKS, JDeveloperMenuConstants.SECTION_HELP_GENERAL_HELP);
        }
        if (jDevHelpSystemImpl.isNavigatorSupported(2)) {
            this._createActionAndMenu(menubar, jMenu, HelpSystemConstants.SHOW_FULL_TEXT_SEARCH_CMD_ID, "oracle.jdevimpl.help.FullTextSearch", string, HelpArb.getString(21), JDeveloperMenuConstants.WEIGHT_HELP_SEARCH, JDeveloperMenuConstants.SECTION_HELP_GENERAL_HELP);
        }
        if (jDevHelpSystemImpl.isNavigatorSupported(1)) {
            this._createActionAndMenu(menubar, jMenu, HelpSystemConstants.SHOW_IDX_CMD_ID, "oracle.jdevimpl.help.Index", string, HelpArb.getString(20), JDeveloperMenuConstants.WEIGHT_HELP_IDX, JDeveloperMenuConstants.SECTION_HELP_GENERAL_HELP);
        }
        if (jDevHelpSystemImpl.isNavigatorSupported(3)) {
            this._createActionAndMenu(menubar, jMenu, HelpSystemConstants.SHOW_FAV_CMD_ID, "oracle.jdevimpl.help.Favorites", string, HelpArb.getString(22), JDeveloperMenuConstants.WEIGHT_HELP_FAVORITES, JDeveloperMenuConstants.SECTION_HELP_GENERAL_HELP);
        }
        if (jDevHelpSystemImpl.isNavigatorSupported(5)) {
            this._createActionAndMenu(menubar, jMenu, HelpSystemConstants.SHOW_CUE_CMD_ID, "oracle.jdevimpl.help.CueCards", string, HelpArb.getString(24), JDeveloperMenuConstants.WEIGHT_HELP_CUECARDS, JDeveloperMenuConstants.SECTION_HELP_JDEV_HELP);
        }
        if (Product.isJDeveloper()) {
            this._createActionAndMenu(menubar, jMenu, HelpSystemConstants.SHOW_TUTORIALS_CMD_ID, "oracle.jdevimpl.help.ShowOTNTutorials", string, HelpArb.getString(6), JDeveloperMenuConstants.WEIGHT_HELP_TUTORIAL, JDeveloperMenuConstants.SECTION_HELP_JDEV_HELP);
            this._createActionAndMenu(menubar, jMenu, HelpSystemConstants.SHOW_SAMPLES_CMD_ID, "oracle.jdevimpl.help.ShowOTNSamples", string, HelpArb.getString(7), JDeveloperMenuConstants.WEIGHT_HELP_SAMPLES, JDeveloperMenuConstants.SECTION_HELP_JDEV_HELP);
        }
        if ((file2 = new File(file3, WEBLINK_EDUCATION_FILENAME)).exists()) {
            this._createActionAndMenu(menubar, jMenu, HelpSystemConstants.WEBLINK_EDUCATION_CMD_ID, "oracle.jdevimpl.help.WebLinkEducation", string, HelpArb.getString(1), JDeveloperMenuConstants.WEIGHT_HELP_JAVA_ED, JDeveloperMenuConstants.SECTION_HELP_JDEV_HELP);
            this._educationFileExists = true;
        }
        if (Product.isJDeveloper()) {
            this._createActionAndMenu(menubar, jMenu, HelpSystemConstants.SHOW_FORUM_CMD_ID, "oracle.jdevimpl.help.ShowOTNForum", string, HelpArb.getString(8), JDeveloperMenuConstants.WEIGHT_HELP_FORUM, JDeveloperMenuConstants.SECTION_HELP_ADDINS);
            this._createActionAndMenu(menubar, jMenu, HelpSystemConstants.WEBLINK_OTN_CMD_ID, "oracle.jdevimpl.help.WebLinkOtn", string, HelpArb.getString(0), JDeveloperMenuConstants.WEIGHT_HELP_OTN, JDeveloperMenuConstants.SECTION_HELP_ADDINS);
        }
        if ((file = new File(file3, WEBLINK_README_FILENAME)).exists()) {
            this._createActionAndMenu(menubar, jMenu, HelpSystemConstants.WEBLINK_README_CMD_ID, "oracle.jdevimpl.help.WebLinkReadme", string, HelpArb.getString(3), JDeveloperMenuConstants.WEIGHT_HELP_RELEASE_NOTES, JDeveloperMenuConstants.SECTION_HELP_ADDINS);
            this._readmeFileExists = true;
        }
        this._createActionAndMenu(menubar, jMenu, HelpSystemConstants.SHOW_TIP_OF_DAY_CMD_ID, "oracle.jdevimpl.help.tipOfDay", string, HelpArb.getString(9), JDeveloperMenuConstants.WEIGHT_HELP_TIP_OF_DAY, JDeveloperMenuConstants.SECTION_HELP_ADDINS);
        IdeAction ideAction = IdeAction.find((int)HelpSystemConstants.SHOW_TIP_OF_DAY_CMD_ID);
        if (ideAction != null) {
            ideAction.setEnabled(false);
        }
        String string2 = addinManager.getCommand(HelpSystemConstants.CHELP_TOPICS_ID, "oracle.jdevimpl.help.ContextHelpCommand");
        IdeAction ideAction2 = IdeAction.get((int)HelpSystemConstants.CHELP_TOPICS_ID, (String)string2, (String)HelpArb.getString(72), (String)string, null, null, null, (boolean)true);
        ideAction2.addController((Controller)this);
        IdeAction.get((int)HelpSystemConstants.BACKWARD_CMD_ID, null, (String)HelpArb.getString(67), (String)string, null, (ArrayResourceBundle)JavadocArb.getInstance(), (int)66, null, (boolean)true);
        IdeAction.get((int)HelpSystemConstants.FORWARD_CMD_ID, null, (String)HelpArb.getString(68), (String)string, null, (ArrayResourceBundle)JavadocArb.getInstance(), (int)67, null, (boolean)true);
        IdeAction.get((int)HelpSystemConstants.ADD_FAVORITE_CMD_ID, (String)"oracle.jdevimpl.help.AddFavoriteCmd", (String)HelpArb.getString(82), (String)string, (Integer)HelpArb.getInteger(83), (ArrayResourceBundle)BookmarkArb.getInstance(), (int)7, null, (boolean)true);
        Ide.getKeyStrokeContextRegistry().addAcceleratorDefinitionFile(this.getClass().getClassLoader(), GLOBAL_ACCELERATORS);
        Ide.getKeyStrokeContextRegistry().addAcceleratorDefinitionFile(this.getClass().getClassLoader(), LOCAL_ACCELERATORS);
        this._initIdePreferencesPanels();
        DockStation.getDockStation().registerDockableFactory("HelpSystemAddin", (DockableFactory)new HelpSystemDockableFactory());
        EditorManager editorManager = EditorManager.getEditorManager();
        Class[] classArray = new Class[]{HelpTopicDocument.class};
        editorManager.register((EditorAddin)this, classArray);
        PrintManager.getPrintManager().registerDocumentPrintFactory(HelpTopicEditor.class, HelpTopicDocumentPrintFactory.class);
        PrintManager.getPrintManager().registerDocumentPrintFactory(HelpWindow.class, HelpTopicDocumentPrintFactory.class);
        PrintManager.getPrintManager().registerDocumentPrintFactory(HelpContentPanel.class, HelpTopicDocumentPrintFactory.class);
        PrintManager.getPrintManager().registerDocumentPrintFactory(HelpContentWindow.class, HelpTopicDocumentPrintFactory.class);
        Recognizer.mapExtensionToClass((String)".helpT", HelpTopicDocument.class);
        Recognizer.mapExtensionToClass((String)".help", HelpTopicDocument.class);
        Recognizer.registerDocumentInfo(HelpTopicDocument.class, (DocumentInfo)new DocumentInfo(HelpArb.getString(71)));
        Ide.addIdeListener((IdeListener)new 5());
        ExitCommand.addShutdownHook((ShutdownHook)this);
    }

    private final void _createActionAndMenu(Menubar menubar, JMenu jMenu, int n, String string, String string2, String string3, float f, float f2) {
        IdeAction ideAction = IdeAction.get((int)n, (String)string, (String)StringUtils.stripMnemonic((String)string3), (String)string2, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string3)), null, null, null, (boolean)true);
        ideAction.addController((Controller)this);
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, f);
        menubar.add((Component)jMenuItem, jMenu, f2);
    }

    private final void _mainWindowOpened() {
        String string = Ide.getProperty((String)"Ide.ShowWelcomePage", (String)Boolean.TRUE.toString());
        boolean bl = Boolean.valueOf(string);
        if (bl) {
            String string2 = System.getProperty("user.language").equals("ja") ? "doc/welcome/welcome_ja.html" : "doc/welcome/welcome.html";
            URL uRL = URLFactory.newFileURL((String)Ide.getHomeDirectory());
            URL uRL2 = URLFactory.newURL((URL)uRL, (String)string2);
            if (URLFileSystem.exists((URL)uRL2)) {
                HelpSystemAddin.openEditorInFrameExternal(uRL2, null, HelpArb.getString(10));
            }
            Ide.setProperty((String)"Ide.ShowWelcomePage", (String)Boolean.FALSE.toString());
        }
        if (_helpSystem.hasTipOfDayEntries()) {
            IdeAction ideAction = IdeAction.find((int)HelpSystemConstants.SHOW_TIP_OF_DAY_CMD_ID);
            if (ideAction != null) {
                ideAction.setEnabled(true);
            }
            if (JDevHelpSystemImpl.getShowTipOfDayPreference()) {
                _helpSystem.showTipOfTheDay();
            }
        }
    }

    private final void _initHelpProvider() {
        HelpUtils.setDefaultHelpProvider((HelpProvider)new 4());
        HelpSystem.setHelpSystem((HelpSystem)_helpSystem);
    }

    private final void _initIdePreferencesPanels() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)AddinManager.getAddinManager().getExtensionForAddin((Addin)this).getID());
        if (!clientSetting.hasData("HelpOptions")) {
            clientSetting.putData("HelpOptions", (Copyable)new HelpOptions());
        }
        ClientSetting.registerUI((Navigable)new Navigable(HelpArb.getString(17), HelpOptionsPanel.class));
    }

    public final void shutdown() {
        if (_helpSystem instanceof JDevHelpSystemImpl) {
            ((JDevHelpSystemImpl)_helpSystem).saveOpenHelpWindows();
        }
        _helpSystem.clearHelpSystem();
    }

    public boolean canShutdown() {
        return true;
    }

    public final boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == HelpSystemConstants.WEBLINK_EDUCATION_CMD_ID) {
            if (this._educationFileExists) {
                File file = new File(Ide.getHomeDirectory());
                File file2 = new File(file, WEBLINK_EDUCATION_FILENAME);
                URL uRL = URLFactory.newFileURL((File)file2);
                HelpSystemAddin.openEditorInFrameExternal(uRL, null, HelpArb.getString(2));
            }
            return true;
        }
        if (n == HelpSystemConstants.WEBLINK_README_CMD_ID) {
            if (this._readmeFileExists) {
                File file = new File(Ide.getHomeDirectory());
                File file3 = new File(file, WEBLINK_README_FILENAME);
                URL uRL = URLFactory.newFileURL((File)file3);
                HelpSystemAddin.openEditorInFrameExternal(uRL, null, HelpArb.getString(4));
            }
            return true;
        }
        if (n == HelpSystemConstants.WEBLINK_OTN_CMD_ID) {
            this.showWebSite(HelpArb.getString(11));
            return true;
        }
        if (n == HelpSystemConstants.SHOW_TOC_CMD_ID) {
            this.showNavigator(0);
            return true;
        }
        if (n == HelpSystemConstants.SHOW_DYNAMIC_LINKS_CMD_ID) {
            this.showNavigator(4);
            return true;
        }
        if (n == HelpSystemConstants.SHOW_FULL_TEXT_SEARCH_CMD_ID) {
            this.showNavigator(2);
            return true;
        }
        if (n == HelpSystemConstants.SHOW_IDX_CMD_ID) {
            this.showNavigator(1);
            return true;
        }
        if (n == HelpSystemConstants.SHOW_FAV_CMD_ID) {
            this.showNavigator(3);
            return true;
        }
        if (n == HelpSystemConstants.SHOW_CUE_CMD_ID) {
            this.showNavigator(5);
            return true;
        }
        if (n == HelpSystemConstants.SHOW_TUTORIALS_CMD_ID) {
            this.showWebSite(HelpArb.getString(12));
            return true;
        }
        if (n == HelpSystemConstants.SHOW_SAMPLES_CMD_ID) {
            this.showWebSite(HelpArb.getString(13));
            return true;
        }
        if (n == HelpSystemConstants.SHOW_FORUM_CMD_ID) {
            this.showWebSite(HelpArb.getString(14));
            return true;
        }
        if (n == HelpSystemConstants.SHOW_WELCOME_PAGE_CMD_ID) {
            3 var10_10 = new 3();
            EventQueue.invokeLater(var10_10);
            return true;
        }
        if (n == HelpSystemConstants.SHOW_TIP_OF_DAY_CMD_ID) {
            2 var11_11 = new 2();
            EventQueue.invokeLater(var11_11);
            return true;
        }
        if (n == HelpSystemConstants.FORWARD_CMD_ID && context.getView() instanceof HelpContentPanel) {
            return context.getView().getController().handleEvent(ideAction, context);
        }
        return false;
    }

    private URL getWelcomePageUrl() {
        ProductInformation productInformation;
        ProductHook productHook = (ProductHook)ExtensionRegistry.getExtensionRegistry().getHook(ProductHook.NAME);
        URL uRL = null;
        if (productHook != null && (productInformation = productHook.getProductInformation()) != null) {
            uRL = productInformation.getWelcomePage();
        }
        if (uRL == null) {
            File file = new File(Ide.getHomeDirectory());
            File file2 = new File(file, WELCOME_DIR);
            File file3 = new File(file2, WELCOME_PAGE_FILENAME);
            uRL = URLFactory.newFileURL((File)file3);
        }
        URL uRL2 = URLFileSystem.getParent(uRL);
        String string = URLFileSystem.getName(uRL);
        Locale locale = StaticLocaleContext.getLocale();
        String string2 = locale.getLanguage();
        URL uRL3 = URLFactory.newURL((URL)uRL2, (String)(string + "_" + string2 + WELCOME_PAGE_FILE_EXT));
        if (URLFileSystem.exists((URL)uRL3)) {
            return uRL3;
        }
        if (URLFileSystem.exists((URL)uRL)) {
            return uRL;
        }
        return null;
    }

    private void showNavigator(int n) {
        HelpWindow helpWindow = (HelpWindow)DockStation.getDockStation().findDockable(HelpWindow.getHelpWindowViewId());
        helpWindow.show();
        DockStation.getDockStation().activateDockable((Dockable)helpWindow);
        helpWindow.switchNavigator(n);
    }

    private void showWebSite(String string) {
        try {
            URL uRL = new URL(string);
            BrowserRunner.getBrowserRunner().runBrowserOnURL(uRL, null, null);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public final boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == HelpSystemConstants.CHELP_TOPICS_ID || n == HelpSystemConstants.SHOW_WELCOME_PAGE_CMD_ID || n == HelpSystemConstants.SHOW_TOC_CMD_ID || n == HelpSystemConstants.SHOW_DYNAMIC_LINKS_CMD_ID || n == HelpSystemConstants.SHOW_FULL_TEXT_SEARCH_CMD_ID || n == HelpSystemConstants.SHOW_IDX_CMD_ID || n == HelpSystemConstants.SHOW_FAV_CMD_ID || n == HelpSystemConstants.SHOW_CUE_CMD_ID || n == HelpSystemConstants.SHOW_TUTORIALS_CMD_ID || n == HelpSystemConstants.SHOW_SAMPLES_CMD_ID || n == HelpSystemConstants.SHOW_FORUM_CMD_ID || n == HelpSystemConstants.WEBLINK_OTN_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == HelpSystemConstants.WEBLINK_README_CMD_ID) {
            if (this._readmeFileExists) {
                ideAction.setEnabled(true);
            }
            return true;
        }
        if (n == HelpSystemConstants.WEBLINK_EDUCATION_CMD_ID) {
            if (this._educationFileExists) {
                ideAction.setEnabled(true);
            }
            return true;
        }
        return false;
    }

    public static void openEditorInFrameExternal(URL uRL) {
        HelpSystemAddin.openEditorInFrameExternal(uRL, null, null);
    }

    public static void openEditorInFrameExternal(URL uRL, Icon icon, String string) {
        HelpTopicDocument helpTopicDocument = new HelpTopicDocument(uRL);
        if (icon != null) {
            helpTopicDocument.setIcon(icon);
        }
        if (string != null) {
            helpTopicDocument.setShortLabel(string);
        }
        Context context = Context.newIdeContext((Node)helpTopicDocument);
        context.setWorkspace(null);
        context.setProject(null);
        EditorManager editorManager = EditorManager.getEditorManager();
        HelpTopicEditor helpTopicEditor = (HelpTopicEditor)editorManager.openEditorInFrame(HelpTopicEditor.class, context);
        if (string == null) {
            helpTopicEditor.setSharable(true);
            ((JDevHelpSystemImpl)_helpSystem).setMRUEditor(helpTopicEditor);
        } else {
            helpTopicEditor.setSharable(false);
        }
        if (helpTopicEditor == null) {
            HelpSystemAddin.showJavadocException(0, uRL.toString());
        }
    }

    static void showJavadocException(int n, String string) {
        String string2 = null;
        switch (n) {
            case 0: {
                string2 = HelpArb.format(26, string);
                break;
            }
            case 1: {
                string2 = HelpArb.format(27, string);
                break;
            }
            case 2: {
                string2 = HelpArb.format(28, string);
                break;
            }
            default: {
                string2 = HelpArb.getString(29);
            }
        }
        String string3 = string2;
        1 var4_4 = new 1(string3);
        EventQueue.invokeLater(var4_4);
    }

    public Class getEditorClass() {
        return HelpTopicEditor.class;
    }

    public synchronized MenuSpec getMenuSpecification() {
        if (this._menuSpec == null) {
            String string = HelpArb.getString(60);
            Integer n = HelpArb.getInteger(61);
            this._menuSpec = new MenuSpec(string, n, HelpArb.getInstance(), 59);
        }
        return this._menuSpec;
    }

    public boolean isDefault() {
        return true;
    }

    static String getExtensionID() {
        AddinManager addinManager = AddinManager.getAddinManager();
        Addin addin = addinManager.getAddin(HelpSystemAddin.class);
        return addinManager.getExtensionForAddin(addin).getID();
    }

    static void mav$_mainWindowOpened(HelpSystemAddin helpSystemAddin) {
        helpSystemAddin._mainWindowOpened();
    }

    static HelpSystem ra$_helpSystem() {
        return _helpSystem;
    }

    static URL mav$getWelcomePageUrl(HelpSystemAddin helpSystemAddin) {
        return helpSystemAddin.getWelcomePageUrl();
    }

    public final class 5
    extends IdeAdapter {
        public void mainWindowOpened(IdeEvent ideEvent) {
            HelpSystemAddin.mav$_mainWindowOpened(HelpSystemAddin.this);
            ((JDevHelpSystemImpl)HelpSystemAddin.ra$_helpSystem()).loadHelpWindows();
            Ide.removeIdeListener((IdeListener)this);
        }
    }

    public final class 4
    implements HelpProvider {
        public void showHelp(Component component) throws HelpUnavailableException {
            block0: {
                if (!(component instanceof JComponent)) break block0;
                HelpSystemAddin.ra$_helpSystem().showHelp((JComponent)component);
            }
        }
    }

    public final class 3
    implements Runnable {
        public void run() {
            block0: {
                URL uRL = HelpSystemAddin.mav$getWelcomePageUrl(HelpSystemAddin.this);
                if (uRL == null) break block0;
                HelpSystemAddin.openEditorInFrameExternal(uRL, null, HelpArb.getString(10));
            }
        }
    }

    public final class 2
    implements Runnable {
        public void run() {
            HelpSystemAddin.ra$_helpSystem().showTipOfTheDay();
        }
    }

    public static final class 1
    implements Runnable {
        private final /* synthetic */ String v$innerMsg;

        public void run() {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), this.v$innerMsg);
        }

        public 1(String string) {
            this.v$innerMsg = string;
        }
    }
}

