/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import oracle.help.common.IndirectTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.library.Book;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.jdevimpl.help.DynamicLinkTarget;
import oracle.jdevimpl.help.HelpArb;

public class HelpTopicDocument
extends Node {
    private Topic _topic;
    private Icon _icon = HelpArb.getIcon(70);
    private String _shortLabel = HelpArb.getString(69);
    private String _longLabel;
    private boolean _helpDependent = true;
    private String _title;
    public static final String EXT1 = ".helpT";
    public static final String EXT2 = ".help";

    public HelpTopicDocument() {
        this.getAttributes().set(ElementAttributes.CLOSEABLE);
    }

    public HelpTopicDocument(Topic topic) throws MalformedURLException {
        this();
        this._topic = topic;
        URL uRL = topic.getTarget().getURL();
        if (uRL == null) {
            String string = null;
            if (topic.hasTarget()) {
                if (topic.getTarget() instanceof IndirectTarget) {
                    IndirectTarget indirectTarget = (IndirectTarget)topic.getTarget();
                    string = indirectTarget.getTargetName();
                } else if (topic.getTarget() instanceof DynamicLinkTarget) {
                    DynamicLinkTarget dynamicLinkTarget = (DynamicLinkTarget)topic.getTarget();
                    string = dynamicLinkTarget.getTopicId();
                }
            }
            throw new MalformedURLException("Failed to find url for topic");
        }
        super.setURL(URLFileSystem.ensureSuffix((URL)uRL, (String)EXT1));
    }

    public HelpTopicDocument(URL uRL) {
        this();
        this._topic = new TopicWrapper(uRL);
        super.setURL(URLFileSystem.ensureSuffix((URL)uRL, (String)EXT2));
        this._helpDependent = false;
    }

    public void setURL(URL uRL) {
        URLPair uRLPair = this._mapURL(uRL);
        URL uRL2 = uRLPair.getNodeURL();
        URL uRL3 = uRLPair.getTopicURL();
        if (this.getURL() != null && URLFileSystem.equals((URL)this.getURL(), (URL)uRL2)) {
            return;
        }
        super.setURL(uRL2);
        this._createTopicWrapper(uRL3);
        this._title = HelpTopicDocument.getTitleFromURL(uRL3);
        if (URLFileSystem.hasSuffix((URL)uRL2, (String)EXT1)) {
            this._helpDependent = true;
        } else if (URLFileSystem.hasSuffix((URL)uRL2, (String)EXT2)) {
            this._shortLabel = this._title;
            this._helpDependent = false;
        }
        this._longLabel = null;
        this.notifyObservers((Object)this, new UpdateMessage(UpdateMessage.ATTRIBUTE_CHANGED, (Object)this));
    }

    private URLPair _mapURL(URL uRL) {
        URLPair uRLPair = new URLPair();
        if (URLFileSystem.hasSuffix((URL)uRL, (String)EXT1)) {
            uRLPair.setTopicURL(URLFileSystem.convertSuffix((URL)uRL, (String)EXT1, (String)""));
            uRLPair.setNodeURL(uRL);
        } else if (URLFileSystem.hasSuffix((URL)uRL, (String)EXT2)) {
            uRLPair.setTopicURL(URLFileSystem.convertSuffix((URL)uRL, (String)EXT2, (String)""));
            uRLPair.setNodeURL(uRL);
        } else if (URLFileSystem.hasSuffix((URL)this.getURL(), (String)EXT1)) {
            uRLPair.setTopicURL(uRL);
            uRLPair.setNodeURL(URLFileSystem.ensureSuffix((URL)uRL, (String)EXT1));
        } else {
            uRLPair.setTopicURL(uRL);
            uRLPair.setNodeURL(URLFileSystem.ensureSuffix((URL)uRL, (String)EXT2));
        }
        return uRLPair;
    }

    public Topic getTopic() {
        return this._topic;
    }

    public void setTopic(Topic topic) {
        this._topic = topic;
        this._longLabel = topic.getLabel();
    }

    public boolean isHelpDependent() {
        return this._helpDependent;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
    }

    public String getShortLabel() {
        return this._shortLabel;
    }

    public void setShortLabel(String string) {
        this._shortLabel = string;
    }

    public String getLongLabel() {
        if (this._longLabel == null) {
            if (this._topic.getLabel() != null) {
                this._longLabel = this._topic.getLabel();
            } else if (this._topic.hasTarget()) {
                if (this._title == null) {
                    try {
                        URL uRL = this._topic.getTarget().getURL();
                        this._title = HelpTopicDocument.getTitleFromURL(uRL);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                this._longLabel = this._title;
            }
        }
        return this._longLabel;
    }

    void setOpenOverride(boolean bl) {
        super.setOpen(bl);
    }

    public boolean isDirty() {
        return false;
    }

    private void _createTopicWrapper(URL uRL) {
        String string = null;
        if (this._topic != null && this._topic.hasTarget()) {
            try {
                URL uRL2 = this._topic.getTarget().getURL();
                if (URLFileSystem.equals((URL)uRL, (URL)uRL2)) {
                    string = this._topic.getLabel();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._topic = new TopicWrapper(uRL);
        if (string != null && this._topic instanceof TopicWrapper) {
            ((TopicWrapper)this._topic).setLabel(string);
        }
    }

    static String getTitleFromURL(URL uRL) {
        String string = null;
        String string2 = uRL.getPath();
        if (string2.indexOf("truncateDocPath.do") != -1 || string2.indexOf("findDocument.do") != -1) {
            return "Doc Review";
        }
        URL uRL2 = uRL;
        try {
            String string3 = uRL.toString();
            String string4 = URLDecoder.decode(string3);
            if (!string4.equals(string3)) {
                uRL2 = URLFactory.newURL((String)string4);
            }
            ParserDelegator parserDelegator = new ParserDelegator();
            1Callback callback = new 1Callback();
            InputStreamReader inputStreamReader = null;
            try {
                try {
                    inputStreamReader = new InputStreamReader(URLFileSystem.openInputStream((URL)uRL2), "ISO-8859-1");
                    parserDelegator.parse(inputStreamReader, callback, false);
                }
                catch (ChangedCharSetException changedCharSetException) {
                    String string5 = changedCharSetException.getCharSetSpec();
                    Pattern pattern = Pattern.compile("charset=\"?(.+)\"?\\s*;?", 2);
                    Matcher matcher = pattern.matcher(string5);
                    String string6 = matcher.find() ? matcher.group(1) : "ISO-8859-1";
                    InputStreamReader inputStreamReader2 = null;
                    try {
                        try {
                            inputStreamReader2 = new InputStreamReader(URLFileSystem.openInputStream((URL)uRL2), string6);
                            1Callback.wa$inTitle(callback, false);
                            parserDelegator.parse(inputStreamReader2, callback, true);
                        }
                        catch (IOException iOException) {}
                    }
                    finally {
                        HelpTopicDocument.forceClose(inputStreamReader2);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                HelpTopicDocument.forceClose(inputStreamReader);
                throw throwable;
            }
            HelpTopicDocument.forceClose(inputStreamReader);
            string = 1Callback.ra$title(callback);
        }
        catch (MalformedURLException malformedURLException) {
            String string7 = null;
            return string7;
        }
        catch (IOException iOException) {
            String string8 = null;
            return string8;
        }
        if (string == null || string.length() == 0) {
            string = HelpArb.getString(81);
        }
        return IdeUtil.decodeHTMLReservedCharacters((String)string).trim();
    }

    private static void forceClose(InputStreamReader inputStreamReader) {
        if (inputStreamReader != null) {
            try {
                inputStreamReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class 1Callback
    extends HTMLEditorKit.ParserCallback {
        private boolean inTitle;
        private String title;

        public void handleText(char[] cArray, int n) {
            if (this.inTitle) {
                this.title = new String(cArray);
            }
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            if (tag == HTML.Tag.TITLE) {
                this.inTitle = true;
            }
        }

        public void handleEndTag(HTML.Tag tag, int n) {
            if (tag == HTML.Tag.TITLE) {
                this.inTitle = false;
            }
        }

        1Callback() {
        }

        static void wa$inTitle(1Callback callback, boolean bl) {
            callback.inTitle = bl;
        }

        static String ra$title(1Callback callback) {
            return callback.title;
        }
    }

    private class TopicWrapper
    implements Target,
    Topic {
        private URL _url;
        private String _label;

        public TopicWrapper(URL uRL) {
            this._url = uRL;
        }

        public URL getActiveIcon() {
            return null;
        }

        public URL getDefaultIcon() {
            return null;
        }

        public String getLabel() {
            return this._label;
        }

        public Book getParentBook() {
            return null;
        }

        public Target getTarget() {
            return this;
        }

        public boolean hasTarget() {
            return true;
        }

        public URL getURL() {
            return this._url;
        }

        public void setLabel(String string) {
            this._label = string;
        }
    }

    private static final class URLPair {
        private URL _nodeURL;
        private URL _topicURL;

        public URL getNodeURL() {
            return this._nodeURL;
        }

        public void setNodeURL(URL uRL) {
            this._nodeURL = uRL;
        }

        public URL getTopicURL() {
            return this._topicURL;
        }

        public void setTopicURL(URL uRL) {
            this._topicURL = uRL;
        }
    }
}

