/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import oracle.help.common.Topic;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.topicDisplay.TopicDisplay;
import oracle.help.topicDisplay.print.TopicPrintJob;
import oracle.ide.Context;
import oracle.ide.print.DocumentPrintFactory;
import oracle.ide.print.PrintManager;
import oracle.jdevimpl.help.HelpContentPanel;
import oracle.jdevimpl.help.HelpContext;
import oracle.jdevimpl.help.HelpTopicEditor;
import oracle.jdevimpl.help.HelpWindow;

public class HelpTopicDocumentPrintFactory
extends DocumentPrintFactory {
    private Context _context;
    private Printable _printable;
    private static double PAGE_MARGIN = 54.0;

    public void create(Context context) {
        this._context = context;
        if (this._context != null) {
            if (this._context.getView() instanceof HelpTopicEditor) {
                HelpTopicEditor helpTopicEditor = (HelpTopicEditor)this._context.getView();
                HTMLBrowser hTMLBrowser = helpTopicEditor.getBrowser();
                URL[] uRLArray = new URL[]{helpTopicEditor.getTopicDisplay().getCurrentURL()};
                this._printable = hTMLBrowser.getPrintable(uRLArray);
                PageFormat pageFormat = this.configurePageFormat();
                PrintManager.getPrintManager().setPrintable(this._printable, pageFormat);
            } else if (this._context.getView() instanceof HelpContentPanel) {
                HelpContentPanel helpContentPanel = (HelpContentPanel)this._context.getView();
                HTMLBrowser hTMLBrowser = helpContentPanel.getBrowser();
                URL[] uRLArray = new URL[]{helpContentPanel.getTopicPanel().getCurrentURL()};
                this._printable = hTMLBrowser.getPrintable(uRLArray);
                PageFormat pageFormat = this.configurePageFormat();
                PrintManager.getPrintManager().setPrintable(this._printable, pageFormat);
            } else if (this._context.getView() instanceof HelpWindow) {
                Object var10_10 = null;
                HelpWindow helpWindow = (HelpWindow)this._context.getView();
                Topic[] topicArray = HelpContext.getTopics(this._context);
                if (topicArray == null) {
                    topicArray = new Topic[]{helpWindow.getTOCNavigator().getCurrentSelection()};
                }
                if (topicArray != null && topicArray.length > 0) {
                    HTMLBrowser hTMLBrowser = null;
                    hTMLBrowser = HelpContentPanel.createHTMLBrowser();
                    if (hTMLBrowser == null) {
                        return;
                    }
                    ArrayList<URL> arrayList = new ArrayList<URL>(topicArray.length);
                    int n = 0;
                    while (n < topicArray.length) {
                        try {
                            if (topicArray[n].hasTarget()) {
                                URL uRL = topicArray[n].getTarget().getURL();
                                arrayList.add(uRL);
                            }
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        ++n;
                    }
                    URL[] uRLArray = arrayList.toArray(new URL[arrayList.size()]);
                    this._printable = hTMLBrowser.getPrintable(uRLArray);
                    PageFormat pageFormat = this.configurePageFormat();
                    PrintManager.getPrintManager().setPrintable(this._printable, pageFormat);
                }
            }
        }
    }

    public boolean isPrintingEnabled(Context context) {
        if (context != null) {
            if (context.getView() instanceof HelpWindow) {
                return ((HelpWindow)context.getView()).isPrintingEnabled();
            }
            if (context.getView() instanceof HelpTopicEditor) {
                return true;
            }
            if (context.getView() instanceof HelpContentPanel) {
                return true;
            }
        }
        return false;
    }

    private void printIt(TopicDisplay topicDisplay, Topic[] topicArray) {
        block2: {
            TopicPrintJob topicPrintJob = topicDisplay.getTopicPrintJob();
            if (topicPrintJob == null) break block2;
            if (topicArray.length == 1) {
                topicPrintJob.printTopic(topicArray[0]);
            } else {
                topicPrintJob.printTopics(topicArray);
            }
        }
    }

    private PageFormat configurePageFormat() {
        PageFormat pageFormat = PrintManager.getPrintManager().getPageFormat();
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (pageFormat == null) {
            pageFormat = printerJob.defaultPage();
        }
        Paper paper = pageFormat.getPaper();
        double d = paper.getWidth();
        double d2 = paper.getHeight();
        paper.setImageableArea(PAGE_MARGIN, PAGE_MARGIN, d - 2.0 * PAGE_MARGIN, d2 - 2.0 * PAGE_MARGIN);
        pageFormat.setPaper(paper);
        pageFormat = printerJob.validatePage(pageFormat);
        return pageFormat;
    }
}

