/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPanel;
import oracle.help.common.Topic;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.library.Library;
import oracle.help.topicDisplay.TopicDisplay;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.view.View;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpContentPanel;
import oracle.jdevimpl.help.HelpSystemConstants;
import oracle.jdevimpl.help.HelpTopicDocument;
import oracle.jdevimpl.help.JDevHelpSystemImpl;

public class HelpTopicEditor
extends Editor {
    private boolean _initialized;
    private HelpTopicDocument _helpDocument;
    private HelpContentPanel _helpContentPanel;
    private JPanel _panel;
    private HelpTopicEditorController _controller;
    private boolean _sharable;
    private Object _parent;
    private boolean _helpSystemDependent;
    public static final int HELP_RELATED = 0;
    public static final int NON_HELP_RELATED = 1;
    private static final String HELP_ID = "f1_helptopic_html";

    void $init$() {
        this._panel = new JPanel();
        this._sharable = true;
        this._helpSystemDependent = true;
    }

    public HelpTopicEditor() {
        this.$init$();
        this._controller = new HelpTopicEditorController();
    }

    public TopicDisplay getTopicDisplayPanel() {
        if (this._helpContentPanel == null) {
            this._init((JDevHelpSystemImpl)HelpSystem.getHelpSystem());
        }
        return this._helpContentPanel.getTopicPanel();
    }

    public TopicDisplay getTopicDisplay() {
        if (this._helpContentPanel == null) {
            return null;
        }
        return this._helpContentPanel.getTopicPanel();
    }

    public void displayTopic(Topic topic) {
        this._helpDocument.setTopic(topic);
        if (topic.getLabel() != null) {
            Ide.getMainWindow().updateTitle((Object)this);
        }
        this._helpContentPanel.displayTopic(topic);
    }

    public Object getEditorAttribute(String string) {
        if (string.equals("vertical_scrollbar_policy")) {
            return new Integer(21);
        }
        return super.getEditorAttribute(string);
    }

    public HTMLBrowser getBrowser() {
        return this._helpContentPanel.getBrowser();
    }

    public HelpTopicDocument getHelpTopicDocument() {
        return this._helpDocument;
    }

    public HelpContentPanel getHelpContentPanel() {
        return this._helpContentPanel;
    }

    public boolean isSharable() {
        return this._sharable;
    }

    public void setSharable(boolean bl) {
        this._sharable = bl;
    }

    public Object getParent() {
        if (this._parent != null) {
            return this._parent;
        }
        return this.owner();
    }

    public void setParent(Object object) {
        this._parent = object;
    }

    public ContextMenu getContextMenu() {
        return this._helpContentPanel.getContextMenu();
    }

    public Controller getController() {
        return this._controller;
    }

    public Toolbar getToolbar() {
        return this._helpContentPanel != null ? this._helpContentPanel._toolbar : null;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo(HELP_ID);
    }

    public void activate() {
        Context context = super.getContext();
        if (HelpSystem.getHelpSystem() instanceof JDevHelpSystemImpl) {
            ((JDevHelpSystemImpl)HelpSystem.getHelpSystem()).setMRUEditor(this);
        }
        if (this._helpContentPanel != null) {
            this._helpContentPanel.syncTOCToURL(this._helpContentPanel.getTopicPanel().getCurrentURL());
        }
    }

    public Component getGUI() {
        return this._panel;
    }

    public void update(Object object, UpdateMessage updateMessage) {
        if (updateMessage.getMessageID() == UpdateMessage.ATTRIBUTE_CHANGED) {
            Ide.getMainWindow().updateTitle((Object)this);
        }
    }

    public synchronized void setContext(Context context) {
        Node node = context.getNode();
        if (node instanceof HelpTopicDocument) {
            super.setContext(context);
            this._helpDocument = (HelpTopicDocument)node;
            if (node.getURL() != null) {
                this._helpDocument.setURL(node.getURL());
            }
        } else if (node.getURL() != null) {
            super.setContext(context);
            this._helpDocument = new HelpTopicDocument(node.getURL());
        }
        this._helpDocument.attach((Observer)this);
    }

    public void open() {
        if (!this._initialized && this._init((JDevHelpSystemImpl)HelpSystem.getHelpSystem())) {
            this._initialized = true;
        }
        this._helpContentPanel.getTopicPanel().displayTopic(this._helpDocument.getTopic());
        this._helpDocument.setOpenOverride(true);
    }

    public boolean isHelpSystemDependent() {
        return this._helpDocument.isHelpDependent();
    }

    public String getTitleLabel() {
        return HelpArb.getString(57);
    }

    public String getTabLabel() {
        return HelpArb.getString(58);
    }

    public Icon getTabIcon() {
        return HelpArb.getIcon(59);
    }

    public Component getDefaultFocusComponent() {
        return GraphicsUtils.getFocusableComponentOrChild((Component)this._helpContentPanel.getTopicPanel().getDisplayContainer(), (boolean)true);
    }

    public void close() {
        super.close();
        EditorManager.getEditorManager().removeLayoutListener(this.getId());
        if (HelpSystem.getHelpSystem() instanceof JDevHelpSystemImpl) {
            ((JDevHelpSystemImpl)HelpSystem.getHelpSystem()).removeEditor(this);
        }
        this._controller = null;
        if (this._helpContentPanel != null) {
            this._helpContentPanel.dispose();
        }
        this._helpContentPanel = null;
    }

    private boolean _init(JDevHelpSystemImpl jDevHelpSystemImpl) {
        if (this._helpDocument.isHelpDependent()) {
            this._helpSystemDependent = true;
            Library library = jDevHelpSystemImpl.getLibrary();
            this._helpContentPanel = library != null ? new HelpContentPanel(library, true, false, (Object)this) : new HelpContentPanel((Object)this);
        } else {
            this._helpSystemDependent = false;
            this._helpContentPanel = new HelpContentPanel((Object)this);
        }
        this._panel.setLayout(new BorderLayout());
        this._panel.add(this._helpContentPanel.getGUI(), "Center");
        return true;
    }

    static HelpContentPanel ra$_helpContentPanel(HelpTopicEditor helpTopicEditor) {
        return helpTopicEditor._helpContentPanel;
    }

    private class HelpTopicEditorController
    implements Controller {
        private IdeAction _findAction = IdeAction.find((int)23);
        private IdeAction _closeAction = IdeAction.find((int)48);
        private IdeAction _closeAllAction = IdeAction.find((int)39);
        private IdeAction _copyAction = IdeAction.find((int)18);
        private IdeAction _printAction = IdeAction.find((int)16);

        public boolean update(IdeAction ideAction, Context context) {
            View view;
            if (context != null && (view = context.getView()) instanceof HelpTopicEditor) {
                int n = ideAction.getCommandId();
                if (n == 23) {
                    ideAction.setEnabled(true);
                    return true;
                }
                if (n == 48) {
                    ideAction.setEnabled(true);
                    return true;
                }
                if (n == 39) {
                    ideAction.setEnabled(true);
                    return true;
                }
                if (n == 18) {
                    ideAction.setEnabled(HelpTopicEditor.ra$_helpContentPanel(HelpTopicEditor.this).isTextSelected());
                    return true;
                }
                if (n == 16) {
                    ideAction.setEnabled(true);
                    return true;
                }
                if (n == HelpSystemConstants.BACKWARD_CMD_ID) {
                    return HelpTopicEditor.ra$_helpContentPanel(HelpTopicEditor.this).getController().update(ideAction, context);
                }
                if (n == HelpSystemConstants.FORWARD_CMD_ID) {
                    return HelpTopicEditor.ra$_helpContentPanel(HelpTopicEditor.this).getController().update(ideAction, context);
                }
            }
            return false;
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            View view;
            int n = ideAction.getCommandId();
            if (context != null && (view = context.getView()) instanceof HelpTopicEditor) {
                if (n == 23) {
                    HelpTopicEditor.ra$_helpContentPanel(HelpTopicEditor.this).runFindDialog();
                    return true;
                }
                if (n == 18) {
                    HelpTopicEditor.ra$_helpContentPanel(HelpTopicEditor.this).copy();
                    return true;
                }
                if (n == HelpSystemConstants.BACKWARD_CMD_ID) {
                    HelpTopicEditor.ra$_helpContentPanel(HelpTopicEditor.this).getController().handleEvent(ideAction, context);
                } else if (n == HelpSystemConstants.FORWARD_CMD_ID) {
                    HelpTopicEditor.ra$_helpContentPanel(HelpTopicEditor.this).getController().handleEvent(ideAction, context);
                }
            }
            return false;
        }
    }
}

