/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.library.Library;
import oracle.help.navigator.LazyNavigator;
import oracle.help.navigator.Navigator;
import oracle.help.navigator.NavigatorEvent;
import oracle.help.navigator.NavigatorListener;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;
import oracle.help.navigator.keywordNavigator.KeywordNavigator;
import oracle.help.navigator.searchNavigator.SearchNavigator;
import oracle.help.navigator.tocNavigator.TOCNavigator;
import oracle.help.topicDisplay.TopicDisplayEvent;
import oracle.help.topicDisplay.TopicDisplayListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DockingParam;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;
import oracle.ide.print.PrintManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.ideimpl.controls.SwitchablePanel;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.help.CueCardOverviewPanel;
import oracle.jdevimpl.help.CueCardOverviewWindow;
import oracle.jdevimpl.help.CueCardSet;
import oracle.jdevimpl.help.CueCardTopic;
import oracle.jdevimpl.help.DynamicLinksNavigator;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpContentPanel;
import oracle.jdevimpl.help.HelpContext;
import oracle.jdevimpl.help.HelpOptions;
import oracle.jdevimpl.help.HelpSystemConstants;
import oracle.jdevimpl.help.JDevCueCardNavigator;
import oracle.jdevimpl.help.JDevFavoritesNavigator;
import oracle.jdevimpl.help.JDevHelpSystemImpl;
import oracle.jdevimpl.help.JDevLibrary;
import oracle.jdevimpl.help.JDevTOCNavigator;
import oracle.jdevimpl.help.MultipleTypeTopic;
import oracle.jdevimpl.java.JavaArb;

public class HelpWindow
extends DockableWindow
implements ChangeListener,
ActionListener,
ListSelectionListener,
Controller,
ContextMenuListener {
    public static final String VIEW_TYPE = "HelpSystemAddin";
    public static final String NAME = "HelpWindow";
    private JPanel _panel;
    private SwitchablePanel _switchablePanel;
    private boolean _initialized;
    private DefaultCustomTabPage _TOCPage;
    private JDevTOCNavigator _TOCNavigator;
    private DefaultCustomTabPage _keywordPage;
    private KeywordNavigator _keywordNavigator;
    private DefaultCustomTabPage _searchPage;
    private SearchNavigator _searchNavigator;
    private TOCNavigator _assignmentsNavigator;
    private DefaultCustomTabPage _assignmentsPage;
    private JDevFavoritesNavigator _favoritesNavigator;
    private DefaultCustomTabPage _favoritesPage;
    private DynamicLinksNavigator _dynamicLinksNavigator;
    private DefaultCustomTabPage _dynamicLinksPage;
    private JDevCueCardNavigator _cueCardNavigator;
    private DefaultCustomTabPage _cueCardPage;
    private DefaultCustomTabPage _cueCardViewPage;
    private HelpContentPanel _cueCardViewer;
    private DefaultCustomTabPage _errorPage;
    private JScrollPane _errorScrollPane;
    private String _windowTitle;
    private HelpNavigatorListener _helpNavigatorListener;
    private ContextMenu _contextMenu;
    private CustomTab _tabs;
    private DefaultCustomTabPage _currentPage;
    private JMultiLineLabel _helpText;
    private JTextArea _textArea;
    private JLabel _textAreaLbl;
    private boolean _uiInitialized;
    private JButton _removeTabBtn;
    private JButton _clearTextBtn;
    private Action _closeTabAction;
    private MouseListener _contextMenuMouseListener;
    private CueCardOverviewWindow _overviewWindow;
    private static final int PRINT_TOPIC_SUBTREE_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.PrintTopicSubtreeCmd");
    private static final int OPEN_IN_NEW_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.OpenInNewEditorCmd");
    private static final int OPEN_IN_NEW_WINDOW_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.OpenInNewWindowCmd");
    private static final int CLOSE_HELP_TAB_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.CloseTabCmd");
    private static final int OPEN_CUE_CARD_VIEWER_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.OpenCueCardViewerCmd");
    private static final int TOC_TAB_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.TOCTabCmd");
    private static final int IDX_TAB_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.IDXTabCmd");
    private static final int SRCH_TAB_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.SRCHTabCmd");
    private static final int FAV_TAB_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.FAVTabCmd");
    private static final int CUE_TAB_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.CUETabCmd");
    private static final int DYN_TAB_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.DYNTabCmd");
    private static final int LEFT = -1;
    private static final int RIGHT = 1;
    public static final int TOC_NAVIGATOR = 0;
    public static final int KEYWORD_NAVIGATOR = 1;
    public static final int SEARCH_NAVIGATOR = 2;
    public static final int FAVORITES_NAVIGATOR = 3;
    public static final int DYNAMIC_LINKS_NAVIGATOR = 4;
    public static final int CUE_CARDS_NAVIGATOR = 5;
    private static final int CUE_CARD_VIEWER = 6;
    public static final int ERROR_DISPLAY = 7;
    static final String FOCUSED_TAB_NODE = "HelpWindowFocusedTabNode";
    static final String FOCUSED_TAB_NUM = "TabNum";
    private static final String HELP_ID = "f1_helpnav_html";

    void $init$() {
        this._panel = new JPanel();
        this._windowTitle = HelpArb.getString(41);
        this._closeTabAction = new TabCloseAction(null);
        this._contextMenuMouseListener = new ContextMenuMouseListener(null);
    }

    public HelpWindow(String string) {
        super(string);
        this.$init$();
        this._helpNavigatorListener = new HelpNavigatorListener(null);
    }

    public String getTitleName() {
        return this._windowTitle;
    }

    public String getTabName() {
        return HelpArb.getString(40);
    }

    public Icon getTabIcon() {
        return HelpArb.getIcon(43);
    }

    public String getMenuTitle() {
        return HelpArb.getString(41);
    }

    public Component getGUI() {
        this._init();
        return this._panel;
    }

    public Toolbar getToolbar() {
        if (this._currentPage == this._dynamicLinksPage) {
            return this._dynamicLinksNavigator.getToolbar();
        }
        return null;
    }

    public int getType() {
        return 32;
    }

    public TOCNavigator getTOCNavigator() {
        return this._TOCNavigator;
    }

    public void updateTitle() {
        super.updateTitle((Object)this._windowTitle);
        this.fireTitleChangeListener();
    }

    public static ViewId getHelpWindowViewId() {
        return new ViewId("HelpSystemAddin.HelpWindow");
    }

    final void switchNavigator(int n) {
        if (n == 7) {
            if (!this._uiInitialized) {
                this._initializeUI();
            }
            this._addErrorTab();
            this._tabs.setSelectedPage(this._tabs.searchPage((CustomTabPage)this._errorPage));
        } else {
            if (!this._init()) {
                return;
            }
            DefaultCustomTabPage defaultCustomTabPage = this.getTabPageForIntPage(n);
            this.setSelectedTabToTab((CustomTabPage)defaultCustomTabPage);
        }
    }

    private void setSelectedTabToTab(CustomTabPage customTabPage) {
        ListModel listModel = this._tabs.getModel();
        int n = listModel.getSize();
        int n2 = 0;
        while (n2 < n) {
            if (listModel.getElementAt(n2) == customTabPage) {
                this._tabs.setSelectedPage(n2);
                return;
            }
            ++n2;
        }
        this._handleDisplay(customTabPage, true);
        this._setPageShowOption(customTabPage, true);
        this.setSelectedTabToTab(customTabPage);
    }

    protected void dockableHidden(DockableEvent dockableEvent) {
        if (dockableEvent.getID() == 1) {
            this._saveLayout();
            if (this._overviewWindow != null) {
                this._overviewWindow.close();
            }
        }
        if (this._currentPage == this._dynamicLinksPage) {
            this._dynamicLinksNavigator.deactivate();
        }
        super.dockableHidden(dockableEvent);
    }

    protected void dockableShown(DockableEvent dockableEvent) {
        if (this._currentPage == this._dynamicLinksPage && this._dynamicLinksNavigator != null) {
            this._dynamicLinksNavigator.activate();
        }
        super.dockableShown(dockableEvent);
    }

    public void close() {
        this.dispose();
        super.close();
    }

    public void dispose() {
        if (this._initialized) {
            this._helpNavigatorListener.removeListener();
            this._TOCPage.setUserObject(null);
            this._keywordPage.setUserObject(null);
            this._searchPage.setUserObject(null);
            this._favoritesPage.setUserObject(null);
            this._dynamicLinksPage.setUserObject(null);
            this._cueCardPage.setUserObject(null);
            if (this._cueCardViewPage != null) {
                this._cueCardViewPage.setUserObject(null);
            }
            this._switchablePanel = null;
            this._textArea.setText(null);
            this._TOCNavigator = null;
            this._keywordNavigator = null;
            this._searchNavigator = null;
            this._favoritesNavigator = null;
            this._dynamicLinksNavigator = null;
            this._cueCardNavigator = null;
            IdeAction ideAction = IdeAction.find((int)EditorManagerImpl.SHOW_DROPDOWN_CMD_ID);
            ideAction.removeController((Controller)this);
            this._initialized = false;
        }
    }

    public boolean isPrintingEnabled() {
        if (this._currentPage != null && this._currentPage.getUserObject() != null) {
            Component component = (Component)this._currentPage.getUserObject();
            if (component instanceof TOCNavigator) {
                return this._TOCNavigator.getCurrentSelection() != null;
            }
            return false;
        }
        return false;
    }

    public void putError(String string) {
        if (this._textArea != null) {
            this._textArea.append(string + "\n");
            this._clearTextBtn.setEnabled(true);
            this._addErrorTab();
            this._tabs.setSelectedPage(7);
        }
    }

    void showCueCardSetForId(String string) {
        JDevLibrary jDevLibrary;
        CueCardSet cueCardSet;
        if (!this._initialized && !this._init()) {
            return;
        }
        JDevHelpSystemImpl jDevHelpSystemImpl = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
        Library library = jDevHelpSystemImpl.getLibrary();
        if (library != null && library instanceof JDevLibrary && (cueCardSet = (jDevLibrary = (JDevLibrary)library).getCueCardSetById(string)) != null) {
            this.showCueCardSet(cueCardSet);
        }
    }

    public ContextMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu();
            this._contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
        if (this._currentPage != null) {
            return this._contextMenu;
        }
        return null;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo(HELP_ID);
    }

    public Controller getController() {
        return this;
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        this.addMenuItems(contextMenu, null);
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getFirstIndex() == -1) {
            return;
        }
        DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._tabs.getPage(listSelectionEvent.getFirstIndex());
        if (defaultCustomTabPage == this._currentPage) {
            return;
        }
        Component component = (Component)defaultCustomTabPage.getUserObject();
        NavigatorHolder navigatorHolder = null;
        if (component instanceof NavigatorHolder) {
            navigatorHolder = (NavigatorHolder)component;
            component = navigatorHolder.getNavigator();
        }
        if (component == null) {
            this._initNavigatorHolder(defaultCustomTabPage);
            component = ((NavigatorHolder)defaultCustomTabPage.getUserObject()).getNavigator();
            component = this._errorScrollPane;
            defaultCustomTabPage = this._errorPage;
        }
        this._helpNavigatorListener.removeListener();
        this._currentPage = defaultCustomTabPage;
        this.updateSelection();
        if (component instanceof Navigator) {
            this._helpNavigatorListener.addListenerToNavigator((Navigator)component);
        }
        if (component == this._TOCNavigator) {
            if (!this._TOCNavigator.isInitialized()) {
                this._TOCNavigator.initializeLazyNavigator();
            }
        } else if ((component instanceof KeywordNavigator || component instanceof SearchNavigator) && component instanceof LazyNavigator) {
            LazyNavigator lazyNavigator = (LazyNavigator)component;
            if (!lazyNavigator.isInitialized()) {
                lazyNavigator.initializeLazyNavigator();
            }
            this.setLabelsNonFocusable(component);
        }
    }

    private void setLabelsNonFocusable(Component component) {
        Component[] componentArray = ((Container)component).getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component2 = componentArray[n];
            if (component2 instanceof JPanel) {
                this.setLabelsNonFocusable(component2);
            } else if (component2 instanceof JLabel) {
                component2.setFocusable(false);
            }
            ++n;
        }
    }

    private void _setPageShowOption(CustomTabPage customTabPage, boolean bl) {
        IdeSettings ideSettings = Ide.getSettings();
        HelpOptions helpOptions = (HelpOptions)((Object)ideSettings.getData("HelpOptions"));
        if (customTabPage == this._TOCPage) {
            helpOptions.setShowTOC(bl);
        } else if (customTabPage == this._keywordPage) {
            helpOptions.setShowKeywordIndex(bl);
        } else if (customTabPage == this._searchPage) {
            helpOptions.setShowFullTextSearch(bl);
        } else if (customTabPage == this._favoritesPage) {
            helpOptions.setShowFavorites(bl);
        } else if (customTabPage == this._cueCardPage) {
            helpOptions.setShowCueCards(bl);
        } else if (customTabPage == this._dynamicLinksPage) {
            helpOptions.setShowDynamicLinks(bl);
        }
    }

    private void _toggleTab(int n) {
        IdeSettings ideSettings = Ide.getSettings();
        HelpOptions helpOptions = (HelpOptions)((Object)ideSettings.getData("HelpOptions"));
        DefaultCustomTabPage defaultCustomTabPage = null;
        boolean bl = false;
        int n2 = -1;
        if (n == TOC_TAB_CMD_ID) {
            helpOptions.setShowTOC(helpOptions.getShowTOC() ^ true);
            bl = helpOptions.getShowTOC();
            n2 = 0;
            defaultCustomTabPage = this._TOCPage;
        } else if (n == IDX_TAB_CMD_ID) {
            helpOptions.setShowKeywordIndex(helpOptions.getShowKeywordIndex() ^ true);
            bl = helpOptions.getShowKeywordIndex();
            n2 = 1;
            defaultCustomTabPage = this._keywordPage;
        } else if (n == SRCH_TAB_CMD_ID) {
            helpOptions.setShowFullTextSearch(helpOptions.getShowFullTextSearch() ^ true);
            bl = helpOptions.getShowFullTextSearch();
            n2 = 2;
            defaultCustomTabPage = this._searchPage;
        } else if (n == FAV_TAB_CMD_ID) {
            helpOptions.setShowFavorites(helpOptions.getShowFavorites() ^ true);
            bl = helpOptions.getShowFavorites();
            n2 = 3;
            defaultCustomTabPage = this._favoritesPage;
        } else if (n == DYN_TAB_CMD_ID) {
            helpOptions.setShowDynamicLinks(helpOptions.getShowDynamicLinks() ^ true);
            bl = helpOptions.getShowDynamicLinks();
            n2 = 4;
            defaultCustomTabPage = this._dynamicLinksPage;
        } else if (n == CUE_TAB_CMD_ID) {
            helpOptions.setShowCueCards(helpOptions.getShowCueCards() ^ true);
            bl = helpOptions.getShowCueCards();
            n2 = 5;
            defaultCustomTabPage = this._cueCardPage;
        }
        this._handleDisplay((CustomTabPage)defaultCustomTabPage, bl);
        if (bl) {
            this.switchNavigator(n2);
        } else {
            int n3 = this._determineNavigation(-1);
            if (n3 != -1) {
                this._tabs.setSelectedPage(n3);
            } else {
                n3 = this._determineNavigation(1);
                if (n3 != -1) {
                    this._tabs.setSelectedPage(n3);
                }
            }
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == PRINT_TOPIC_SUBTREE_CMD_ID) {
            TopicTreeNode topicTreeNode = this._TOCNavigator.getCurrentSelectionNode();
            Topic[] topicArray = topicTreeNode.getAllTopicsInSubTree();
            Context context2 = new Context(context);
            HelpContext.setTopics(context2, topicArray);
            PrintManager.getPrintManager().handleEvent(IdeAction.find((int)16), context2);
            return true;
        }
        if (n == OPEN_IN_NEW_EDITOR_CMD_ID) {
            Topic topic = null;
            topic = this._currentPage == this._TOCPage ? this._TOCNavigator.getCurrentSelection() : (this._currentPage == this._favoritesPage ? this._favoritesNavigator.getCurrentSelection() : this._dynamicLinksNavigator.getCurrentSelection());
            if (topic != null && HelpSystem.getHelpSystem() instanceof JDevHelpSystemImpl) {
                ((JDevHelpSystemImpl)HelpSystem.getHelpSystem()).showTopic(topic, true, false);
            }
            return true;
        }
        if (n == HelpSystemConstants.BACKWARD_CMD_ID) {
            if (this._currentPage != null && this._currentPage == this._cueCardViewPage && this._cueCardViewer != null) {
                this._cueCardViewer.goBackward();
                return true;
            }
        } else if (n == HelpSystemConstants.FORWARD_CMD_ID) {
            if (this._currentPage != null && this._currentPage == this._cueCardViewPage && this._cueCardViewer != null) {
                this._cueCardViewer.goForward();
                return true;
            }
        } else {
            if (n == OPEN_IN_NEW_WINDOW_CMD_ID) {
                Topic topic = null;
                topic = this._currentPage == this._TOCPage ? this._TOCNavigator.getCurrentSelection() : (this._currentPage == this._favoritesPage ? this._favoritesNavigator.getCurrentSelection() : this._dynamicLinksNavigator.getCurrentSelection());
                if (topic != null && HelpSystem.getHelpSystem() instanceof JDevHelpSystemImpl) {
                    ((JDevHelpSystemImpl)HelpSystem.getHelpSystem()).showTopic(topic, true, true);
                }
                return true;
            }
            if (n == 68) {
                if (context.getView() instanceof HelpWindow) {
                    boolean bl = this._dynamicLinksNavigator.getPinState() ^ true;
                    this._dynamicLinksNavigator.setPinState(bl);
                    if (bl) {
                        this._dynamicLinksNavigator.deactivate();
                    } else {
                        this._dynamicLinksNavigator.activate();
                    }
                    return true;
                }
            } else {
                if (n == CLOSE_HELP_TAB_CMD_ID) {
                    if (this._currentPage != null) {
                        this._closeTabPage((CustomTabPage)this._currentPage);
                    }
                    return true;
                }
                if (n == 70) {
                    this._navigate(-1);
                    return true;
                }
                if (n == 71) {
                    this._navigate(1);
                    return true;
                }
                if (n == EditorManagerImpl.SHOW_DROPDOWN_CMD_ID) {
                    if (context.getView() instanceof HelpWindow) {
                        this._switchablePanel.displayDropdownMenu();
                        return true;
                    }
                } else {
                    if (n == OPEN_CUE_CARD_VIEWER_CMD_ID) {
                        CueCardSet cueCardSet = (CueCardSet)this._cueCardNavigator.getCurrentSelection();
                        this._cueCardNavigator.selectCueCardSet(cueCardSet);
                        return true;
                    }
                    if (n == TOC_TAB_CMD_ID || n == IDX_TAB_CMD_ID || n == SRCH_TAB_CMD_ID || n == FAV_TAB_CMD_ID || n == DYN_TAB_CMD_ID || n == CUE_TAB_CMD_ID) {
                        this._toggleTab(n);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (ideAction == null) {
            return false;
        }
        int n = ideAction.getCommandId();
        if (n == 16) {
            ideAction.setEnabled(this.isPrintingEnabled());
            return true;
        }
        if (n == 68) {
            if (context.getView() instanceof HelpWindow && this._currentPage == this._dynamicLinksPage) {
                ideAction.setEnabled(true);
                boolean bl = this._dynamicLinksNavigator.getPinState();
                ideAction.putValue("State", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
                return true;
            }
        } else {
            if (n == 70) {
                ideAction.setEnabled(this._determineNavigation(-1) != -1);
                return true;
            }
            if (n == 71) {
                ideAction.setEnabled(this._determineNavigation(1) != -1);
                return true;
            }
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._removeTabBtn) {
            this._textArea.setText(null);
            this._switchablePanel.removePage((CustomTabPage)this._errorPage);
        } else if (actionEvent.getSource() == this._clearTextBtn) {
            this._textArea.setText(null);
            this._textArea.requestFocusInWindow();
            this._clearTextBtn.setEnabled(false);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this._displayAppropriateTabs();
    }

    private synchronized boolean _init() {
        if (!this._uiInitialized) {
            this._initializeUI();
        }
        if (this._initialized) {
            return true;
        }
        WaitCursor waitCursor = Ide.getWaitCursor();
        waitCursor.show();
        JDevHelpSystemImpl jDevHelpSystemImpl = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
        Library library = jDevHelpSystemImpl.getLibrary();
        if (library != null) {
            IdeSettings ideSettings;
            HelpOptions helpOptions;
            boolean bl = false;
            oracle.help.common.View[] viewArray = library.getAllViews();
            if (viewArray != null) {
                int n = 0;
                while (n < viewArray.length) {
                    String string = viewArray[n].getLabel();
                    if (string != null && string.equals("Assignments")) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
            if ((helpOptions = (HelpOptions)((Object)(ideSettings = Ide.getSettings()).getData("HelpOptions"))).getShowTOC()) {
                this._switchablePanel.addPage((CustomTabPage)this._TOCPage, (Component)this._TOCPage.getUserObject());
            }
            if (helpOptions.getShowKeywordIndex()) {
                this._switchablePanel.addPage((CustomTabPage)this._keywordPage, (Component)this._keywordPage.getUserObject());
            }
            if (helpOptions.getShowFullTextSearch()) {
                this._switchablePanel.addPage((CustomTabPage)this._searchPage, (Component)this._searchPage.getUserObject());
            }
            if (helpOptions.getShowFavorites()) {
                this._switchablePanel.addPage((CustomTabPage)this._favoritesPage, (Component)this._favoritesPage.getUserObject());
            }
            if (helpOptions.getShowDynamicLinks()) {
                this._switchablePanel.addPage((CustomTabPage)this._dynamicLinksPage, (Component)this._dynamicLinksPage.getUserObject());
            }
            if (helpOptions.getShowCueCards()) {
                this._switchablePanel.addPage((CustomTabPage)this._cueCardPage, (Component)this._cueCardPage.getUserObject());
            }
            if (bl) {
                try {
                    this._assignmentsNavigator = (TOCNavigator)Navigator.createNavigator((String)"oracle.help.navigator.tocNavigator.TOCNavigator", (Library)library, (String)"Assignments", null, (boolean)true);
                    this._assignmentsPage.setUserObject((Object)this._assignmentsNavigator);
                    this._assignmentsNavigator.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
                    this._switchablePanel.addPage((CustomTabPage)this._assignmentsPage, (Component)this._assignmentsNavigator);
                }
                catch (Exception exception) {
                    this._initialized = false;
                    this._removeTabBtn.setEnabled(false);
                    waitCursor.hide();
                    boolean bl2 = false;
                    return bl2;
                }
            }
            int n = -1;
            if (jDevHelpSystemImpl != null && jDevHelpSystemImpl instanceof JDevHelpSystemImpl) {
                n = this._getLastFocusedTab(jDevHelpSystemImpl.getLayout());
            }
            this._currentPage = n == -1 ? this.getTabPageForIntPage(4) : this.getTabPageForIntPage(n);
            this._handleDisplay((CustomTabPage)this._currentPage, true);
            NavigatorHolder navigatorHolder = (NavigatorHolder)this._currentPage.getUserObject();
            if (navigatorHolder.getNavigator() == null) {
                this._initNavigatorHolder(this._currentPage);
            }
            Navigator navigator = navigatorHolder.getNavigator();
            this._helpNavigatorListener.addListenerToNavigator(navigator);
            this._switchablePanel.moveToFront((Component)navigatorHolder);
            this.setSelectedTabToTab((CustomTabPage)this._currentPage);
            this._tabs.addHierarchyListener((HierarchyListener)new TabHierarchyListener(null));
            if (navigator instanceof LazyNavigator) {
                ((LazyNavigator)navigator).initializeLazyNavigator();
            } else if (navigator instanceof JDevTOCNavigator) {
                ((JDevTOCNavigator)navigator).initializeLazyNavigator();
            }
            this._panel.revalidate();
            this._initialized = true;
            this._removeErrorTab();
            this._removeTabBtn.setEnabled(true);
            waitCursor.hide();
            return true;
        }
        this._setInitializationErrors(jDevHelpSystemImpl);
        this._initialized = false;
        this._addErrorTab();
        this._switchablePanel.moveToFront((Component)this._errorScrollPane);
        this._removeTabBtn.setEnabled(false);
        waitCursor.hide();
        return false;
    }

    private Library getLibrary() {
        JDevHelpSystemImpl jDevHelpSystemImpl = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
        Library library = jDevHelpSystemImpl.getLibrary();
        return library;
    }

    private void _initNavigatorHolder(DefaultCustomTabPage defaultCustomTabPage) {
        WaitCursor waitCursor = Ide.getWaitCursor();
        waitCursor.show();
        Library library = this.getLibrary();
        if (defaultCustomTabPage == this._TOCPage) {
            this._initTOCNavigator(library);
        } else if (defaultCustomTabPage == this._keywordPage) {
            this._initKeywordNavigator(library);
        } else if (defaultCustomTabPage == this._searchPage) {
            this._initSearchNavigator(library);
        } else if (defaultCustomTabPage == this._favoritesPage) {
            this._initFavoritesNavigator(library);
        } else if (defaultCustomTabPage == this._dynamicLinksPage) {
            this._initDynamicLinksNavigator(library);
        } else if (defaultCustomTabPage == this._cueCardPage) {
            this._initCueCardNavigator(library);
        }
        waitCursor.hide();
    }

    private boolean _initTOCNavigator(Library library) {
        boolean bl = false;
        if (library != null) {
            try {
                this._TOCNavigator = new JDevTOCNavigator(this, library, "Contents");
                NavigatorHolder navigatorHolder = (NavigatorHolder)this._TOCPage.getUserObject();
                navigatorHolder.setNavigator((Navigator)this._TOCNavigator);
                this._TOCNavigator.setBorder(new EmptyBorder(0, 0, 0, 0));
                bl = true;
            }
            catch (Exception exception) {
                this._removeTabBtn.setEnabled(false);
            }
        }
        return bl;
    }

    private boolean _initKeywordNavigator(Library library) {
        boolean bl = false;
        if (library != null) {
            try {
                this._keywordNavigator = (KeywordNavigator)Navigator.createNavigator((String)"oracle.help.navigator.keywordNavigator.KeywordNavigator", (Library)library, (String)"Index", null, (boolean)true);
                NavigatorHolder navigatorHolder = (NavigatorHolder)this._keywordPage.getUserObject();
                navigatorHolder.setNavigator((Navigator)this._keywordNavigator);
                this._keywordNavigator.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
                this._keywordNavigator.addMouseListener(this._contextMenuMouseListener);
                bl = true;
            }
            catch (Exception exception) {
                this._removeTabBtn.setEnabled(false);
            }
        }
        return bl;
    }

    private boolean _initSearchNavigator(Library library) {
        boolean bl = false;
        if (library != null) {
            try {
                this._searchNavigator = (SearchNavigator)Navigator.createNavigator((String)"oracle.help.navigator.searchNavigator.SearchNavigator", (Library)library, (String)"Search", null, (boolean)true);
                NavigatorHolder navigatorHolder = (NavigatorHolder)this._searchPage.getUserObject();
                navigatorHolder.setNavigator((Navigator)this._searchNavigator);
                this._searchNavigator.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
                this._searchNavigator.addMouseListener(this._contextMenuMouseListener);
                bl = true;
            }
            catch (Exception exception) {
                this._removeTabBtn.setEnabled(false);
            }
        }
        return bl;
    }

    private boolean _initFavoritesNavigator(Library library) {
        boolean bl = false;
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        if (library != null) {
            try {
                FavoritesModel favoritesModel;
                if (helpSystem != null && helpSystem instanceof JDevHelpSystemImpl && (favoritesModel = ((JDevHelpSystemImpl)helpSystem).getFavoritesModel()) != null) {
                    this._favoritesNavigator = new JDevFavoritesNavigator(this, library, "Favorites");
                    this._favoritesNavigator.setFavoritesModel(favoritesModel);
                    NavigatorHolder navigatorHolder = (NavigatorHolder)this._favoritesPage.getUserObject();
                    navigatorHolder.setNavigator((Navigator)this._favoritesNavigator);
                    this._favoritesNavigator.setBorder(new EmptyBorder(0, 0, 0, 0));
                    bl = true;
                }
            }
            catch (Exception exception) {
                this._removeTabBtn.setEnabled(false);
            }
        }
        return bl;
    }

    private boolean _initDynamicLinksNavigator(Library library) {
        boolean bl = false;
        if (library != null) {
            try {
                this._dynamicLinksNavigator = (DynamicLinksNavigator)Navigator.createNavigator((String)"oracle.jdevimpl.help.DynamicLinksNavigator", (Library)library, (String)"Dynamic Links", null, (boolean)true);
                NavigatorHolder navigatorHolder = (NavigatorHolder)this._dynamicLinksPage.getUserObject();
                navigatorHolder.setNavigator((Navigator)this._dynamicLinksNavigator);
                this._dynamicLinksNavigator.setHelpWindow(this);
                this._dynamicLinksNavigator.getTree().addMouseListener(this._contextMenuMouseListener);
                bl = true;
            }
            catch (Exception exception) {
                this._removeTabBtn.setEnabled(false);
            }
        }
        return bl;
    }

    private boolean _initCueCardNavigator(Library library) {
        boolean bl = false;
        if (library != null) {
            try {
                this._cueCardNavigator = new JDevCueCardNavigator(this, library, "Cue Cards");
                NavigatorHolder navigatorHolder = (NavigatorHolder)this._cueCardPage.getUserObject();
                navigatorHolder.setNavigator((Navigator)this._cueCardNavigator);
                bl = true;
            }
            catch (Exception exception) {
                this._removeTabBtn.setEnabled(false);
            }
        }
        return bl;
    }

    private void _initializeUI() {
        NavigatorHolder navigatorHolder = new NavigatorHolder(null);
        this._TOCPage = new DefaultCustomTabPage(null, HelpArb.getString(34), (Object)navigatorHolder);
        navigatorHolder.setTabPage(this._TOCPage);
        this._TOCPage.setTooltip(HelpArb.getString(34));
        navigatorHolder = new NavigatorHolder(null);
        this._keywordPage = new DefaultCustomTabPage(null, HelpArb.getString(36), (Object)navigatorHolder);
        navigatorHolder.setTabPage(this._keywordPage);
        this._keywordPage.setTooltip(HelpArb.getString(36));
        navigatorHolder = new NavigatorHolder(null);
        this._searchPage = new DefaultCustomTabPage(null, HelpArb.getString(38), (Object)navigatorHolder);
        navigatorHolder.setTabPage(this._searchPage);
        this._searchPage.setTooltip(HelpArb.getString(38));
        navigatorHolder = new NavigatorHolder(null);
        this._assignmentsPage = new DefaultCustomTabPage(null, HelpArb.getString(55), (Object)navigatorHolder);
        navigatorHolder.setTabPage(this._assignmentsPage);
        this._assignmentsPage.setTooltip(HelpArb.getString(55));
        navigatorHolder = new NavigatorHolder(null);
        this._favoritesPage = new DefaultCustomTabPage(null, HelpArb.getString(56), (Object)navigatorHolder);
        navigatorHolder.setTabPage(this._favoritesPage);
        this._favoritesPage.setTooltip(HelpArb.getString(56));
        navigatorHolder = new NavigatorHolder(null);
        this._dynamicLinksPage = new DefaultCustomTabPage(null, HelpArb.getString(89), (Object)navigatorHolder);
        navigatorHolder.setTabPage(this._dynamicLinksPage);
        this._dynamicLinksPage.setTooltip(HelpArb.getString(89));
        navigatorHolder = new NavigatorHolder(null);
        this._cueCardPage = new DefaultCustomTabPage(null, HelpArb.getString(96), (Object)navigatorHolder);
        navigatorHolder.setTabPage(this._cueCardPage);
        this._cueCardPage.setTooltip(HelpArb.getString(96));
        this._panel.setLayout(new BorderLayout());
        this._createErrorPage();
        Component[] componentArray = new Component[]{this._errorScrollPane};
        this._switchablePanel = new SwitchablePanel();
        this._switchablePanel.setDisplayTabNavigators(true);
        this._tabs = this._switchablePanel.getCustomTab();
        this._tabs.setGapBeforeTabs(-1);
        this._tabs.addSelectionListener((ListSelectionListener)this);
        this._tabs.setCloseAction(this._closeTabAction);
        this._tabs.addMouseListener((MouseListener)new CustomTabMouseListener(null));
        this._switchablePanel.setDisplayTabNavigators(true);
        IdeAction ideAction = IdeAction.find((int)EditorManagerImpl.SHOW_DROPDOWN_CMD_ID);
        ideAction.addController((Controller)this);
        this._panel.add((Component)this._switchablePanel, "Center");
        IdeSettings ideSettings = Ide.getSettings();
        HelpOptions helpOptions = (HelpOptions)((Object)ideSettings.getData("HelpOptions"));
        helpOptions.addChangeListener(this);
        this._uiInitialized = true;
    }

    private int _getNumPagesNotCueCardViewer() {
        DefaultListModel defaultListModel = this._switchablePanel.getModel();
        int n = defaultListModel.getSize();
        if (this._cueCardViewPage == null) {
            return n;
        }
        return n - 1;
    }

    private void _closeTabPage(CustomTabPage customTabPage) {
        block1: {
            block0: {
                if (customTabPage != this._cueCardViewPage) break block0;
                this._switchablePanel.removePage(customTabPage);
                this._cueCardViewPage = null;
                this._cueCardViewer.dispose();
                this._cueCardViewer = null;
                if (this._overviewWindow == null) break block1;
                this._overviewWindow.close();
                break block1;
            }
            if (this._getNumPagesNotCueCardViewer() <= 1) break block1;
            this._switchablePanel.removePage(customTabPage);
            IdeSettings ideSettings = Ide.getSettings();
            HelpOptions helpOptions = (HelpOptions)((Object)ideSettings.getData("HelpOptions"));
            this._setPageShowOption(customTabPage, false);
        }
    }

    private void _displayAppropriateTabs() {
        IdeSettings ideSettings = Ide.getSettings();
        HelpOptions helpOptions = (HelpOptions)((Object)ideSettings.getData("HelpOptions"));
        JDevHelpSystemImpl jDevHelpSystemImpl = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
        boolean bl = helpOptions.getShowTOC() && jDevHelpSystemImpl.isNavigatorSupported(0);
        boolean bl2 = helpOptions.getShowKeywordIndex() && jDevHelpSystemImpl.isNavigatorSupported(1);
        boolean bl3 = helpOptions.getShowFullTextSearch() && jDevHelpSystemImpl.isNavigatorSupported(2);
        boolean bl4 = helpOptions.getShowFavorites() && jDevHelpSystemImpl.isNavigatorSupported(3);
        boolean bl5 = helpOptions.getShowDynamicLinks() && jDevHelpSystemImpl.isNavigatorSupported(4);
        boolean bl6 = helpOptions.getShowCueCards() && jDevHelpSystemImpl.isNavigatorSupported(5);
        this._handleDisplay((CustomTabPage)this._TOCPage, bl);
        this._handleDisplay((CustomTabPage)this._keywordPage, bl2);
        this._handleDisplay((CustomTabPage)this._searchPage, bl3);
        this._handleDisplay((CustomTabPage)this._favoritesPage, bl4);
        this._handleDisplay((CustomTabPage)this._dynamicLinksPage, bl5);
        this._handleDisplay((CustomTabPage)this._cueCardPage, bl6);
    }

    private int _determineNavigation(int n) {
        DefaultListModel defaultListModel = this._switchablePanel.getModel();
        if (defaultListModel.size() > 1) {
            int n2 = defaultListModel.indexOf(this._currentPage);
            if (n2 == 0 && n == -1) {
                return -1;
            }
            if (n2 == defaultListModel.size() - 1 && n == 1) {
                return -1;
            }
            return n2 + n;
        }
        return -1;
    }

    private void _navigate(int n) {
        int n2 = this._determineNavigation(n);
        if (n2 != -1) {
            this._tabs.setSelectedPage(n2);
        }
    }

    private void _createErrorPage() {
        if (this._errorPage == null) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            this._errorScrollPane = new JScrollPane(jPanel);
            this._textAreaLbl = new JLabel();
            jPanel.add((Component)this._textAreaLbl, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
            this._textArea = new JTextArea();
            ResourceUtils.resLabel((JLabel)this._textAreaLbl, (Component)this._textArea, (String)HelpArb.getString(73));
            this._textArea.setEditable(false);
            this._textArea.setLineWrap(true);
            this._textArea.setWrapStyleWord(true);
            JScrollPane jScrollPane = new JScrollPane(this._textArea);
            jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
            jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this._clearTextBtn = new JButton();
            ResourceUtils.resButton((AbstractButton)this._clearTextBtn, (String)HelpArb.getString(75));
            jPanel.add((Component)this._clearTextBtn, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this._clearTextBtn.addActionListener(this);
            this._clearTextBtn.setEnabled(false);
            this._helpText = new JMultiLineLabel(HelpArb.getString(74));
            jPanel.add((Component)this._helpText, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
            this._removeTabBtn = new JButton();
            ResourceUtils.resButton((AbstractButton)this._removeTabBtn, (String)HelpArb.getString(76));
            jPanel.add((Component)this._removeTabBtn, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this._removeTabBtn.addActionListener(this);
            this._errorPage = new DefaultCustomTabPage(JavaArb.getIcon(27), null, (Object)this._errorScrollPane);
            this._errorPage.setTooltip(HelpArb.getString(51));
        }
    }

    private void _setInitializationErrors(JDevHelpSystemImpl jDevHelpSystemImpl) {
        this._textArea.setText(null);
        List list = jDevHelpSystemImpl.getErrors();
        int n = list.size();
        this._clearTextBtn.setEnabled(true);
        int n2 = 0;
        while (n2 < n) {
            this._textArea.append((String)list.get(n2));
            ++n2;
        }
    }

    private void _removeErrorTab() {
        if (this._errorPage != null) {
            this._textArea.setText(null);
            this._switchablePanel.removePage((CustomTabPage)this._errorPage);
        }
    }

    private void _addErrorTab() {
        if (this._errorPage != null) {
            this._switchablePanel.addPage((CustomTabPage)this._errorPage, (Component)this._errorScrollPane);
        }
    }

    private int getPageIntForPage(DefaultCustomTabPage defaultCustomTabPage) {
        int n = -1;
        if (defaultCustomTabPage == this._TOCPage) {
            n = 0;
        } else if (defaultCustomTabPage == this._keywordPage) {
            n = 1;
        } else if (defaultCustomTabPage == this._searchPage) {
            n = 2;
        } else if (defaultCustomTabPage == this._favoritesPage) {
            n = 3;
        } else if (defaultCustomTabPage == this._dynamicLinksPage) {
            n = 4;
        } else if (defaultCustomTabPage == this._cueCardPage) {
            n = 5;
        }
        return n;
    }

    private DefaultCustomTabPage getTabPageForIntPage(int n) {
        DefaultCustomTabPage defaultCustomTabPage = null;
        if (n == 0) {
            defaultCustomTabPage = this._TOCPage;
        } else if (n == 1) {
            defaultCustomTabPage = this._keywordPage;
        } else if (n == 2) {
            defaultCustomTabPage = this._searchPage;
        } else if (n == 3) {
            defaultCustomTabPage = this._favoritesPage;
        } else if (n == 4) {
            defaultCustomTabPage = this._dynamicLinksPage;
        } else if (n == 5) {
            defaultCustomTabPage = this._cueCardPage;
        } else if (n == 6) {
            defaultCustomTabPage = this._cueCardViewPage;
        }
        return defaultCustomTabPage;
    }

    private void _handleDisplay(CustomTabPage customTabPage, boolean bl) {
        boolean bl2 = false;
        Component component = this._switchablePanel.getComponentForPage(customTabPage);
        if (component != null) {
            bl2 = true;
        }
        if (bl2 != bl) {
            if (bl) {
                int n = this.getPageIntForPage((DefaultCustomTabPage)customTabPage);
                int n2 = 0;
                int n3 = 0;
                DefaultListModel defaultListModel = this._switchablePanel.getModel();
                int n4 = defaultListModel.size();
                int n5 = 0;
                while (n5 < n4 && n2 < n) {
                    DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)defaultListModel.elementAt(n5);
                    n2 = this.getPageIntForPage(defaultCustomTabPage);
                    n3 = n5;
                    if (n5 == n4 - 1 && n2 < n) {
                        ++n3;
                    }
                    ++n5;
                }
                DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)customTabPage;
                NavigatorHolder navigatorHolder = (NavigatorHolder)defaultCustomTabPage.getUserObject();
                this._switchablePanel.addPage(customTabPage, (Component)navigatorHolder, n3);
            } else {
                this._closeTabPage(customTabPage);
            }
        }
    }

    void saveLayout(DefaultStructuredPropertyAccess defaultStructuredPropertyAccess) {
        int n = this.getPageIntForPage(this._currentPage);
        if (n != -1) {
            DefaultStructuredPropertyAccess defaultStructuredPropertyAccess2 = new DefaultStructuredPropertyAccess(FOCUSED_TAB_NODE);
            defaultStructuredPropertyAccess2.setProperty(FOCUSED_TAB_NUM, Integer.toString(n));
            defaultStructuredPropertyAccess.appendChild((StructuredPropertyAccess)defaultStructuredPropertyAccess2);
        }
    }

    private void _saveLayout() {
        HelpSystem helpSystem;
        if (this._currentPage != null && (helpSystem = HelpSystem.getHelpSystem()) != null && helpSystem instanceof JDevHelpSystemImpl) {
            int n = this.getPageIntForPage(this._currentPage);
            DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = ((JDevHelpSystemImpl)helpSystem).getLayout();
            if (defaultStructuredPropertyAccess != null) {
                DefaultStructuredPropertyAccess defaultStructuredPropertyAccess2 = HelpWindow.getFocusedTabNode(defaultStructuredPropertyAccess);
                if (defaultStructuredPropertyAccess2 == null) {
                    defaultStructuredPropertyAccess2 = new DefaultStructuredPropertyAccess(FOCUSED_TAB_NODE);
                    defaultStructuredPropertyAccess.appendChild((StructuredPropertyAccess)defaultStructuredPropertyAccess2);
                }
                defaultStructuredPropertyAccess2.setProperty(FOCUSED_TAB_NUM, Integer.toString(n));
                ((JDevHelpSystemImpl)helpSystem).saveLayout(defaultStructuredPropertyAccess);
            }
        }
    }

    static DefaultStructuredPropertyAccess getFocusedTabNode(DefaultStructuredPropertyAccess defaultStructuredPropertyAccess) {
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess2 = null;
        if (defaultStructuredPropertyAccess != null) {
            Iterator iterator = defaultStructuredPropertyAccess.getChildNodes();
            while (iterator.hasNext()) {
                DefaultStructuredPropertyAccess defaultStructuredPropertyAccess3 = (DefaultStructuredPropertyAccess)iterator.next();
                String string = defaultStructuredPropertyAccess3.getName();
                if (!string.equals(FOCUSED_TAB_NODE)) continue;
                defaultStructuredPropertyAccess2 = defaultStructuredPropertyAccess3;
                break;
            }
        }
        return defaultStructuredPropertyAccess2;
    }

    private int _getLastFocusedTab(DefaultStructuredPropertyAccess defaultStructuredPropertyAccess) {
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess2;
        int n = -1;
        if (defaultStructuredPropertyAccess != null && (defaultStructuredPropertyAccess2 = HelpWindow.getFocusedTabNode(defaultStructuredPropertyAccess)) != null) {
            n = Integer.parseInt(defaultStructuredPropertyAccess2.getProperty(FOCUSED_TAB_NUM, "-1"));
        }
        return n;
    }

    private void showCueCardSet(CueCardSet cueCardSet) {
        this.show();
        HelpContentPanel helpContentPanel = this.getCueCardViewer();
        helpContentPanel.displayTopic(cueCardSet);
        if (cueCardSet.getStepList().size() > 1) {
            CueCardOverviewWindow cueCardOverviewWindow = this.getOverviewWindow();
            cueCardOverviewWindow.getCueCardOverviewPanel().setCueCardSet(cueCardSet);
            cueCardOverviewWindow.show();
        } else {
            CueCardOverviewWindow cueCardOverviewWindow = this.getCueCardOverviewWindow(false);
            if (cueCardOverviewWindow != null) {
                cueCardOverviewWindow.getCueCardOverviewPanel().setCueCardSet(cueCardSet);
            }
        }
        this.switchNavigator(6);
        GraphicsUtils.focusComponentOrChild((Component)helpContentPanel.getGUI());
    }

    CueCardOverviewWindow getCueCardOverviewWindow(boolean bl) {
        if (bl && this._overviewWindow == null) {
            this.getOverviewWindow();
        }
        return this._overviewWindow;
    }

    private HelpContentPanel getCueCardViewer() {
        if (this._cueCardViewer == null) {
            this._cueCardViewPage = new DefaultCustomTabPage(null, HelpArb.getString(114), null);
            this._cueCardViewPage.setTooltip(HelpArb.getString(114));
            JDevHelpSystemImpl jDevHelpSystemImpl = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
            Library library = jDevHelpSystemImpl.getLibrary();
            this._cueCardViewer = new HelpContentPanel(library);
            this._cueCardViewPage.setUserObject((Object)this._cueCardViewer.getGUI());
            this._switchablePanel.addPage((CustomTabPage)this._cueCardViewPage, this._cueCardViewer.getGUI());
        }
        return this._cueCardViewer;
    }

    private CueCardOverviewWindow getOverviewWindow() {
        if (this._overviewWindow == null) {
            DockStation dockStation = DockStation.getDockStation();
            this._overviewWindow = new CueCardOverviewWindow("HelpSystemAddin.CueCardOverviewWindow");
            this._overviewWindow.addViewListener(new OverviewWindowListener(null));
            this._overviewWindow.addTopicDisplayListener(new CueCardOverviewListener(null));
            IdeSettings ideSettings = Ide.getSettings();
            EnvironOptions environOptions = (EnvironOptions)ideSettings.getData("environment-options");
            CueCardOverviewPanel cueCardOverviewPanel = this._overviewWindow.getCueCardOverviewPanel();
            Color color = new Color(environOptions.getLogHrefColor());
            cueCardOverviewPanel.setLinkFG(color);
            DockingParam dockingParam = new DockingParam();
            dockingParam.setPosition((Dockable)LogManager.getIdeLogWindow(), 4);
            dockStation.dock((Dockable)this._overviewWindow, dockingParam);
            this._overviewWindow.show();
            this._cueCardViewer.setOverviewWindowBtnSelected(true);
        }
        return this._overviewWindow;
    }

    void addMenuItems(Object object, Topic topic) {
        boolean bl = object instanceof ContextMenu;
        ContextMenu contextMenu = null;
        if (!bl) {
            contextMenu = this.getContextMenu();
            JPopupMenu jPopupMenu = (JPopupMenu)object;
            if (jPopupMenu.getComponentCount() > 0) {
                jPopupMenu.add(new JPopupMenu.Separator());
            }
        } else {
            contextMenu = (ContextMenu)object;
        }
        if (this._currentPage != null && this._currentPage == this._TOCPage || this._currentPage == this._favoritesPage || this._currentPage == this._dynamicLinksPage) {
            Topic topic2 = topic;
            if (topic2 == null) {
                topic = this._currentPage == this._TOCPage ? this._TOCNavigator.getCurrentSelection() : (this._currentPage == this._favoritesPage ? this._favoritesNavigator.getCurrentSelection() : this._dynamicLinksNavigator.getCurrentSelection());
            }
            if (this._currentPage != null && this._currentPage == this._TOCPage) {
                IdeAction ideAction = IdeAction.get((int)PRINT_TOPIC_SUBTREE_CMD_ID, null, (String)HelpArb.getString(44), null, (Integer)HelpArb.getInteger(45), (ArrayResourceBundle)IdeArb.getInstance(), (int)76, null, (boolean)true);
                ideAction.addController((Controller)this);
                ideAction.setEnabled(topic != null);
                this._addMenuItemForAction(object, ideAction, 1.0f);
            }
            IdeAction ideAction = IdeAction.get((int)OPEN_IN_NEW_EDITOR_CMD_ID, null, (String)HelpArb.getString(46), null, (Integer)HelpArb.getInteger(47), (ArrayResourceBundle)HelpArb.getInstance(), (int)48, null, (boolean)true);
            ideAction.addController((Controller)this);
            ideAction.setEnabled(topic != null && topic.hasTarget());
            this._addMenuItemForAction(object, ideAction, 1.0f);
            ideAction = IdeAction.get((int)OPEN_IN_NEW_WINDOW_CMD_ID, null, (String)HelpArb.getString(52), null, (Integer)HelpArb.getInteger(53), (ArrayResourceBundle)HelpArb.getInstance(), (int)54, null, (boolean)true);
            ideAction.addController((Controller)this);
            ideAction.setEnabled(topic != null && topic.hasTarget());
            this._addMenuItemForAction(object, ideAction, 1.0f);
        }
        if (this._currentPage != null && this._currentPage == this._cueCardPage) {
            CueCardSet cueCardSet = (CueCardSet)this._cueCardNavigator.getCurrentSelection();
            IdeAction ideAction = IdeAction.get((int)OPEN_CUE_CARD_VIEWER_CMD_ID, null, (String)HelpArb.getString(94), null, (Integer)HelpArb.getInteger(95), null, null, null, (boolean)true);
            ideAction.addController((Controller)this);
            ideAction.setEnabled(cueCardSet != null);
            this._addMenuItemForAction(object, ideAction, 1.0f);
        }
        if (!bl && ((JPopupMenu)object).getComponentCount() > 0) {
            ((JPopupMenu)object).add(new JPopupMenu.Separator());
        }
        IdeAction ideAction = IdeAction.get((int)CLOSE_HELP_TAB_CMD_ID, null, (String)HelpArb.getString(90), null, (Integer)HelpArb.getInteger(91), null, null, null, (boolean)true);
        ideAction.addController((Controller)this);
        if (this._currentPage == this._cueCardViewPage || this._getNumPagesNotCueCardViewer() > 1) {
            ideAction.setEnabled(true);
        } else {
            ideAction.setEnabled(false);
        }
        this._addMenuItemForAction(object, ideAction, JDeveloperMenuConstants.SECTION_MIDDLE);
        this._createAndAddTabMenuItems(object, this._createActionsForOpeningTabs(), true);
        IdeAction ideAction2 = IdeAction.newLocalAction((int)70, (View)this);
        ideAction2.setEnabled(this._determineNavigation(-1) != -1);
        JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)ideAction2);
        if (bl) {
            contextMenu.add((Component)jMenuItem, JDeveloperMenuConstants.SECTION_BOTTOM);
        } else {
            ((JPopupMenu)object).add(new JPopupMenu.Separator());
            ((JPopupMenu)object).add(jMenuItem);
        }
        IdeAction ideAction3 = IdeAction.newLocalAction((int)71, (View)this);
        ideAction3.setEnabled(this._determineNavigation(1) != -1);
        JMenuItem jMenuItem2 = contextMenu.createMenuItem((ToggleAction)ideAction3);
        if (bl) {
            contextMenu.add((Component)jMenuItem2, JDeveloperMenuConstants.SECTION_BOTTOM);
        } else {
            ((JPopupMenu)object).add(jMenuItem2);
        }
    }

    private IdeAction[] _createActionsForOpeningTabs() {
        int n;
        IdeSettings ideSettings = Ide.getSettings();
        HelpOptions helpOptions = (HelpOptions)((Object)ideSettings.getData("HelpOptions"));
        JDevHelpSystemImpl jDevHelpSystemImpl = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
        ArrayList<IdeAction> arrayList = new ArrayList<IdeAction>(6);
        String string = null;
        IdeAction ideAction = null;
        if (jDevHelpSystemImpl.isNavigatorSupported(0)) {
            string = HelpArb.getString(19);
            ideAction = IdeAction.get((int)TOC_TAB_CMD_ID, null, (String)StringUtils.stripMnemonic((String)string), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), null, null, null, (boolean)true);
            ideAction.addController((Controller)this);
            ideAction.setEnabled(helpOptions.getShowTOC());
            arrayList.add(ideAction);
        }
        if (jDevHelpSystemImpl.isNavigatorSupported(1)) {
            string = HelpArb.getString(20);
            ideAction = IdeAction.get((int)IDX_TAB_CMD_ID, null, (String)StringUtils.stripMnemonic((String)string), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), null, null, null, (boolean)true);
            ideAction.addController((Controller)this);
            ideAction.setEnabled(helpOptions.getShowKeywordIndex());
            arrayList.add(ideAction);
        }
        if (jDevHelpSystemImpl.isNavigatorSupported(2)) {
            string = HelpArb.getString(21);
            ideAction = IdeAction.get((int)SRCH_TAB_CMD_ID, null, (String)StringUtils.stripMnemonic((String)string), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), null, null, null, (boolean)true);
            ideAction.addController((Controller)this);
            ideAction.setEnabled(helpOptions.getShowFullTextSearch());
            arrayList.add(ideAction);
        }
        if (jDevHelpSystemImpl.isNavigatorSupported(3)) {
            string = HelpArb.getString(22);
            ideAction = IdeAction.get((int)FAV_TAB_CMD_ID, null, (String)StringUtils.stripMnemonic((String)string), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), null, null, null, (boolean)true);
            ideAction.addController((Controller)this);
            ideAction.setEnabled(helpOptions.getShowFavorites());
            arrayList.add(ideAction);
        }
        if (jDevHelpSystemImpl.isNavigatorSupported(4)) {
            string = HelpArb.getString(23);
            ideAction = IdeAction.get((int)DYN_TAB_CMD_ID, null, (String)StringUtils.stripMnemonic((String)string), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), null, null, null, (boolean)true);
            ideAction.addController((Controller)this);
            ideAction.setEnabled(helpOptions.getShowDynamicLinks());
            arrayList.add(ideAction);
        }
        if (jDevHelpSystemImpl.isNavigatorSupported(5)) {
            string = HelpArb.getString(24);
            ideAction = IdeAction.get((int)CUE_TAB_CMD_ID, null, (String)StringUtils.stripMnemonic((String)string), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), null, null, null, (boolean)true);
            ideAction.addController((Controller)this);
            ideAction.setEnabled(helpOptions.getShowCueCards());
            arrayList.add(ideAction);
        }
        if ((n = arrayList.size()) == 0) {
            return null;
        }
        IdeAction[] ideActionArray = new IdeAction[n];
        ideActionArray = arrayList.toArray(ideActionArray);
        return ideActionArray;
    }

    private void _createAndAddTabMenuItems(Object object, IdeAction[] ideActionArray, boolean bl) {
        boolean bl2 = object instanceof ContextMenu;
        ContextMenu contextMenu = null;
        contextMenu = !bl2 ? this.getContextMenu() : (ContextMenu)object;
        JMenu jMenu = null;
        if (bl) {
            String string = HelpArb.getString(140);
            jMenu = contextMenu.createSubMenu(StringUtils.stripMnemonic((String)string), new Integer(StringUtils.getMnemonicKeyCode((String)string)));
        }
        int n = 0;
        while (n < ideActionArray.length) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem((Action)ideActionArray[n]);
            jCheckBoxMenuItem.setSelected(ideActionArray[n].isEnabled());
            ideActionArray[n].setEnabled(true);
            if (bl) {
                jMenu.add(jCheckBoxMenuItem);
            } else {
                contextMenu.add((Component)jCheckBoxMenuItem);
            }
            ++n;
        }
        if (bl) {
            if (bl2) {
                contextMenu.add((Component)jMenu, JDeveloperMenuConstants.SECTION_MIDDLE);
            } else {
                ((JPopupMenu)object).add(jMenu);
            }
        }
    }

    private void _addMenuItemForAction(Object object, IdeAction ideAction, float f) {
        boolean bl = object instanceof ContextMenu;
        ContextMenu contextMenu = null;
        contextMenu = !bl ? this.getContextMenu() : (ContextMenu)object;
        JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)ideAction);
        if (bl) {
            contextMenu.add((Component)jMenuItem, f);
        } else {
            ((JPopupMenu)object).add(jMenuItem);
        }
    }

    static void mav$showCueCardSet(HelpWindow helpWindow, CueCardSet cueCardSet) {
        helpWindow.showCueCardSet(cueCardSet);
    }

    static void mav$_closeTabPage(HelpWindow helpWindow, CustomTabPage customTabPage) {
        helpWindow._closeTabPage(customTabPage);
    }

    static DefaultCustomTabPage ra$_currentPage(HelpWindow helpWindow) {
        return helpWindow._currentPage;
    }

    static DefaultCustomTabPage ra$_dynamicLinksPage(HelpWindow helpWindow) {
        return helpWindow._dynamicLinksPage;
    }

    static HelpContentPanel ra$_cueCardViewer(HelpWindow helpWindow) {
        return helpWindow._cueCardViewer;
    }

    static void wa$_overviewWindow(HelpWindow helpWindow, CueCardOverviewWindow cueCardOverviewWindow) {
        helpWindow._overviewWindow = cueCardOverviewWindow;
    }

    static SwitchablePanel ra$_switchablePanel(HelpWindow helpWindow) {
        return helpWindow._switchablePanel;
    }

    static CustomTab ra$_tabs(HelpWindow helpWindow) {
        return helpWindow._tabs;
    }

    static void mav$_initNavigatorHolder(HelpWindow helpWindow, DefaultCustomTabPage defaultCustomTabPage) {
        helpWindow._initNavigatorHolder(defaultCustomTabPage);
    }

    static IdeAction[] mav$_createActionsForOpeningTabs(HelpWindow helpWindow) {
        return helpWindow._createActionsForOpeningTabs();
    }

    static void mav$_createAndAddTabMenuItems(HelpWindow helpWindow, Object object, IdeAction[] ideActionArray, boolean bl) {
        helpWindow._createAndAddTabMenuItems(object, ideActionArray, bl);
    }

    private final class HelpNavigatorListener
    implements NavigatorListener {
        private Navigator _owner;

        public void addListenerToNavigator(Navigator navigator) {
            if (this._owner != null) {
                this._owner.removeNavigatorListener((NavigatorListener)this);
            }
            navigator.addNavigatorListener((NavigatorListener)this);
            this._owner = navigator;
        }

        public void removeListener() {
            if (this._owner != null) {
                this._owner.removeNavigatorListener((NavigatorListener)this);
                this._owner = null;
            }
        }

        public void topicSelected(NavigatorEvent navigatorEvent) {
        }

        public void topicActivated(NavigatorEvent navigatorEvent) {
            Topic topic = navigatorEvent.getTopic();
            if (topic instanceof CueCardSet) {
                HelpWindow.mav$showCueCardSet(HelpWindow.this, (CueCardSet)navigatorEvent.getTopic());
            } else if (topic instanceof MultipleTypeTopic) {
                MultipleTypeTopic multipleTypeTopic = (MultipleTypeTopic)topic;
                if (multipleTypeTopic.getTopicType() == 2) {
                    HelpWindow.this.showCueCardSetForId(multipleTypeTopic.getCueCardId());
                } else if (multipleTypeTopic.getTopicType() == 3) {
                    try {
                        URL uRL = multipleTypeTopic.getTarget().getURL();
                        BrowserRunner.getBrowserRunner().runBrowserOnURL(uRL, null, null);
                    }
                    catch (MalformedURLException malformedURLException) {}
                } else if (topic.hasTarget()) {
                    JDevHelpSystemImpl jDevHelpSystemImpl = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
                    jDevHelpSystemImpl.showTopic(navigatorEvent.getTopic());
                }
            } else if (topic.hasTarget()) {
                JDevHelpSystemImpl jDevHelpSystemImpl = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
                jDevHelpSystemImpl.showTopic(navigatorEvent.getTopic());
            }
        }

        private HelpNavigatorListener() {
        }

        HelpNavigatorListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class TabCloseAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            CustomTabPage customTabPage = (CustomTabPage)actionEvent.getSource();
            HelpWindow.mav$_closeTabPage(HelpWindow.this, customTabPage);
        }

        private TabCloseAction() {
        }

        TabCloseAction(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class ContextMenuMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this._showContextMenu(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this._showContextMenu(mouseEvent);
            }
        }

        private void _showContextMenu(MouseEvent mouseEvent) {
            JTree jTree;
            TreePath treePath;
            Context context = HelpWindow.this.getContext(mouseEvent);
            if (HelpWindow.ra$_currentPage(HelpWindow.this) != null && HelpWindow.ra$_currentPage(HelpWindow.this) == HelpWindow.ra$_dynamicLinksPage(HelpWindow.this) && (treePath = (jTree = (JTree)mouseEvent.getSource()).getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
                jTree.setSelectionPath(treePath);
            }
            HelpWindow.this.getContextMenu().show(context);
        }

        private ContextMenuMouseListener() {
        }

        ContextMenuMouseListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class CueCardOverviewListener
    implements TopicDisplayListener {
        public void topicDisplayChanged(TopicDisplayEvent topicDisplayEvent) {
            if (topicDisplayEvent.getID() == 2000 && topicDisplayEvent.getChangeType() == 0) {
                CueCardTopic cueCardTopic = new CueCardTopic(topicDisplayEvent.getURL());
                HelpWindow.ra$_cueCardViewer(HelpWindow.this).displayTopic(cueCardTopic);
                HelpWindow.this.switchNavigator(6);
                GraphicsUtils.focusComponentOrChild((Component)HelpWindow.ra$_cueCardViewer(HelpWindow.this).getGUI());
            }
        }

        private CueCardOverviewListener() {
        }

        CueCardOverviewListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class OverviewWindowListener
    implements ViewListener {
        public void viewActivated(ViewEvent viewEvent) {
        }

        public void viewDeactivated(ViewEvent viewEvent) {
        }

        public void viewClosed(ViewEvent viewEvent) {
            HelpWindow.wa$_overviewWindow(HelpWindow.this, null);
            if (HelpWindow.ra$_cueCardViewer(HelpWindow.this) != null) {
                HelpWindow.ra$_cueCardViewer(HelpWindow.this).setOverviewWindowBtnSelected(false);
            }
        }

        private OverviewWindowListener() {
        }

        OverviewWindowListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class TabHierarchyListener
    implements HierarchyListener {
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            long l = hierarchyEvent.getChangeFlags();
            if ((l & (long)4) == (long)4) {
                HelpWindow.ra$_switchablePanel(HelpWindow.this).ensureTabVisible();
                HelpWindow.ra$_tabs(HelpWindow.this).removeHierarchyListener((HierarchyListener)this);
            }
        }

        private TabHierarchyListener() {
        }

        TabHierarchyListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class NavigatorHolder
    extends JPanel {
        private Navigator _navigator;
        private DefaultCustomTabPage _tabPage;

        public void setTabPage(DefaultCustomTabPage defaultCustomTabPage) {
            this._tabPage = defaultCustomTabPage;
        }

        public Navigator getNavigator() {
            return this._navigator;
        }

        public void setNavigator(Navigator navigator) {
            this._navigator = navigator;
            this.setLayout(new BorderLayout());
            this.add((Component)navigator, "Center");
        }

        public void setVisible(boolean bl) {
            if (bl && this._navigator == null) {
                HelpWindow.mav$_initNavigatorHolder(HelpWindow.this, this._tabPage);
            }
            if (this._navigator != null) {
                this._navigator.setVisible(bl);
            }
            super.setVisible(bl);
        }

        private NavigatorHolder() {
        }

        NavigatorHolder(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class CustomTabMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this._showContextMenu(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this._showContextMenu(mouseEvent);
            }
        }

        private void _showContextMenu(MouseEvent mouseEvent) {
            ContextMenu contextMenu = new ContextMenu();
            contextMenu.addContextMenuListener((ContextMenuListener)new 1());
            Context context = HelpWindow.this.getContext(mouseEvent);
            contextMenu.show(context);
        }

        private CustomTabMouseListener() {
        }

        CustomTabMouseListener(1 var2_2) {
            this();
        }

        public final class 1
        implements ContextMenuListener {
            public void menuWillShow(ContextMenu contextMenu) {
                HelpWindow.mav$_createAndAddTabMenuItems(HelpWindow.this, contextMenu, HelpWindow.mav$_createActionsForOpeningTabs(HelpWindow.this), false);
            }

            public void menuWillHide(ContextMenu contextMenu) {
            }

            public boolean handleDefaultAction(Context context) {
                return false;
            }
        }
    }
}

