/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.View;
import oracle.help.library.Library;
import oracle.help.library.LibraryListener;
import oracle.help.navigator.NavigatorException;
import oracle.ide.Context;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.IdeIcons;
import oracle.jdevimpl.help.CueCardNavigator;
import oracle.jdevimpl.help.CueCardSet;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpWindow;

public final class JDevCueCardNavigator
extends CueCardNavigator {
    private HelpWindow _helpWindow;

    public JDevCueCardNavigator(HelpWindow helpWindow, Library library, String string) throws NavigatorException {
        this._helpWindow = helpWindow;
        this.label = string;
        this.labelImage = null;
        this.library = library;
        this.filterByLabel = true;
        this.type = "oracle.jdevimpl.help.JDevCueCardNavigator";
        View[] viewArray = null;
        int n = 0;
        this.listeners = new ListenerManager();
        this.views = new ArrayList();
        if (library != null) {
            this.library.addLibraryListener((LibraryListener)this);
            viewArray = this.filterViewsByLabel(library.getAllViews(), string);
            if (viewArray != null) {
                n = 0;
                while (n < viewArray.length) {
                    this.views.add(viewArray[n]);
                    ++n;
                }
            }
        }
        this.initNavigator(viewArray);
    }

    protected void addMouseListener(JTree jTree) {
        super.addMouseListener(jTree);
        JDevCueCardMouseAdapter jDevCueCardMouseAdapter = new JDevCueCardMouseAdapter(null);
        jTree.addMouseListener(jDevCueCardMouseAdapter);
    }

    protected void addTreeCellRenderer(DefaultTreeCellRenderer defaultTreeCellRenderer) {
        super.addTreeCellRenderer(defaultTreeCellRenderer);
        defaultTreeCellRenderer.setLeafIcon(HelpArb.getIcon(103));
        defaultTreeCellRenderer.setOpenIcon(IdeArb.getIcon((int)55));
        defaultTreeCellRenderer.setClosedIcon(IdeIcons.getIcon((int)4));
    }

    void selectCueCardSet(CueCardSet cueCardSet) {
        if (cueCardSet != null) {
            this.fireTopicActivated(cueCardSet);
        }
    }

    static HelpWindow ra$_helpWindow(JDevCueCardNavigator jDevCueCardNavigator) {
        return jDevCueCardNavigator._helpWindow;
    }

    private class JDevCueCardMouseAdapter
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this._showContextMenu(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this._showContextMenu(mouseEvent);
            }
        }

        private void _showContextMenu(MouseEvent mouseEvent) {
            Context context = JDevCueCardNavigator.ra$_helpWindow(JDevCueCardNavigator.this).getContext(mouseEvent);
            JDevCueCardNavigator.ra$_helpWindow(JDevCueCardNavigator.this).getContextMenu().show(context);
        }

        private JDevCueCardMouseAdapter() {
        }

        JDevCueCardMouseAdapter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

