/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.help.Help;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.library.Book;
import oracle.help.library.Library;
import oracle.help.library.LibraryException;
import oracle.help.navigator.favoritesNavigator.DefaultFavoritesModel;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;
import oracle.help.topicDisplay.TopicDisplayException;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.config.DTCache;
import oracle.ide.config.IdeSettings;
import oracle.ide.docking.DockStation;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;
import oracle.ide.model.Node;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.Traversable;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.util.SwingWorker;
import oracle.ide.view.View;
import oracle.javatools.util.SwingUtils;
import oracle.jdeveloper.dialogs.JDevDialogHeader;
import oracle.jdeveloper.help.JavadocUtil;
import oracle.jdevimpl.ProfileIDs;
import oracle.jdevimpl.help.CueCardOverviewWindow;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpContentPanel;
import oracle.jdevimpl.help.HelpContentWindow;
import oracle.jdevimpl.help.HelpHook;
import oracle.jdevimpl.help.HelpOptions;
import oracle.jdevimpl.help.HelpSystemAddin;
import oracle.jdevimpl.help.HelpTopicDocument;
import oracle.jdevimpl.help.HelpTopicEditor;
import oracle.jdevimpl.help.HelpWindow;
import oracle.jdevimpl.help.JDevHelpSet;
import oracle.jdevimpl.help.JDevLibrary;
import oracle.jdevimpl.help.JavadocBook;
import oracle.jdevimpl.help.ModalHelpContentDialog;
import oracle.jdevimpl.help.MultipleTypeTopic;

public final class JDevHelpSystemImpl
extends HelpSystem {
    public static final String LANGUAGE_HELP_BOOK_NAME = "...language-help...";
    private ArrayList _addinHelpSetList;
    private ArrayList _loadErrors;
    private JDevLibrary _library;
    private Dialog _modalOwner;
    private ArrayList _helpJarsList;
    private boolean _initialized;
    private String _lastPrintString;
    private ModalHelpContentDialog _modalDialog;
    private static ArrayList _helpTopicEditors = new ArrayList();
    private HashMap _topicSubstitutes;
    private FavoritesModel _favoritesModel;
    private List _tipOfDayList;
    private boolean _hooksProcessedForTipJars;
    private boolean _hooksProcessedForHelpSetJars;
    private int[] _supportedNavigators;
    private final boolean DEBUG;
    private static final int INITIALIZATION_ERROR = 0;
    private static final int DISPLAY_ERROR = 1;
    private static final String LAYOUT_FILE = "Help.windows";
    private static final String FAVORITES_FILE = "HelpBookmarks.xml";
    private static final String HELPSYSTEM_LAST_TIP_JAR = "JDevHelpSystemImpl.last-tip-jar";
    private static final String HELPSYSTEM_LAST_TIP = "JDevHelpSystemImpl.last-tip";
    private static final String HELPSYSTEM_SHOW_TIP_OF_DAY = "JDevHelpSystemImpl.show-tip";
    private HelpKeyListener _helpKeyListener;

    void $init$() {
        this._addinHelpSetList = new ArrayList();
        this._loadErrors = new ArrayList();
        this._helpJarsList = new ArrayList();
        this._tipOfDayList = new ArrayList();
        this.DEBUG = false;
    }

    public JDevHelpSystemImpl() {
        this.$init$();
    }

    public Library getLibrary() {
        if (this._initialize()) {
            return this._library;
        }
        return null;
    }

    public void loadHelpWindows() {
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = null;
        defaultStructuredPropertyAccess = this.getLayout();
        if (defaultStructuredPropertyAccess == null) {
            return;
        }
        Iterator iterator = defaultStructuredPropertyAccess.getChildNodes();
        while (iterator.hasNext()) {
            DefaultStructuredPropertyAccess defaultStructuredPropertyAccess2 = (DefaultStructuredPropertyAccess)iterator.next();
            String string = defaultStructuredPropertyAccess2.getName();
            if (!string.equals("HelpWindow")) continue;
            HelpContentWindow.loadLayout(defaultStructuredPropertyAccess2);
        }
    }

    DefaultStructuredPropertyAccess getLayout() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        URL uRL = extensionRegistry.getSystemDirectory(HelpSystemAddin.getExtensionID());
        File file = new File(uRL.getPath(), LAYOUT_FILE);
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = null;
        try {
            defaultStructuredPropertyAccess = DefaultStructuredPropertyAccess.loadFromXML((File)file);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultStructuredPropertyAccess;
    }

    public void saveOpenHelpWindows() {
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = new DefaultStructuredPropertyAccess("HelpWindows");
        int n = _helpTopicEditors.size();
        int n2 = 0;
        while (n2 < n) {
            HelpTopicEditor helpTopicEditor = (HelpTopicEditor)((Object)_helpTopicEditors.get(n2));
            if (helpTopicEditor.getParent() != null && helpTopicEditor.getParent() instanceof HelpContentWindow) {
                HelpContentWindow helpContentWindow = (HelpContentWindow)helpTopicEditor.getParent();
                helpContentWindow.saveLayout(defaultStructuredPropertyAccess);
            }
            ++n2;
        }
        DockStation dockStation = DockStation.getDockStation();
        HelpWindow helpWindow = (HelpWindow)dockStation.getDockable(HelpWindow.getHelpWindowViewId());
        if (helpWindow != null) {
            helpWindow.saveLayout(defaultStructuredPropertyAccess);
        } else {
            DefaultStructuredPropertyAccess defaultStructuredPropertyAccess2 = HelpWindow.getFocusedTabNode(this.getLayout());
            if (defaultStructuredPropertyAccess2 != null) {
                defaultStructuredPropertyAccess.appendChild((StructuredPropertyAccess)defaultStructuredPropertyAccess2);
            }
        }
        this.saveLayout(defaultStructuredPropertyAccess);
    }

    void saveLayout(DefaultStructuredPropertyAccess defaultStructuredPropertyAccess) {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        URL uRL = extensionRegistry.getSystemDirectory(HelpSystemAddin.getExtensionID());
        File file = new File(uRL.getPath(), LAYOUT_FILE);
        try {
            DefaultStructuredPropertyAccess.saveToXML((StructuredPropertyAccess)defaultStructuredPropertyAccess, (File)file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List getErrors() {
        return this._loadErrors;
    }

    public final void showLanguageHelp(Context context, String string) {
        JDevHelpSystemImpl.showLanguageHelpNonOHJ(context, string);
    }

    final void showLanguageHelpOHJ(Context context, String string) {
        Ide.getWaitCursor().show();
        try {
            if (string == null) {
                HelpSystemAddin.showJavadocException(2, "");
                Ide.getWaitCursor().hide();
                return;
            }
            URL uRL = JavadocUtil.resolveJavadocURL(context, string);
            if (uRL == null) {
                HelpSystemAddin.showJavadocException(1, string);
                Ide.getWaitCursor().hide();
                return;
            }
            String string2 = uRL.toString();
            this.goTo("...language-help...:" + string2);
        }
        finally {
            Ide.getWaitCursor().hide();
        }
    }

    final FavoritesModel getFavoritesModel() {
        if (this._favoritesModel == null) {
            if (this._library == null) {
                this._initialize();
            }
            if (this._library != null) {
                this._favoritesModel = new DefaultFavoritesModel(this._getHelpbookmarksFile(), (Library)this._library);
            }
        }
        return this._favoritesModel;
    }

    private URL _getHelpbookmarksFile() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        URL uRL = extensionRegistry.getSystemDirectory(HelpSystemAddin.getExtensionID());
        return URLFactory.newURL((URL)uRL, (String)FAVORITES_FILE);
    }

    final void supportsNavigators(int[] nArray) {
        this._supportedNavigators = nArray;
    }

    final boolean isNavigatorSupported(int n) {
        int n2 = 0;
        while (n2 < this._supportedNavigators.length) {
            if (this._supportedNavigators[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static final URL getResolvedURL(Context context, String string) {
        try {
            URL uRL;
            if (string == null) {
                HelpSystemAddin.showJavadocException(2, "");
                URL uRL2 = null;
                return uRL2;
            }
            URL uRL3 = uRL = JavadocUtil.resolveJavadocURL(context, string);
            return uRL3;
        }
        catch (Exception exception) {
            return null;
        }
    }

    Topic getTopicForString(String string) {
        return this.getTopicForString(string, true);
    }

    Topic getTopicForString(String string, boolean bl) {
        SimpleTopic simpleTopic = null;
        if (string != null) {
            URL uRL = this._library.mapIDToURL(string);
            if (uRL != null) {
                SimpleTopic simpleTopic2;
                SimpleURLTarget simpleURLTarget = new SimpleURLTarget(null, uRL.toString());
                simpleTopic = simpleTopic2 = new SimpleTopic(null, (Target)simpleURLTarget, null);
            } else if (bl) {
                this._showHelpError(1, HelpArb.format(77, string));
            }
        } else if (bl) {
            this._showHelpError(1, HelpArb.getString(15));
        }
        return simpleTopic;
    }

    static final void showLanguageHelpNonOHJ(Context context, String string) {
        8 var2_2 = new 8(context, string);
        var2_2.start();
    }

    public final boolean doesTopicExist(String string) {
        if (!this._initialize()) {
            this._showHelpError(0, null);
            return false;
        }
        URL uRL = this._library.mapIDToURL(string);
        return uRL != null;
    }

    public final Editor showHelp(URL uRL) {
        if (uRL == null) {
            throw new NullPointerException("url is null.");
        }
        HelpTopicDocument helpTopicDocument = new HelpTopicDocument(uRL);
        String string = URLFileSystem.getFileName((URL)uRL);
        helpTopicDocument.setShortLabel(string);
        Context context = Context.newIdeContext((Node)helpTopicDocument);
        return EditorManager.getEditorManager().openEditorInFrame(HelpTopicEditor.class, context);
    }

    public final void showHelp(JComponent jComponent) {
        if (Boolean.valueOf(System.getProperty("jdev.skip.help")).booleanValue()) {
            LogManager.getIdeLogWindow().getPage().log((Object)("Help ID: " + HelpUtils.getHelpID((Component)jComponent) + "\n"));
            return;
        }
        if (!this._initialize()) {
            this._showHelpError(0, null);
            return;
        }
        7 var2_2 = new 7(this, jComponent);
        Window window = WindowUtils.getActiveWindow();
        if (window == null) {
            EventQueue.invokeLater(var2_2);
        } else {
            var2_2.run();
        }
    }

    public final void showHelp(Context context) {
        if (!this._initialize()) {
            this._showHelpError(0, null);
            return;
        }
        Context context2 = context;
        6 var3_3 = new 6(this, context2);
        SwingUtilities.invokeLater(var3_3);
    }

    public final void showHelp(HelpInfo helpInfo) {
        if (helpInfo != null && helpInfo.getHelpType() != 1 && !this._initialize()) {
            this._showHelpError(0, null);
            return;
        }
        HelpInfo helpInfo2 = helpInfo;
        5 var3_3 = new 5(this, helpInfo2);
        SwingUtilities.invokeLater(var3_3);
    }

    public final void registerTopic(JComponent jComponent, String string) {
        String string2;
        if (this._topicSubstitutes != null && (string2 = (String)this._topicSubstitutes.get(string)) != null) {
            string = string2;
        }
        HelpUtils.setHelpID((JComponent)jComponent, (String)string);
    }

    public final void registerClientWindow(Window window) {
        Help.registerClientWindow((Window)window);
    }

    public final void unregisterClientWindow(Window window) {
        Help.unregisterClientWindow((Window)window);
    }

    public void registerHelpSetURL(URL uRL) {
        this.registerHelpSetURL(uRL, null, -1);
    }

    public void registerHelpSetURL(URL uRL, String string, int n) {
        String string2 = uRL.toExternalForm();
        String[] stringArray = string2.split(".jar!");
        this.registerHelpSetURL(stringArray[0], 0, uRL, string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTipOfDayURL(URL uRL) {
        List list = this._tipOfDayList;
        synchronized (list) {
            if (URLFileSystem.exists((URL)uRL)) {
                this._tipOfDayList.add(uRL);
            }
        }
    }

    public boolean hasTipOfDayEntries() {
        this._processManifestForTipJars();
        return this._tipOfDayList.size() > 0;
    }

    private Topic getTipOfTheDay() {
        int n = this._tipOfDayList.size();
        if (n == 0) {
            return null;
        }
        Topic topic = null;
        DTCache dTCache = Ide.getDTCache();
        int n2 = dTCache.getInteger(HELPSYSTEM_LAST_TIP_JAR, -1);
        int n3 = dTCache.getInteger(HELPSYSTEM_LAST_TIP, 0);
        if (++n2 >= this._tipOfDayList.size()) {
            n2 = 0;
            ++n3;
        }
        dTCache.putInteger(HELPSYSTEM_LAST_TIP_JAR, n2);
        dTCache.putInteger(HELPSYSTEM_LAST_TIP, n3);
        URL uRL = (URL)this._tipOfDayList.get(n2);
        try {
            JarIndex jarIndex = JarUtil.getJarIndex((URL)uRL);
            String[] stringArray = jarIndex.getEntries();
            ArrayList<String> arrayList = new ArrayList<String>();
            int n4 = 0;
            while (n4 < stringArray.length) {
                if (stringArray[n4].endsWith("html")) {
                    arrayList.add(stringArray[n4]);
                }
                ++n4;
            }
            int n5 = arrayList.size();
            if (n5 == 0) {
                Topic topic2 = null;
                return topic2;
            }
            if (n3 >= n5) {
                n3 %= n5;
            }
            String string = (String)arrayList.get(n3);
            URL uRL2 = URLFactory.newJarURL((URL)uRL, (String)string);
            HelpTopicDocument helpTopicDocument = new HelpTopicDocument(uRL2);
            topic = helpTopicDocument.getTopic();
        }
        catch (IOException iOException) {
            Topic topic3 = null;
            return topic3;
        }
        return topic;
    }

    public static boolean getShowTipOfDayPreference() {
        DTCache dTCache = Ide.getDTCache();
        return dTCache.getBoolean(HELPSYSTEM_SHOW_TIP_OF_DAY, true);
    }

    public void showTipOfTheDay() {
        Topic topic = this.getTipOfTheDay();
        if (topic == null) {
            return;
        }
        TipOfDayDialog tipOfDayDialog = new TipOfDayDialog(SwingUtils.getAncestorFrame((Component)Ide.getMainWindow()));
        tipOfDayDialog.setModal(false);
        if (tipOfDayDialog == null) {
            return;
        }
        tipOfDayDialog.setMinimumSize(450, 375);
        tipOfDayDialog.setMaximumInitialSize(450, 375);
        tipOfDayDialog.setPreferredSize(450, 375);
        tipOfDayDialog.setResizable(true);
        JPanel jPanel = new JPanel(new GridBagLayout());
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setSelected(JDevHelpSystemImpl.getShowTipOfDayPreference());
        ResourceUtils.resButton((AbstractButton)jCheckBox, (String)HelpArb.getString(112));
        jCheckBox.addActionListener(new 4(this, jCheckBox));
        HelpContentPanel helpContentPanel = new HelpContentPanel(tipOfDayDialog);
        tipOfDayDialog.setHelpContentPanel(helpContentPanel);
        jPanel.add(helpContentPanel.getGUI(), new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jCheckBox, new GridBagConstraints(0, 3, 1, 2, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        JDevDialogHeader jDevDialogHeader = new JDevDialogHeader();
        jDevDialogHeader.setHeaderTitle(HelpArb.getString(111));
        tipOfDayDialog.setDialogHeader(jDevDialogHeader);
        tipOfDayDialog.setContent(jPanel);
        tipOfDayDialog.pack();
        helpContentPanel.displayTopic(topic);
        tipOfDayDialog.setOKButtonEnabled(true);
        tipOfDayDialog.setInitialFocus(helpContentPanel.getGUI());
        tipOfDayDialog.setTitle(HelpArb.getString(110));
        tipOfDayDialog.setButtonMask(16);
        JButton jButton = new JButton();
        ResourceUtils.resButton((AbstractButton)jButton, (String)HelpArb.getString(113));
        jButton.addActionListener(new 3(this, helpContentPanel));
        tipOfDayDialog.addCustomButton(jButton);
        tipOfDayDialog.runDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHelpSetURL(String string, int n, URL uRL, String string2, int n2) {
        if (string == null) {
            return;
        }
        ArrayList arrayList = this._addinHelpSetList;
        synchronized (arrayList) {
            int n3 = this._findLocationInList(string, this._addinHelpSetList);
            if (n == 1 && n3 > -1) {
                this._addinHelpSetList.remove(n3);
            } else if (n3 == -1) {
                this._addinHelpSetList.add(new HelpJarInfo(string, uRL, string2, n2));
            } else {
                HelpJarInfo helpJarInfo = (HelpJarInfo)this._addinHelpSetList.get(n3);
                helpJarInfo.update(uRL, string2, n2);
            }
        }
    }

    protected void showTopic(Topic topic) {
        IdeSettings ideSettings = Ide.getSettings();
        HelpOptions helpOptions = (HelpOptions)((Object)ideSettings.getData("HelpOptions"));
        this.showTopic(topic, false, helpOptions.getOpenInWindow());
    }

    protected void showTopic(Topic topic, boolean bl, boolean bl2) {
        if (topic != null) {
            MultipleTypeTopic multipleTypeTopic;
            if (topic instanceof MultipleTypeTopic && (multipleTypeTopic = (MultipleTypeTopic)topic).getTopicType() == 4) {
                JDevHelpSystemImpl.showLanguageHelpNonOHJ(Context.newIdeContext(), multipleTypeTopic.getLanguageString());
                return;
            }
            if (this._checkModalMode()) {
                if (this._modalDialog != null && this._modalDialog.getOwner() == this._getActiveModalOwnerDialog()) {
                    this._modalDialog.show(topic);
                } else {
                    this._modalDialog = new ModalHelpContentDialog(this._getActiveModalOwnerDialog(), (Library)this._library, this._modalDialog);
                    this._modalDialog.show(topic);
                }
                this.printTopicForDebugging(topic, null, null);
            } else {
                HelpTopicEditor helpTopicEditor = JDevHelpSystemImpl._getMRUEditor(0);
                if (bl || helpTopicEditor == null) {
                    HelpTopicDocument helpTopicDocument = null;
                    try {
                        helpTopicDocument = new HelpTopicDocument(topic);
                    }
                    catch (Exception exception) {
                        return;
                    }
                    Context context = Context.newIdeContext((Node)helpTopicDocument);
                    context.setWorkspace(null);
                    context.setProject(null);
                    if (bl2) {
                        HelpContentWindow helpContentWindow = new HelpContentWindow(context);
                        helpTopicEditor = helpContentWindow.getHelpTopicEditor();
                        this.setMRUEditor(helpTopicEditor);
                    } else {
                        helpTopicEditor = (HelpTopicEditor)EditorManager.getEditorManager().openEditorInFrame(HelpTopicEditor.class, context);
                        this.setMRUEditor(helpTopicEditor);
                    }
                } else if (!bl2) {
                    Context context = helpTopicEditor.getContext();
                    helpTopicEditor = (HelpTopicEditor)EditorManager.getEditorManager().openEditorInFrame(HelpTopicEditor.class, context);
                }
                if (helpTopicEditor != null) {
                    helpTopicEditor.displayTopic(topic);
                    if (helpTopicEditor.getParent() instanceof HelpContentWindow) {
                        HelpContentWindow helpContentWindow = (HelpContentWindow)helpTopicEditor.getParent();
                        helpContentWindow.activate();
                        helpContentWindow.getGUI().requestFocus();
                    }
                }
                this.printTopicForDebugging(topic, null, null);
            }
        }
    }

    public final void goTo(String string) {
        if (!this._initialize()) {
            this._showHelpError(0, null);
            return;
        }
        SwingUtilities.invokeLater(new 2(this, string));
    }

    public void clearHelpSystem() {
        this._dispose();
    }

    public void registerTopicSubstitute(String string, String string2) {
        if (this._topicSubstitutes == null) {
            this._topicSubstitutes = new HashMap();
        }
        this._topicSubstitutes.put(string, string2);
    }

    public List getHelpContentWindows() {
        ArrayList<HelpTopicEditor> arrayList = new ArrayList<HelpTopicEditor>();
        int n = _helpTopicEditors.size();
        int n2 = 0;
        while (n2 < n) {
            HelpTopicEditor helpTopicEditor = (HelpTopicEditor)((Object)_helpTopicEditors.get(n2));
            if (helpTopicEditor.getParent() instanceof HelpContentWindow) {
                arrayList.add(helpTopicEditor);
            }
            ++n2;
        }
        return arrayList;
    }

    static final boolean isDocWriter() {
        return Boolean.valueOf(System.getProperty("docWriter"));
    }

    public void printTopicForDebugging(Topic topic, String string, URL uRL) {
        if (JDevHelpSystemImpl.isDocWriter()) {
            String string2 = null;
            if (topic != null) {
                try {
                    URL uRL2 = topic.getTarget().getURL();
                    string2 = "Opened Help URL: " + uRL2 != null ? topic.getTarget().getURL().toString() : "unable to map topicid to URL\n";
                }
                catch (MalformedURLException malformedURLException) {
                    string2 = "Caught MalformedURLException";
                }
            } else if (uRL != null) {
                string2 = "Opened Help URL: " + uRL.toString() + "\n";
            } else if (string != null) {
                string2 = "Requested help topic: " + string + "\n";
            }
            if (!string2.equals(this._lastPrintString)) {
                LogManager.getIdeLogWindow().getPage().log((Object)string2);
                this._lastPrintString = string2;
            }
        }
    }

    void closeHelpRelatedEditors() {
        int n = _helpTopicEditors.size();
        ArrayList<HelpTopicEditor> arrayList = new ArrayList<HelpTopicEditor>();
        int n2 = 0;
        while (n2 < n) {
            HelpTopicEditor helpTopicEditor = (HelpTopicEditor)((Object)_helpTopicEditors.get(n2));
            if (helpTopicEditor.isHelpSystemDependent() && helpTopicEditor.getParent() instanceof HelpContentWindow) {
                arrayList.add(helpTopicEditor);
            }
            ++n2;
        }
        n = arrayList.size();
        int n3 = 0;
        while (n3 < n) {
            HelpTopicEditor helpTopicEditor = (HelpTopicEditor)((Object)arrayList.get(n3));
            ((HelpContentWindow)helpTopicEditor.getParent()).close();
            ++n3;
        }
        EditorManager editorManager = EditorManager.getEditorManager();
        if (editorManager != null) {
            List list = editorManager.getEditorsInfo();
            ArrayList<EditorInfo> arrayList2 = new ArrayList<EditorInfo>();
            int n4 = list.size();
            int n5 = 0;
            while (n5 < n4) {
                HelpTopicEditor helpTopicEditor;
                EditorInfo editorInfo = (EditorInfo)list.get(n5);
                if (editorInfo._getEditor() instanceof HelpTopicEditor && (helpTopicEditor = (HelpTopicEditor)editorInfo._getEditor()).isHelpSystemDependent()) {
                    arrayList2.add(editorInfo);
                }
                ++n5;
            }
            if (arrayList2.size() > 0) {
                editorManager.closeEditors(arrayList2);
            }
        }
    }

    private boolean _initialize() {
        if (this._initialized) {
            return true;
        }
        this._init();
        return this._initialized;
    }

    private void _processManifestForTipJars() {
        if (!this._hooksProcessedForTipJars) {
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
            HelpHook helpHook = (HelpHook)extensionRegistry.getIdeHook(HelpHook.ELEMENT);
            if (helpHook != null) {
                helpHook.registerHelpTipJars(this);
            }
            this._hooksProcessedForTipJars = true;
        }
    }

    private void _processManifestForHelpSetJars() {
        ArrayList arrayList = null;
        if (this._addinHelpSetList.size() > 0) {
            arrayList = this._addinHelpSetList;
            this._addinHelpSetList = new ArrayList();
        }
        if (!this._hooksProcessedForHelpSetJars) {
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
            HelpHook helpHook = (HelpHook)extensionRegistry.getIdeHook(HelpHook.ELEMENT);
            if (helpHook != null) {
                helpHook.registerHelpSetJars(this);
            }
            this._hooksProcessedForHelpSetJars = true;
        }
        if (arrayList != null) {
            this._addinHelpSetList.addAll(arrayList);
        }
    }

    private synchronized void _init() {
        int n = 0;
        if (ProfileIDs.PROFILE_HELPINITIALIZE) {
            n = IdeProfile.startEvent((int)3500);
        }
        this._processManifestForHelpSetJars();
        this._library = new JDevLibrary();
        this._helpKeyListener = new HelpKeyListener(null);
        if (!this._loadHelpSystem()) {
            this._dispose();
            this._initialized = false;
            if (ProfileIDs.PROFILE_HELPINITIALIZE) {
                IdeProfile.endEvent((int)n);
            }
            return;
        }
        if (ProfileIDs.PROFILE_HELPINITIALIZE) {
            IdeProfile.endEvent((int)n);
        }
        this._initialized = true;
    }

    private HelpInfo _findHelpInfoFromContext(Context context) {
        if (context == null) {
            return HelpInfo.getDefaultHelpInfo();
        }
        HelpInfo helpInfo = this._findHelpInfoFromView(context.getView());
        if (helpInfo != null) {
            helpInfo.setContext(context);
        }
        return helpInfo;
    }

    private HelpInfo _findHelpInfoFromView(View view) {
        if (view == null) {
            return HelpInfo.getDefaultHelpInfo();
        }
        HelpInfo helpInfo = view.getHelpInfo();
        if (helpInfo != null) {
            return helpInfo;
        }
        if (this._isViewOwnerValidAndNotSelf(view)) {
            return this._findHelpInfoFromView(view.owner());
        }
        return HelpInfo.getDefaultHelpInfo();
    }

    private boolean _isViewOwnerValidAndNotSelf(View view) {
        return view != null && view.owner() != null && view.owner() != view;
    }

    private void _showTopic(String string) {
        this.printTopicForDebugging(null, string, null);
        Topic topic = this.getTopicForString(string);
        if (topic != null) {
            this.showTopic(topic);
        }
    }

    private final boolean _loadHelpSystem() {
        this._loadErrors.clear();
        boolean bl = JDevHelpSystemImpl.isDocReview();
        if (bl) {
            this.convertURLsToDocReview();
        }
        this._orderHelpJars(this._addinHelpSetList);
        int n = this._helpJarsList.size();
        int n2 = 0;
        while (n2 < n) {
            HelpJarInfo helpJarInfo = (HelpJarInfo)this._helpJarsList.get(n2);
            URL uRL = helpJarInfo.getControlFileURL();
            this._loadHelpFromURL(uRL);
            ++n2;
        }
        this._helpJarsList.clear();
        if (this._library == null) {
            return false;
        }
        try {
            this._library.addBook(new JavadocBook());
        }
        catch (LibraryException libraryException) {
            // empty catch block
        }
        return this._library.getBookCount() != 0;
    }

    private final void _orderHelpJars(List list) {
        ArrayList<HelpJarInfo> arrayList = new ArrayList<HelpJarInfo>();
        for (HelpJarInfo helpJarInfo : list) {
            URL uRL = helpJarInfo.getControlFileURL();
            if (uRL == null || !URLFileSystem.exists((URL)uRL) || this._addOrReplaceHelp(helpJarInfo)) continue;
            arrayList.add(helpJarInfo);
        }
        if (arrayList.size() > 0) {
            if (arrayList.size() == list.size()) {
                int n = 0;
                while (n < arrayList.size()) {
                    HelpJarInfo helpJarInfo = (HelpJarInfo)arrayList.get(n);
                    HelpJarInfo.mav$clearRelativePositioning(helpJarInfo);
                    this._addOrReplaceHelp(helpJarInfo);
                    ++n;
                }
            } else {
                this._orderHelpJars(arrayList);
            }
        }
    }

    private final boolean _addOrReplaceHelp(HelpJarInfo helpJarInfo) {
        int n = this._findLocationInList(helpJarInfo.getName(), this._helpJarsList);
        if (n != -1) {
            this._helpJarsList.remove(n);
            this._helpJarsList.add(n, helpJarInfo);
        } else if (helpJarInfo.getRelativeToName() == null) {
            this._helpJarsList.add(helpJarInfo);
        } else {
            n = this._findLocationInList(helpJarInfo.getRelativeToName(), this._helpJarsList);
            if (n == -1) {
                return false;
            }
            n = helpJarInfo.getRelativeLocation() == 0 ? Math.max(0, n - 1) : Math.min(this._helpJarsList.size(), n + 1);
            this._helpJarsList.add(n, helpJarInfo);
        }
        return true;
    }

    private int _findLocationInList(String string, List list) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            HelpJarInfo helpJarInfo = (HelpJarInfo)list.get(n2);
            if (string.toLowerCase().equals(helpJarInfo.getName().toLowerCase())) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private final void _loadHelpFromURL(URL uRL) {
        if (uRL == null) {
            return;
        }
        try {
            this._library.addBook((Book)new JDevHelpSet(uRL));
        }
        catch (Exception exception) {
            this._loadErrors.add(HelpArb.format(26, uRL.toString()));
        }
    }

    private final void _showHelpError(int n, String string) {
        if (this._checkModalMode()) {
            String string2 = string;
            if (n == 0) {
                string2 = HelpArb.getString(79);
            }
            this._showErrorMessage(this._modalOwner, string2, HelpArb.getString(78));
        } else {
            HelpWindow helpWindow = (HelpWindow)DockStation.getDockStation().getDockable(new ViewId("HelpSystemAddin", "HelpWindow"));
            if (helpWindow != null && n == 0) {
                helpWindow.switchNavigator(7);
                helpWindow.show();
            } else {
                this._showErrorMessage((Component)Ide.getMainWindow(), string, HelpArb.getString(78));
            }
        }
    }

    private final void _dispose() {
        CueCardOverviewWindow cueCardOverviewWindow;
        this._library = null;
        this._helpKeyListener = null;
        HelpWindow helpWindow = (HelpWindow)DockStation.getDockStation().getDockable(HelpWindow.getHelpWindowViewId());
        if (helpWindow != null) {
            helpWindow.dispose();
        }
        if ((cueCardOverviewWindow = (CueCardOverviewWindow)DockStation.getDockStation().getDockable(CueCardOverviewWindow.getViewId())) != null) {
            cueCardOverviewWindow.close();
        }
        this._topicSubstitutes = null;
        this._initialized = false;
    }

    static final boolean isDocReview() {
        return Boolean.valueOf(System.getProperty("docReview"));
    }

    static final URL convertURLToDocReview(URL uRL) {
        URL uRL2 = uRL;
        String string = uRL.toString();
        if (string.indexOf("ohj") != -1) {
            string = string.replaceFirst("ohj", "hosted");
            uRL2 = URLFactory.newURL((String)string);
        }
        return uRL2;
    }

    private final void convertURLsToDocReview() {
        for (HelpJarInfo helpJarInfo : this._addinHelpSetList) {
            URL uRL = helpJarInfo.getControlFileURL();
            uRL = JDevHelpSystemImpl.convertURLToDocReview(uRL);
            helpJarInfo.update(uRL, null, -1);
        }
    }

    protected void clearModalDialog() {
        this._modalDialog = null;
    }

    protected void setModalDialog(ModalHelpContentDialog modalHelpContentDialog) {
        this._modalDialog = modalHelpContentDialog;
    }

    protected void setMRUEditor(HelpTopicEditor helpTopicEditor) {
        if (helpTopicEditor.isSharable()) {
            int n = _helpTopicEditors.indexOf((Object)helpTopicEditor);
            if (n == -1) {
                _helpTopicEditors.add(0, helpTopicEditor);
            } else if (n > 0) {
                _helpTopicEditors.remove(n);
                _helpTopicEditors.add(0, helpTopicEditor);
            }
        }
    }

    protected void removeEditor(HelpTopicEditor helpTopicEditor) {
        int n = _helpTopicEditors.indexOf((Object)helpTopicEditor);
        if (n != -1) {
            _helpTopicEditors.remove(n);
        }
    }

    private static HelpTopicEditor _getMRUEditor(int n) {
        int n2 = _helpTopicEditors.size();
        if (n2 == 0) {
            return null;
        }
        IdeSettings ideSettings = Ide.getSettings();
        HelpOptions helpOptions = (HelpOptions)((Object)ideSettings.getData("HelpOptions"));
        boolean bl = helpOptions.getOpenInWindow();
        boolean bl2 = n == 0;
        int n3 = 0;
        while (n3 < n2) {
            HelpTopicEditor helpTopicEditor = (HelpTopicEditor)((Object)_helpTopicEditors.get(n3));
            if (helpTopicEditor.isHelpSystemDependent() == bl2 && (bl && helpTopicEditor.getParent() instanceof HelpContentWindow || !bl && !(helpTopicEditor.getParent() instanceof HelpContentWindow))) {
                return helpTopicEditor;
            }
            ++n3;
        }
        return null;
    }

    private Dialog _getActiveModalOwnerDialog() {
        Window window = WindowUtils.getActiveWindow();
        Dialog dialog = null;
        while (window != null) {
            Dialog dialog2;
            if (window instanceof Dialog && (dialog2 = (Dialog)window).isModal()) {
                dialog = dialog2;
                break;
            }
            window = (Window)window.getParent();
        }
        return dialog;
    }

    private boolean _checkModalMode() {
        Dialog dialog = this._getActiveModalOwnerDialog();
        boolean bl = false;
        boolean bl2 = false;
        if (dialog != null) {
            bl2 = true;
        }
        if (bl2 && !bl) {
            bl = true;
        } else if (bl && !bl2) {
            bl = false;
        }
        this._modalOwner = dialog;
        return bl;
    }

    private void _showErrorMessage(Component component, String string, String string2) {
        1 var4_4 = new 1(this, component, string, string2);
        if (SwingUtilities.isEventDispatchThread()) {
            var4_4.run();
        } else {
            SwingUtilities.invokeLater(var4_4);
        }
    }

    static HelpTopicEditor maS$_getMRUEditor(int n) {
        return JDevHelpSystemImpl._getMRUEditor(n);
    }

    static void mav$_showHelpError(JDevHelpSystemImpl jDevHelpSystemImpl, int n, String string) {
        jDevHelpSystemImpl._showHelpError(n, string);
    }

    static void mav$_showTopic(JDevHelpSystemImpl jDevHelpSystemImpl, String string) {
        jDevHelpSystemImpl._showTopic(string);
    }

    static void mav$_showErrorMessage(JDevHelpSystemImpl jDevHelpSystemImpl, Component component, String string, String string2) {
        jDevHelpSystemImpl._showErrorMessage(component, string, string2);
    }

    static HelpInfo mav$_findHelpInfoFromContext(JDevHelpSystemImpl jDevHelpSystemImpl, Context context) {
        return jDevHelpSystemImpl._findHelpInfoFromContext(context);
    }

    static Topic mav$getTipOfTheDay(JDevHelpSystemImpl jDevHelpSystemImpl) {
        return jDevHelpSystemImpl.getTipOfTheDay();
    }

    public static final class 8
    extends SwingWorker {
        URL url;
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ String v$symbolName;

        void $init$() {
            this.url = null;
        }

        public Object construct() {
            this.url = JDevHelpSystemImpl.getResolvedURL(this.v$context, this.v$symbolName);
            return this.url;
        }

        public void finished() {
            if (this.url == null) {
                return;
            }
            HelpTopicEditor helpTopicEditor = JDevHelpSystemImpl.maS$_getMRUEditor(1);
            if (helpTopicEditor != null) {
                SimpleURLTarget simpleURLTarget = new SimpleURLTarget(null, this.url.toString());
                SimpleTopic simpleTopic = new SimpleTopic(null, (Target)simpleURLTarget, null);
                helpTopicEditor.displayTopic((Topic)simpleTopic);
                List list = EditorManager.getEditorManager().getEditorsInfo();
                int n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    EditorInfo editorInfo = (EditorInfo)list.get(n2);
                    if (editorInfo._getEditor() == helpTopicEditor) {
                        EditorManager.getEditorManager().activateEditor(editorInfo);
                    }
                    ++n2;
                }
            } else {
                HelpSystemAddin.openEditorInFrameExternal(this.url);
            }
        }

        public 8(Context context, String string) {
            this.v$symbolName = string;
            this.v$context = context;
            this.$init$();
        }
    }

    public final class 7
    implements Runnable {
        private final /* synthetic */ JComponent v$comp;
        final /* synthetic */ JDevHelpSystemImpl this$0;

        public void run() {
            try {
                String string = null;
                Book book = null;
                if (this.v$comp != null) {
                    string = HelpUtils.getHelpID((Component)this.v$comp);
                    if (string == null && this.v$comp instanceof Traversable) {
                        string = ((Traversable)this.v$comp).getHelpID();
                    }
                    book = (Book)HelpUtils.getHelpSet((Component)this.v$comp);
                }
                if (string == null) {
                    JDevHelpSystemImpl.mav$_showHelpError(this.this$0, 1, HelpArb.getString(15));
                } else {
                    JDevHelpSystemImpl.mav$_showTopic(this.this$0, string);
                }
            }
            catch (TopicDisplayException topicDisplayException) {
                JDevHelpSystemImpl.mav$_showErrorMessage(this.this$0, WindowUtils.getActiveWindow(), HelpArb.getString(15), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public 7(JDevHelpSystemImpl jDevHelpSystemImpl, JComponent jComponent) {
            this.v$comp = jComponent;
            this.this$0 = jDevHelpSystemImpl;
        }
    }

    public final class 6
    implements Runnable {
        private final /* synthetic */ Context v$fCtx;
        final /* synthetic */ JDevHelpSystemImpl this$0;

        public void run() {
            HelpInfo helpInfo = JDevHelpSystemImpl.mav$_findHelpInfoFromContext(this.this$0, this.v$fCtx);
            this.this$0.showHelp(helpInfo);
        }

        public 6(JDevHelpSystemImpl jDevHelpSystemImpl, Context context) {
            this.v$fCtx = context;
            this.this$0 = jDevHelpSystemImpl;
        }
    }

    public final class 5
    implements Runnable {
        private final /* synthetic */ HelpInfo v$fHelpInfo;
        final /* synthetic */ JDevHelpSystemImpl this$0;

        public void run() {
            if (this.v$fHelpInfo != null && this.v$fHelpInfo.getHelpType() == 1) {
                this.this$0.showLanguageHelp(this.v$fHelpInfo.getContext(), this.v$fHelpInfo.getHelpTopicID());
            } else {
                this.this$0.goTo(this.v$fHelpInfo != null ? this.v$fHelpInfo.getHelpTopicID() : HelpInfo.getDefaultHelpInfo().getHelpTopicID());
            }
        }

        public 5(JDevHelpSystemImpl jDevHelpSystemImpl, HelpInfo helpInfo) {
            this.v$fHelpInfo = helpInfo;
            this.this$0 = jDevHelpSystemImpl;
        }
    }

    public final class 4
    implements ActionListener {
        private final /* synthetic */ JCheckBox v$cBox;
        final /* synthetic */ JDevHelpSystemImpl this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            DTCache dTCache = Ide.getDTCache();
            dTCache.putBoolean(JDevHelpSystemImpl.HELPSYSTEM_SHOW_TIP_OF_DAY, this.v$cBox.isSelected());
        }

        public 4(JDevHelpSystemImpl jDevHelpSystemImpl, JCheckBox jCheckBox) {
            this.v$cBox = jCheckBox;
            this.this$0 = jDevHelpSystemImpl;
        }
    }

    public final class 3
    implements ActionListener {
        private final /* synthetic */ HelpContentPanel v$hcp;
        final /* synthetic */ JDevHelpSystemImpl this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            Topic topic = JDevHelpSystemImpl.mav$getTipOfTheDay(this.this$0);
            if (topic != null) {
                this.v$hcp.displayTopic(topic);
            }
        }

        public 3(JDevHelpSystemImpl jDevHelpSystemImpl, HelpContentPanel helpContentPanel) {
            this.v$hcp = helpContentPanel;
            this.this$0 = jDevHelpSystemImpl;
        }
    }

    public final class 2
    implements Runnable {
        private final /* synthetic */ String v$topicID;
        final /* synthetic */ JDevHelpSystemImpl this$0;

        public void run() {
            block9: {
                int n = 0;
                if (ProfileIDs.PROFILE_HELPSHOWTOPIC) {
                    n = IdeProfile.startEvent((int)3501);
                }
                try {
                    try {
                        if (this.v$topicID == null) {
                            JDevHelpSystemImpl.mav$_showHelpError(this.this$0, 1, HelpArb.getString(15));
                            break block9;
                        }
                        JDevHelpSystemImpl.mav$_showTopic(this.this$0, this.v$topicID);
                    }
                    catch (TopicDisplayException topicDisplayException) {
                        JDevHelpSystemImpl.mav$_showErrorMessage(this.this$0, WindowUtils.getActiveWindow(), HelpArb.getString(15), null);
                    }
                    catch (Exception exception) {}
                }
                finally {
                    if (ProfileIDs.PROFILE_HELPSHOWTOPIC) {
                        IdeProfile.endEvent((int)n);
                    }
                }
            }
        }

        public 2(JDevHelpSystemImpl jDevHelpSystemImpl, String string) {
            this.v$topicID = string;
            this.this$0 = jDevHelpSystemImpl;
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ Component v$parent;
        private final /* synthetic */ String v$message;
        private final /* synthetic */ String v$title;
        final /* synthetic */ JDevHelpSystemImpl this$0;

        public void run() {
            JOptionPane.showMessageDialog(this.v$parent, this.v$message, this.v$title, 0);
        }

        public 1(JDevHelpSystemImpl jDevHelpSystemImpl, Component component, String string, String string2) {
            this.v$title = string2;
            this.v$message = string;
            this.v$parent = component;
            this.this$0 = jDevHelpSystemImpl;
        }
    }

    private class HelpKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (!keyEvent.isConsumed() && keyEvent.getKeyCode() == 112) {
                try {
                    JDevHelpSystemImpl.this.showHelp((JComponent)keyEvent.getSource());
                    keyEvent.consume();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private HelpKeyListener() {
        }

        HelpKeyListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static class HelpJarInfo {
        private String _name;
        private URL _controlFileURL;
        private String _relativeToName;
        private int _relativeLocation;

        public HelpJarInfo(String string, URL uRL, String string2, int n) {
            this._name = string;
            this._controlFileURL = uRL;
            this._relativeToName = string2;
            this._relativeLocation = n;
        }

        public String getName() {
            return this._name;
        }

        public URL getControlFileURL() {
            return this._controlFileURL;
        }

        public String getRelativeToName() {
            return this._relativeToName;
        }

        public int getRelativeLocation() {
            return this._relativeLocation;
        }

        public void update(URL uRL, String string, int n) {
            if (uRL != null) {
                this._controlFileURL = uRL;
            }
            if (string != null) {
                this._relativeToName = string;
            }
            if (n != -1) {
                this._relativeLocation = n;
            }
        }

        private void clearRelativePositioning() {
            this._relativeToName = null;
            this._relativeLocation = -1;
        }

        static void mav$clearRelativePositioning(HelpJarInfo helpJarInfo) {
            helpJarInfo.clearRelativePositioning();
        }
    }

    private static class TipOfDayDialog
    extends JEWTDialog {
        private HelpContentPanel _helpContentPanel;

        public TipOfDayDialog(Frame frame) {
            super(frame);
        }

        public void setHelpContentPanel(HelpContentPanel helpContentPanel) {
            this._helpContentPanel = helpContentPanel;
        }

        protected void dismissDialog(boolean bl) {
            super.dismissDialog(true);
            if (this._helpContentPanel != null) {
                this._helpContentPanel.dispose();
                this._helpContentPanel = null;
            }
            super.dispose();
        }
    }
}

